/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitDeleteContacts
extends WorkFlowCommitListener {
    public CommitDeleteContacts() {
        this.reportId = (int)ReportsUtil.DELETE_CONTACT_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(10048);
        try {
            String dn = (String)result.get(10004);
            guid = (String)result.get(10050);
            ADHandler.deleteContact((String)this.domainName, (Long)loginId, (String)dn);
            message.append(rb.getString("contacts.message.successfully_deleted_contact"));
            errorOccured = false;
            out.log(Level.INFO, " Deleted contact guid " + guid + " dn " + dn);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(rb));
        }
        catch (Exception e) {
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        this.updateResult(guid, message.toString(), errorOccured);
        TechAuditAPI.getInstance().auditDeleteContact(loginId, rb.getString("admp.reports.report_actions.create_request.options.delete_contacts"), this.getValue(result, (Integer)10004), this.domainName, message.toString(), rb);
        return message.toString();
    }
}

