/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitDeleteGroups
extends WorkFlowCommitListener {
    public CommitDeleteGroups() {
        this.reportId = (int)ReportsUtil.DELETE_GROUP_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(2021);
        try {
            String dn = (String)result.get(2003);
            guid = (String)result.get(2022);
            if (!this.isAuthorizedGroup(dn, this.domainName)) {
                out.log(Level.INFO, "HDT is not authorized to modify this group--" + dn);
                message.append(rb.getString("groupmanagement.messages.not_authorized_group"));
            } else {
                ADHandler.deleteGroup((String)this.domainName, (Long)loginId, (String)CommonUtil.escapeDN((String)dn));
                GroupHandler.deleteGroup((String)this.domainName, (Long)loginId, (String)dn);
                message.append(rb.getString("admp.workflow.commitrequest.statmsg.success_deleted_group"));
                errorOccured = false;
                out.log(Level.INFO, " Deleted Groups guid " + guid + " dn " + dn);
            }
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = le.getErrorMsgList().contains("80071392") ? new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + rb.getString("client.groups.DeleteGroupListener.unable_to_delete_the_group") + " " + rb.getString("client.groups.DeleteGroupListener.primary_group_for_users")) : new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(rb));
        }
        catch (Exception e) {
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        this.updateResult(guid, message.toString(), errorOccured);
        TechAuditAPI.getInstance().auditDeleteGroup(loginId, rb.getString("admp.mgmt.grp_mgmt.del_grps.mgmtname.del_grps"), this.getValue(result, (Integer)2003), this.domainName, message.toString(), rb);
        return message.toString();
    }
}

