/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.webclient.formats.UserModificationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitDeleteHomeFolder
extends WorkFlowCommitListener {
    public CommitDeleteHomeFolder() {
        this.reportId = (int)ReportsUtil.MODIFY_USER_PROFILE_ATTRIBUTES_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        this.domainName = (String)result.get(1143);
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("distinguishedName");
        attributeList.add("objectGUID");
        attributeList.add("objectSID");
        attributeList.add("homeDirectory");
        attributeList.add("scriptPath");
        attributeList.add("profilePath");
        attributeList.add("sAMAccountName");
        attributeList.add("userPrincipalName");
        attributeList.add("name");
        Hashtable resultHash = new Hashtable();
        resultHash.putAll(result);
        ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
        String path = new String();
        String drive = new String();
        StringBuffer message = new StringBuffer();
        try {
            boolean homefolder;
            String folderToBeDeleted;
            boolean profilePath;
            block13: {
                String sid = this.getValue(result, (Integer)1144);
                String dn = this.getValue(result, (Integer)1004);
                profilePath = false;
                folderToBeDeleted = "";
                homefolder = true;
                String formatedFolder = folderToBeDeleted = this.getValue(result, (Integer)1042);
                if (folderToBeDeleted.endsWith("$")) {
                    formatedFolder = folderToBeDeleted.substring(0, folderToBeDeleted.length() - 1);
                }
                formatedFolder = UserModificationFormatUtil.getFormattedValue(formatedFolder, resultHash, this.domainName, "");
                if (!folderToBeDeleted.equals("") && folderToBeDeleted.length() != 0) {
                    try {
                        DeleteUtil.removeFolder(formatedFolder, "HomeFolder", this.domainName, loginId, rb, message);
                        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                        Properties homeDriveAttrib = new Properties();
                        homeDriveAttrib.put("ATTRIB_LDAP_NAME", "homeDrive");
                        homeDriveAttrib.put("ATTRIB_VALUE", "");
                        homeDriveAttrib.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        homeDriveAttrib.put("DATA_HANDLER_TYPE", new Long(3L));
                        homeDriveAttrib.put("DW_CONTROL_CODE", new Long(1L));
                        setAttributeList.add(homeDriveAttrib);
                        Properties homeDirectoryAttrib = new Properties();
                        homeDirectoryAttrib.put("ATTRIB_LDAP_NAME", "homeDirectory");
                        homeDirectoryAttrib.put("ATTRIB_VALUE", "");
                        homeDirectoryAttrib.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        homeDirectoryAttrib.put("DATA_HANDLER_TYPE", new Long(3L));
                        homeDirectoryAttrib.put("DW_CONTROL_CODE", new Long(1L));
                        setAttributeList.add(homeDirectoryAttrib);
                        ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), attributeList, (NativeListener)this);
                    }
                    catch (LocalizedException le) {
                        if (homefolder) {
                            message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.delete_homefolders.statmsg.unable_delete_homefolder"), le.getMessage()));
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        if (homefolder) {
                            message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.delete_homefolders.statmsg.unable_delete_homefolder"), e.getMessage()));
                        }
                        break block13;
                    }
                }
                if (homefolder) {
                    message.append(rb.getString("admp.mgmt.user_mgmt.delete_homefolders.statmsg.unable_delete_user_does_not_have_homefolder"));
                }
            }
            String deletedFrom = folderToBeDeleted;
            String deletedText = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_deleted");
            String task = "";
            if (homefolder) {
                task = rb.getString("admp.mgmt.user_mgmt.delete_homefolders.mgmtname.delete_home_folders");
                if (folderToBeDeleted == null || folderToBeDeleted == "") {
                    deletedFrom = rb.getString("admp.mgmt.user_mgmt.delete_homefolders.statmsg.no_home_folder");
                }
            }
            if (profilePath || homefolder) {
                TechAuditAPI.getInstance().auditDeleteHomeFolder(loginId, task, this.getValue(result, (Integer)1010), this.domainName, deletedFrom, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb, profilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

