/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitModifyPhotos
extends WorkFlowCommitListener {
    public CommitModifyPhotos() {
        this.reportId = (int)ReportsUtil.MODIFY_BULK_PHOTOS_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        ArrayList setAttributeList = new ArrayList();
        String status = rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.photos.status");
        try {
            String objectId = this.getValue(result, (Integer)1145);
            String sAMAccountName = this.getValue(result, (Integer)1006);
            String sid = this.getValue(result, (Integer)1144);
            String dn = this.getValue(result, (Integer)1004);
            String domainName = (String)result.get(1143);
            String uniqueOperationId = "";
            String photoFolder = "";
            String hostId = "";
            String attribute = "";
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            for (AdmpInput admpInput : inputsDetails) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getLabel().equalsIgnoreCase("uniqueOperationId")) {
                        uniqueOperationId = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("hostId")) {
                        hostId = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("attributeName")) {
                        attribute = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("photoFolderName")) continue;
                    photoFolder = fcOption.getValue();
                }
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)objectId, 0));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", crit);
            Row tmpRow = dataObject.getRow("ADSMPhotoMgmtTempTable");
            String hexValOfImage = (String)tmpRow.get("PHOTO_HEX");
            String photoFilePath = (String)tmpRow.get("PHOTO_FILE_PATH");
            if (hexValOfImage.length() > 0 || photoFilePath != null && photoFilePath.length() > 0) {
                byte[] byteArrOfImg = null;
                if (attribute.equalsIgnoreCase("exchangePhoto")) {
                    File file = new File(photoFilePath);
                    String fileName = file.getName();
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byteArrOfImg = new byte[(int)file.length()];
                    fileInputStream.read(byteArrOfImg);
                    fileInputStream.close();
                } else {
                    int hexStrLen = hexValOfImage.length();
                    byteArrOfImg = new byte[hexStrLen / 2];
                    for (int indx1 = 0; indx1 < hexStrLen; indx1 += 2) {
                        byteArrOfImg[indx1 / 2] = (byte)((Character.digit(hexValOfImage.charAt(indx1), 16) << 4) + Character.digit(hexValOfImage.charAt(indx1 + 1), 16));
                    }
                }
                boolean isSuccess = false;
                try {
                    status = "";
                    if (attribute.equalsIgnoreCase("exchangePhoto")) {
                        String mailServer = ModifyPhotoListener.getMailServerForSingleUser(domainName, loginId, sAMAccountName);
                        if (mailServer != null) {
                            Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                            status = ADHandler.setExchangePhoto((String)domainName, (long)loginId, (String)objectId, (String)photoFilePath, (Properties)exchangeServerDetails);
                            if (status.length() == 0) {
                                File file = new File(photoFilePath);
                                String fileName = file.getName();
                                byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                                UserPhotoMgmtUtil.writePhotoToFile((String)photoFolder.replace(attribute, "thumbnailPhoto"), (byte[])byteArrOfImg, (String)objectId);
                            }
                        }
                        if (mailServer == null || !status.equals("")) {
                            status = mailServer == null ? status + rb.getString("admp.common.text.some_err_occured_while_setting_exch_photo") : status + rb.getString(status);
                            File file = new File(photoFilePath);
                            String fileName = file.getName();
                            photoFolder = photoFolder.replace(attribute, "thumbnailPhoto");
                            attribute = "thumbnailPhoto";
                            byteArrOfImg = ModifyPhotoListener.getScaledImg(file, fileName.substring(fileName.lastIndexOf(".") + 1), true);
                            ADHandler.setUserPhoto((String)domainName, (Long)loginId, (String)sid, (String)dn, (byte[])byteArrOfImg, (String)attribute);
                            UserPhotoMgmtUtil.writePhotoToFile((String)photoFolder, (byte[])byteArrOfImg, (String)objectId);
                            status = status + " " + rb.getString("admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_attrib_updated_successfully");
                        }
                    } else {
                        ADHandler.setUserPhoto((String)domainName, (Long)loginId, (String)sid, (String)dn, (byte[])byteArrOfImg, (String)attribute);
                    }
                    if (status.equals("")) {
                        UserPhotoMgmtUtil.writePhotoToFile((String)photoFolder, (byte[])byteArrOfImg, (String)objectId);
                        status = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
                        isSuccess = true;
                    }
                }
                catch (LocalizedException ex) {
                    ex.printStackTrace();
                    String key = "admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error";
                    if (status.length() > 0) {
                        key = "admp.mgmt.user_mgmt.photo_mgmt.thumbnailphoto_error";
                        status = status + " ";
                    }
                    status = status + rb.getString(key) + ex.getMessage(rb);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    status = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + rb.getString("admp.mgmt.gpo_mgmt_some_err_occ");
                }
                Criteria updateResultCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)objectId, 0);
                updateResultCrit = updateResultCrit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0));
                DataObject resultDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", updateResultCrit);
                if (resultDO != null && !resultDO.isEmpty()) {
                    Row row = resultDO.getRow("ADSMPhotoMgmtTempTable");
                    row.set("PHOTO_HEX", (Object)"");
                    row.set("RESULT", (Object)(isSuccess ? "SUCCESS" : status));
                    resultDO.updateRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(resultDO);
                }
            }
            return status;
        }
        catch (Exception e) {
            return status;
        }
    }
}

