/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitMoveContacts
extends WorkFlowCommitListener {
    public CommitMoveContacts() {
        this.reportId = (int)ReportsUtil.MOVE_CONTACT_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String destinationDN;
        String dn;
        String guid;
        Boolean errorOccured;
        StringBuffer message;
        block9: {
            message = new StringBuffer();
            errorOccured = true;
            guid = "";
            this.domainName = (String)result.get(10048);
            dn = (String)result.get(10004);
            destinationDN = "";
            try {
                guid = (String)result.get(10050);
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                if (!inputsDetails.isEmpty()) {
                    for (AdmpInput admpInput : inputsDetails) {
                        if (admpInput.getIsMultiple().booleanValue()) {
                            for (FcOption fcOption : admpInput.getMultipleInput()) {
                                if (!fcOption.getLabel().equalsIgnoreCase("Container")) continue;
                                destinationDN = fcOption.getValue();
                            }
                            continue;
                        }
                        if (!admpInput.getName().equals("Container")) continue;
                        destinationDN = admpInput.getValue();
                    }
                    ADHandlerForMgmt.moveObject((String)this.domainName, (Long)loginId, (String)dn, (String)destinationDN);
                    guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    ADHandler.updateContact((String)this.domainName, (Long)loginId, (String)guid, (String)destinationDN, (ArrayList)this.attributeList, (NativeListener)this);
                    if (message.length() == 0) {
                        message.append("" + rb.getString("admp.workflow.commitrequest.statmsg.success_modified"));
                    } else {
                        message.insert(0, rb.getString("admp.workflow.commitrequest.statmsg.modified_but_error"));
                    }
                    errorOccured = false;
                    out.log(Level.INFO, "Commit Move Contacts guid " + guid + " dn " + dn + " destinationDN " + destinationDN);
                    break block9;
                }
                message = new StringBuffer(rb.getString("admp.workflow.commitrequest.alert.No_inputs_mentioned"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(rb));
            }
            catch (Exception e) {
                message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
            }
        }
        this.updateResult(guid, message.toString(), errorOccured);
        TechAuditAPI.getInstance().auditMoveContact(loginId, rb.getString("admp.mgmt.cont_mgmt.move_conts.mgmtname.move_conts"), this.getValue(result, (Integer)10008), this.domainName, StrUtil.getContainerDNFromDN((String)dn), destinationDN, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return message.toString();
    }
}

