/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.cvc.FileServerDataUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtHandler;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtTask;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommitNTFSPermission
extends WorkFlowCommitListener {
    Long loginId;
    AdventNetResourceBundle rb;
    Integer reportId = 8001;

    @Override
    public void commitReqMonitorFollowRequestTask(Long requestId, Long reqMonitorTaskId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
        try {
            this.loginId = loginId;
            this.rb = rb;
            Criteria criCVC = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"REQ_MONITOR_TASK_ID"), (Object)reqMonitorTaskId, 0);
            criCVC = criCVC.and(new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"IS_REMOVED"), (Object)false, 0));
            DataObject dataObj = WorkFlowUtil.getCVCWorkFlowObjectsDO((Criteria)criCVC);
            Integer subCategory = WorkFlowUtil.getSubCategoryForRequest((Long)requestId);
            HashMap<String, HashMap<Long, HashMap<Long, ArrayList<Long>>>> cvcInputData = new HashMap<String, HashMap<Long, HashMap<Long, ArrayList<Long>>>>();
            Hashtable<Long, Hashtable<Long, Long>> cvcUniqueIdHash = new Hashtable<Long, Hashtable<Long, Long>>();
            ArrayList editActionsList = WorkFlowUtil.getResultRowEditActions((Criteria)new Criteria(Column.getColumn((String)"WFRequestRowEditActions", (String)"SUB_CATEGORY"), (Object)subCategory, 0));
            for (Hashtable editAction : editActionsList) {
                Long actionId = (Long)editAction.get("ACTION_ID");
                String actionName = (String)editAction.get("ACTION_NAME");
                Iterator it = dataObj.getRows("WFCVCDataSummary", new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"ACTION_ID"), (Object)actionId, 0));
                while (it.hasNext()) {
                    JSONArray cvcMaskIdArray;
                    Row r = (Row)it.next();
                    Long uniqueId = (Long)r.get("UNIQUE_ID");
                    String cvcDataJSONStr = (String)r.get("CVC_DATA_SUMMARY");
                    JSONObject cvcDataJSON = new JSONObject(cvcDataJSONStr);
                    Long cvcFolderId = cvcDataJSON.has("CVC_FOLDER_INPUT_ID") ? Long.valueOf(cvcDataJSON.getLong("CVC_FOLDER_INPUT_ID")) : null;
                    Long cvcPermissionId = cvcDataJSON.has("CVC_PERMISSION_INPUT_ID") ? Long.valueOf(cvcDataJSON.getLong("CVC_PERMISSION_INPUT_ID")) : null;
                    JSONArray jSONArray = cvcMaskIdArray = cvcDataJSON.has("CVC_ACCESS_MASK_INPUT_ID") ? cvcDataJSON.getJSONArray("CVC_ACCESS_MASK_INPUT_ID") : new JSONArray();
                    if (cvcFolderId == null || cvcPermissionId == null) continue;
                    HashMap folderPermList = cvcInputData.get(actionName) != null ? (HashMap)cvcInputData.get(actionName) : new HashMap();
                    HashMap permList = folderPermList.get(cvcFolderId) != null ? (HashMap)folderPermList.get(cvcFolderId) : new HashMap();
                    ArrayList<Long> maskIdList = new ArrayList<Long>();
                    for (int i = 0; i < cvcMaskIdArray.length(); ++i) {
                        Long cvcMaskId = cvcMaskIdArray.getLong(i);
                        maskIdList.add(cvcMaskId);
                    }
                    permList.put(cvcPermissionId, maskIdList);
                    folderPermList.put(cvcFolderId, permList);
                    cvcInputData.put(actionName, folderPermList);
                    Hashtable<Object, Object> permVsUniqueId = cvcUniqueIdHash.get(cvcFolderId) != null ? cvcUniqueIdHash.get(cvcFolderId) : new Hashtable();
                    permVsUniqueId.put(cvcPermissionId, uniqueId);
                    cvcUniqueIdHash.put(cvcFolderId, permVsUniqueId);
                }
            }
            Long generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)"", (Long)loginId);
            String tableName = FileServerMgmtHandler.getModifyFolderResultTableName((Long)generationId);
            String outputFileName = System.getProperty("server.home") + File.separator + "temp" + File.separator + "result_data" + File.separator + tableName + "_" + System.currentTimeMillis();
            QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
            String uniqueID = queryGen.getUniqueId();
            String delimiter = queryGen.getFieldDelimiter();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)System.getProperty("user.name"), (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)rb, (String)rb.getString("admp.home.feature.heading.workflow"), (Long)requestId);
            FileServerMgmtTask task = new FileServerMgmtTask(generationId, loginId, true, rb);
            Action action = new Action(task, loginId, dataObj, auditDataObj, audit_id, outputFileName, uniqueID, delimiter, reqMonitorTaskId, generationId, cvcUniqueIdHash, rb);
            action.execute(cvcInputData);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isCompleted = true;
    }

    class Action {
        private String outputFileName = "";
        private String uniqueID = null;
        private String delimiter = "";
        private DataObject auditDataObj = null;
        private Long audit_id = null;
        private AdventNetResourceBundle rb = null;
        private DataObject cvcDO = null;
        private FileServerMgmtTask task = null;
        private Long loginId = null;
        private Long reqMonitorTaskId = null;
        private Long generationId = null;
        Hashtable<Long, Hashtable<Long, Long>> cvcUniqueIdHash = null;

        public Action(FileServerMgmtTask task, Long loginId, DataObject cvcDO, DataObject auditDataObj, Long audit_id, String outputFileName, String uniqueID, String delimiter, Long reqMonitorTaskId, Long generationId, Hashtable<Long, Hashtable<Long, Long>> cvcUniqueIdHash, AdventNetResourceBundle rb) {
            this.task = task;
            this.loginId = loginId;
            this.cvcDO = cvcDO;
            this.auditDataObj = auditDataObj;
            this.audit_id = audit_id;
            this.outputFileName = outputFileName;
            this.uniqueID = uniqueID;
            this.delimiter = delimiter;
            this.reqMonitorTaskId = reqMonitorTaskId;
            this.generationId = generationId;
            this.rb = rb;
            this.cvcUniqueIdHash = cvcUniqueIdHash;
        }

        public void execute(HashMap<String, HashMap<Long, HashMap<Long, ArrayList<Long>>>> cvcInputData) {
            for (String actionName : cvcInputData.keySet()) {
                HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList = cvcInputData.get(actionName);
                if (actionName.equals("ASSIGN_PERMISSION_TO_FOLDER")) {
                    this.setFolderPermission(folderPermList);
                    continue;
                }
                if (actionName.equals("ADD_TO_GROUP_HAVING_SAME_PERMISSION")) {
                    this.addToGroup(folderPermList);
                    continue;
                }
                if (actionName.equals("ADD_TO_GROUP_ASSIGN_PERMISSION_TO_GROUP")) {
                    this.addToGroupAndAssignToFolder(folderPermList);
                    continue;
                }
                if (actionName.equals("REMOVE_PERMISSION_FROM_FOLDER")) {
                    this.removeFolderPermission(folderPermList);
                    continue;
                }
                if (!actionName.equals("REMOVE_USER_FROM_GROUP")) continue;
                this.removeFromGroup(folderPermList);
            }
            this.completeExecution();
        }

        private void setFolderPermission(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList) {
            this.setFolderPermission(folderPermList, this.cvcDO, "add");
        }

        private void removeFolderPermission(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList) {
            this.setFolderPermission(folderPermList, this.cvcDO, "remove");
        }

        private void setFolderPermission(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList, DataObject cvcDO, String action) {
            try {
                ArrayList accessMaskMapList = FileServerMgmtHandler.getAccessMaskList((String)"folder");
                ArrayList advancedAccessMaskMapList = FileServerMgmtHandler.getAccessMaskList((String)"folder", (Boolean)true);
                for (Long folderId : folderPermList.keySet()) {
                    HashMap<Long, ArrayList<Long>> permList = folderPermList.get(folderId);
                    Criteria folderCri = new Criteria(Column.getColumn((String)"CVCFolderSelectionData", (String)"INPUT_ID"), (Object)folderId, 0);
                    ArrayList folderPropList = FileServerDataUtil.getFolderPropList((DataObject)cvcDO, (Criteria)folderCri);
                    Properties folderProp = (Properties)folderPropList.get(0);
                    for (Long permId : permList.keySet()) {
                        ArrayList<Long> maskIdList = permList.get(permId);
                        DataObject cvcDO1 = (DataObject)cvcDO.clone();
                        if (!maskIdList.isEmpty()) {
                            cvcDO1.deleteRows("CVCAccessMaskData", new Criteria(Column.getColumn((String)"CVCAccessMaskData", (String)"UNIQUE_ID"), (Object)StrUtil.getLongArray(maskIdList), 9));
                        }
                        Criteria permCri = new Criteria(Column.getColumn((String)"CVCPermissionData", (String)"INPUT_ID"), (Object)permId, 0);
                        ArrayList permPropList = FileServerDataUtil.getPermissionDetails((DataObject)cvcDO1, (Criteria)permCri, (String)action);
                        String message = this.task.setFolderPermission(folderProp, permPropList, new Properties(), 0, this.outputFileName, this.uniqueID, this.delimiter, Boolean.valueOf(true));
                        this.setAuditObjectDetails(folderId, permId, message);
                        String folderPath = this.getFolderPath(folderId);
                        String domainName = FileServerMgmtUtil.getDomainForFolder((String)folderPath);
                        Properties permProp = (Properties)permPropList.get(0);
                        String trustee = (String)permProp.get("TRUSTEE");
                        Properties objProp = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)trustee);
                        String objName = objProp.getProperty("OBJECT_NAME") != null ? objProp.getProperty("OBJECT_NAME") : trustee;
                        HashMap<String, String> objLogProps = new HashMap<String, String>();
                        objLogProps.put("Folder", folderPath);
                        objLogProps.put(this.rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.object_name"), objName);
                        ArrayList maskList = (ArrayList)permProp.get("PERMISSION");
                        String permStr = "";
                        for (int i = 0; i < maskList.size(); ++i) {
                            Properties prop = (Properties)maskList.get(i);
                            String addRemoveStr = (String)prop.get("operation");
                            if (addRemoveStr.equals("add")) {
                                objLogProps.put(this.rb.getString("admp.deleg.hdt_deleg.edit_hdt.link.add_remove_groups"), this.rb.getString("o365.input_fields.add_permissions"));
                            } else if (addRemoveStr.equals("delete")) {
                                objLogProps.put(this.rb.getString("admp.deleg.hdt_deleg.edit_hdt.link.add_remove_groups"), this.rb.getString("o365.input_fields.remove_permissions"));
                            }
                            Long accessMaskVal = (Long)prop.get("ACCESS_MASK");
                            String accessMaskStr = "";
                            if (accessMaskVal.equals(-1L)) {
                                accessMaskStr = "admp.mgmt.fileserver.perm_mgmt.remove_perm.all_permission";
                            } else {
                                accessMaskStr = FileServerMgmtUtil.getPermissionFromVal((ArrayList)accessMaskMapList, (Long)accessMaskVal, (String)"ACCESS_MASK", (String)"ACCESS_MASK_STRING");
                                if (accessMaskStr.equals("")) {
                                    accessMaskStr = FileServerMgmtUtil.getPermissionFromVal((ArrayList)advancedAccessMaskMapList, (Long)accessMaskVal, (String)"ACCESS_MASK", (String)"ACCESS_MASK_STRING");
                                }
                            }
                            permStr = permStr.equals("") ? this.rb.getString(accessMaskStr) : permStr + ", " + this.rb.getString(accessMaskStr);
                        }
                        objLogProps.put("Permissions", permStr);
                        TechAuditAPI.getInstance().auditNTFSPermissions(this.loginId, this.rb.getString("admp.mgmt.fileserver.sub_heading.permission_mgmt"), this.rb.getString("admp.mgmt.fileserver.mgmtname.modify_permission"), objLogProps, domainName, message, this.rb);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void addToGroup(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList) {
            this.addToGroup(folderPermList, true);
        }

        private void addToGroup(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList, Boolean isAuditRequired) {
            HashMap<Long, HashMap<Long, Hashtable>> result = new HashMap<Long, HashMap<Long, Hashtable>>();
            for (Long folderId : folderPermList.keySet()) {
                try {
                    HashMap<Long, ArrayList<Long>> permList = folderPermList.get(folderId);
                    for (Long permId : permList.keySet()) {
                        String actionValueId = this.getActionValueId(folderId, permId);
                        Criteria c = new Criteria(Column.getColumn((String)"CVCPermissionData", (String)"INPUT_ID"), (Object)permId, 0);
                        Row permRow = this.cvcDO.getRow("CVCPermissionData", c);
                        if (permRow == null) continue;
                        String message = this.rb.getString("admp.mgmt.fileserver.perm_mgmt.succesfully_modified");
                        String accountId = (String)permRow.get("ACCOUNT_GUID");
                        String domainName = (String)permRow.get("DOMAIN_NAME");
                        ArrayList<String> addToGroupSidList = new ArrayList<String>();
                        addToGroupSidList.add(actionValueId);
                        Row dataSummaryRow = this.cvcDO.getRow("WFCVCDataSummary");
                        String dn = CommonUtil.getDistinguishedName((String)domainName, (String)accountId);
                        ArrayList groupList = new ArrayList();
                        NativeError errHdlr = new NativeError();
                        if (dataSummaryRow.get("ACTION_VALUE_DOMAIN") != null && !domainName.equalsIgnoreCase((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN"))) {
                            groupList = GroupHandler.getDNList((String)((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN")), addToGroupSidList);
                            String searchString = "(&(objectClass=group)(distinguishedName=" + (String)groupList.get(0) + "))";
                            ArrayList propList = new ArrayList();
                            Hashtable<String, Object> props = new Hashtable<String, Object>();
                            props.put("DW_CONTROL_CODE", 3L);
                            props.put("ATTRIB_VALUE", dn);
                            props.put("DATA_HANDLER_TYPE", 1L);
                            props.put("ATTRIB_LDAP_NAME", "member");
                            props.put("ATTRIB_VALUE_COUNT", 1L);
                            propList.add(props);
                            errHdlr = ADHandler.searchAndModifyGroup((String)((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN")), (Long)this.loginId, (String)((String)groupList.get(0)), (String)searchString, null, propList, new ArrayList(), (boolean)false);
                        } else {
                            groupList = GroupHandler.getDNList((String)domainName, addToGroupSidList);
                            errHdlr = ADHandlerForMgmt.modifyGroup((String)domainName, (Long)this.loginId, (String)accountId, (String)dn, new ArrayList(), (ArrayList)groupList, (boolean)true);
                        }
                        String errorSeverity = errHdlr.getSeverityLevel(groupList.get(0));
                        Properties objProp = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)accountId);
                        String userName = objProp.getProperty("OBJECT_NAME") != null ? objProp.getProperty("OBJECT_NAME") : accountId;
                        String actionValue = this.getActionValue(folderId, permId);
                        if (actionValue == null || actionValue.equals("")) {
                            actionValue = actionValueId;
                        }
                        if (errorSeverity == null) {
                            HashMap<Object, Object> permIdResult = result.get(folderId) != null ? result.get(folderId) : new HashMap();
                            permIdResult.put(permId, new Hashtable());
                            result.put(folderId, permIdResult);
                        } else {
                            message = MessageFormat.format(this.rb.getString("admp.workflow.workflow_result.problem_in_adding_user_to_group"), actionValue);
                            Hashtable errorDetails = errHdlr.getErrorDetails(groupList.get(0));
                            if (errorDetails == null) {
                                errorDetails = new Hashtable();
                            }
                            HashMap<Object, Object> permIdResult = result.get(folderId) != null ? result.get(folderId) : new HashMap();
                            permIdResult.put(permId, errorDetails);
                            result.put(folderId, permIdResult);
                        }
                        if (isAuditRequired.booleanValue()) {
                            this.setAuditObjectDetails(folderId, permId, message);
                        }
                        HashMap<String, String> objLogProps = new HashMap<String, String>();
                        objLogProps.put(this.rb.getString("admp.common.attrib_disp_name.user_name"), userName);
                        objLogProps.put(this.rb.getString("admp.common.attrib_disp_name.group_name"), actionValue);
                        objLogProps.put(this.rb.getString("admp.deleg.hdt_deleg.edit_hdt.link.add_remove_groups"), this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.input.add_to_group"));
                        TechAuditAPI.getInstance().auditNTFSPermissions(this.loginId, this.rb.getString("admp.mgmt.fileserver.sub_heading.permission_mgmt"), this.rb.getString("admp.mgmt.fileserver.mgmtname.modify_permission"), objLogProps, domainName, message, this.rb);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.updateAddRemoveGroupResultSummary(result);
        }

        private void removeFromGroup(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList) {
            HashMap<Long, HashMap<Long, Hashtable>> result = new HashMap<Long, HashMap<Long, Hashtable>>();
            for (Long folderId : folderPermList.keySet()) {
                try {
                    HashMap<Long, ArrayList<Long>> permList = folderPermList.get(folderId);
                    for (Long permId : permList.keySet()) {
                        String actionValueId = this.getActionValueId(folderId, permId);
                        Criteria c = new Criteria(Column.getColumn((String)"CVCPermissionData", (String)"INPUT_ID"), (Object)permId, 0);
                        Row permRow = this.cvcDO.getRow("CVCPermissionData", c);
                        if (permRow == null) continue;
                        String statusMessage = this.rb.getString("admp.mgmt.fileserver.perm_mgmt.succesfully_modified");
                        String accountId = (String)permRow.get("ACCOUNT_GUID");
                        String domainName = (String)permRow.get("DOMAIN_NAME");
                        ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
                        removeFromGroupSidList.add(actionValueId);
                        String dn = CommonUtil.getDistinguishedName((String)domainName, (String)accountId);
                        ArrayList<Properties> list = new ArrayList<Properties>();
                        Properties p = new Properties();
                        p.put("ATTRIB_VALUE", dn);
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                        p.put("ATTRIB_LDAP_NAME", "member");
                        p.put("DW_CONTROL_CODE", new Long(4L));
                        list.add(p);
                        for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                            Boolean status = true;
                            String message = "";
                            NativeError errHdlr = new NativeError();
                            try {
                                Row dataSummaryRow = this.cvcDO.getRow("WFCVCDataSummary");
                                String groupDN = null;
                                if (dataSummaryRow.get("ACTION_VALUE_DOMAIN") != null && !domainName.equalsIgnoreCase((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN"))) {
                                    groupDN = CommonUtil.getDistinguishedName((String)((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN")), (String)((String)removeFromGroupSidList.get(index)));
                                    String searchString = "(&(objectClass=group)(distinguishedName=" + groupDN + "))";
                                    ADHandler.searchAndModifyGroup((String)((String)dataSummaryRow.get("ACTION_VALUE_DOMAIN")), (Long)this.loginId, (String)groupDN, (String)searchString, null, list, new ArrayList(), (boolean)true);
                                } else {
                                    groupDN = CommonUtil.getDistinguishedName((String)domainName, (String)((String)removeFromGroupSidList.get(index)));
                                    ADHandlerForMgmt.modifyGroup((String)domainName, (Long)this.loginId, (String)((String)removeFromGroupSidList.get(index)), (String)groupDN, list, null, (boolean)true);
                                }
                            }
                            catch (LocalizedException le) {
                                Hashtable errorDetails = (Hashtable)le.getErrorMsgList().get(0);
                                message = (String)errorDetails.get("NATIVE_ERROR_MESSAGE");
                                status = false;
                            }
                            catch (Exception ex) {
                                message = ex.getMessage();
                                status = false;
                            }
                            Properties objProp = UserMgmtUtil.getObjectPropertiesFromSID((String)domainName, (String)accountId);
                            String userName = objProp.getProperty("OBJECT_NAME") != null ? objProp.getProperty("OBJECT_NAME") : accountId;
                            String actionValue = this.getActionValue(folderId, permId);
                            if (actionValue == null || actionValue.equals("")) {
                                actionValue = actionValueId;
                            }
                            if (!status.booleanValue()) {
                                Hashtable<String, String> errorDetails = new Hashtable<String, String>();
                                errorDetails.put("NATIVE_ERROR_MESSAGE", message);
                                errorDetails.put("ERROR_MESSAGE", message);
                                HashMap permIdResult = result.get(folderId) != null ? (HashMap)result.get(folderId) : new HashMap();
                                permIdResult.put(permId, errorDetails);
                                result.put(folderId, permIdResult);
                                statusMessage = MessageFormat.format(this.rb.getString("admp.workflow.workflow_result.problem_in_removing_user_from_group"), actionValue);
                                this.updateAddRemoveGroupResultSummary(result);
                            }
                            this.setAuditObjectDetails(folderId, permId, statusMessage);
                            HashMap<String, String> objLogProps = new HashMap<String, String>();
                            objLogProps.put(this.rb.getString("admp.common.attrib_disp_name.user_name"), userName);
                            objLogProps.put(this.rb.getString("admp.common.attrib_disp_name.group_name"), actionValue);
                            objLogProps.put(this.rb.getString("admp.deleg.hdt_deleg.edit_hdt.link.add_remove_groups"), this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.input.remove_frm_grp"));
                            TechAuditAPI.getInstance().auditNTFSPermissions(this.loginId, this.rb.getString("admp.mgmt.fileserver.sub_heading.permission_mgmt"), this.rb.getString("admp.mgmt.fileserver.mgmtname.modify_permission"), objLogProps, domainName, statusMessage, this.rb);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void addToGroupAndAssignToFolder(HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermList) {
            this.addToGroup(folderPermList, false);
            DataObject cvcDO1 = (DataObject)this.cvcDO.clone();
            for (Long folderId : folderPermList.keySet()) {
                try {
                    HashMap<Long, ArrayList<Long>> permList = folderPermList.get(folderId);
                    for (Long permId : permList.keySet()) {
                        Criteria c = new Criteria(Column.getColumn((String)"CVCPermissionData", (String)"INPUT_ID"), (Object)permId, 0);
                        Row permRow = cvcDO1.getRow("CVCPermissionData", c);
                        if (permRow == null) continue;
                        permRow.set("ACCOUNT_GUID", (Object)this.getActionValueId(folderId, permId));
                        permRow.set("ACCOUNT_NAME", (Object)this.getActionValueId(folderId, permId));
                        permRow.set("ACCOUNT_TYPE", (Object)"group");
                        cvcDO1.updateRow(permRow);
                    }
                    HashMap<Long, HashMap<Long, ArrayList<Long>>> folderPermListTemp = new HashMap<Long, HashMap<Long, ArrayList<Long>>>();
                    folderPermListTemp.put(folderId, permList);
                    this.setFolderPermission(folderPermListTemp, cvcDO1, "add");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void updateAddRemoveGroupResultSummary(HashMap<Long, HashMap<Long, Hashtable>> result) {
            for (Long folderId : result.keySet()) {
                HashMap<Long, Hashtable> permResult = result.get(folderId);
                for (Long permId : permResult.keySet()) {
                    try {
                        Hashtable errorDetails = permResult.get(permId);
                        if (errorDetails.get("ERROR_MESSAGE") == null) continue;
                        Long uniqueId = this.getCVCUniqueId(folderId, permId);
                        Criteria c = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
                        Row r = this.cvcDO.getRow("WFCVCDataSummary", c);
                        if (r == null) continue;
                        String errorMessage = (String)errorDetails.get("NATIVE_ERROR_MESSAGE");
                        r.set("ACTION_RESULT", (Object)errorMessage);
                        this.cvcDO.updateRow(r);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void completeExecution() {
            try {
                Iterator it = this.cvcDO.getRows("WFCVCDataSummary");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    r.set("IS_EXECUTED", (Object)true);
                    this.cvcDO.updateRow(r);
                }
                Row generationMap = new Row("RequestCVCResultGenerationMap");
                generationMap.set("REQ_MONITOR_TASK_ID", (Object)this.reqMonitorTaskId);
                generationMap.set("REPORT_GENERATION_ID", (Object)this.generationId);
                this.cvcDO.addRow(generationMap);
                this.task.postNativeTask(this.outputFileName);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.cvcDO);
                WorkFlowUtil.cvcMgmtDataObjectCache.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Long getCVCUniqueId(Long folderId, Long permId) {
            return this.cvcUniqueIdHash.get(folderId).get(permId);
        }

        private String getActionValueId(Long folderId, Long permId) {
            try {
                Long uniqueId = this.getCVCUniqueId(folderId, permId);
                Criteria c = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
                Row r = this.cvcDO.getRow("WFCVCDataSummary", c);
                if (r != null) {
                    return (String)r.get("ACTION_VALUE_ID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getActionValue(Long folderId, Long permId) {
            try {
                Long uniqueId = this.getCVCUniqueId(folderId, permId);
                Criteria c = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
                Row r = this.cvcDO.getRow("WFCVCDataSummary", c);
                if (r != null) {
                    return (String)r.get("ACTION_VALUE");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getFolderPath(Long folderId) {
            try {
                Row folderRow = this.cvcDO.getRow("CVCFolderSelectionData", new Criteria(Column.getColumn((String)"CVCFolderSelectionData", (String)"INPUT_ID"), (Object)folderId, 0));
                if (folderRow != null) {
                    return (String)folderRow.get("FOLDER_PATH");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private void setAuditObjectDetails(Long folderId, Long permId, String message) {
            String folderPath = this.getFolderPath(folderId);
            String domainName = FileServerMgmtUtil.getDomainForFolder((String)folderPath);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)this.audit_id, (Long)this.getCVCUniqueId(folderId, permId), null, (String)folderPath, (String)domainName, (String)"fsm", (Boolean)true, (DataObject)this.auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            audit_info.put("error_msg", message);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)this.auditDataObj);
        }
    }
}

