/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CommitRemoveO365Licenses
extends WorkFlowCommitListener {
    private boolean connectToOffice365;
    private ArrayList<String> servicePlanNames = new ArrayList();

    public CommitRemoveO365Licenses() {
        this.reportId = (int)ReportsUtil.O365_LICENSE_MGMT_REPORT_ID;
        this.connectToOffice365 = false;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMWAADServicePlanDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"UNIQUE_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMWAADServicePlanDetails", (String)"SERVICE_NAME"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (dataObj != null) {
                Iterator it = dataObj.getRows("ADSMWAADServicePlanDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    this.servicePlanNames.add((String)r.get("SERVICE_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String objectId = "";
        String upn = "";
        String tenantId = "";
        String tenantPwd = "";
        int operationId = 0;
        Boolean errorOccured = true;
        ArrayList list = new ArrayList();
        ArrayList<Properties> auditPropList = new ArrayList<Properties>();
        HashMap immutableIdProps = new HashMap();
        Boolean isDirSync = false;
        Boolean processLogicalJoin = false;
        ArrayList<Object> attributePropsList = new ArrayList<Object>();
        try {
            objectId = (String)result.get(17001);
            upn = (String)result.get(17004);
            String selectedLicenses = "";
            String groupModifyStatusMessage = "";
            Boolean isRemoveAll = false;
            ArrayList<Properties> licenseDetails = new ArrayList<Properties>();
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            if (!inputsDetails.isEmpty()) {
                AdmpInput admpInput = (AdmpInput)inputsDetails.get(0);
                ArrayList multiInputDetailsList = admpInput.getMultipleInput();
                Boolean isMultiple = admpInput.getIsMultiple();
                for (FcOption fcoption : multiInputDetailsList) {
                    if (fcoption.getLabel().equalsIgnoreCase("domain")) {
                        this.domainName = fcoption.getValue();
                        continue;
                    }
                    if (fcoption.getLabel().equalsIgnoreCase("selectedO365Licenses")) {
                        selectedLicenses = fcoption.getValue();
                        continue;
                    }
                    if (!fcoption.getLabel().equalsIgnoreCase("isRemoveAllO365License")) continue;
                    isRemoveAll = Boolean.valueOf(fcoption.getValue());
                }
                Criteria waadCrit = new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.domainName, 0);
                waadCrit = waadCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"IAMAPP_ID"), (Object)FcLayoutConstants.OFFICE_365_APPID, 0));
                DataObject waadIdDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADADDomainLinkDetails", new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.domainName, 0));
                Iterator it = waadIdDo.getRows("ADSMWAADADDomainLinkDetails");
                Row r = (Row)it.next();
                Long waadDomainId = Long.parseLong(String.valueOf(r.get("WAAD_DOMAIN_ID")));
                DataObject waadDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADDomainConfiguration", new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_DOMAIN_ID"), (Object)waadDomainId, 0));
                Iterator it2 = waadDO.getRows("ADSMWAADDomainConfiguration");
                Row r2 = (Row)it2.next();
                tenantId = (String)r2.get("WAAD_TENANT_ID");
                tenantPwd = (String)r2.get("WAAD_TENANT_PASSWD");
                immutableIdProps = O365MgmtHandler.getImmutableIdDetails((Long)waadDomainId, (String)"user");
                isDirSync = (Boolean)r2.get("IS_DIR_SYNC_ENABLED");
                processLogicalJoin = false;
                ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(46), "o365user");
                for (int i = 0; i < tableNames.size(); ++i) {
                    ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(46));
                    for (int j = 0; j < l.size(); ++j) {
                        Properties p = (Properties)l.get(j);
                        if (attributePropsList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                        attributePropsList.add(p.get("ATTRIB_LDAP_NAME"));
                    }
                }
                if (!isDirSync.booleanValue()) {
                    attributePropsList.remove("ImmutableId");
                    attributePropsList.remove("DecodedImmutableId");
                    if ((String)immutableIdProps.get("WAAD_ATTRIB_NAME") != null) {
                        processLogicalJoin = true;
                    }
                }
                O365InfoCache.getInstance();
                String moduleName = O365InfoCache.getInstalledModule();
                HashMap serviceNameVsPlanId = new HashMap();
                if (!isRemoveAll.booleanValue()) {
                    operationId = 3;
                    JSONObject inputJsonObj = new JSONObject(selectedLicenses);
                    JSONArray licArray = inputJsonObj.getJSONArray("accountSKUDetailsList");
                    for (int i = 0; i < licArray.length(); ++i) {
                        JSONObject licJson = licArray.getJSONObject(i);
                        Properties curLicense = new Properties();
                        String licName = licJson.getString("ACCOUNT_SKU_ID");
                        licName = URLDecoder.decode(licName, "UTF-8");
                        curLicense.put("LicenseName", licName);
                        if (!licJson.getBoolean("IS_SELECTED")) continue;
                        if (moduleName.equalsIgnoreCase("AzureAD")) {
                            Properties licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(licJson.getString("ACCOUNT_SKU_ID"));
                            serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                        }
                        JSONArray spArray = licJson.getJSONArray("ServicePlans");
                        ArrayList<Properties> spDetails = new ArrayList<Properties>();
                        for (int j = 0; j < spArray.length(); ++j) {
                            JSONObject spJson = spArray.getJSONObject(j);
                            Properties curSp = new Properties();
                            if (moduleName.equalsIgnoreCase("AzureAD")) {
                                curSp.put("ServicePlanName", serviceNameVsPlanId.get(spJson.getString("SERVICE_NAME")));
                            } else {
                                curSp.put("ServicePlanName", spJson.getString("SERVICE_NAME"));
                            }
                            curSp.put("TargetClass", spJson.getString("TYPE"));
                            curSp.put("IsDisabled", (Object)(!spJson.getBoolean("IS_SELECTED") ? 1 : 0));
                            spDetails.add(curSp);
                        }
                        curLicense.put("ServicePlans", spDetails);
                        licenseDetails.add(curLicense);
                    }
                    StringBuilder sb = new StringBuilder();
                    for (Properties prop : licenseDetails) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(rb.getString(O365MgmtHandler.getDispNameForWAADAccountSKU((String)prop.getProperty("LicenseName"))));
                        ArrayList spDetails = (ArrayList)prop.get("ServicePlans");
                        ArrayList<String> selectedServPlanList = new ArrayList<String>();
                        for (Properties spProp : spDetails) {
                            if (((Boolean)spProp.get("IsDisabled")).booleanValue()) continue;
                            selectedServPlanList.add(rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)spProp.getProperty("ServicePlanName"))));
                        }
                        if (spDetails.size() == selectedServPlanList.size()) continue;
                        sb.append(selectedServPlanList.toString());
                    }
                    Properties licProp = new Properties();
                    licProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.reports.o365.Licenses"));
                    licProp.put("ATTRIB_VALUE", sb.toString());
                    auditPropList.add(licProp);
                } else {
                    operationId = 4;
                }
                String operation = "";
                switch (operationId) {
                    case 1: {
                        operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_add_to_existing");
                        break;
                    }
                    case 2: {
                        operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_replace_existing");
                        break;
                    }
                    case 3: {
                        operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_revoke_selected_lic");
                        break;
                    }
                    case 4: {
                        operation = rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt_revoke_all");
                    }
                }
                Properties operationProp = new Properties();
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.lic_mgmt"));
                operationProp.put("ATTRIB_VALUE", operation);
                auditPropList.add(operationProp);
                if (!this.connectToOffice365) {
                    String connectionMsg = ADHandler.connectPowershellService((String)tenantId, (String)tenantPwd);
                    if (connectionMsg != null && connectionMsg.trim().length() > 0) {
                        this.isCompleted = true;
                        HDTAuditUtil.updateAuditData((Long)((Long)audit_info.get("object_id")), (String)upn, (String)"OBJECT_NAME", (DataObject)auditDataObj);
                        HDTAuditUtil.updateAuditData((Long)((Long)audit_info.get("object_id")), (String)tenantId, (String)"OBJECT_DOMAIN", (DataObject)auditDataObj);
                        TechAuditAPI.getInstance().auditO365Modification(loginId, rb.getString("admp.mgmt.office365.mgmtdesc.assign_revoke_licenses"), upn, tenantId, auditPropList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
                        return connectionMsg;
                    }
                    this.connectToOffice365 = true;
                }
                String resultMsg = "admp.mgmt.gpo_mgmt_some_err_occ";
                Properties waadAccountProps = DomainInfoCache.getInstance().getWAADDomainProperties(tenantId);
                JSONArray waadAccSkuDetailsList = (JSONArray)waadAccountProps.get("SKU_DETAILS");
                JSONArray authorizedSkuDetsJSON = HelpdeskUtil.getDelegatedAccountSKUDetailsList((JSONArray)waadAccSkuDetailsList, (long)waadDomainId, (Long)loginId, (AdventNetResourceBundle)rb);
                ArrayList<Properties> authorizedLicenseDetails = new ArrayList<Properties>();
                for (int i = 0; i < authorizedSkuDetsJSON.length(); ++i) {
                    Properties skuIdDetails = new Properties();
                    JSONObject accountSKUDet = (JSONObject)authorizedSkuDetsJSON.get(i);
                    String skuId = (String)accountSKUDet.get("ACCOUNT_SKU_ID");
                    if (moduleName.equalsIgnoreCase("AzureAD")) {
                        Properties licenseProp = (Properties)O365InfoCache.getInstance().getO365LicenseStatusProps(skuId);
                        serviceNameVsPlanId = (HashMap)licenseProp.get("serviceNameVsPlanId");
                    }
                    skuIdDetails.put("LicenseName", skuId);
                    ArrayList<Object> authorizedServices = new ArrayList<Object>();
                    JSONArray servPlanList = (JSONArray)accountSKUDet.get("ServicePlans");
                    for (int j = 0; j < servPlanList.length(); ++j) {
                        JSONObject servicePlanObj = (JSONObject)servPlanList.get(j);
                        String service = (String)servicePlanObj.get("SERVICE_NAME");
                        if (moduleName.equalsIgnoreCase("AzureAD")) {
                            authorizedServices.add(serviceNameVsPlanId.get(service));
                            continue;
                        }
                        authorizedServices.add(service);
                    }
                    skuIdDetails.put("ServicePlans", authorizedServices);
                    authorizedLicenseDetails.add(skuIdDetails);
                }
                if (waadAccSkuDetailsList != null) {
                    resultMsg = ADHandler.updateO365Licenses((String)tenantId, (String)tenantPwd, (String)objectId, (int)operationId, (String)"", licenseDetails, (NativeListener)this, (ArrayList)this.attributeList, (String)"ObjectId", authorizedLicenseDetails);
                }
                if (resultMsg != null && resultMsg.length() > 0) {
                    resultMsg = this.getResultString(resultMsg);
                    message.append(resultMsg);
                }
                errorOccured = false;
            } else {
                message = new StringBuffer("admp.workflow.commitrequest.alert.No_inputs_mentioned");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = new StringBuffer("admp.workflow.commitrequest.statmsg.error");
        }
        this.updateResult(objectId, rb.getString(message.toString()), errorOccured);
        HDTAuditUtil.updateAuditData((Long)((Long)audit_info.get("object_id")), (String)upn, (String)"OBJECT_NAME", (DataObject)auditDataObj);
        HDTAuditUtil.updateAuditData((Long)((Long)audit_info.get("object_id")), (String)tenantId, (String)"OBJECT_DOMAIN", (DataObject)auditDataObj);
        TechAuditAPI.getInstance().auditO365Modification(loginId, rb.getString("admp.mgmt.office365.mgmtdesc.assign_revoke_licenses"), upn, tenantId, auditPropList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        Properties props = ADHandler.getO365UserProperties((String)tenantId, (String)tenantPwd, attributePropsList, (String)((String)immutableIdProps.get("ATTRIB_LDAP_NAME")), (String)((String)immutableIdProps.get("WAAD_ATTRIB_NAME")), (boolean)processLogicalJoin, (boolean)isDirSync, (String)"ObjectId", (String)objectId);
        Hashtable tableRowMap = new Hashtable();
        Hashtable relationalTableRowMap = new Hashtable();
        Hashtable uiValues = new Hashtable();
        String o365baseTableName = "O365UserGeneralDetails";
        String o365TableKey = "OBJECT_ID";
        this.addRow(props, objectId, tableRowMap, relationalTableRowMap, uiValues, 46, o365TableKey);
        ArrayList<String> currentGuidList = new ArrayList<String>();
        currentGuidList.add(objectId);
        DBObjectUtil.addOrUpdate((String)o365baseTableName, (String)o365TableKey, currentGuidList, tableRowMap, relationalTableRowMap);
        return rb.getString(message.toString());
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (json.has("friendlyErrorMsg")) {
                    result = json.getString("friendlyErrorMsg");
                    if (json.getBoolean("scanErrorMsg")) {
                        for (int i = 0; i < this.servicePlanNames.size(); ++i) {
                            String curServicePlan = this.servicePlanNames.get(i);
                            result = result.replaceAll(curServicePlan, this.rb.getString(O365MgmtHandler.getDisplayNameForWAADServicePlan((String)curServicePlan)));
                        }
                    }
                } else {
                    result = "admp.mgmt.common.statmsg.successfully_modified";
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }
}

