/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.iam.GAppsUtil;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.webclient.layout.gapps.GappsMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommitResetPassword
extends WorkFlowCommitListener {
    public CommitResetPassword() {
        this.reportId = (int)ReportsUtil.RESET_PASSWORD_USER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String guid;
        Boolean errorOccured;
        StringBuffer message;
        block49: {
            message = null;
            errorOccured = true;
            guid = "";
            try {
                String dn = (String)result.get(1004);
                String sid = (String)result.get(1144);
                this.domainName = (String)result.get(1143);
                guid = (String)result.get(1145);
                String samAccountName = (String)result.get(1006);
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
                ArrayList<Properties> winNTProviderList = new ArrayList<Properties>();
                boolean isSuccess = false;
                boolean changePasswordAtNextLogin = false;
                Logger logger = Logger.getLogger("ADMangLogger");
                int pwdNeverExpires = -1;
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                Long actionToPerform = (Long)requestActionDetails.get("REQUEST_ACTION");
                if (!actionToPerform.equals(6L)) break block49;
                if (!inputsDetails.isEmpty()) {
                    Properties p;
                    String password = null;
                    String passwordType = null;
                    String mustChangePassword = null;
                    String cantChangePassword = null;
                    String passwordNeverExpires = null;
                    for (AdmpInput admpInput : inputsDetails) {
                        if (admpInput.getIsMultiple().booleanValue()) {
                            ArrayList inputsList = admpInput.getMultipleInput();
                            for (FcOption fcOption : inputsList) {
                                if (fcOption.getLabel().equalsIgnoreCase("PasswordType")) {
                                    passwordType = fcOption.getValue();
                                }
                                if (fcOption.getLabel().equalsIgnoreCase("Password")) {
                                    password = fcOption.getValue();
                                }
                                if (fcOption.getLabel().equalsIgnoreCase("UserMustChangePwd")) {
                                    mustChangePassword = fcOption.getValue();
                                }
                                if (fcOption.getLabel().equalsIgnoreCase("CantChangePwd")) {
                                    cantChangePassword = fcOption.getValue();
                                }
                                if (!fcOption.getLabel().equalsIgnoreCase("PwdNeverExpires")) continue;
                                passwordNeverExpires = fcOption.getValue();
                            }
                            continue;
                        }
                        password = admpInput.getValue();
                    }
                    String passwordActionStatusMessage = "";
                    if (passwordType != null && passwordType.equalsIgnoreCase("generatePassword")) {
                        PasswordPolicy pwdPolicy = new PasswordPolicy();
                        pwdPolicy.setPolicyDetails();
                        password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
                    }
                    if (password != null && !password.equals("")) {
                        try {
                            ADHandlerForMgmt.setPassword((String)this.domainName, (Long)loginId, (String)sid, (String)dn, (String)password);
                            errorOccured = false;
                            isSuccess = true;
                            out.log(Level.INFO, "commit Reset password: samaccountname " + samAccountName);
                            passwordActionStatusMessage = rb.getString("admp.workflow.commitrequest.statmsg.success_resetpwd");
                            audit_info.put("password", password);
                            UserHandler.updatePassword((String)this.domainName, (String)sid, (String)password);
                        }
                        catch (LocalizedException le) {
                            message = new StringBuffer(rb.getString("usermanagement.messages.error_changing_password") + le.getMessage(rb));
                            passwordActionStatusMessage = rb.getString("usermanagement.messages.error_changing_password") + le.getMessage(rb);
                        }
                        catch (Exception ex) {
                            message = new StringBuffer(rb.getString("usermanagement.messages.error_changing_password") + ex.getMessage());
                            passwordActionStatusMessage = rb.getString("usermanagement.messages.error_changing_password") + ex.getMessage();
                        }
                        TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, rb.getString("admp.mgmt.user_mgmt.reset_pwd.mgmtname.reset_password"), samAccountName, this.domainName, "password", password, passwordActionStatusMessage, rb.getString("admp.mgmt.user_mgmt.mgmtcategory.user_modification"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                        out.log(Level.INFO, "Resetpassword action completed for the user name " + samAccountName);
                    }
                    String statusMessage = "";
                    if (message == null && mustChangePassword != null) {
                        p = new Properties();
                        p.put("DATA_HANDLER_TYPE", new Long(10L));
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                        try {
                            if (mustChangePassword.equalsIgnoreCase("true")) {
                                changePasswordAtNextLogin = true;
                                boolean checkCantChangePassword = ADHandlerForMgmt.checkCantChangePassword((String)this.domainName, (Long)loginId, (String)samAccountName, (String)dn);
                                if (checkCantChangePassword && cantChangePassword == null) {
                                    throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.cant_set_change_pwd_next_logon_cannot_as_cant_change_pwd"));
                                }
                                if (ADHandlerForMgmt.checkPasswordNeverExpires((String)this.domainName, (Long)loginId, (String)sid, (String)dn) && passwordNeverExpires == null) {
                                    throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.pwd_never_expires_set_so_cannot_set_change_pwd_next_logon"));
                                }
                                p.put("ATTRIB_VALUE", new Long(0L));
                                setAttributeList.add(p);
                            } else if (mustChangePassword.equalsIgnoreCase("false")) {
                                p.put("ATTRIB_VALUE", new Long(-1L));
                                setAttributeList.add(p);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = new StringBuffer(e.getMessage());
                            statusMessage = e.getMessage();
                        }
                    }
                    if (message == null && cantChangePassword != null) {
                        p = new Properties();
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("ATTRIB_LDAP_NAME", "userFlags");
                        try {
                            if (cantChangePassword.equalsIgnoreCase("true")) {
                                if (ADHandlerForMgmt.checkUserMustChangePassword((String)this.domainName, (Long)loginId, (String)sid, (String)dn) && mustChangePassword == null) {
                                    throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.uncheck_the_change_pwd_next_logon_and_apply"));
                                }
                                p.put("ATTRIB_VALUE", String.valueOf(64));
                                winNTProviderList.add(p);
                            } else if (cantChangePassword.equalsIgnoreCase("false")) {
                                p.put("ATTRIB_AND_VALUE", String.valueOf(-65));
                                winNTProviderList.add(p);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = new StringBuffer(e.getMessage());
                            statusMessage = e.getMessage();
                        }
                    }
                    if (message == null && passwordNeverExpires != null) {
                        int userAccountControl = 0;
                        int andUserAccountControl = 0xFFFFFFF;
                        Properties p1 = new Properties();
                        p1.put("DATA_HANDLER_TYPE", new Long(7L));
                        p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p1.put("ATTRIB_LDAP_NAME", "userAccountControl");
                        try {
                            if (passwordNeverExpires.equalsIgnoreCase("true")) {
                                if (ADHandlerForMgmt.checkUserMustChangePassword((String)this.domainName, (Long)loginId, (String)sid, (String)dn) && mustChangePassword == null) {
                                    throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.uncheck_the_change_pwd_next_logon_and_apply"));
                                }
                                p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl |= 0x10000));
                                p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                                p1.put("ATTRIB_UAC_VALUE", MessageFormat.format(rb.getString("admp.auditing.uac_password_never_expire_flag"), rb.getString("admp.common.attribvalue.true")));
                                modifyAttributeList.add(p1);
                                pwdNeverExpires = 1;
                            } else if (passwordNeverExpires.equalsIgnoreCase("false")) {
                                p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
                                p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl &= 0xFFEFFFF));
                                p1.put("ATTRIB_UAC_VALUE", MessageFormat.format(rb.getString("admp.auditing.uac_password_never_expire_flag"), rb.getString("admp.common.attribvalue.false")));
                                modifyAttributeList.add(p1);
                                pwdNeverExpires = 0;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = new StringBuffer(e.getMessage());
                            statusMessage = e.getMessage();
                        }
                    }
                    out.log(Level.INFO, "Password options native attributes list " + setAttributeList);
                    if (setAttributeList.size() != 0 || modifyAttributeList.size() != 0 || winNTProviderList.size() != 0) {
                        try {
                            ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, setAttributeList, modifyAttributeList, new ArrayList(), new ArrayList(), null);
                            if (cantChangePassword != null && winNTProviderList.size() > 0) {
                                boolean cantChangePasswordBool = false;
                                if (cantChangePassword.equalsIgnoreCase("true")) {
                                    cantChangePasswordBool = true;
                                }
                                String distinguishedName = CommonUtil.escapeSpecialCharacters((String)dn);
                                UserMgmtUtil.setUserCannotChangePass((boolean)cantChangePasswordBool, (String)this.domainName, (Long)loginId, (String)distinguishedName, (String)samAccountName);
                            }
                            errorOccured = false;
                            statusMessage = rb.getString("admp.mgmt.common.text.successfully_modified");
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            message = new StringBuffer(rb.getString("groupmanagement.messages.successfully_modified_error") + le.getMessage(rb));
                            statusMessage = rb.getString("groupmanagement.messages.successfully_modified_error") + le.getMessage(rb);
                        }
                        catch (Exception e) {
                            errorOccured = true;
                            message = new StringBuffer(rb.getString("groupmanagement.messages.successfully_modified_error") + e.getMessage());
                            statusMessage = rb.getString("groupmanagement.messages.successfully_modified_error") + e.getMessage();
                        }
                    }
                    TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.reset_pwd.mgmtname.password_options"), samAccountName, this.domainName, setAttributeList, modifyAttributeList, winNTProviderList, statusMessage, (Long)audit_info.get("object_id"), auditDataObj, rb);
                    if (message == null) {
                        message = new StringBuffer(rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    }
                    if (isSuccess) {
                        String objectId;
                        HashMap policyMap = DeprovisionUtil.getResetPasswordPolicyMap((String)this.domainName);
                        if (Boolean.valueOf((String)policyMap.get("reset_password_google_apps")).booleanValue() && (objectId = GAppsUtil.getObjectId((String)guid)) != null && objectId != "") {
                            logger.log(Level.INFO, "Start: Reset Password in Google Apps");
                            if (GappsMgmtUtil.resetPassword(this.domainName, loginId, objectId, password, changePasswordAtNextLogin)) {
                                logger.log(Level.INFO, "Password reset successful in Google Apps");
                                message.append(" " + rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_successful"));
                            } else {
                                message.append(" " + rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_failure"));
                                logger.log(Level.INFO, "Could not reset password in Google Apps");
                            }
                        }
                        if (Boolean.valueOf((String)policyMap.get("reset_password_in_o365")).booleanValue()) {
                            message.append(DeleteUtil.resetO365UserPwd(this.domainName, loginId, guid, password, changePasswordAtNextLogin, pwdNeverExpires, rb));
                        }
                    }
                    break block49;
                }
                out.log(Level.SEVERE, "CommitResetPassword inputdetails list empty.. This case should not occurred.. severity case.. needs to analyse");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateResult(guid, message.toString(), errorOccured);
        return message.toString();
    }
}

