/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.workflow.RequestExecutionFlow;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitUserModification
extends WorkFlowCommitListener {
    @Override
    public void commitReqMonitorFollowRequestTask(Long requestId, Long reqMonitorTaskId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
        ArrayList inputsDetails = (ArrayList)inputDetails.get("MultipleInputs");
        Long userCreationId = WFRequestUtil.getUserCreationId((Long)reqMonitorTaskId);
        ADMPAuthObject authObject = new ADMPAuthObject(loginId);
        this.reportId = ReportsUtil.MODIFY_USER_ATTRIBUTES;
        this.domainName = WFRequestUtil.getWFRequestDomainName((Long)requestId);
        String totalAttributeList = "";
        String toBeUpdateAttributeList = "";
        String toBeFormADSearchAttributeList = "";
        String customAttributeString = "";
        String isAppendValue = "true";
        String isClearValue = "true";
        try {
            if (!inputsDetails.isEmpty()) {
                for (AdmpInput admpInput : inputsDetails) {
                    String actionType = admpInput.getName();
                    ArrayList multiInputDetailsList = admpInput.getMultipleInput();
                    Boolean isMultiple = admpInput.getIsMultiple();
                    for (FcOption fcoption : multiInputDetailsList) {
                        if (fcoption.getLabel().equalsIgnoreCase("validSelected")) {
                            toBeUpdateAttributeList = fcoption.getValue();
                            continue;
                        }
                        if (fcoption.getLabel().equalsIgnoreCase("totalAttributes")) {
                            totalAttributeList = fcoption.getValue();
                            continue;
                        }
                        if (fcoption.getLabel().equalsIgnoreCase("validSelectedValues")) {
                            toBeFormADSearchAttributeList = fcoption.getValue();
                            continue;
                        }
                        if (fcoption.getLabel().equalsIgnoreCase("customAttributes")) {
                            customAttributeString = fcoption.getValue();
                            continue;
                        }
                        if (fcoption.getLabel().equalsIgnoreCase("isAppendMultiValue")) {
                            isAppendValue = fcoption.getValue();
                            continue;
                        }
                        if (!fcoption.getLabel().equalsIgnoreCase("isClearEmptyValue")) continue;
                        isClearValue = fcoption.getValue();
                    }
                }
                out.log(Level.INFO, "ModifyUser by CSV Import action input details : totalAttributeList : " + totalAttributeList + " toBeUpdateAttributeList : " + toBeUpdateAttributeList + " toBeFormADSearchAttributeList : " + toBeFormADSearchAttributeList + " domainName :: " + this.domainName);
                String[] attributeList = totalAttributeList.split(";");
                ArrayList totalAttributeProps = ReportAttributesUtil.getAttributeProps((String[])attributeList, (String)"ATTRIB_ID", null);
                out.log(Level.INFO, "totalAttributeProps :: " + totalAttributeProps);
                String[] customAttributeArray = customAttributeString.split(";");
                String[] toBeUpdateAttributeArray = toBeUpdateAttributeList.split(";");
                String[] toBeFormSearchAttribArray = toBeFormADSearchAttributeList.split(";");
                ArrayList validSelectedAttribList = ReportAttributesUtil.getAttributeProps((ArrayList)totalAttributeProps, (String[])toBeUpdateAttributeArray);
                ArrayList validSelectedValuesAttribList = ReportAttributesUtil.getAttributeProps((ArrayList)totalAttributeProps, (String[])toBeFormSearchAttribArray);
                for (String customAttribName : customAttributeArray) {
                    validSelectedAttribList.add(customAttribName);
                }
                String[] validSelected = validSelectedAttribList.toArray(new String[validSelectedAttribList.size()]);
                String[] validSelectedValues = validSelectedValuesAttribList.toArray(new String[validSelectedValuesAttribList.size()]);
                String keyLdapName = RequestExecutionFlow.getKeyLdapName((ArrayList)totalAttributeProps);
                Hashtable domainVsIds = authObject.getDomainActionMap();
                Long[] ids = authObject.getActionArray();
                CSVUserListener listener = this.initListener(loginId, ids, domainVsIds, new ArrayList());
                ArrayList userDetailsList1 = AddUserHandler.getInstance().getUserDetailsList(userCreationId, totalAttributeProps, -1, -1, null);
                listener.init(this.reportId, userCreationId, this.domainName, userDetailsList1, keyLdapName, requestId, null);
                listener.setAuthorizedDomainOUHash(authObject.getDomainOUsMap());
                listener.setValidSelected(validSelected);
                listener.setAdvancedOptions(isAppendValue, isClearValue);
                listener.setWorkflowMode(true);
                if (validSelectedValues.length != 0) {
                    listener.setValidSelectedValues(validSelectedValues);
                }
                listener.rb = rb;
                String hostIdInfo = System.getProperty("user.name");
                listener.setHostId(hostIdInfo);
                listener.modifyUser();
                while (!listener.isCompleted()) {
                    Thread.sleep(100L);
                }
                this.isCompleted = true;
                out.log(Level.INFO, "ModifyUsr by csv import action completed for the usercreationId " + userCreationId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CSVUserListener initListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        CSVUserListener listener = null;
        try {
            String className = "com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener";
            if (this.reportId != null) {
                DataObject obj = ReportHandler.getReportDetails((Integer)this.reportId);
                Row r = obj.getFirstRow("ADSMReports");
                className = (String)r.get("CLASS_NAME");
            }
            Class<?> classToInvoke = Class.forName(className.trim());
            Class[] args = new Class[]{loginId.getClass(), ids.getClass(), domainVsIds.getClass(), groupList.getClass()};
            Object[] objs = new Object[]{loginId, ids, domainVsIds, groupList};
            Constructor<?> ct = classToInvoke.getConstructor(args);
            listener = (CSVUserListener)ct.newInstance(objs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listener;
    }
}

