/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.util.ScheduledMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.workflow.ScheduledRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScheduledMgmtAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("WFLogger");

    public void initRoboDetails(HttpServletRequest request, DynaValidatorForm bean, Long loginId, Long roboId) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.init(request, bean, loginId);
        this.initTimeValues(bean, roboId);
        ScheduledRequest robo = new ScheduledRequest(roboId, Boolean.valueOf(true));
        bean.set("roboId", (Object)robo.getRoboId());
        bean.set("roboName", (Object)robo.getRoboName());
        bean.set("description", (Object)robo.getDescription());
        bean.set("subject", (Object)robo.getSubject());
        bean.set("domains", (Object)robo.getDomainName());
        bean.set("requestAction", (Object)robo.getRequestAction());
        bean.set("subCategory", (Object)robo.getSubCategory());
        bean.set("requestTypeList", (Object)WorkFlowUtil.getRequestTypes(null, (Integer)robo.getSubCategory()));
        bean.set("domainOUList", (Object)robo.getDomainOUList());
        bean.set("reportValue", (Object)rb.getString(ScheduledMgmtUtil.getReportDetails((Long)roboId)));
        ArrayList reportIds = robo.getReportIDS();
        if (!reportIds.isEmpty()) {
            String key = "report_id";
            for (int j = 0; j < reportIds.size(); ++j) {
                Hashtable reportId = (Hashtable)reportIds.get(j);
                request.setAttribute("report_id", (Object)((Integer)reportId.get(key)));
            }
        }
        HashMap actionInputsMap = robo.getActionInputs();
        String templateId = (String)actionInputsMap.get("template");
        String csvLocation = (String)actionInputsMap.get("csvLocation");
        bean.set("newPassword", (Object)"");
        bean.set("template", (Object)templateId);
        bean.set("csvLocation", (Object)csvLocation);
        bean.set("inputValue", actionInputsMap.get("Container"));
        bean.set("domainSelect", actionInputsMap.get("domainSelect"));
        bean.set("selectedOUName", actionInputsMap.get("selectedOUName"));
    }

    public void init(HttpServletRequest request, DynaValidatorForm bean, Long loginId) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String[] hoursDef = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
        Integer[] hourValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        String[] minutesDef = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
        Integer[] minuteValues = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
        String[] dayValues = new String[]{rb.getString("admp.common.days.sunday"), rb.getString("admp.common.days.monday"), rb.getString("admp.common.days.tuesday"), rb.getString("admp.common.days.wednesday"), rb.getString("admp.common.days.thursday"), rb.getString("admp.common.days.friday"), rb.getString("admp.common.days.saturday")};
        String[] dateDef = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
        Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        bean.set("hours", (Object)hoursDef);
        bean.set("hourValues", (Object)hourValues);
        bean.set("minutes", (Object)minutesDef);
        bean.set("minuteValues", (Object)minuteValues);
        bean.set("days", (Object)days);
        bean.set("dayValues", (Object)dayValues);
        bean.set("date", (Object)dateDef);
        bean.set("dateValues", (Object)dateValues);
        ArrayList subCategoryList = WorkFlowUtil.getRequestSubCategoryDetails();
        HashMap categoryTable = (HashMap)subCategoryList.get(0);
        Integer subCategory = (Integer)categoryTable.get("SUB_CATEGORY");
        bean.set("subCategoryList", (Object)subCategoryList);
        bean.set("subCategory", (Object)subCategory);
        bean.set("requestTypeList", (Object)WorkFlowUtil.getRequestTypes(null, (Integer)subCategory));
        bean.set("roboName", (Object)"");
        bean.set("description", (Object)"");
        bean.set("subject", (Object)"");
        bean.set("scheduleType", (Object)"");
        bean.set("inputValues", new ArrayList());
        bean.set("reportValue", (Object)"");
        try {
            Hashtable domains = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            ArrayList domainList = (ArrayList)domains.get("domainList");
            bean.set("domainList", (Object)domainList);
            String[] defaultNamingList = new String[domainList.size()];
            String[] domainNames = new String[domainList.size()];
            int j = 0;
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                String domainName1 = domainProp.getProperty("DOMAIN_NAME");
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                if (!ClientAuthorizationUtil.isAuthorized(request, domainName1, (Long)8000L).booleanValue()) continue;
                defaultNamingList[j] = defaultNamingContext;
                domainNames[j] = domainName1;
                ++j;
            }
            bean.set("inputValues", new ArrayList());
            bean.set("defaultNamingList", (Object)defaultNamingList);
            bean.set("domainNames", (Object)domainNames);
            bean.set("domainOUList", new Hashtable());
            bean.set("templateList", (Object)UserTemplateHandler.getTemplates((Long)loginId, (String)"TEMPLATE_NAME", (Boolean)true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initTimeValues(DynaValidatorForm bean, Long schedule_id) {
        String scheduleType = SchedulerUtil.getScheduleType((Long)schedule_id);
        ArrayList timeDetails = SchedulerUtil.getScheduleTimeDetails((String)scheduleType, (Long)schedule_id);
        Hashtable hash = (Hashtable)timeDetails.get(0);
        bean.set("scheduleType", (Object)scheduleType);
        if (scheduleType.equalsIgnoreCase("hourly")) {
            Long TIME_PERIOD = (Long)hash.get("TIME_PERIOD");
            bean.set("hoursel1", (Object)TIME_PERIOD.intValue());
        } else {
            String REPEAT_FREQUENCY = (String)hash.get("REPEAT_FREQUENCY");
            Integer DAY_OF_WEEK = (Integer)hash.get("DAY_OF_WEEK");
            Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
            Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String executionTime = (String)hash.get("EXECUTION_TIME");
            String hrs = executionTime.substring(0, executionTime.indexOf(58));
            String mns = executionTime.substring(executionTime.indexOf(58) + 1, executionTime.lastIndexOf(58));
            Integer hours = Integer.parseInt(hrs);
            Integer minutes = Integer.parseInt(mns);
            if (scheduleType.equalsIgnoreCase("Daily")) {
                bean.set("dailysel1", (Object)hours);
                bean.set("dailysel2", (Object)minutes);
            } else if (scheduleType.equalsIgnoreCase("Weekly")) {
                bean.set("weeklysel1", (Object)days[DAY_OF_WEEK - 1]);
                bean.set("weeklysel2", (Object)hours);
                bean.set("weeklysel3", (Object)minutes);
            } else if (scheduleType.equalsIgnoreCase("Monthly")) {
                bean.set("monthsel1", (Object)DATE_OF_MONTH);
                bean.set("monthsel2", (Object)hours);
                bean.set("monthsel3", (Object)minutes);
            }
        }
    }

    public HashMap getTimeValues(HttpServletRequest request, DynaValidatorForm bean, AdventNetResourceBundle rb) {
        HashMap<String, Object> timeValues = new HashMap<String, Object>();
        int hours = 0;
        int minutes = 0;
        int day = 0;
        int date = 0;
        String timeSummary = null;
        String scheduleType = request.getParameter("repSchedule");
        if (scheduleType != null) {
            if (scheduleType.equalsIgnoreCase("daily")) {
                hours = (Integer)bean.get("dailysel1");
                minutes = (Integer)bean.get("dailysel2");
                timeSummary = MessageFormat.format(rb.getString("client.reports.SchedulerAction.daily"), hours, minutes);
            } else if (scheduleType.equalsIgnoreCase("weekly")) {
                day = (Integer)bean.get("weeklysel1");
                hours = (Integer)bean.get("weeklysel2");
                minutes = (Integer)bean.get("weeklysel3");
                String[] dayValues = (String[])bean.get("dayValues");
                timeSummary = MessageFormat.format(rb.getString("client.reports.SchedulerAction.weekly_on"), dayValues[day - 1], hours, minutes);
            } else if (scheduleType.equalsIgnoreCase("monthly")) {
                date = (Integer)bean.get("monthsel1");
                hours = (Integer)bean.get("monthsel2");
                minutes = (Integer)bean.get("monthsel3");
                timeSummary = MessageFormat.format(rb.getString("client.reports.SchedulerAction.monthly_on"), date, hours, minutes);
            } else if (scheduleType.equalsIgnoreCase("hourly")) {
                hours = (Integer)bean.get("hoursel1");
                timeSummary = MessageFormat.format(rb.getString("client.reports.SchedulerAction.for_each"), hours);
            }
        }
        timeValues.put("scheduleType", scheduleType);
        timeValues.put("hours", hours);
        timeValues.put("minutes", minutes);
        timeValues.put("day", day);
        timeValues.put("date", date);
        timeValues.put("timeSummary", timeSummary);
        return timeValues;
    }

    public ActionForward scheduledWorkFlows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "showScheduledRequests";
        return mapping.findForward(forwardPage);
    }

    public ActionForward updateScheduledWorkFlowStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "showScheduledRequests";
        Long taskId = SchedulerUtil.getTaskID((String)"MgmtAutomation");
        Long scheduleId = Long.valueOf(request.getParameter("scheduleId"));
        String action = request.getParameter("action");
        if (action != null && action.equalsIgnoreCase("Disable")) {
            SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)4);
        } else if (action.equalsIgnoreCase("Enable")) {
            SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)3);
        } else if (action.equalsIgnoreCase("Delete")) {
            ScheduledMgmtUtil.deleteRoboRequester((Long)scheduleId);
            WorkFlowUtil.deleteRequests((Long)scheduleId, (Long[])new Long[]{WorkFlowUtil.ROBO_MODE});
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward scheduledMgmtReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "scheduledReportDetails";
        ArrayList scheduledReportDetails = new ArrayList();
        HttpSession session = request.getSession();
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String ascending = request.getParameter("ascending");
            Boolean ascending1 = null;
            if (ascending != null && ascending.equalsIgnoreCase("true")) {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
                bean.set("ascending", (Object)"false");
                ascending1 = true;
            } else if (ascending != null) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
                bean.set("ascending", (Object)"true");
                ascending1 = false;
            }
            scheduledReportDetails = SchedulerInputsUtil.getScheduledReportDetails(loginId, ascending1);
            request.setAttribute("scheduledReportDetails", (Object)scheduledReportDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward addReportInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            ArrayList inputValues = (ArrayList)bean.get("inputValues");
            String reportID = request.getParameter("id");
            for (int i = 0; i < inputValues.size(); ++i) {
                ArrayList inputs = (ArrayList)inputValues.get(i);
                for (int j = 0; j < inputs.size(); ++j) {
                    Hashtable hash = (Hashtable)inputs.get(j);
                    Integer reportId = 0;
                    Enumeration e = hash.keys();
                    while (e.hasMoreElements()) {
                        reportId = (Integer)e.nextElement();
                    }
                    if (!reportId.toString().equalsIgnoreCase(reportID)) continue;
                    inputValues.remove(inputs);
                    --i;
                }
            }
            String parameterNames = "";
            Hashtable<Object, Object> hash = new Hashtable<Object, Object>();
            ArrayList<Hashtable<Object, Object>> val = new ArrayList<Hashtable<Object, Object>>();
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                parameterNames = (String)e.nextElement();
                if (parameterNames.equalsIgnoreCase("methodToCall") || parameterNames.equalsIgnoreCase("id") || parameterNames.equalsIgnoreCase("properties")) continue;
                if (request.getParameter("properties") != null && request.getParameter("properties").equalsIgnoreCase("domainPattern")) {
                    ObjectName obj = new ObjectName(request.getParameter(parameterNames));
                    Hashtable<String, String> hashProps = obj.getKeyPropertyList();
                    Enumeration<String> enumeration = hashProps.keys();
                    while (enumeration.hasMoreElements()) {
                        String property = enumeration.nextElement();
                        hash.put(parameterNames, hashProps.get(property));
                        hash.put("PROPERTIES", property);
                        val.add(hash);
                        hash = new Hashtable();
                    }
                    continue;
                }
                hash.put(parameterNames, request.getParameter(parameterNames));
            }
            if (val.size() == 0) {
                val.add(hash);
            }
            hash = new Hashtable();
            hash.put(Integer.parseInt(reportID), val);
            val = new ArrayList();
            val.add(hash);
            if (!inputValues.isEmpty()) {
                inputValues.remove(0);
            }
            inputValues.add(val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeReportInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            ArrayList inputValues = (ArrayList)bean.get("inputValues");
            String reportID = request.getParameter("id");
            for (int i = 0; i < inputValues.size(); ++i) {
                ArrayList inputs = (ArrayList)inputValues.get(i);
                for (int j = 0; j < inputs.size(); ++j) {
                    Hashtable hash = (Hashtable)inputs.get(j);
                    Integer reportId = 0;
                    Enumeration e = hash.keys();
                    while (e.hasMoreElements()) {
                        reportId = (Integer)e.nextElement();
                    }
                    if (!reportId.toString().equalsIgnoreCase(reportID)) continue;
                    inputValues.remove(inputs);
                    --i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward loadRequestActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String subCategory = request.getParameter("subCategory");
            ArrayList requestTypeList = WorkFlowUtil.getRequestTypes(null, (Integer)new Integer(subCategory));
            ByteArrayOutputStream outNode = null;
            bean.set("requestTypeList", (Object)requestTypeList);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (HashMap map : requestTypeList) {
                Element requestActionElement = document.createElement("requestTypes");
                requestActionElement.setAttribute("WF_ACTION_NAME", rb.getString((String)map.get("WF_ACTION_NAME")));
                requestActionElement.setAttribute("WF_ACTION_ID", map.get("WF_ACTION_ID").toString());
                data.appendChild(requestActionElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward addActionInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            ArrayList<String> values = new ArrayList<String>();
            String[] actionValues = request.getParameterValues("actions");
            for (int i = 0; i < actionValues.length; ++i) {
                values.add(actionValues[i]);
            }
            bean.set("actionValues", values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

