/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflowRule;
import com.adventnet.sym.adsm.common.server.workflow.TaskInputsUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFAttributeHandler;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleConstants;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlow;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroHandler;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRArrayList;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ListUserDataProvider;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportExporter;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorkFlowClientUtil
extends WorkFlowUtil {
    private static Logger out = Logger.getLogger("WFLogger");

    public static boolean createRequest(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long requestId = null;
        try {
            String domainName;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (!LicenseMgr.getInstance().isModuleLicensed("Workflow")) {
                request.setAttribute("message", (Object)rb.getString("admp.workflow.common.license_error"));
                return false;
            }
            if (!CommonUtil.isAdmpTechAvailable()) {
                request.setAttribute("requestId", (Object)0L);
                request.setAttribute("message", (Object)MessageFormat.format(rb.getString("admp.ad_deleg.license_restriction_module_message"), rb.getString(LicenseUtil.HIGHER_VERSION), rb.getString("admp.workflow.createrequest.title_create_request")));
                return false;
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList selectedSIDsList = new ArrayList();
            AbstractListener listener = bean.getListener();
            String resultTableName = "";
            String baseTableName = "";
            Long generationID = 0L;
            if (listener != null) {
                resultTableName = listener.getResultTableName();
                generationID = listener.getGenerationId();
            } else {
                Integer reportID = Integer.parseInt(request.getParameter("oldReportId"));
                Row r = ReportHandler.getReportDetailsRow((Integer)reportID);
                resultTableName = (String)r.get("RESULT_TABLE_NAME");
                baseTableName = (String)r.get("BASE_TABLE_NAME");
                generationID = Long.parseLong(request.getParameter("oldGenerationId"));
            }
            JSONObject selectedSids = null;
            if (request.getParameter("selectedSids") != null) {
                selectedSids = new JSONObject(request.getParameter("selectedSids"));
            }
            selectedSIDsList = ReportResultInputUtil.getSelectedSids(selectedSids, resultTableName, generationID, baseTableName, null);
            String subject = request.getParameter("Subject");
            String desc = request.getParameter("Description");
            String inputValue = null;
            if (request.getParameter("inputValue") != null) {
                inputValue = request.getParameter("inputValue");
            }
            String requestAction = request.getParameter("requestAction");
            ArrayList multipleActions = TaskInputsUtil.getActionsWithInputs((String)inputValue, (String)requestAction);
            String priority = request.getParameter("priority");
            Integer category = new Integer(0);
            Integer subcategory = new Integer(0);
            Integer reportId = (Integer)bean.get("reportId");
            if (reportId == null || reportId != null && reportId == -1) {
                reportId = Integer.parseInt(request.getParameter("oldReportId"));
            }
            if (request.getParameter("subCategoryId") != null) {
                subcategory = Integer.parseInt(request.getParameter("subCategoryId"));
            }
            out.log(Level.INFO, " Report Id from the bean :" + reportId);
            if (reportId != null) {
                DataObject dataObj;
                if (subcategory == 0) {
                    dataObj = DataAccess.get((String)WFRuleConstants.ADSMWorkFlowCategoryReports, (Criteria)new Criteria(Column.getColumn((String)WFRuleConstants.ADSMWorkFlowCategoryReports, (String)"REPORT_ID"), (Object)reportId, 0));
                    subcategory = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMWorkFlowCategoryReports, "SUB_CATEGORY");
                }
                dataObj = DataAccess.get((String)WFRuleConstants.ADSMRequestSubCategory, (Criteria)new Criteria(new Column(WFRuleConstants.ADSMRequestSubCategory, "SUB_CATEGORY"), (Object)subcategory, 0));
                category = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMRequestSubCategory, "CATEGORY");
            }
            String tableName = WorkFlowUtil.getDetailsTableName((Integer)subcategory);
            ArrayList wfAuthorizedDomainList = WorkFlowUserHandler.getAuthorizedDomainListForCatagory((Long)loginId, (Integer)subcategory);
            ArrayList<String> domainList = new ArrayList<String>();
            for (int i = 0; i < wfAuthorizedDomainList.size(); ++i) {
                Properties prop = (Properties)wfAuthorizedDomainList.get(i);
                domainName = prop.getProperty("DOMAIN_NAME");
                ArrayList authorizedRequestTypesList = WorkFlowUserHandler.getAllAuthorizedRequestTypesList((Long)loginId, (String)domainName);
                if (!authorizedRequestTypesList.contains(new Long(requestAction))) continue;
                domainList.add(domainName);
            }
            ArrayList authorizedGUIDsList = WorkFlow.getAuthorizedGUIDsList((Long)loginId, (ArrayList)selectedSIDsList, (String)tableName, (Object[])domainList.toArray());
            Boolean isPartialRequest = false;
            if (authorizedGUIDsList.size() != selectedSIDsList.size()) {
                isPartialRequest = true;
            }
            domainName = request.getParameter("domainName");
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(multipleActions);
            wfRequest.setSelectedGuidList(authorizedGUIDsList);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setDomainName(domainName);
            requestId = wfRequest.createRequest(loginId, null, subject, desc, category, subcategory);
            out.log(Level.INFO, "Manual Request Created - Input details " + multipleActions + " RequestId " + requestId);
            bean.set("selectedSIDs", new ArrayList());
            bean.set("modifyResultColumn", "");
            bean.set("RANGE", new Integer(25));
            bean.set("FROM_INDEX", new Long(1L));
            bean.set("PAGE_NUMBER", "1");
            bean.set("ascending", "true");
            if (requestId != null) {
                WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(1), requestId, rb, loginId);
                executeRule.start();
                out.log(Level.INFO, "Request Creation Success : RequestId: " + requestId);
                if (isPartialRequest.booleanValue()) {
                    request.setAttribute("message", (Object)"Partial");
                } else {
                    request.setAttribute("message", (Object)"Success");
                }
                request.setAttribute("requestId", (Object)requestId);
                return true;
            }
            out.log(Level.INFO, "Request Creation Failure occurred");
            request.setAttribute("message", (Object)"Failure");
            request.setAttribute("requestId", (Object)requestId);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Request Creation Failure occurred");
            request.setAttribute("message", (Object)"Failure");
            request.setAttribute("requestId", requestId);
            return false;
        }
    }

    public static void export(Long taskDetailsId, String taskName, String storageDir, String reportFileName, String reportType, ArrayList attributeList, ArrayList resultList, Map inputParams, Long loginId, Hashtable multipleValuesSids, AdventNetResourceBundle rb) {
        try {
            System.out.println(" ExportRequestResult started");
            Locale locale = I18NUtil.getDefaultLocale((Long)loginId);
            ReportJRDataSource dataSource = new ReportJRDataSource(resultList, multipleValuesSids, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName((String)inputParams.get("subject"));
            reportFileName = "ADMPWorkflowExecutedResult";
            if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                JRElement[] elements = titleBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    titleBand.removeElement((JRDesignElement)elements[i]);
                }
                titleBand.setHeight(0);
                JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                JRElement[] elements1 = pageHeaderBand.getElements();
                for (int i = 0; i < elements1.length; ++i) {
                    pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
                }
                pageHeaderBand.setHeight(0);
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                JRElement[] elements2 = pageFooterBand.getElements();
                for (int i = 0; i < elements2.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements2[i]);
                }
                pageFooterBand.setHeight(0);
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (reportType.toLowerCase().indexOf("html") != -1 || reportType.toLowerCase().indexOf("pdf") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, resultList, multipleValuesSids, reportType, rb);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.log(Level.INFO, "Input Params After Filling " + inputParams);
                return;
            }
            ReportExporter exporter = new ReportExporter();
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                exporter.exportAsPdf(print, taskName, taskDetailsId, storageDir, loginId);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                out.log(Level.INFO, "The reportFileName in abs exportreport is : " + reportFileName);
                exporter.exportAsHTML(print, taskName, taskDetailsId, storageDir);
            } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
                exporter.exportAsXLSX(print, taskName, taskDetailsId, storageDir, formatPatternMap);
            } else {
                out.log(Level.INFO, "Invalid Report Type");
            }
            String password = PasswordUtil.getExportFilePassword((Long)loginId);
            if (password != null && !password.equals("")) {
                ZipUtility.makeZip(storageDir, password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportRequests(String reportFileName, String reportType, String searchFilter, ArrayList attributeList, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        JRArrayList tempJRReportList = new JRArrayList();
        Long loginId = null;
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        Object tempJRReportFileName = null;
        Hashtable multipleValuesSids = new Hashtable();
        int startIndex = 1;
        int exportCount = 0;
        try {
            Hashtable columnWidths;
            Integer widthValue;
            int noOfObjToFetch;
            int exportPerRowCount;
            HttpSession session = request.getSession();
            Integer sortAttribId = Integer.parseInt(request.getParameter("attribId"));
            Boolean ascending = Boolean.parseBoolean(request.getParameter("ascending"));
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String tmpJRReportFilePrefix = productHome + File.separator + "temp" + File.separator + "jaspertemp" + File.separator + "ExportReport_" + new Random().nextInt(1000) + "_";
            File file = new File(productHome + File.separator + "temp" + File.separator + "jaspertemp");
            file.mkdirs();
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            boolean isSingleSheet = false;
            int n = exportPerRowCount = exportParams.get("EXPORT_PER_ROW_COUNT") != null ? Integer.parseInt((String)exportParams.get("EXPORT_PER_ROW_COUNT")) : 0;
            int n2 = exportPerRowCount != 0 && exportPerRowCount != -1 ? exportPerRowCount : (noOfObjToFetch = reportType.toLowerCase().indexOf("xls") != -1 ? 20000 : 5000);
            if (reportType.toLowerCase().indexOf("xls") != -1 && exportPerRowCount == -1) {
                isSingleSheet = true;
            }
            ArrayList defaultColumnList = WFAttributeHandler.getInstance().getListReqDefaultColumnList(loginId);
            List list = WorkFlow.listRequests((int)startIndex, (int)noOfObjToFetch, (String)searchFilter, (ArrayList)defaultColumnList, (Integer)sortAttribId, (Boolean)ascending, (Long)loginId, null, (AdventNetResourceBundle)rb);
            exportCount = list.size();
            ReportJRDataSource dataSource = new ReportJRDataSource(new ArrayList(list), multipleValuesSids, true, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName(JRFieldDesignUtil.getReportName("admp.workflow.export.title", rb));
            reportFileName = "WorkFlowRequests";
            request.setAttribute("reportFileName", (Object)reportFileName);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            inputParams.put("title", rb.getString("admp.workflow.export.title"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRDesignBand defaultHeaderBand = (JRDesignBand)headerBand.clone();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            boolean flexWidth = true;
            String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
            if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                flexWidth = false;
                pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
            }
            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributeList, new ArrayList(list), multipleValuesSids, reportType, request, new Hashtable(), pageColumnWidth, flexWidth, showSerialNo, true, rb)).remove("maxColumnWidth")) != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, showSerialNo, true, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JasperReport jasperReportBasedOnType = null;
            JRDesignBand titleBand = new JRDesignBand();
            titleBand.setHeight(0);
            jasperDesign.setTitle((JRBand)titleBand);
            if (isSingleSheet) {
                jasperDesign.setColumnHeader((JRBand)defaultHeaderBand);
            }
            jasperReportBasedOnType = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            int AddToPgNumber = 0;
            while (!list.isEmpty()) {
                AddToPgNumber = ReportExportUtil.writeDataToJasperPrintFile(tempJRReportList, tmpJRReportFilePrefix, inputParams, new ArrayList(list), multipleValuesSids, AddToPgNumber, jasperReportBasedOnType, jasperReport, dataSource, defaultHeaderBand, reportType, locale, isSingleSheet, showSerialNo, startIndex, noOfObjToFetch);
                list = WorkFlow.listRequests((int)(startIndex += noOfObjToFetch), (int)(startIndex + noOfObjToFetch), (String)searchFilter, (ArrayList)defaultColumnList, (Integer)11006, (Boolean)false, (Long)loginId, null, (AdventNetResourceBundle)rb);
                exportCount += list.size();
                if (list.isEmpty()) continue;
                dataSource = new ReportJRDataSource(new ArrayList(list), multipleValuesSids, true, startIndex, reportType);
                columnWidths = JRDesignUtil.calculateWidth(attributeList, new ArrayList(list), multipleValuesSids, reportType, request, columnWidths, pageColumnWidth, false, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ReportExportUtil.exportReport(reportType, request, response, tempJRReportList, reportFileName, loginId, locale);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.workflow", (String)"admp.workflow.export.title", (Integer)8000, (String)"-", (Boolean)Boolean.FALSE, (String)(reportFileName + "." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)exportCount);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            tempJRReportList.deleteJRFiles();
        }
    }

    public static void export(String reportFileName, String reportType, ArrayList attributeList, ArrayList resultList, Map inputParams, HttpServletRequest request, HttpServletResponse response, Hashtable multipleValuesSids) {
        try {
            System.out.println(" ExportRequestResult started");
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            ReportJRDataSource dataSource = new ReportJRDataSource(resultList, multipleValuesSids, showSerialNo, 1, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            jasperDesign.setName((String)inputParams.get("subject"));
            request.setAttribute("reportFileName", (Object)reportFileName);
            reportFileName = "ADMPWorkflowExecutedResult";
            if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                if (reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                    JRElement[] elements = titleBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        titleBand.removeElement((JRDesignElement)elements[i]);
                    }
                    titleBand.setHeight(0);
                    JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                    JRElement[] elements1 = pageHeaderBand.getElements();
                    for (int i = 0; i < elements1.length; ++i) {
                        pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
                    }
                    pageHeaderBand.setHeight(0);
                }
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                JRElement[] elements2 = pageFooterBand.getElements();
                for (int i = 0; i < elements2.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements2[i]);
                }
                pageFooterBand.setHeight(0);
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (reportType.toLowerCase().indexOf("html") != -1 || reportType.toLowerCase().indexOf("pdf") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, resultList, multipleValuesSids, reportType, request, showSerialNo, rb);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, showSerialNo, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.log(Level.INFO, "Input Params After Filling " + inputParams);
                return;
            }
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.workflow", (String)"admp.workflow.viewrequest.attribname.workflow_status", (Integer)8000, (String)"-", (Boolean)Boolean.FALSE, (String)(reportFileName + "." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)resultList.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" ExportRequestResult Finished");
    }

    public static void exportCreationStatusReport(String reportFileName, String reportType, ArrayList list, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        try {
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            ListUserDataProvider dataProvider = new ListUserDataProvider(list);
            JRDataSource dataSource = dataProvider.getJRDataSource();
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((String)reportFileName, (Map)inputParams, (JRDataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error page " + e);
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            Date date = new Date();
            String currentDate = dateFormat.format(date);
            reportFileName = "UserCreationStatus_" + currentDate;
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCheckboxSIDtoBean(HttpServletRequest request, ReportBean bean) {
        ArrayList deSelectedSIDs = (ArrayList)bean.get("deSelectedSIDs");
        ArrayList<String> selectedSIDs = (ArrayList<String>)bean.get("selectedSIDs");
        ArrayList<String> currentlySelected = new ArrayList<String>();
        String selectedSIDsStr = request.getParameter("selectedSIDsStr");
        out.log(Level.INFO, "selectedSIDsStr came in Request " + selectedSIDsStr);
        StringTokenizer token = new StringTokenizer(selectedSIDsStr, ",");
        while (token.hasMoreTokens()) {
            int index;
            if (selectedSIDs == null) {
                selectedSIDs = new ArrayList<String>();
            }
            String objectGuid = (String)token.nextElement();
            currentlySelected.add(objectGuid);
            if (!selectedSIDs.contains(objectGuid)) {
                selectedSIDs.add(objectGuid);
            }
            if ((index = deSelectedSIDs.indexOf(objectGuid)) == -1) continue;
            deSelectedSIDs.remove(index);
        }
        String deSelectedSIDsStr = request.getParameter("deSelectedSIDsStr");
        if (deSelectedSIDsStr != null) {
            token = new StringTokenizer(deSelectedSIDsStr, ",");
            while (token.hasMoreTokens()) {
                String objectGuid = (String)token.nextElement();
                if (currentlySelected.contains(objectGuid)) continue;
                if (!deSelectedSIDs.contains(objectGuid)) {
                    deSelectedSIDs.add(objectGuid);
                }
                if (!selectedSIDs.contains(objectGuid)) continue;
                selectedSIDs.remove(objectGuid);
            }
        }
        bean.set("deSelectedSIDs", deSelectedSIDs);
        bean.set("selectedSIDs", selectedSIDs);
    }

    public static ArrayList<HashMap> getActionsWithInputs(String inputValue, String requestAction) {
        String inputName = null;
        ArrayList<HashMap> multipleActions = new ArrayList<HashMap>();
        HashMap<String, Serializable> singleAction = new HashMap<String, Serializable>();
        singleAction.put("RequestAction", new Long(requestAction));
        ArrayList multipleInputs = new ArrayList();
        if (inputValue != null) {
            HashMap<String, String> singleInput = new HashMap<String, String>();
            if (requestAction.equals("4") || requestAction.equals("34") || requestAction.equals("42")) {
                inputName = "Container";
                out.log(Level.INFO, "inputName: " + inputName + "inputValue: " + inputValue);
            } else if (requestAction.equals("6")) {
                inputName = "Password";
                out.log(Level.FINE, "inputName: " + inputName + "inputValue: " + inputValue);
            } else if (requestAction.equals("8")) {
                inputName = "Group";
            }
            singleInput.put("VARIABLE", inputName);
            singleInput.put("VALUE", inputValue);
            multipleInputs.add(singleInput);
        }
        singleAction.put("MultipleInputs", multipleInputs);
        multipleActions.add(singleAction);
        return multipleActions;
    }

    public static boolean isEnabled(Long loginId, Integer workflowElementId) {
        ArrayList allWFelements = WorkFlowUtil.getDistinctWFElement();
        boolean returnValue = false;
        boolean isWorkflowElementEnabled = false;
        for (int i = 0; i < allWFelements.size(); ++i) {
            if (((Integer)allWFelements.get(i)).intValue() != workflowElementId.intValue()) continue;
            isWorkflowElementEnabled = true;
        }
        returnValue = loginId != null && WorkFlowUserHandler.isWorkflowTechnician((Long)new Long(workflowElementId.intValue()), (Long)loginId) == false ? false : isWorkflowElementEnabled;
        return returnValue;
    }

    public static DataObject getResultList(String params, Long loginId, ArrayList<HashMap> columnList, HttpServletRequest request) {
        return WorkFlowClientUtil.getResultList(params, loginId, columnList, request, Boolean.TRUE);
    }

    public static DataObject getResultList(String params, Long loginId, ArrayList<HashMap> columnList, HttpServletRequest request, Boolean isWorkflowMode) {
        ArrayList resultList = new ArrayList();
        DataObject dataObj = null;
        Integer count = 0;
        try {
            Criteria ouCriteria;
            JSONObject json = new JSONObject(params);
            String domainName = json.getString("domainName");
            String searchPattern = json.getString("searchPattern");
            String requestAction = "";
            if (json.has("requestAction")) {
                requestAction = json.getString("requestAction");
            }
            String orderByColumnName = "";
            String uniqueColumnName = "";
            Integer startIndex = 1;
            Integer toIndex = 1000;
            if (json.has("startIndex")) {
                startIndex = json.getInt("startIndex");
            }
            if (json.has("toIndex")) {
                toIndex = json.getInt("toIndex");
            }
            boolean OrderByColumnPostion = false;
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)3003L);
            if (domainName.equals("-")) {
                domainName = domainList.get(0);
            }
            boolean isExcludeChildOu = false;
            ArrayList ouList = null;
            if (!isWorkflowMode.booleanValue()) {
                ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            } else {
                isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            }
            HashMap columnProp = columnList.get(0);
            String tableName = (String)columnProp.get("TABLE_NAME");
            String joinTableName = CommonUtil.getSIDTableName((String)domainName);
            if (requestAction.equalsIgnoreCase("11") || requestAction.equalsIgnoreCase("12") || requestAction.equalsIgnoreCase("18")) {
                joinTableName = "ADSMMailBoxObjects";
            }
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            if (!tableName.equals("ADSMContactGeneralDetails") && !tableName.equals("O365UserGeneralDetails")) {
                Join join = new Join(tableName, joinTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                query.addJoin(join);
            }
            for (int i = 0; i < columnList.size(); ++i) {
                columnProp = columnList.get(i);
                Boolean isDisplaycolumn = (Boolean)columnProp.get("IS_UNIQUE_DISPLAY_COLUMN");
                orderByColumnName = (String)columnProp.get("COLUMN_NAME");
                if (isDisplaycolumn.booleanValue()) {
                    uniqueColumnName = orderByColumnName;
                    query.addSortColumn(new SortColumn(tableName, orderByColumnName, true));
                }
                Column selectColumn = Column.getColumn((String)tableName, (String)orderByColumnName);
                if (query.getSelectColumns().contains(selectColumn)) continue;
                query.addSelectColumn(selectColumn);
            }
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)new Integer(1), 0);
            if (!tableName.equalsIgnoreCase("O365UserGeneralDetails")) {
                Column objectGuidColumn = Column.getColumn((String)tableName, (String)"OBJECT_GUID");
                if (!query.getSelectColumns().contains(objectGuidColumn)) {
                    query.addSelectColumn(objectGuidColumn);
                }
                Column dnColumn = Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME");
                if (!query.getSelectColumns().contains(dnColumn)) {
                    query.addSelectColumn(dnColumn);
                }
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            } else {
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_ID"));
                if (requestAction.equalsIgnoreCase("19")) {
                    ArrayList waadDomains = O365InfoCache.getInstance().getO365Domains(domainName);
                    if (waadDomains.size() == 0) {
                        criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_ID"), null, 0));
                    } else {
                        Criteria waadCrit = null;
                        for (int i = 0; i < waadDomains.size(); ++i) {
                            waadCrit = waadCrit == null ? new Criteria(Column.getColumn((String)tableName, (String)"USER_PRINCIPAL_NAME"), (Object)((String)waadDomains.get(i)), 11) : waadCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"USER_PRINCIPAL_NAME"), (Object)((String)waadDomains.get(i)), 11));
                        }
                        criteria = criteria.and(waadCrit);
                    }
                }
            }
            if (requestAction.equalsIgnoreCase("11")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"OBJECT_CLASS"), (Object)"user", 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"RECIPIENT_TYPE"), (Object)new String[]{"1", "2", "4", "8", "16", "32"}, 8));
            }
            if (requestAction.equalsIgnoreCase("12") || requestAction.equalsIgnoreCase("18")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"OBJECT_CLASS"), (Object)"user", 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMMailBoxObjects", (String)"RECIPIENT_TYPE"), (Object)new String[]{"1", "2", "4", "8", "16", "32", "128", "4096", "8192", "16384", "549755813888", "536870912", "8388608"}, 8));
            }
            if (!searchPattern.equals("")) {
                searchPattern = "*" + searchPattern + "*";
                Criteria searchCrit = new Criteria(new Column(tableName, uniqueColumnName), (Object)searchPattern, 2, false);
                Criteria criteria2 = criteria = criteria == null ? searchCrit : criteria.and(searchCrit);
            }
            if (ouList != null && !ouList.isEmpty() && !tableName.equalsIgnoreCase("O365UserGeneralDetails")) {
                Criteria ouCrit = null;
                ouCrit = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)tableName, (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)tableName, (ArrayList)ouList);
                criteria = criteria == null ? ouCrit : criteria.and(ouCrit);
            }
            if (tableName.equalsIgnoreCase("ADSMGroupGeneralDetails") && !isWorkflowMode.booleanValue() && (ouCriteria = HelpdeskUtil.getOUCriteria((Long)loginId, (String)domainName)) != null) {
                criteria = criteria.and(ouCriteria);
            }
            query.setCriteria(criteria);
            query.setRange(new Range(startIndex.intValue(), toIndex - startIndex));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            request.setAttribute("startIndex", (Object)startIndex);
            request.setAttribute("toIndex", (Object)toIndex);
            request.setAttribute("resultList", resultList);
            request.setAttribute("orderByColumnName", (Object)orderByColumnName);
            request.setAttribute("columnList", columnList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static boolean createRequest(HttpServletRequest request, JSONObject params, ArrayList selectedSIDsList, Integer reportId) {
        HttpSession session = request.getSession();
        Long requestId = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (!LicenseMgr.getInstance().isModuleLicensed("Workflow")) {
                request.setAttribute("requestId", (Object)0L);
                request.setAttribute("message", (Object)LicenseMgr.getInstance().getlicenseMessage("Workflow", rb));
                return false;
            }
            if (!CommonUtil.isAdmpTechAvailable()) {
                request.setAttribute("requestId", (Object)0L);
                request.setAttribute("message", (Object)MessageFormat.format(rb.getString("admp.ad_deleg.license_restriction_module_message"), rb.getString(LicenseUtil.HIGHER_VERSION), rb.getString("admp.workflow.createrequest.title_create_request")));
                return false;
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String subject = params.getString("subject");
            String desc = params.getString("description");
            Integer priority = new Integer(params.getString("priority"));
            String inputValue = null;
            String domainName = "";
            if (params.has("domainName")) {
                domainName = params.getString("domainName");
            }
            if (params.has("inputValue")) {
                inputValue = params.getString("inputValue");
            }
            String requestAction = params.getString("requestAction");
            ArrayList multipleActions = TaskInputsUtil.getActionsWithInputs((String)inputValue, (String)requestAction);
            Integer category = new Integer(0);
            Integer subcategory = new Integer(0);
            Boolean isCVCRequest = false;
            Boolean hasAdditionalExeActions = false;
            if (requestAction.equals("4") || requestAction.equals("34") || requestAction.equals("42")) {
                String containerName = "";
                for (HashMap singleAction : multipleActions) {
                    ArrayList multipleInputs = (ArrayList)singleAction.get("MultipleInputs");
                    for (AdmpInput admpInput : multipleInputs) {
                        ArrayList inputList = admpInput.getMultipleInput();
                        for (FcOption fcOption : inputList) {
                            if (!fcOption.getLabel().equalsIgnoreCase("Container")) continue;
                            containerName = fcOption.getValue();
                        }
                    }
                }
                ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
                if (ouList.size() > 0 && !ouList.contains(containerName)) {
                    boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                    Criteria c = null;
                    c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                    ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                    if (!ouList.contains(containerName)) {
                        out.log(Level.INFO, "Request Creation Failure occurred due to unAuthorized Move Container selected");
                        request.setAttribute("requestId", (Object)0L);
                        request.setAttribute("message", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"));
                        return false;
                    }
                }
            }
            if (reportId != null) {
                DataObject dataObj = DataAccess.get((String)WFRuleConstants.ADSMWorkFlowCategoryReports, (Criteria)new Criteria(new Column(WFRuleConstants.ADSMWorkFlowCategoryReports, "REPORT_ID"), (Object)reportId, 0));
                subcategory = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMWorkFlowCategoryReports, "SUB_CATEGORY");
                isCVCRequest = (Boolean)dataObj.getFirstValue(WFRuleConstants.ADSMWorkFlowCategoryReports, "IS_CVC_REQUEST");
                hasAdditionalExeActions = (Boolean)dataObj.getFirstValue(WFRuleConstants.ADSMWorkFlowCategoryReports, "HAS_ADDITIONAL_EXE_ACTIONS");
                dataObj = DataAccess.get((String)WFRuleConstants.ADSMRequestSubCategory, (Criteria)new Criteria(new Column(WFRuleConstants.ADSMRequestSubCategory, "SUB_CATEGORY"), (Object)subcategory, 0));
                category = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMRequestSubCategory, "CATEGORY");
            }
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(multipleActions);
            wfRequest.setSelectedGuidList(selectedSIDsList);
            wfRequest.setDomainName(domainName);
            wfRequest.setPriority(priority);
            wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
            wfRequest.setIsCVCRequest(isCVCRequest);
            wfRequest.setHasAdditionalExeActions(hasAdditionalExeActions);
            requestId = wfRequest.createRequest(loginId, null, subject, desc, category, subcategory);
            if (requestId != null) {
                WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
                executeRule.start();
                out.log(Level.INFO, "Request Creation Success from method 2 : RequestId: " + requestId);
                request.setAttribute("requestId", (Object)requestId);
                request.setAttribute("message", (Object)(rb.getString("admp.workflow.createrequest.mod_message_success") + " " + requestId + "." + rb.getString("admp.workflow.createrequest.mod_message_success_end")));
                return true;
            }
            out.log(Level.INFO, "Request Creation Failure occurred from method 2");
            request.setAttribute("requestId", (Object)requestId);
            request.setAttribute("message", (Object)rb.getString("admp.workflow.createrequest.message_failure"));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Request Creation Failure occurred");
            return false;
        }
    }

    public static boolean createRequest(HttpServletRequest request, JSONObject params, AdventNetResourceBundle rb) {
        Long requestId = null;
        try {
            if (!LicenseMgr.getInstance().isModuleLicensed("Workflow")) {
                request.setAttribute("requestId", (Object)0L);
                request.setAttribute("message", (Object)LicenseMgr.getInstance().getlicenseMessage("Workflow", rb));
                return false;
            }
            if (!CommonUtil.isAdmpTechAvailable()) {
                request.setAttribute("requestId", (Object)0L);
                request.setAttribute("message", (Object)MessageFormat.format(rb.getString("admp.ad_deleg.license_restriction_module_message"), rb.getString(LicenseUtil.HIGHER_VERSION), rb.getString("admp.workflow.createrequest.title_create_request")));
                return false;
            }
            Long loginId = params.getLong("loginId");
            String subject = params.getString("subject");
            String desc = params.getString("description");
            String domainName = params.getString("domainName");
            String inputValue = params.getString("inputValue");
            String requestAction = params.getString("requestAction");
            Integer priority = params.getInt("priority");
            Integer category = params.getInt("categoryId");
            Integer reportId = WF_CREATEREQUEST_REPORTID[category];
            Integer subcategory = new Integer(0);
            ArrayList guidList = (ArrayList)params.get("guidList");
            Long requestMode = params.has("mode") ? params.getLong("mode") : AutomationConstants.REQUEST_MANUAL_MODE.longValue();
            ArrayList multipleActions = TaskInputsUtil.getActionsWithInputs((String)inputValue, (String)requestAction);
            if (reportId != null) {
                DataObject dataObj = DataAccess.get((String)WFRuleConstants.ADSMWorkFlowCategoryReports, (Criteria)new Criteria(new Column(WFRuleConstants.ADSMWorkFlowCategoryReports, "REPORT_ID"), (Object)reportId, 0));
                subcategory = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMWorkFlowCategoryReports, "SUB_CATEGORY");
                dataObj = DataAccess.get((String)WFRuleConstants.ADSMRequestSubCategory, (Criteria)new Criteria(new Column(WFRuleConstants.ADSMRequestSubCategory, "SUB_CATEGORY"), (Object)subcategory, 0));
                category = (Integer)dataObj.getFirstValue(WFRuleConstants.ADSMRequestSubCategory, "CATEGORY");
            }
            WorkFlowRequest wfRequest = new WorkFlowRequest();
            wfRequest.setRequestInputActions(multipleActions);
            wfRequest.setDomainName(domainName);
            wfRequest.setPriority(priority);
            wfRequest.setRequestMode(requestMode);
            if (params.has("userCreationId")) {
                wfRequest.setUserCreationId(Long.valueOf(params.getLong("userCreationId")));
            } else {
                wfRequest.setSelectedGuidList(guidList);
            }
            requestId = wfRequest.createRequest(loginId, null, subject, desc, category, subcategory);
            if (requestId != null) {
                WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
                executeRule.start();
                request.setAttribute("requestId", (Object)requestId);
                request.setAttribute("message", (Object)rb.getString("admp.workflow.createrequest.message_success"));
                return true;
            }
            out.log(Level.INFO, "Request Creation Failure occurred from method 2");
            request.setAttribute("requestId", (Object)requestId);
            request.setAttribute("message", (Object)rb.getString("admp.workflow.createrequest.message_failure"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isAllowToRejectRequeset(Long requestId) {
        Integer currentWfStausId = WorkFlowUtil.getWorkflowStatus((Long)requestId);
        boolean isAllowToModifyWFStatus = true;
        isAllowToModifyWFStatus = currentWfStausId.compareTo(WorkFlowUtil.WORKFLOW_STATUS_COMMITED) != 0 && currentWfStausId.compareTo(WorkFlowUtil.WORKFLOW_STATUS_REJECTED) != 0 && currentWfStausId.compareTo(WorkFlowUtil.WORKFLOW_STATUS_CANCELED) != 0;
        return isAllowToModifyWFStatus;
    }

    public static boolean isAllowToModifyWFStatus(WFViewRequest wfviewRequest, Integer wfStatusId) {
        Long processedCount = wfviewRequest.getwFProcessedCount();
        Integer currentWfStausId = wfviewRequest.getWorkflowStatus();
        BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviewRequest.getWfRuleId());
        Integer nextWFStatus = 0;
        nextWFStatus = processedCount.compareTo(0L) == 0 ? businessWorkflowRule.getNextElement(currentWfStausId) : businessWorkflowRule.getNextElement(currentWfStausId, processedCount);
        boolean isAllowToModifyWFStatus = true;
        isAllowToModifyWFStatus = currentWfStausId.compareTo(WorkFlowUtil.WORKFLOW_STATUS_REJECTED) != 0 && nextWFStatus.compareTo(wfStatusId) == 0;
        return isAllowToModifyWFStatus;
    }

    public static void viewRequest(WFViewRequest wfViewRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Row row;
        ArrayList loginIdList;
        DataObject dataObj;
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = wfViewRequest.getRequestId();
        Integer wFstatusId = wfViewRequest.getWorkflowStatus();
        BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfViewRequest.getWfRuleId());
        int currentWorkFlow = businessWorkflowRule.getNextElement(wFstatusId, wfViewRequest.getwFProcessedCount());
        Boolean isAuthorizedToManage = WorkFlowUserHandler.isAssignedWorkflowTechnician((Long)requestId, (Integer)wFstatusId, (Long)new Long("" + currentWorkFlow), (Long)loginId);
        Long boardId = null;
        if (wFstatusId.equals(WorkFlowUtil.WORKFLOW_STATUS_CREATED) || wFstatusId.equals(WorkFlowUtil.WORKFLOW_STATUS_REVIEWED) || wFstatusId.equals(WorkFlowUtil.WORKFLOW_STATUS_APPROVED) || wFstatusId.equals(WorkFlowUtil.WORKFLOW_STATUS_COMMITED)) {
            boardId = new Long(wFstatusId.intValue());
        }
        Boolean isAuthorizedToView = WorkFlowUserHandler.isAuthorizedToView((Long)requestId, (Integer)wFstatusId, (Long)boardId, (Long)loginId);
        Boolean isUnClosed = false;
        Integer reqStatus = wfViewRequest.getRequestStatus();
        Long requestor_id = wfViewRequest.getRequester();
        boolean sharedAutomation = false;
        if (WorkFlowUserHandler.isRequester((Long)loginId).booleanValue() && requestor_id != null && !requestor_id.equals(loginId) && wfViewRequest.getAutomationId() != null && wFstatusId == WorkFlowUtil.WORKFLOW_STATUS_CREATED && !(dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomation", new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"AUTOMATION_ID"), (Object)wfViewRequest.getAutomationId(), 0))).isEmpty() && (loginIdList = SchedulerUtil.getSharedScheduleTechnicianList((Long)((Long)(row = dataObj.getFirstRow("ADSMAutomation")).get("SCHEDULE_ID")))).contains(loginId)) {
            sharedAutomation = true;
        }
        if (!(sharedAutomation || currentWorkFlow == 0 || reqStatus.compareTo(WFRuleConstants.WORKFLOW_REQUEST_STAUS_OPEN) != 0 || requestor_id == null || requestor_id.equals(loginId) || isAuthorizedToManage.booleanValue() || isAuthorizedToView.booleanValue())) {
            response.sendError(403);
        }
        if ((currentWorkFlow == 0 || currentWorkFlow == WorkFlowUtil.WORKFLOW_STATUS_REJECTED) && reqStatus.compareTo(WFRuleConstants.WORKFLOW_REQUEST_STAUS_OPEN) == 0) {
            isUnClosed = true;
        }
        request.setAttribute("wfViewRequest", (Object)wfViewRequest);
        request.setAttribute("isAuthorizedToManage", (Object)isAuthorizedToManage);
        request.setAttribute("isUnClosed", (Object)isUnClosed);
    }

    public static void setUserDetailsRows(HttpServletRequest request, FcBulkExecuteFormBean fcBulkExecuteFormBean, HashMap resultMap, AdventNetResourceBundle rb, Integer workflowStatus, Long reqMonitorTaskId) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        fcBulkExecuteFormBean.setWorkflowPage(true);
        Long requestId = new Long(request.getParameter("requestId"));
        Hashtable macroHash = WFAssigneeMacroUtil.getMacroBasedTechnicianHash((Long)requestId, (Long)loginId);
        Boolean isMacroBasedTechnician = (Boolean)macroHash.get("IS_ASSIGNED_BY_MACRO");
        ArrayList objectIndexList = null;
        if (isMacroBasedTechnician.booleanValue()) {
            objectIndexList = new ArrayList();
            String macro = (String)macroHash.get("MACRO");
            Hashtable hash = WFAssigneeMacroHandler.getObjectsForTechnician((String)macro, (Long)requestId, (Long)loginId);
            Set keys = hash.keySet();
            objectIndexList.addAll(keys);
        }
        JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails((Long)null, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), objectIndexList, fcBulkExecuteFormBean.getDomainName(), loginId, rb, -1, -1, null, request, fcBulkExecuteFormBean.getActionId(), false, fcBulkExecuteFormBean.getDPValues());
        JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
        FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList, fcBulkExecuteFormBean.getTemplateCategoryId());
        ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(columnsList);
        JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
        ArrayList list = FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcBulkExecuteFormBean.getTemplateCategoryId(), (String)fcBulkExecuteFormBean.getDomainName(), (int)-1, (String)"", (Integer)workflowStatus, (Long)reqMonitorTaskId);
        request.setAttribute("templateListSize", (Object)list.size());
        FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, objectsList);
        fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
        request.setAttribute("objectsList", (Object)objectsList);
        request.setAttribute("taskDetailsId", (Object)reqMonitorTaskId);
        request.setAttribute("sortedColumnsList", (Object)sortedColumnsList);
    }

    public static HashMap<Long, String> getWFUsersMap(ArrayList<Hashtable> list, AdventNetResourceBundle rb) {
        HashMap<Long, String> usersList = new HashMap<Long, String>();
        for (Hashtable hash : list) {
            Long loginId = (Long)hash.get("LOGIN_ID");
            String name = (String)hash.get("FULL_NAME");
            String domainName = (String)hash.get("DOMAINNAME");
            String displayName = "";
            displayName = domainName.equalsIgnoreCase("ADManager Plus Authentication") ? rb.getString(name) : domainName + "\\" + name;
            usersList.put(loginId, displayName);
        }
        return usersList;
    }
}

