/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplate;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTrigger;
import com.adventnet.sym.adsm.common.server.automation.AutomationNotificationMacro;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.ScheduledMgmtUtil;
import com.adventnet.sym.adsm.common.server.workflow.CommitListener;
import com.adventnet.sym.adsm.common.server.workflow.WFAttributeHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowCommit;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public abstract class WorkFlowCommitListener
extends ModifyUserListener
implements CommitListener {
    protected static Logger out = Logger.getLogger("WFLogger");
    protected Long requestId = null;
    private String commitStatus = "success";
    protected boolean isCompleted = false;
    protected ArrayList attributeList = null;
    protected Hashtable domainVsincludeExcludeGroupOUMap = null;
    String keyLdapName = "OBJECT_GUID";
    String defaultNamingContext = "";

    public String getCommitStatus() {
        return this.commitStatus;
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void commitReqMonitorFollowRequestTask(Long requestId, Long reqMonitorTaskId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
        out.log(Level.INFO, " Inside commit listener commit request called.: requestid " + requestId + "loginId :" + loginId + " inputdetails " + inputDetails);
        this.rb = rb;
        Long requestMode = WorkFlowUtil.getWorkFlowType((Long)requestId);
        String moduleName = "";
        moduleName = requestMode == 2L ? rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (requestMode == 1L ? rb.getString("admp.auto.automation.heading.automation") : (requestMode == 0L ? rb.getString("admp.home.feature.heading.workflow") : ""));
        inputDetails.put("MODULE_NAME", moduleName);
        ReqMonitorFollowCommitAction action = new ReqMonitorFollowCommitAction(requestId, reqMonitorTaskId, loginId, inputDetails, rb);
        action.start();
    }

    public void commitRequest(Long requestId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
        out.log(Level.INFO, " Inside commit listener commit request called.: requestid " + requestId + "loginId :" + loginId + " inputdetails " + inputDetails);
        this.rb = rb;
        Long requestMode = WorkFlowUtil.getWorkFlowType((Long)requestId);
        String moduleName = "";
        moduleName = requestMode == 2L ? rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (requestMode == 1L ? rb.getString("admp.auto.automation.heading.automation") : (requestMode == 0L ? rb.getString("admp.home.feature.heading.workflow") : ""));
        inputDetails.put("MODULE_NAME", moduleName);
        CommitAction action = new CommitAction(requestId, loginId, inputDetails, rb);
        action.start();
    }

    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        return "";
    }

    protected void updateResult(String guid, String message, Boolean errorOccured) {
        if (errorOccured.booleanValue()) {
            this.commitStatus = "error";
        }
    }

    @Override
    public void fillAttribs(ArrayList list, String attribName, Object attribValue) {
        Properties prop = (Properties)list.get(0);
        prop.put("ATTRIB_LDAP_NAME", attribName);
        if (attribValue instanceof String) {
            prop.put("ATTRIB_VALUE", attribValue.toString());
        } else if (attribValue instanceof ArrayList) {
            prop.put("ATTRIB_LDAP_NAME", attribName);
            prop.put("ATTRIB_VALUE_COUNT", (Object)2L);
            prop.put("ATTRIB_VALUE", attribValue);
        }
    }

    public String getDomainName(HashMap h, Integer subcategoryId) {
        String domainName = "";
        if (subcategoryId.compareTo(1) == 0 || subcategoryId.compareTo(11) == 0) {
            domainName = (String)h.get(1143);
        } else if (subcategoryId.compareTo(2) == 0 || subcategoryId.compareTo(12) == 0) {
            domainName = (String)h.get(2021);
        } else if (subcategoryId.compareTo(3) == 0 || subcategoryId.compareTo(13) == 0) {
            domainName = (String)h.get(3016);
        } else if (subcategoryId.compareTo(4) == 0 || subcategoryId.compareTo(14) == 0) {
            domainName = (String)h.get(10048);
        }
        return domainName;
    }

    public String getObjectName(HashMap h, Integer subcategoryId) {
        String objName = "";
        if (subcategoryId.compareTo(1) == 0 || subcategoryId.compareTo(11) == 0) {
            objName = this.getValue(h, new Integer(1006));
            if (objName == "") {
                objName = this.getValue(h, new Integer(1010));
            }
        } else if (subcategoryId.compareTo(2) == 0 || subcategoryId.compareTo(12) == 0) {
            objName = this.getValue(h, new Integer(2047));
            if (objName == "") {
                objName = DirectoryObjectUtil.getNameFromDN((String)this.getValue(h, new Integer(2003)));
            }
        } else if (subcategoryId.compareTo(3) == 0 || subcategoryId.compareTo(13) == 0) {
            objName = this.getValue(h, new Integer(3001));
            if (objName == "") {
                objName = this.getValue(h, new Integer(3032));
            }
        } else if (subcategoryId.compareTo(4) == 0 || subcategoryId.compareTo(14) == 0) {
            objName = this.getValue(h, new Integer(10008));
        }
        return objName;
    }

    public String getValue(HashMap h, Integer i) {
        String s = (String)h.get(i);
        if (s == null || s.equalsIgnoreCase("null") || s.equalsIgnoreCase("-")) {
            s = "";
        }
        return s;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public boolean isAuthorizedGroup(String groupDN, String domainName) {
        Hashtable includeExcludeGroupOUMap;
        if (this.domainVsincludeExcludeGroupOUMap != null && (includeExcludeGroupOUMap = (Hashtable)this.domainVsincludeExcludeGroupOUMap.get(domainName)) != null) {
            ArrayList groupIncludeList = (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU");
            ArrayList groupExcludeList = (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU");
            if (HelpdeskUtil.isExcludedGroup((String)groupDN, (ArrayList)groupExcludeList) || !HelpdeskUtil.isAuthorizedGroup((String)groupDN, (ArrayList)groupIncludeList)) {
                return false;
            }
        }
        return true;
    }

    protected class CommitAction
    extends Thread {
        private Long loginId = null;
        private HashMap inputDetails = null;
        private AdventNetResourceBundle rb = null;
        Integer subcategoryId = null;

        public CommitAction(Long commitRequestId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
            WorkFlowCommitListener.this.requestId = commitRequestId;
            this.loginId = loginId;
            this.inputDetails = inputDetails;
            this.subcategoryId = WorkFlowUtil.getSubCategoryForRequest((Long)WorkFlowCommitListener.this.requestId);
            this.rb = rb;
        }

        private DataObject initRequiredDataObject() {
            DataObject dataObject = null;
            try {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMWorkFlowResult", (String)"REQUEST_ID"), (Object)WorkFlowCommitListener.this.requestId, 0);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWorkFlowResult", crit);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return dataObject;
        }

        @Override
        public void run() {
            boolean checkGroupAuthorization;
            ArrayList columnList = WFAttributeHandler.getInstance().getCommitColumnList(WorkFlowCommitListener.this.requestId);
            Integer subcategoryId = WorkFlowUtil.getSubCategoryForRequest((Long)WorkFlowCommitListener.this.requestId);
            HashMap h = (HashMap)columnList.get(0);
            WorkFlowCommitListener.this.baseTableName = (String)h.get("TABLE_NAME");
            ArrayList resultList = WorkFlowCommit.getRequestGUIDResult((Long)WorkFlowCommitListener.this.requestId, (ArrayList)columnList, (String)WorkFlowCommitListener.this.baseTableName);
            DataObject actionDetailsHistoryDO = this.initRequiredDataObject();
            Long actionToPerform = (Long)this.inputDetails.get("REQUEST_ACTION");
            if (actionToPerform.compareTo(5L) == 0) {
                WorkFlowCommitListener.this.reportId = ReportsUtil.UNLOCK_USER_USER_MGMT_REPORT_ID;
            }
            boolean isGroupWFAction = actionToPerform.compareTo(WorkFlowUtil.DELETE_GROUP_WF_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.MOVE_GROUP_WF_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.REMOVEFROM_GROUP_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.COMPUTER_REMOVEFROM_GROUP_ACTION_ID) == 0;
            Long requestMode = WorkFlowUtil.getWorkFlowType((Long)WorkFlowCommitListener.this.requestId);
            boolean bl = checkGroupAuthorization = requestMode.equals(1L) && isGroupWFAction;
            if (checkGroupAuthorization) {
                WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap = new Hashtable();
            }
            WorkFlowCommitListener.this.attributeList = WorkFlowCommitListener.this.getAttributeList();
            out.log(Level.FINE, " resultList for comiiting :" + resultList);
            try {
                ArrayList objectIds = WorkFlowCommitListener.this.getObjIdList();
                WorkFlowCommitListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, WorkFlowCommitListener.this.getTableColumns());
                WorkFlowCommitListener.this.updateResult = false;
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                String hostId = System.getProperty("server.name");
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Long)((Long)this.inputDetails.get("REQUEST_ACTION")), (String)((String)this.inputDetails.get("WF_ACTION_NAME")), (String)this.rb.getString((String)this.inputDetails.get("SUB_CATEGORY_NAME")), null, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)((String)this.inputDetails.get("MODULE_NAME")), (Long)WorkFlowCommitListener.this.requestId);
                for (int i = 0; i < resultList.size(); ++i) {
                    HashMap result = (HashMap)resultList.get(i);
                    String guid = (String)result.get("OBJECT_GUID");
                    String objName = WorkFlowCommitListener.this.getObjectName(result, subcategoryId);
                    String resultDomainName = WorkFlowCommitListener.this.getDomainName(result, subcategoryId);
                    if (WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap != null && WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap.get(resultDomainName) == null) {
                        WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap.put(resultDomainName, HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)this.loginId, (String)resultDomainName));
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)resultDomainName, (DataObject)auditDataObj);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    audit_info.put("object_id", object_id);
                    Criteria reqResultDetailsCriteria = new Criteria(Column.getColumn((String)"ADSMWorkFlowResult", (String)"OBJECT_GUID"), (Object)guid, 0);
                    Row autoReqResultGuidRow = actionDetailsHistoryDO.getRow("ADSMWorkFlowResult", reqResultDetailsCriteria);
                    String statusMessage = WorkFlowCommitListener.this.commit(result, this.inputDetails, this.loginId, this.rb, audit_info, auditDataObj);
                    audit_info.put("error_msg", statusMessage);
                    autoReqResultGuidRow.set("MESSAGE", (Object)statusMessage);
                    actionDetailsHistoryDO.updateRow(autoReqResultGuidRow);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                WorkFlowCommitListener.this.isCompleted = true;
                WorkFlowCommitListener.this.endTableUpdateQueue();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(actionDetailsHistoryDO);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected class ReqMonitorFollowCommitAction
    extends Thread {
        private Long loginId = null;
        private Long reqMonitorTaskId = null;
        private Long reqActionId = null;
        private HashMap inputDetails = null;
        private AdventNetResourceBundle rb = null;
        Integer subcategoryId = null;

        public ReqMonitorFollowCommitAction(Long commitRequestId, Long reqMonitorTaskId, Long loginId, HashMap inputDetails, AdventNetResourceBundle rb) {
            WorkFlowCommitListener.this.requestId = commitRequestId;
            this.loginId = loginId;
            this.reqMonitorTaskId = reqMonitorTaskId;
            this.inputDetails = inputDetails;
            this.rb = rb;
            this.subcategoryId = WorkFlowUtil.getSubCategoryForRequest((Long)WorkFlowCommitListener.this.requestId);
        }

        private DataObject initRequiredDataObject() {
            DataObject dataObject = null;
            try {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMReqMonitorTask"));
                query.setCriteria(new Criteria(Column.getColumn((String)"ADSMReqMonitorTask", (String)"REQ_MONITOR_TASK_ID"), (Object)this.reqMonitorTaskId, 0));
                query.addSelectColumn(Column.getColumn(null, (String)"*"));
                query.addJoin(new Join("ADSMReqMonitorTask", "ReqMonitorTaskResultDetails", new String[]{"REQ_MONITOR_TASK_ID"}, new String[]{"REQ_MONITOR_TASK_ID"}, 2));
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return dataObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean checkGroupAuthorization;
            DataObject actionDetailsHistoryDO = this.initRequiredDataObject();
            try {
                Row reqAction = actionDetailsHistoryDO.getRow("ADSMReqMonitorTask", new Criteria(Column.getColumn((String)"ADSMReqMonitorTask", (String)"REQ_MONITOR_TASK_ID"), (Object)this.reqMonitorTaskId, 0));
                if (reqAction != null) {
                    this.reqActionId = (Long)reqAction.get("REQUEST_ACTION");
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            ArrayList columnList = WFAttributeHandler.getInstance().getCommitColumnList(WorkFlowCommitListener.this.requestId, this.reqActionId);
            HashMap h = (HashMap)columnList.get(0);
            WorkFlowCommitListener.this.baseTableName = (String)h.get("TABLE_NAME");
            ArrayList resultList = WorkFlowCommit.getReqMonitorTaskGUIDResult((Long)this.reqMonitorTaskId, (Long)WorkFlowCommitListener.this.requestId, (ArrayList)columnList, (String)WorkFlowCommitListener.this.baseTableName);
            WorkFlowCommitListener.this.isCompleted = false;
            Long actionToPerform = (Long)this.inputDetails.get("REQUEST_ACTION");
            if (actionToPerform.compareTo(WorkFlowUtil.UNLOCK_USER_ACTION_ID) == 0) {
                WorkFlowCommitListener.this.reportId = ReportsUtil.UNLOCK_USER_USER_MGMT_REPORT_ID;
            }
            Long requestMode = WorkFlowUtil.getWorkFlowType((Long)WorkFlowCommitListener.this.requestId);
            boolean isGroupWFAction = actionToPerform.compareTo(WorkFlowUtil.DELETE_GROUP_WF_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.MOVE_GROUP_WF_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.REMOVEFROM_GROUP_ACTION_ID) == 0 || actionToPerform.compareTo(WorkFlowUtil.COMPUTER_REMOVEFROM_GROUP_ACTION_ID) == 0;
            boolean bl = checkGroupAuthorization = requestMode.equals(1L) && isGroupWFAction;
            if (checkGroupAuthorization) {
                WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap = new Hashtable();
            }
            WorkFlowCommitListener.this.attributeList = WorkFlowCommitListener.this.getAttributeList();
            ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClassFromBaseTableName(WorkFlowCommitListener.this.baseTableName);
            Integer objectId = objectClass.getId();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            Hashtable nameVsValue = new Hashtable();
            Hashtable<String, Object> auditDO = new Hashtable<String, Object>();
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                String hostId = System.getProperty("user.name");
                ArrayList objectIds = WorkFlowCommitListener.this.getObjIdList();
                WorkFlowCommitListener.this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, WorkFlowCommitListener.this.getTableColumns());
                WorkFlowCommitListener.this.updateResult = false;
                Criteria criteria = new Criteria(Column.getColumn((String)"ReqMonitorTaskResultDetails", (String)"REQ_MONITOR_TASK_ID"), (Object)this.reqMonitorTaskId, 0);
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Long)((Long)this.inputDetails.get("REQUEST_ACTION")), (String)((String)this.inputDetails.get("WF_ACTION_NAME")), (String)this.rb.getString((String)this.inputDetails.get("SUB_CATEGORY_NAME")), null, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)((String)this.inputDetails.get("MODULE_NAME")), (Long)WorkFlowCommitListener.this.requestId);
                this.inputDetails.put("batchName", "ADMP_Export_" + System.currentTimeMillis());
                out.log(Level.INFO, " resultList for comiiting :" + resultList);
                for (int i = 0; i < resultList.size(); ++i) {
                    HashMap result = (HashMap)resultList.get(i);
                    String guid = (String)result.get("OBJECT_GUID");
                    String objName = WorkFlowCommitListener.this.getObjectName(result, this.subcategoryId);
                    String resultDomainName = WorkFlowCommitListener.this.getDomainName(result, this.subcategoryId);
                    if (WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap != null && WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap.get(resultDomainName) == null) {
                        WorkFlowCommitListener.this.domainVsincludeExcludeGroupOUMap.put(resultDomainName, HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)this.loginId, (String)resultDomainName));
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)resultDomainName, (DataObject)auditDataObj);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    audit_info.put("object_id", object_id);
                    Criteria reqResultDetailsCriteria = criteria.and(new Criteria(Column.getColumn((String)"ReqMonitorTaskResultDetails", (String)"OBJECT_GUID"), (Object)guid, 0));
                    Row autoReqResultGuidRow = actionDetailsHistoryDO.getRow("ReqMonitorTaskResultDetails", reqResultDetailsCriteria);
                    String statusMessage = WorkFlowCommitListener.this.commit(result, this.inputDetails, this.loginId, this.rb, audit_info, auditDataObj);
                    audit_info.put("error_msg", statusMessage);
                    autoReqResultGuidRow.set("MESSAGE", (Object)statusMessage);
                    actionDetailsHistoryDO.updateRow(autoReqResultGuidRow);
                    if (statusMessage.toLowerCase().contains(this.rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase())) {
                        auditObjectIdList.add(object_id);
                        nameVsValue.put(objName, audit_info);
                    }
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                WorkFlowCommitListener.this.endTableUpdateQueue();
                Row taskMonitorRow = actionDetailsHistoryDO.getRow("ADSMReqMonitorTask", criteria);
                if (taskMonitorRow != null) {
                    taskMonitorRow.set("RESULT_STATUS", (Object)"");
                    actionDetailsHistoryDO.updateRow(taskMonitorRow);
                    auditDO.put("auditDO", auditDataObj);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(actionDetailsHistoryDO);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WorkFlowCommitListener.this.commitStatus = "error";
                System.out.println("Error occured while updating the results of the executed task");
            }
            finally {
                WorkFlowCommitListener.this.isCompleted = true;
            }
            NotificationMacro macro = (NotificationMacro)NotificationTemplateHandler.macroMap.get(WorkFlowCommitListener.this.requestId);
            if (macro != null && AutomationUtil.isNotifyEnabledAutomation((Long)((Long)macro.getIds().get("automationId")))) {
                String filePath = new File(System.getProperty("server.home")).getAbsolutePath();
                filePath = filePath.replaceFirst("\\\\bin\\\\..", "\\\\audit-data");
                filePath = filePath + File.separator + "Notification";
                String storageDir = NotificationProfileHandler.createNotificationDirectory((String)("Technician_" + this.loginId), (String)filePath);
                AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                auditDO.put("objectId", objectId);
                auditDO.put("auditObjectIdList", auditObjectIdList);
                auditDO.put("list", nameVsValue);
                auditDO.put("storageDir", storageDir);
                auditDO.put("reportId", WorkFlowCommitListener.this.reportId);
                auditDO.put("automationId", macro.getIds().get("automationId"));
                auditDO.put("autoRaisedId", macro.getIds().get("autoRaisedId"));
                auditDO.put("requestId", macro.getIds().get("requestId"));
                auditDO.put("errorMessage", macro.getIds().get("errorMessage"));
                notificationMacro.init(auditDO);
                ArrayList templateList = ScheduledMgmtUtil.getSelectedTemplateList((Long)((Long)macro.getIds().get("automationId")));
                ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                for (Long notificationTemplateId : templateList) {
                    JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)this.rb);
                    NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                    associatedTemplates.add(notificationTemplate);
                }
                NotificationTrigger trigger = new NotificationTrigger(null, WorkFlowCommitListener.this.domainName, this.rb, this.loginId, (NotificationMacro)notificationMacro, "Automation", null);
                trigger.setNotificationTemplates(associatedTemplates);
                trigger.start();
            }
        }
    }
}

