/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.Controller;

public class WorkFlowController
extends Action
implements Controller {
    public void execute(ComponentContext tileContext, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        try {
            this.execute(null, null, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void perform(ComponentContext tileContext, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        String path = null;
        String selectedTile = request.getParameter("selectedTile");
        try {
            Row r;
            Iterator itr;
            Criteria c;
            Hashtable tilesTable = new Hashtable();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList userBoards = WorkFlowUserHandler.getBoardsForUser((Long)loginId);
            if (loginId == 1L && userBoards.isEmpty()) {
                userBoards.add(new Long(1L));
                loginId = null;
            }
            SelectQueryImpl sq = new SelectQueryImpl(new Table("WFLinksToWFBoard"));
            sq.addSelectColumn(new Column(null, "*"));
            SortColumn sortColumn = new SortColumn("WFLinksToWFBoard", "PRIORITY", true);
            sq.addSortColumn(sortColumn);
            DataObject tilesDataObject = DataAccess.get((SelectQuery)sq);
            DataObject linkDataOBject = DataAccess.get((String)"WorkflowLinks", (Criteria)null);
            boolean isCustomizedBusinessWorkflowConfigured = false;
            if (AdminUtil.getRefValue("HAS_USER_DEFINED_WORKFLOWS").booleanValue()) {
                isCustomizedBusinessWorkflowConfigured = true;
            }
            ArrayList<Properties> arrayList = new ArrayList<Properties>();
            if (ClientUtil.checkAuthorization(request, new long[]{8000L})) {
                c = new Criteria(new Column("WorkflowLinks", "WORKFLOWLINK_ID"), (Object)new Integer[]{8, 9}, 8);
                itr = linkDataOBject.getRows("WorkflowLinks", c);
                while (itr.hasNext()) {
                    r = (Row)itr.next();
                    Properties p = new Properties();
                    p.setProperty("displayName", (String)r.get("DISPLAY_NAME"));
                    p.setProperty("id", (String)r.get("TILE_NAME"));
                    p.setProperty("url", (String)r.get("URL"));
                    p.setProperty("desc", (String)r.get("DESCRIPTION"));
                    if (!arrayList.contains(p)) {
                        arrayList.add(p);
                    }
                    if (isCustomizedBusinessWorkflowConfigured || (Integer)r.get("WORKFLOWLINK_ID") != 8 || selectedTile != null) continue;
                    selectedTile = (String)r.get("TILE_NAME");
                    path = (String)r.get("URL");
                }
                tilesTable.put(3L, arrayList);
            }
            if (ClientUtil.checkAuthorization(request, new long[]{8000L})) {
                arrayList = new ArrayList();
                c = new Criteria(new Column("WorkflowLinks", "WORKFLOWLINK_ID"), (Object)new Integer[]{4, 5, 6}, 8);
                itr = linkDataOBject.getRows("WorkflowLinks", c);
                while (itr.hasNext()) {
                    r = (Row)itr.next();
                    Integer workflowlinkId = (Integer)r.get("WORKFLOWLINK_ID");
                    if (workflowlinkId == 5) {
                        ArrayList availableWFelementsList = WorkFlowUtil.getDistinctWFElement();
                        for (int index = 1; index < availableWFelementsList.size(); ++index) {
                            Properties p = new Properties();
                            String url = (String)r.get("URL");
                            Integer boardId = (Integer)availableWFelementsList.get(index);
                            url = url + boardId + "&selectedTechId=" + boardId;
                            ArrayList boardDetailsList = WorkFlowUtil.getBoardDetails((Integer)boardId);
                            Properties prop = (Properties)boardDetailsList.get(0);
                            String displayName = prop.getProperty("BOARD_NAME");
                            String desc = prop.getProperty("DESCRIPTION");
                            p.setProperty("displayName", displayName);
                            p.setProperty("id", (String)r.get("TILE_NAME") + boardId);
                            p.setProperty("url", url);
                            p.setProperty("desc", desc);
                            arrayList.add(p);
                        }
                        continue;
                    }
                    Properties p = new Properties();
                    p.setProperty("displayName", (String)r.get("DISPLAY_NAME"));
                    p.setProperty("id", (String)r.get("TILE_NAME"));
                    p.setProperty("url", (String)r.get("URL"));
                    p.setProperty("desc", (String)r.get("DESCRIPTION"));
                    if (arrayList.contains(p)) continue;
                    arrayList.add(p);
                }
                tilesTable.put(2L, arrayList);
            }
            arrayList = new ArrayList();
            for (Long userBoard : userBoards) {
                if (!WorkFlowClientUtil.isEnabled(loginId, new Integer(userBoard.intValue()))) continue;
                Criteria cri = new Criteria(new Column("WFLinksToWFBoard", "PARENT_ID"), (Object)1L, 0);
                cri = cri.and(new Criteria(new Column("WFLinksToWFBoard", "BOARD_ID"), (Object)userBoard, 0));
                Iterator tilesIterator = tilesDataObject.getRows("WFLinksToWFBoard", cri);
                while (tilesIterator.hasNext()) {
                    Row r2 = (Row)tilesIterator.next();
                    Integer workflowLinkId = (Integer)r2.get("WORKFLOWLINK_ID");
                    Criteria c2 = new Criteria(new Column("WorkflowLinks", "WORKFLOWLINK_ID"), (Object)workflowLinkId, 0);
                    Row linkRow = linkDataOBject.getRow("WorkflowLinks", c2);
                    Properties p = new Properties();
                    p.setProperty("displayName", (String)linkRow.get("DISPLAY_NAME"));
                    p.setProperty("id", (String)linkRow.get("TILE_NAME"));
                    p.setProperty("url", (String)linkRow.get("URL"));
                    p.setProperty("desc", (String)linkRow.get("DESCRIPTION"));
                    if (!arrayList.contains(p)) {
                        arrayList.add(p);
                    }
                    if (workflowLinkId != 2) continue;
                    if (selectedTile == null) {
                        selectedTile = (String)linkRow.get("TILE_NAME");
                    }
                    if (path != null) continue;
                    path = (String)linkRow.get("URL");
                }
            }
            tilesTable.put(1L, arrayList);
            Enumeration enumerator = tilesTable.keys();
            while (selectedTile == null && enumerator.hasMoreElements() && path == null) {
                ArrayList list = (ArrayList)tilesTable.get(enumerator.nextElement());
                if (list.size() <= 0) continue;
                Properties prop = (Properties)list.get(0);
                selectedTile = (String)prop.get("id");
                path = (String)prop.get("url");
            }
            request.setAttribute("selectedTile", (Object)selectedTile);
            request.setAttribute("tilesTable", tilesTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        forward = new ActionForward("url", path, false);
        return forward;
    }
}

