/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflowRule;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro.WFAbstractMacro;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class GroupManagerMacro
extends WFAbstractMacro {
    public GroupManagerMacro(Long requestId, Long reqMonitorTaskId) {
        super(requestId, reqMonitorTaskId, "%manager%", "ReqMonitorTaskMultiInputManagerMapping", "ReqMonitorTaskMultiInput");
    }

    @Override
    public ArrayList populate() {
        if (this.isDataPopulated().booleanValue()) {
            this.clearStatusColumn();
        } else {
            Hashtable<Object, String> objectVsManagerDN = this.copyObjectDetails();
            this.fillManagerDetails(objectVsManagerDN);
            this.setIsDataPopulated(Boolean.TRUE);
        }
        ArrayList<Long> yetToValidateTechnicians = this.getYetToValidateTechnicians();
        if (yetToValidateTechnicians.size() == 0) {
            yetToValidateTechnicians.add(CommonUtil.ADMIN_LOGIN_ID);
        }
        return yetToValidateTechnicians;
    }

    @Override
    public String getObjectColumn() {
        return "OBJECT_GUID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Object, String> copyObjectDetails() {
        Hashtable<Object, String> guidVsManagerDN = new Hashtable<Object, String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)this.getParentTableName()));
            query.addSelectColumn(Column.getColumn((String)this.getParentTableName(), (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ReqMonitorTaskInputDetails", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"SID_STRING"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DOMAIN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"MANAGED_BY_DN"));
            query.addJoin(new Join(Table.getTable((String)this.getParentTableName()), Table.getTable((String)"ReqMonitorTaskInputDetails"), new String[]{"TASK_SINGLE_INPUT_ID"}, new String[]{"TASK_SINGLE_INPUT_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)this.getParentTableName()), Table.getTable((String)"ADSMGroupGeneralDetails"), new String[]{"SERVER_VALUE"}, new String[]{"SID_STRING"}, 1));
            Criteria crit = new Criteria(Column.getColumn((String)"ReqMonitorTaskInputDetails", (String)"REQ_MONITOR_TASK_ID"), (Object)this.getReqMonitorTaskId(), 0);
            String domainName = this.getDomainName();
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            query.setCriteria(crit);
            this.macroConfDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Long uniqueId = (Long)dataSet.getValue("UNIQUE_ID");
                String guid = (String)dataSet.getValue("OBJECT_GUID");
                String managerDN = (String)dataSet.getValue("MANAGED_BY_DN");
                String serverValue = (String)dataSet.getValue("SERVER_VALUE");
                Row row = new Row(this.getTableName());
                row.set("REQ_MONITOR_TASK_ID", (Object)this.getReqMonitorTaskId());
                row.set("REQ_MONITOR_TASK_MULTIPLE_INPUT_ID", (Object)uniqueId);
                row.set("OBJECT_GUID", (Object)guid);
                row.set("SERVER_VALUE", (Object)serverValue);
                this.macroConfDataObj.addRow(row);
                if (managerDN == null) continue;
                guidVsManagerDN.put(guid, managerDN);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return guidVsManagerDN;
    }

    @Override
    public Hashtable<Long, ArrayList> getRejectedObjects() {
        Hashtable<Long, ArrayList> rejectedHash = new Hashtable<Long, ArrayList>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), (Object)false, 0);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long taskMultipleInputID = (Long)row.get("REQ_MONITOR_TASK_MULTIPLE_INPUT_ID");
                Long loginId = (Long)row.get("LOGIN_ID");
                ArrayList<Long> idList = rejectedHash.get(loginId);
                if (idList == null) {
                    idList = new ArrayList<Long>();
                    rejectedHash.put(loginId, idList);
                }
                idList.add(taskMultipleInputID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rejectedHash;
    }

    @Override
    public Boolean removeRejectedObjects() {
        try {
            Hashtable<Long, ArrayList> rejectedHash = this.getRejectedObjects();
            Set<Long> keys = rejectedHash.keySet();
            Iterator<Long> itr = keys.iterator();
            String comments = "admp.workflow.assignee_macro.reject_comment";
            BusinessWorkflowRule businessWorkflowRule = this.getBusinessWorkflowRule();
            Integer wfStatus = businessWorkflowRule.getPrevWFElementId(this.getWfStatus());
            while (itr.hasNext()) {
                Long loginId = itr.next();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
                ArrayList idList = rejectedHash.get(loginId);
                Criteria criteria = new Criteria(Column.getColumn((String)this.getParentTableName(), (String)"UNIQUE_ID"), (Object)idList.toArray(), 8);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
                WFTaskAuditActivities.updateManagerAuditActivities((Long)loginId, (Long)this.getReqMonitorTaskId(), (Integer)wfStatus, (ArrayList)this.getGuidsForIdList(idList), (String)rb.getString(comments), (boolean)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public ArrayList getGuidsForIdList(ArrayList idList) {
        ArrayList<String> guidList = new ArrayList<String>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"REQ_MONITOR_TASK_MULTIPLE_INPUT_ID"), (Object)idList.toArray(), 8);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String objectGuid = (String)row.get("OBJECT_GUID");
                guidList.add(objectGuid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guidList;
    }

    @Override
    public Criteria getCriteriaForTechnician(Long loginId) {
        return null;
    }

    public String getDomainName() {
        String domainName = "";
        try {
            String detailsTableName = WorkFlowUtil.getDetailsTableName((Long)WFAssigneeMacroUtil.getRequestIdFromReqMonitorTaskId((Long)this.getReqMonitorTaskId()));
            Criteria crit = new Criteria(Column.getColumn((String)"ReqMonitorTaskResultDetails", (String)"REQ_MONITOR_TASK_ID"), (Object)this.getReqMonitorTaskId(), 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ReqMonitorTaskResultDetails", crit);
            Row row = dataObj.getRow("ReqMonitorTaskResultDetails");
            String objectGuid = (String)row.get("OBJECT_GUID");
            crit = new Criteria(Column.getColumn((String)detailsTableName, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(detailsTableName, crit);
            row = dataObj.getRow(detailsTableName);
            domainName = (String)row.get("DOMAIN_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    @Override
    public Hashtable getObjectsForTechnician(Long loginId) {
        Hashtable<String, Integer> serverValueVsCount = new Hashtable<String, Integer>();
        Hashtable<Object, Integer> validatedCountHash = this.getValidatedCountHash();
        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
            return validatedCountHash;
        }
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 1));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String objectGuid = (String)row.get("OBJECT_GUID");
                String serverValue = (String)row.get("SERVER_VALUE");
                serverValueVsCount.put(serverValue, validatedCountHash.get(objectGuid));
            }
            if (serverValueVsCount.size() == 0) {
                ArrayList<Object> guidList = this.getYetToValidateObjects();
                crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
                it = this.macroConfDataObj.getRows(this.getTableName(), crit);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String objectGuid = (String)row.get("OBJECT_GUID");
                    String serverValue = (String)row.get("SERVER_VALUE");
                    if (!guidList.contains(objectGuid)) continue;
                    serverValueVsCount.put(serverValue, validatedCountHash.get(objectGuid));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverValueVsCount;
    }

    @Override
    public Boolean isObjectStatusAvailable() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isInputStatusAvailable() {
        return Boolean.TRUE;
    }
}

