/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro.WFAbstractMacro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModifyObjectManagerMacro
extends WFAbstractMacro {
    public ModifyObjectManagerMacro(Long requestId, Long reqMonitorTaskId) {
        super(requestId, reqMonitorTaskId, "%manager%", "ReqMonitorTaskResultManagerMapping", "ReqMonitorTaskResultDetails");
    }

    @Override
    public ArrayList populate() {
        if (this.isDataPopulated().booleanValue()) {
            this.clearStatusColumn();
        } else {
            ArrayList<String> objectGuidList = this.copyObjectDetails();
            this.fillManagerDetails(objectGuidList);
            this.setIsDataPopulated(Boolean.TRUE);
        }
        ArrayList<Long> yetToValidateTechnicians = this.getYetToValidateTechnicians();
        if (yetToValidateTechnicians.size() == 0) {
            yetToValidateTechnicians.add(CommonUtil.ADMIN_LOGIN_ID);
        }
        return yetToValidateTechnicians;
    }

    @Override
    public String getObjectColumn() {
        return "OBJECT_GUID";
    }

    public ArrayList<String> copyObjectDetails() {
        ArrayList<String> objectGuidList = new ArrayList<String>();
        try {
            this.macroConfDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(this.getParentTableName(), new Criteria(Column.getColumn((String)this.getParentTableName(), (String)"REQ_MONITOR_TASK_ID"), (Object)this.getReqMonitorTaskId(), 0));
            Iterator it = dataObj.getRows(this.getParentTableName());
            while (it.hasNext()) {
                Row parenTableRow = (Row)it.next();
                Long uniqueId = (Long)parenTableRow.get("UNIQUE_ID");
                String objectGuid = (String)parenTableRow.get("OBJECT_GUID");
                Row row = new Row(this.getTableName());
                row.set("REQ_MONITOR_TASK_ID", (Object)this.getReqMonitorTaskId());
                row.set("REQ_MONITOR_TASK_RESULT_ID", (Object)uniqueId);
                row.set("OBJECT_GUID", (Object)objectGuid);
                this.macroConfDataObj.addRow(row);
                objectGuidList.add(objectGuid);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectGuidList;
    }

    public void fillManagerDetails(ArrayList objectGuidList) {
        String detailsTableName = WorkFlowUtil.getDetailsTableName((Long)this.getRequestId());
        Hashtable guidVsManagerDN = WFAssigneeMacroUtil.getGuidVsManagerDN((ArrayList)objectGuidList, (String)detailsTableName);
        this.fillManagerDetails(guidVsManagerDN);
    }

    @Override
    public Hashtable<Long, ArrayList> getRejectedObjects() {
        Hashtable<Long, ArrayList> rejectedHash = new Hashtable<Long, ArrayList>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), (Object)false, 0);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String guid = (String)row.get("OBJECT_GUID");
                Long loginId = (Long)row.get("LOGIN_ID");
                ArrayList<String> guidList = rejectedHash.get(loginId);
                if (guidList == null) {
                    guidList = new ArrayList<String>();
                    rejectedHash.put(loginId, guidList);
                }
                guidList.add(guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rejectedHash;
    }

    @Override
    public Boolean removeRejectedObjects() {
        Hashtable<Long, ArrayList> rejectedHash = this.getRejectedObjects();
        Set<Long> keys = rejectedHash.keySet();
        Iterator<Long> itr = keys.iterator();
        ArrayList taskDetailsIdList = WFAssigneeMacroUtil.getTaskdetailsIdList((Long)this.getRequestId());
        String comments = "admp.workflow.assignee_macro.reject_comment";
        Boolean isRejected = Boolean.TRUE;
        while (itr.hasNext()) {
            Long loginId = itr.next();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
            ArrayList guidList = rejectedHash.get(loginId);
            JSONArray selectedGuidList = new JSONArray((Collection)guidList);
            for (int i = 0; i < taskDetailsIdList.size(); ++i) {
                Boolean isSuccess;
                Long taskDetailsId = (Long)taskDetailsIdList.get(i);
                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(this.getRequestId(), taskDetailsId, loginId);
                auditActivities.updateBoardId(isRejected);
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setIsCVCRequest();
                auditActivities.setComments(rb.getString(comments));
                if (auditActivities.isCVCRequest().booleanValue()) {
                    auditActivities.setAuditActivityType(WFRequestUtil.CVC_ROW_REMOVED);
                }
                if ((isSuccess = Boolean.valueOf(auditActivities.updateAuditActivities(new JSONObject(), Long.valueOf(-1L), new JSONArray(), selectedGuidList, isRejected))).booleanValue()) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Criteria getCriteriaForTechnician(Long loginId) {
        Criteria criteria = null;
        ArrayList<Long> idList = new ArrayList<Long>();
        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
            return criteria;
        }
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 1));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long resultId = (Long)row.get("REQ_MONITOR_TASK_RESULT_ID");
                if (idList.contains(resultId)) continue;
                idList.add(resultId);
            }
            if (idList.size() == 0) {
                ArrayList<Object> yetToValidateObjects = this.getYetToValidateObjects();
                crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
                it = this.macroConfDataObj.getRows(this.getTableName(), crit);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String objectGuid = (String)row.get("OBJECT_GUID");
                    Long resultId = (Long)row.get("REQ_MONITOR_TASK_RESULT_ID");
                    if (idList.contains(resultId) || !yetToValidateObjects.contains(objectGuid)) continue;
                    idList.add(resultId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        criteria = idList.size() > 0 ? new Criteria(Column.getColumn((String)this.getParentTableName(), (String)"UNIQUE_ID"), (Object)idList.toArray(), 8) : new Criteria(Column.getColumn((String)this.getParentTableName(), (String)"UNIQUE_ID"), null, 0);
        return criteria;
    }

    @Override
    public Hashtable getObjectsForTechnician(Long loginId) {
        Hashtable<String, Integer> guidVsCount = new Hashtable<String, Integer>();
        Hashtable<Object, Integer> validatedCountHash = this.getValidatedCountHash();
        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
            return validatedCountHash;
        }
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 1));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String objectGuid = (String)row.get("OBJECT_GUID");
                guidVsCount.put(objectGuid, validatedCountHash.get(objectGuid));
            }
            if (guidVsCount.size() == 0) {
                ArrayList<Object> guidList = this.getYetToValidateObjects();
                crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
                it = this.macroConfDataObj.getRows(this.getTableName(), crit);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String objectGuid = (String)row.get("OBJECT_GUID");
                    if (!guidList.contains(objectGuid)) continue;
                    guidVsCount.put(objectGuid, validatedCountHash.get(objectGuid));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guidVsCount;
    }

    @Override
    public Boolean isObjectStatusAvailable() {
        return Boolean.TRUE;
    }

    @Override
    public Boolean isInputStatusAvailable() {
        return Boolean.FALSE;
    }
}

