/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro.ModifyObjectManagerMacro;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class O365ManagerMacro
extends ModifyObjectManagerMacro {
    public O365ManagerMacro(Long requestId, Long reqMonitorTaskId) {
        super(requestId, reqMonitorTaskId);
    }

    @Override
    public void fillManagerDetails(ArrayList objectGuidList) {
        try {
            Hashtable<String, String> guidVsImmutableId = new Hashtable<String, String>();
            String detailsTableName = "O365UserGeneralDetails";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)detailsTableName));
            query.addSelectColumn(Column.getColumn((String)detailsTableName, (String)"DECODED_IMMUTABLE_ID"));
            query.addSelectColumn(Column.getColumn((String)detailsTableName, (String)"OBJECT_ID"));
            query.addSelectColumn(Column.getColumn((String)detailsTableName, (String)"WAAD_DOMAIN_ID"));
            String[] objectGuidArray = new String[objectGuidList.size()];
            objectGuidArray = objectGuidList.toArray(objectGuidArray);
            int chunk = 1000;
            String[] chunkArray = null;
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < objectGuidArray.length; i += chunk) {
                chunkArray = Arrays.copyOfRange(objectGuidArray, i, Math.min(objectGuidArray.length, i + chunk));
                Criteria crit = new Criteria(Column.getColumn((String)detailsTableName, (String)"OBJECT_ID"), (Object)chunkArray, 8);
                query.setCriteria(crit);
                dataObj.append(CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query));
            }
            Iterator it = dataObj.getRows(detailsTableName);
            Long waadDomainId = null;
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String guid = (String)row.get("OBJECT_ID");
                String immutableid = (String)row.get("DECODED_IMMUTABLE_ID");
                waadDomainId = (Long)row.get("WAAD_DOMAIN_ID");
                if (immutableid == null) continue;
                guidVsImmutableId.put(guid, immutableid);
            }
            ArrayList immutableIdList = new ArrayList(guidVsImmutableId.values());
            if (waadDomainId != null) {
                ArrayList linkedDomainList = O365InfoCache.getInstance().getLinkedADDomains(waadDomainId);
                ArrayList<String> dirSyncDomainList = new ArrayList<String>();
                for (String domain : linkedDomainList) {
                    boolean isDirSyncEnabled = O365MgmtHandler.isLinkedWithDirSyncEnabledAccount((String)domain);
                    if (!isDirSyncEnabled) continue;
                    dirSyncDomainList.add(domain);
                }
                if (dirSyncDomainList.size() > 0) {
                    Properties objectClassVsSourceAnchorDetails = O365InfoCache.getInstance().getSourceAnchorDetails(waadDomainId);
                    Properties sourceAnchorDetails = (Properties)objectClassVsSourceAnchorDetails.get("user");
                    String joinColumnName = (String)sourceAnchorDetails.get("COLUMN_NAME");
                    String joinTableName = (String)sourceAnchorDetails.get("TABLE_NAME");
                    Hashtable idVsManagerDN = WFAssigneeMacroUtil.getManagerDN(immutableIdList, (String)joinTableName, (String)joinColumnName, dirSyncDomainList);
                    Set keys = guidVsImmutableId.keySet();
                    Hashtable<String, String> guidVsManagerDN = new Hashtable<String, String>();
                    for (String key : keys) {
                        String immutableId = (String)guidVsImmutableId.get(key);
                        String managerDn = (String)idVsManagerDN.get(immutableId.toUpperCase());
                        if (managerDn == null) continue;
                        guidVsManagerDN.put(key, managerDn);
                    }
                    this.fillManagerDetails(guidVsManagerDN);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

