/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFTask;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacro;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroHandler;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro.WFAbstractMacro;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class TemplateManagerMacro
extends WFAbstractMacro {
    public TemplateManagerMacro(Long requestId, Long reqMonitorTaskId) {
        super(requestId, reqMonitorTaskId, "%manager%", "ReqMonitorTaskCSVResultManagerMapping", "FcBulkObjectIndexDetails");
    }

    @Override
    public ArrayList populate() {
        if (this.isDataPopulated().booleanValue()) {
            this.clearStatusColumn();
        } else {
            Hashtable<Object, String> objectVsManagerDN = this.copyObjectDetails();
            this.fillManagerDetails(objectVsManagerDN);
            this.setIsDataPopulated(Boolean.TRUE);
        }
        ArrayList<Long> yetToValidateTechnicians = this.getYetToValidateTechnicians();
        if (yetToValidateTechnicians.size() == 0) {
            yetToValidateTechnicians.add(CommonUtil.ADMIN_LOGIN_ID);
        }
        return yetToValidateTechnicians;
    }

    @Override
    public String getObjectColumn() {
        return "OBJECT_INDEX_ID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Object, String> copyObjectDetails() {
        Hashtable<Object, String> idVsManagerDN = new Hashtable<Object, String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Long actionId = WorkFlowUtil.getRequestActionId((Long)this.getReqMonitorTaskId());
            Integer objectIndexType = 2;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)this.getParentTableName()));
            query.addSelectColumn(Column.getColumn((String)this.getParentTableName(), (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ReqMonitorTaskCSVImportResult", (String)"UNIQUE_ID "));
            query.addSelectColumn(Column.getColumn((String)"ReqMonitorTaskCSVImportResult", (String)"REQ_MONITOR_TASK_ID "));
            query.addSelectColumn(Column.getColumn((String)"ReqMonitorTaskCSVImportResult", (String)"USER_CREATION_ID "));
            query.addSelectColumn(Column.getColumn((String)"FcBulkUserManagerVals", (String)"UNIQUE_ID"));
            query.addSelectColumn(Column.getColumn((String)"FcBulkUserManagerVals", (String)"MANAGER"));
            query.addSelectColumn(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_TYPE"));
            query.addSelectColumn(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_GUID"));
            query.addJoin(new Join(Table.getTable((String)this.getParentTableName()), Table.getTable((String)"ReqMonitorTaskCSVImportResult"), new String[]{"OBJECT_CREATION_ID"}, new String[]{"USER_CREATION_ID"}, 1));
            query.addJoin(new Join(Table.getTable((String)this.getParentTableName()), Table.getTable((String)"FcBulkUserManagerVals"), new String[]{"OBJECT_INDEX_ID"}, new String[]{"OBJECT_INDEX_ID"}, 1));
            Criteria crit = new Criteria(Column.getColumn((String)"ReqMonitorTaskCSVImportResult", (String)"REQ_MONITOR_TASK_ID"), (Object)this.getReqMonitorTaskId(), 0);
            Criteria managerCrit = new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"MANAGER"), null, 0);
            managerCrit = managerCrit.or(new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 0));
            crit = crit.and(managerCrit);
            query.setCriteria(crit);
            this.macroConfDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Long indexId = (Long)dataSet.getValue("OBJECT_INDEX_ID");
                String managerDN = (String)dataSet.getValue("MANAGER");
                Row row = new Row(this.getTableName());
                row.set("REQ_MONITOR_TASK_ID", (Object)this.getReqMonitorTaskId());
                row.set("OBJECT_INDEX_ID", (Object)indexId);
                this.macroConfDataObj.addRow(row);
                if (managerDN != null) {
                    idVsManagerDN.put(indexId, managerDN);
                }
                if (actionId == null || !actionId.equals(WorkFlowUtil.MODIFY_USER_ACTION_ID)) continue;
                String objectGuid = (String)dataSet.getValue("OBJECT_GUID");
                row.set("OBJECT_GUID", (Object)objectGuid);
                if (managerDN != null) continue;
                row.set("IS_TEMPLATE_VALUE", (Object)Boolean.FALSE);
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMUserGeneralDetails", new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                Row userRow = dataObject.getRow("ADSMUserGeneralDetails");
                if (userRow == null || (managerDN = (String)userRow.get("MANAGER_DN")) == null) continue;
                idVsManagerDN.put(indexId, managerDN);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return idVsManagerDN;
    }

    @Override
    public Hashtable<Long, ArrayList> getRejectedObjects() {
        Hashtable<Long, ArrayList> rejectedHash = new Hashtable<Long, ArrayList>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), (Object)false, 0);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long objectIndexId = (Long)row.get("OBJECT_INDEX_ID");
                Long loginId = (Long)row.get("LOGIN_ID");
                ArrayList<Long> idList = rejectedHash.get(loginId);
                if (idList == null) {
                    idList = new ArrayList<Long>();
                    rejectedHash.put(loginId, idList);
                }
                idList.add(objectIndexId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rejectedHash;
    }

    @Override
    public Boolean removeRejectedObjects() {
        try {
            Hashtable<Long, ArrayList> rejectedHash = this.getRejectedObjects();
            Set<Long> keys = rejectedHash.keySet();
            Iterator<Long> itr = keys.iterator();
            String comments = "admp.workflow.assignee_macro.reject_comment";
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            WFViewRequest wfViewRequest = new WFViewRequest(this.getRequestId(), rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(this.getReqMonitorTaskId());
            Long objectCreationId = wfTask.getUserCreationId();
            Long templateCategoryId = null;
            HashMap resultMap = wfTask.getRequestUserCreationDetails();
            for (AdmpInput admpInput : wfTask.getInputList()) {
                if (!admpInput.getName().equalsIgnoreCase("templateCategoryId")) continue;
                templateCategoryId = new Long(admpInput.getValue());
            }
            String domainName = (String)resultMap.get("DOMAIN_NAME");
            String containerName = (String)resultMap.get("CONTAINER_NAME");
            String templateName = (String)resultMap.get("TEMPLATE_NAME");
            Long layoutId = (Long)resultMap.get("LAYOUT_ID");
            Long actioId = wfTask.getRequestActionId();
            ArrayList columnList = ColumnConfiguration.getColumnList((long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (int)2);
            Hashtable dpValues = FcLayoutUtil.getDPValues((Long)templateCategoryId, (Long)CommonUtil.ADMIN_LOGIN_ID, (String)domainName, (AdventNetResourceBundle)rb, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE);
            Boolean isRejected = Boolean.TRUE;
            while (itr.hasNext()) {
                Long loginId = itr.next();
                AdventNetResourceBundle resourceBundle = ResourceBundleMgr.getInstance().getBundle(loginId);
                ArrayList idList = rejectedHash.get(loginId);
                for (int i = 0; i < idList.size(); ++i) {
                    JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(null, (Long)null, objectCreationId, templateCategoryId, (Long)idList.get(i), domainName, CommonUtil.ADMIN_LOGIN_ID, rb, -1, -1, null, new ADMPAuthObject(CommonUtil.ADMIN_LOGIN_ID), actioId, false, dpValues);
                    JSONObject columnsList = new JSONObject();
                    FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
                    JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
                    WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(this.getRequestId(), this.getReqMonitorTaskId(), loginId);
                    auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                    auditActivities.setAuditActivitySubType(WFRequestUtil.TASK_OBJECT_REMOVED);
                    auditActivities.updateBoardId(isRejected);
                    auditActivities.updateIsCSVImportActionType();
                    auditActivities.setComments(resourceBundle.getString(comments));
                    auditActivities.updateAuditActivities(new JSONObject(), (Long)idList.get(i), objectsList, new JSONArray(), isRejected);
                }
                Criteria criteria = new Criteria(Column.getColumn((String)this.getParentTableName(), (String)"OBJECT_INDEX_ID"), (Object)idList.toArray(), 8);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Criteria getCriteriaForTechnician(Long loginId) {
        return null;
    }

    @Override
    public Hashtable getObjectsForTechnician(Long loginId) {
        Hashtable<Long, Integer> idVsCount = new Hashtable<Long, Integer>();
        Hashtable<Object, Integer> validatedCountHash = this.getValidatedCountHash();
        if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
            return validatedCountHash;
        }
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 1));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long objectIndexId = (Long)row.get("OBJECT_INDEX_ID");
                idVsCount.put(objectIndexId, validatedCountHash.get(objectIndexId));
            }
            if (idVsCount.size() == 0) {
                ArrayList<Object> idList = this.getYetToValidateObjects();
                crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
                it = this.macroConfDataObj.getRows(this.getTableName(), crit);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long objectIndexId = (Long)row.get("OBJECT_INDEX_ID");
                    if (!idList.contains(objectIndexId)) continue;
                    idVsCount.put(objectIndexId, validatedCountHash.get(objectIndexId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idVsCount;
    }

    @Override
    public void updateValue(Object uniqueObjectId) {
        try {
            Hashtable<Object, String> objectVsManagerDN = new Hashtable<Object, String>();
            Integer objectIndexType = 2;
            Criteria managerCrit = new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_ID"), uniqueObjectId, 0);
            managerCrit = managerCrit.and(new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"MANAGER"), null, 1));
            managerCrit = managerCrit.and(new Criteria(Column.getColumn((String)"FcBulkUserManagerVals", (String)"OBJECT_INDEX_TYPE"), (Object)objectIndexType, 0));
            DataObject managerDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcBulkUserManagerVals", managerCrit);
            Row managerRow = managerDataObject.getRow("FcBulkUserManagerVals");
            String managerDn = null;
            if (managerRow != null) {
                managerDn = (String)managerRow.get("MANAGER");
            }
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"OBJECT_INDEX_ID"), uniqueObjectId, 0);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            ArrayList<Row> deleteRowList = new ArrayList<Row>();
            ArrayList<Row> addRowList = new ArrayList<Row>();
            Boolean isDeleteRow = Boolean.FALSE;
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String dn = (String)row.get("MANAGER_DISTINGUISHED_NAME");
                String objectGuid = (String)row.get("OBJECT_GUID");
                Boolean validationStatus = (Boolean)row.get("VALIDATION_STATUS");
                if (isDeleteRow.booleanValue()) {
                    if (validationStatus == null) {
                        deleteRowList.add(row);
                    }
                } else if (managerDn != null && !managerDn.equals("")) {
                    if (dn != null && managerDn.equalsIgnoreCase(dn)) break;
                    if (validationStatus != null) {
                        Row addRow = new Row(this.getTableName());
                        addRow.set("MANAGER_DISTINGUISHED_NAME", (Object)managerDn);
                        addRow.set("OBJECT_GUID", (Object)objectGuid);
                        addRow.set("OBJECT_INDEX_ID", uniqueObjectId);
                        addRow.set("REQ_MONITOR_TASK_ID", (Object)this.getReqMonitorTaskId());
                        addRow.set("IS_TEMPLATE_VALUE", (Object)Boolean.TRUE);
                        addRowList.add(addRow);
                    } else {
                        row.set("MANAGER_GUID", null);
                        row.set("MANAGER_GROUP_GUID", null);
                        row.set("MANAGER_DISTINGUISHED_NAME", (Object)managerDn);
                        row.set("IS_TEMPLATE_VALUE", (Object)Boolean.TRUE);
                        objectVsManagerDN.put(uniqueObjectId, managerDn);
                        this.macroConfDataObj.updateRow(row);
                    }
                } else if (objectGuid != null) {
                    String currentManagerDn;
                    DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMUserGeneralDetails", new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0));
                    Row userRow = dataObject.getRow("ADSMUserGeneralDetails");
                    if (userRow != null && (currentManagerDn = (String)userRow.get("MANAGER_DN")) != null) {
                        if (dn != null && currentManagerDn.equalsIgnoreCase(dn)) break;
                        if (validationStatus != null) {
                            Row addRow = new Row(this.getTableName());
                            addRow.set("MANAGER_DISTINGUISHED_NAME", (Object)managerDn);
                            addRow.set("OBJECT_GUID", (Object)objectGuid);
                            addRow.set("OBJECT_INDEX_ID", uniqueObjectId);
                            addRow.set("REQ_MONITOR_TASK_ID", (Object)this.getReqMonitorTaskId());
                            addRow.set("IS_TEMPLATE_VALUE", (Object)Boolean.FALSE);
                            addRowList.add(addRow);
                        } else {
                            row.set("MANAGER_GUID", null);
                            row.set("MANAGER_GROUP_GUID", null);
                            row.set("MANAGER_DISTINGUISHED_NAME", (Object)currentManagerDn);
                            row.set("IS_TEMPLATE_VALUE", (Object)Boolean.FALSE);
                            objectVsManagerDN.put(uniqueObjectId, currentManagerDn);
                            this.macroConfDataObj.updateRow(row);
                        }
                    }
                } else {
                    row.set("MANAGER_GUID", null);
                    row.set("MANAGER_GROUP_GUID", null);
                    row.set("MANAGER_DISTINGUISHED_NAME", null);
                    row.set("LOGIN_ID", null);
                    row.set("IS_TEMPLATE_VALUE", (Object)Boolean.TRUE);
                    this.macroConfDataObj.updateRow(row);
                }
                if (isDeleteRow.booleanValue()) continue;
                isDeleteRow = Boolean.TRUE;
            }
            if (deleteRowList.size() > 0) {
                for (Row row : deleteRowList) {
                    this.macroConfDataObj.deleteRow(row);
                }
            }
            if (isDeleteRow.booleanValue()) {
                if (addRowList.size() > 0) {
                    for (Row row : addRowList) {
                        this.macroConfDataObj.addRow(row);
                    }
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            }
            if (objectVsManagerDN.size() > 0) {
                this.fillManagerDetails(objectVsManagerDN, crit);
            }
            WFAssigneeMacroHandler.updateRequestVsTechnicianMapping((WFAssigneeMacro)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillManagerDetails(Hashtable objectVsManagerDN, Criteria criteria) {
        try {
            ArrayList managerDNList = new ArrayList(objectVsManagerDN.values());
            HashSet set = new HashSet(managerDNList);
            managerDNList.clear();
            managerDNList.addAll(set);
            Hashtable managerDetailsHash = WFAssigneeMacroUtil.getManagerDetails(managerDNList);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), criteria);
            ArrayList<String> groupGuidList = new ArrayList<String>();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                String managerDN = (String)objectVsManagerDN.get(object);
                if (managerDN == null) continue;
                Hashtable managerDetails = (Hashtable)managerDetailsHash.get(managerDN);
                row.set("MANAGER_DISTINGUISHED_NAME", (Object)managerDN);
                if (managerDetails != null) {
                    if (((String)managerDetails.get("OBJECT_CLASS")).equalsIgnoreCase("USER")) {
                        row.set("MANAGER_GUID", (Object)((String)managerDetails.get("OBJECT_GUID")));
                        row.set("LOGIN_ID", (Object)((Long)managerDetails.get("LOGIN_ID")));
                    } else if (((String)managerDetails.get("OBJECT_CLASS")).equalsIgnoreCase("GROUP")) {
                        row.set("MANAGER_GROUP_GUID", (Object)((String)managerDetails.get("OBJECT_GUID")));
                        String groupGuid = (String)managerDetails.get("OBJECT_GUID");
                        if (!groupGuidList.contains(groupGuid)) {
                            groupGuidList.add(groupGuid);
                        }
                    }
                }
                this.macroConfDataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            if (groupGuidList.size() > 0) {
                this.fillManagerGroupMembers(groupGuidList, criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillManagerGroupMembers(ArrayList groupGuidList, Criteria criteria) {
        try {
            Hashtable guidvsLoginIdArray = WFAssigneeMacroUtil.getManagerGroupMemberTech((ArrayList)groupGuidList);
            ArrayList<Row> memberRowList = new ArrayList<Row>();
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"MANAGER_GROUP_GUID"), (Object)groupGuidList.toArray(), 8);
            crit = crit.and(criteria);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String groupGuid = (String)row.get("MANAGER_GROUP_GUID");
                ArrayList loginIdArray = (ArrayList)guidvsLoginIdArray.get(groupGuid);
                if (loginIdArray == null) continue;
                for (Long loginId : loginIdArray) {
                    Row memberRow = new Row(this.getTableName());
                    List columnList = row.getColumns();
                    for (String column : columnList) {
                        if (column.equalsIgnoreCase("UNIQUE_ID")) continue;
                        memberRow.set(column, row.get(column));
                    }
                    memberRow.set("LOGIN_ID", (Object)loginId);
                    memberRowList.add(memberRow);
                }
            }
            for (Row row : memberRowList) {
                this.macroConfDataObj.addRow(row);
            }
            if (memberRowList.size() > 0) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Boolean isObjectStatusAvailable() {
        return Boolean.TRUE;
    }

    @Override
    public Boolean isInputStatusAvailable() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean isObjectHistoryAvailable() {
        return Boolean.TRUE;
    }
}

