/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow.assigneemacro;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflowRule;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacro;
import com.adventnet.sym.adsm.common.server.workflow.assigneemacro.WFAssigneeMacroUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class WFAbstractMacro
implements WFAssigneeMacro {
    private String macro;
    private String tableName;
    private Long requestId;
    private Long reqMonitorTaskId;
    private Integer directValidationCount;
    private Boolean isDataPopulated = Boolean.FALSE;
    private String parentTableName;
    public DataObject macroConfDataObj;
    private Integer wfStatus;
    private BusinessWorkflowRule businessWorkflowRule;
    private Integer totalValidationCount;

    public WFAbstractMacro(Long requestId, Long reqMonitorTaskId, String macro, String tableName, String parentTableName) {
        this.requestId = requestId;
        this.reqMonitorTaskId = reqMonitorTaskId;
        this.macro = macro;
        this.tableName = tableName;
        this.parentTableName = parentTableName;
    }

    public String getMacro() {
        return this.macro;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getParentTableName() {
        return this.parentTableName;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public Long getReqMonitorTaskId() {
        return this.reqMonitorTaskId;
    }

    public void setIsDataPopulated(Boolean isDataPopulated) {
        this.isDataPopulated = isDataPopulated;
    }

    public Boolean isDataPopulated() {
        return this.isDataPopulated;
    }

    private void setTotalValidationCount(Integer count) {
        this.totalValidationCount = count;
    }

    public Integer getTotalValidationCount() {
        return this.totalValidationCount;
    }

    private void setDirectValidationCount(Integer count) {
        this.directValidationCount = count;
    }

    protected Integer getDirectValidationCount() {
        return this.directValidationCount;
    }

    public Integer getValidatedCount() {
        Integer macroValidationCount = this.getMacroValidatedCount();
        if (macroValidationCount.equals(-1)) {
            return macroValidationCount;
        }
        return this.getDirectValidationCount() + macroValidationCount;
    }

    public void setWfStatus(Integer status) {
        this.wfStatus = status;
    }

    public Integer getWfStatus() {
        return this.wfStatus;
    }

    public void setBusinessWorkflowRule(BusinessWorkflowRule businessWorkflowRule) {
        this.businessWorkflowRule = businessWorkflowRule;
    }

    public BusinessWorkflowRule getBusinessWorkflowRule() {
        return this.businessWorkflowRule;
    }

    protected void initRequestDetails() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMRequests", (String)"REQUEST_ID"), (Object)this.getRequestId(), 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMRequests", crit);
            Row row = dataObject.getRow("ADSMRequests");
            Long count = (Long)row.get("WORKFLOW_PROCESS_COUNT");
            Integer macroValidationCount = this.getMacroValidatedCount();
            if (macroValidationCount.equals(-1)) {
                this.setDirectValidationCount(macroValidationCount);
            } else {
                this.setDirectValidationCount(count.intValue() - macroValidationCount);
            }
            Integer status = (Integer)row.get("WORKFLOW_STATUS");
            Long ruleId = (Long)row.get("RULE_ID");
            BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)ruleId);
            this.setBusinessWorkflowRule(businessWorkflowRule);
            Integer currentWorkflowStatus = businessWorkflowRule.getNextElement(status, count);
            this.setWfStatus(currentWorkflowStatus);
            Long actualWFPrcessCount = businessWorkflowRule.getWFElementCount(currentWorkflowStatus);
            if (actualWFPrcessCount != null) {
                this.setTotalValidationCount(actualWFPrcessCount.intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        try {
            this.macroConfDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(this.getTableName(), new Criteria(Column.getColumn((String)this.getTableName(), (String)"REQ_MONITOR_TASK_ID"), (Object)this.getReqMonitorTaskId(), 0));
            if (this.macroConfDataObj.size(this.getTableName()) > 0) {
                this.setIsDataPopulated(Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initRequestDetails();
    }

    public void fillManagerDetails(Hashtable objectVsManagerDN) {
        try {
            ArrayList managerDNList = new ArrayList(objectVsManagerDN.values());
            HashSet set = new HashSet(managerDNList);
            managerDNList.clear();
            managerDNList.addAll(set);
            Hashtable managerDetailsHash = WFAssigneeMacroUtil.getManagerDetails(managerDNList);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName());
            ArrayList<String> groupGuidList = new ArrayList<String>();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                String managerDN = (String)objectVsManagerDN.get(object);
                if (managerDN == null) continue;
                Hashtable managerDetails = (Hashtable)managerDetailsHash.get(managerDN);
                row.set("MANAGER_DISTINGUISHED_NAME", (Object)managerDN);
                if (managerDetails != null) {
                    if (((String)managerDetails.get("OBJECT_CLASS")).equalsIgnoreCase("USER")) {
                        row.set("MANAGER_GUID", (Object)((String)managerDetails.get("OBJECT_GUID")));
                        row.set("LOGIN_ID", (Object)((Long)managerDetails.get("LOGIN_ID")));
                    } else if (((String)managerDetails.get("OBJECT_CLASS")).equalsIgnoreCase("GROUP")) {
                        row.set("MANAGER_GROUP_GUID", (Object)((String)managerDetails.get("OBJECT_GUID")));
                        String groupGuid = (String)managerDetails.get("OBJECT_GUID");
                        if (!groupGuidList.contains(groupGuid)) {
                            groupGuidList.add(groupGuid);
                        }
                    }
                }
                this.macroConfDataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            if (groupGuidList.size() > 0) {
                this.fillManagerGroupMembers(groupGuidList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillManagerGroupMembers(ArrayList groupGuidList) {
        try {
            Hashtable guidvsLoginIdArray = WFAssigneeMacroUtil.getManagerGroupMemberTech((ArrayList)groupGuidList);
            ArrayList<Row> memberRowList = new ArrayList<Row>();
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"MANAGER_GROUP_GUID"), (Object)groupGuidList.toArray(), 8);
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                String groupGuid = (String)row.get("MANAGER_GROUP_GUID");
                ArrayList loginIdArray = (ArrayList)guidvsLoginIdArray.get(groupGuid);
                if (loginIdArray == null) continue;
                for (Long loginId : loginIdArray) {
                    Row memberRow = new Row(this.getTableName());
                    List columnList = row.getColumns();
                    for (String column : columnList) {
                        if (column.equalsIgnoreCase("UNIQUE_ID")) continue;
                        memberRow.set(column, row.get(column));
                    }
                    memberRow.set("LOGIN_ID", (Object)loginId);
                    memberRowList.add(memberRow);
                }
            }
            for (Row row : memberRowList) {
                this.macroConfDataObj.addRow(row);
            }
            if (memberRowList.size() > 0) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean clearStatusColumn() {
        try {
            Iterator it = this.macroConfDataObj.getRows(this.getTableName());
            while (it.hasNext()) {
                Row row = (Row)it.next();
                row.set("VALIDATION_STATUS", null);
                this.macroConfDataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean clearTask() {
        try {
            this.macroConfDataObj.deleteRows(this.getTableName(), new Criteria(Column.getColumn((String)this.getTableName(), (String)"UNIQUE_ID"), null, 1));
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Hashtable<Object, Integer> getMacroValidatedCountHash() {
        return this.getValidatedCountHash(Boolean.TRUE);
    }

    public Hashtable<Object, Integer> getValidatedCountHash() {
        return this.getValidatedCountHash(Boolean.FALSE);
    }

    public Hashtable<Object, Integer> getValidatedCountHash(Boolean isMacro) {
        Hashtable<Object, Integer> validatedCountHash = new Hashtable<Object, Integer>();
        try {
            Iterator it = this.macroConfDataObj.getRows(this.getTableName());
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                Boolean status = (Boolean)row.get("VALIDATION_STATUS");
                Integer validatedCount = validatedCountHash.get(object);
                if (validatedCount == null) {
                    validatedCount = isMacro != false ? Integer.valueOf(0) : this.getDirectValidationCount();
                    validatedCountHash.put(object, validatedCount);
                }
                if (status != null && status.booleanValue() && !validatedCount.equals(-1)) {
                    Integer n = validatedCount;
                    Integer n2 = validatedCount = Integer.valueOf(validatedCount + 1);
                    validatedCountHash.put(object, validatedCount);
                    continue;
                }
                if (status == null || status.booleanValue()) continue;
                validatedCountHash.put(object, -1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validatedCountHash;
    }

    public Integer getMacroValidatedCount() {
        Integer minValidatedCount = 0;
        Boolean isFirstValue = Boolean.TRUE;
        Boolean isRejected = Boolean.TRUE;
        Hashtable<Object, Integer> validatedCountHash = this.getMacroValidatedCountHash();
        Set<Object> keys = validatedCountHash.keySet();
        Iterator<Object> itr = keys.iterator();
        while (itr.hasNext()) {
            Integer count = validatedCountHash.get(itr.next());
            if (isRejected.booleanValue() && !count.equals(-1)) {
                isRejected = Boolean.FALSE;
            }
            if (count.equals(-1) || !isFirstValue.booleanValue() && count >= minValidatedCount) continue;
            minValidatedCount = count;
            isFirstValue = Boolean.FALSE;
        }
        if (isRejected.booleanValue() && validatedCountHash.size() > 0) {
            minValidatedCount = -1;
        }
        return minValidatedCount;
    }

    public ArrayList<Long> getYetToValidateTechnicians() {
        ArrayList<Long> yetToValidateTechnicians = new ArrayList<Long>();
        try {
            ArrayList<Object> objectList = this.getYetToValidateObjects();
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), null, 1);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Long loginId;
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                if (!objectList.contains(object) || yetToValidateTechnicians.contains(loginId = (Long)row.get("LOGIN_ID"))) continue;
                yetToValidateTechnicians.add(loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getBoardTechnicians(yetToValidateTechnicians);
    }

    public ArrayList<Long> getValidatedTechncians() {
        ArrayList<Long> validatedTechnicians = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), null, 1);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 1));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long loginId = (Long)row.get("LOGIN_ID");
                if (validatedTechnicians.contains(loginId)) continue;
                validatedTechnicians.add(loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getBoardTechnicians(validatedTechnicians);
    }

    public ArrayList<Object> getYetToValidateObjects() {
        ArrayList<Object> idList = new ArrayList<Object>();
        Hashtable<Object, Integer> validatedCountHash = this.getValidatedCountHash();
        Set<Object> keys = validatedCountHash.keySet();
        for (Object object : keys) {
            Integer count = validatedCountHash.get(object);
            if (count.equals(-1) || count >= this.getTotalValidationCount()) continue;
            idList.add(object);
        }
        return idList;
    }

    public Integer approve(Long loginId) {
        ArrayList<Object> objectList = this.getYetToValidateObjects();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                if (!objectList.contains(object)) continue;
                row.set("VALIDATION_STATUS", (Object)true);
                this.macroConfDataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getValidatedCount();
    }

    public Integer reject(Long loginId) {
        ArrayList<Object> objectList = this.getYetToValidateObjects();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)this.getTableName(), (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)this.getTableName(), (String)"VALIDATION_STATUS"), null, 0));
            Iterator it = this.macroConfDataObj.getRows(this.getTableName(), crit);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Object object = row.get(this.getObjectColumn());
                if (!objectList.contains(object)) continue;
                row.set("VALIDATION_STATUS", (Object)false);
                this.macroConfDataObj.updateRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.macroConfDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getValidatedCount();
    }

    public ArrayList getBoardTechnicians(ArrayList tehnicianList) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            if (tehnicianList.size() > 0) {
                Integer status = this.getWfStatus();
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMBoardMembers", (String)"BOARD_ID"), (Object)status, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMBoardMembers", (String)"LOGIN_ID"), (Object)tehnicianList.toArray(), 8));
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMBoardMembers", criteria);
                Iterator it = dataObject.getRows("ADSMBoardMembers");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long loginId = (Long)row.get("LOGIN_ID");
                    list.add(loginId);
                }
                if (tehnicianList.contains(CommonUtil.ADMIN_LOGIN_ID)) {
                    list.add(CommonUtil.ADMIN_LOGIN_ID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateValue(Object uniqueObjectId) {
    }

    public Boolean isObjectHistoryAvailable() {
        return Boolean.FALSE;
    }

    public abstract ArrayList populate();

    public abstract String getObjectColumn();

    public abstract Criteria getCriteriaForTechnician(Long var1);

    public abstract Hashtable getObjectsForTechnician(Long var1);

    public abstract Boolean removeRejectedObjects();

    public abstract Hashtable<Long, ArrayList> getRejectedObjects();

    public abstract Boolean isObjectStatusAvailable();

    public abstract Boolean isInputStatusAvailable();
}

