/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.security.server.TemplateHandler;
import com.adventnet.sym.adsm.security.webclient.model.ApplyBean;
import com.adventnet.sym.adsm.security.webclient.model.TemplateBean;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplySecurityAction
extends DispatchAction {
    private static Long DELEGATE_ROLE_ACTION_ID = 1805L;
    static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};

    public ActionForward introPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("intro");
    }

    public ActionForward selectSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ArrayList templateList;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domainVsactions = authObject.getDomainActionMap();
        Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
        String domainName = selectedDomain.getProperty("DOMAIN_NAME");
        ApplyBean applyBean = (ApplyBean)form;
        if (request.getParameter("back") == null) {
            applyBean.set("SID_PATH", new ArrayList());
            applyBean.set("ADOBJECT_PATH", new ArrayList());
            applyBean.set("TEMPLATE_LIST", new ArrayList());
        }
        if (request.getParameter("templates") != null) {
            templateList = (ArrayList)applyBean.get("TEMPLATE_LIST");
            templateList.add(request.getParameter("templates"));
        } else if (request.getParameter("savedTemplate") != null) {
            templateList = (ArrayList)applyBean.get("TEMPLATE_LIST");
            TemplateBean templateBean = (TemplateBean)((Object)request.getSession().getAttribute("TemplateBean"));
            String templateName = (String)templateBean.get("TEMPLATE_NAME");
            templateList.add(templateName);
        }
        if (request.getParameter("adobject") != null) {
            ArrayList adoList = (ArrayList)applyBean.get("ADOBJECT_PATH");
            String adoString = request.getParameter("adobject");
            System.out.println("in apply sec action 1");
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            if (adoString.equals(rootPath) || adoString.equals("")) {
                try {
                    DirectoryObject tempObject = (DirectoryObject)ADHandler.getDomainObject((String)domainName, (Long)loginId, (String)rootPath);
                    ArrayList childObjectsList = tempObject.getChildObjectList();
                    DirectoryObject obj = (DirectoryObject)childObjectsList.get(0);
                    adoList.add(obj.getID());
                    System.out.println("The AD Object at top is " + obj.getID());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                adoList.add(request.getParameter("adobject"));
            }
        }
        request.setAttribute("domainName", (Object)domainName);
        return mapping.findForward("selectsid");
    }

    public ActionForward getSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ApplyBean applyBean = (ApplyBean)form;
        applyBean.getSIDs(request);
        return mapping.findForward("sid");
    }

    public ActionForward selectedSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ApplyBean applyBean = (ApplyBean)form;
        applyBean.selectedSIDs(request);
        return mapping.findForward("selectedsids");
    }

    public ActionForward selectADOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domainVsactions = authObject.getDomainActionMap();
        Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
        String domainName = selectedDomain.getProperty("DOMAIN_NAME");
        request.setAttribute("domainName", (Object)domainName);
        return mapping.findForward("selectado");
    }

    public ActionForward getADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            ApplyBean applyBean = (ApplyBean)form;
            applyBean.getADObjects(request);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                request.setAttribute("errorMsg", (Object)e.getMessage());
            }
            e.printStackTrace();
        }
        return mapping.findForward("ado");
    }

    public ActionForward expandNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ApplyBean applyBean = (ApplyBean)form;
            String nodeClicked = request.getParameter("nodeClicked");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            applyBean.setDirectoryObject(nodeClicked, request);
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(nodeClicked, request, "ApplyTreeModel");
            String outNode = DirectoryObjectUtil.getADOJSONElement(object, rootPath, false);
            response.setContentType("application/json;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward selectedADOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ApplyBean applyBean = (ApplyBean)form;
        applyBean.selectedADOs(request);
        return mapping.findForward("selectedados");
    }

    public ActionForward selectRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("selectroles");
    }

    public ActionForward getRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList list = SecurityClientUtil.getTemplates(loginId);
        request.setAttribute("rolesList", (Object)list);
        return mapping.findForward("roles");
    }

    public ActionForward expandTemplates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String templateToExpand = request.getParameter("templateToExpand");
            ByteArrayOutputStream outNode = this.getRoleXMLElement(request, templateToExpand);
            response.setContentType("text/xml;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteArrayOutputStream getRoleXMLElement(HttpServletRequest request, String templateName) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element templateElement = document.createElement("template");
            templateElement.setAttribute("name", templateName);
            data.appendChild(templateElement);
            ArrayList aceList = new ArrayList();
            Hashtable p = TemplateHandler.get((String)templateName, (Long)loginId);
            aceList = (ArrayList)p.get("aceList");
            for (int i = 0; i < aceList.size(); ++i) {
                Hashtable prop = (Hashtable)aceList.get(i);
                Element aceElement = document.createElement("ace");
                aceElement.setAttribute("permissionString", rb.getString((String)prop.get("PERMISSION_STRING")));
                aceElement.setAttribute("aceType", rb.getString((String)prop.get("TYPE_STRING")));
                aceElement.setAttribute("appliesTo", rb.getString((String)prop.get("APPLIESTO_STRING")));
                data.appendChild(aceElement);
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public ActionForward selectedRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ApplyBean applyBean = (ApplyBean)form;
        applyBean.selectedRoles(request);
        return mapping.findForward("selectedroles");
    }

    public ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("summary");
    }

    public ActionForward applyRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Hashtable tempList = TemplateHandler.getTemplateInfo();
        String message = null;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ApplyBean applyBean = (ApplyBean)form;
            applyBean.selectedRoles(request);
            ArrayList<Long> templateIdList = new ArrayList<Long>();
            ArrayList TEMPLATE_LIST = (ArrayList)applyBean.get("TEMPLATE_LIST");
            ArrayList ADOBJECT_PATH = (ArrayList)applyBean.get("ADOBJECT_PATH");
            ArrayList SID_PATH = (ArrayList)applyBean.get("SID_PATH");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            System.out.println("Delegate templateList : " + TEMPLATE_LIST);
            System.out.println("Delegate domainName : " + domainName);
            System.out.println("Delegate SID_PATH : " + SID_PATH);
            System.out.println("Delegate ADOBJECT_PATH : " + ApplySecurityAction.encode((String)ADOBJECT_PATH.get(0)));
            for (String templateName : TEMPLATE_LIST) {
                for (String tempName : tempList.keySet()) {
                    if (!rb.getString(tempName).equals(templateName) && !tempName.equals(templateName)) continue;
                    Long tempId = (Long)tempList.get(tempName);
                    templateIdList.add(tempId);
                }
            }
            int statusCode = TemplateHandler.delegateTemplate(templateIdList, (String)domainName, (Long)loginId, (ArrayList)SID_PATH, (ArrayList)ADOBJECT_PATH);
            System.out.println("Delegation Status  : " + statusCode);
            applyBean.set("TEMPLATE_LIST", new ArrayList());
            applyBean.set("SID_PATH", new ArrayList());
            applyBean.set("ADOBJECT_PATH", new ArrayList());
            request.setAttribute("statusCode", (Object)new Integer(statusCode));
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
            return mapping.findForward("summary");
        }
        return mapping.findForward("viewTemplateList");
    }

    public ActionForward revokeRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block2: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            try {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ArrayList<String> SID_LIST = new ArrayList<String>();
                ArrayList<String> DELEGATION_PATH = new ArrayList<String>();
                String roleName = request.getParameter("role");
                String sid = request.getParameter("sid");
                SID_LIST.add(sid);
                String object = request.getParameter("object");
                System.out.println("Revokin the object : " + ApplySecurityAction.encode(object));
                String delId = request.getParameter("delId");
                Long deleId = new Long(delId);
                String tempId = request.getParameter("tempId");
                Long templateId = new Long(tempId);
                DELEGATION_PATH.add(object);
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Hashtable domainVsactions = authObject.getDomainActionMap();
                Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
                String domainName = selectedDomain.getProperty("DOMAIN_NAME");
                TemplateHandler.revokeTemplate((String)roleName, (String)domainName, (Long)loginId, SID_LIST, DELEGATION_PATH, (Long)deleId, (Long)templateId);
                request.setAttribute("message", (Object)rb.getString("client.security.ApplySecurityAction.successfully_revoked"));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage() == null) break block2;
                request.setAttribute("message", (Object)rb.getString(e.getMessage()));
            }
        }
        return mapping.findForward("viewTemplateList");
    }

    public static String encode(String s) {
        StringBuffer sbuf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == ' ') {
                sbuf.append('+');
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            sbuf.append(hex[0xE0 | ch >> 12]);
            sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex[0x80 | ch & 0x3F]);
        }
        return sbuf.toString();
    }
}

