/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.usermanagement.SearchSIDsListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.security.server.SearchHandler;
import com.adventnet.sym.adsm.security.webclient.TemplateAction;
import com.adventnet.sym.adsm.security.webclient.model.SearchBean;
import com.adventnet.sym.adsm.security.webclient.model.SearchListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchAction
extends TemplateAction {
    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block24: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            try {
                SearchBean bean = (SearchBean)form;
                SearchListener listener = bean.getListener();
                if (listener == null) {
                    listener = new SearchListener(rb);
                    bean.setListener(listener);
                }
                if (request.getParameter("stop") != null) {
                    listener.stopSearch();
                }
                if (request.getParameter("search") != null) {
                    listener.stopSearch();
                    Properties selectedDomain = null;
                    String domainName = "";
                    ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
                    String defaultDomain = DomainUtil.getDefaultDomain();
                    if (domainNameList.contains(defaultDomain)) {
                        domainName = defaultDomain;
                    } else if (!domainNameList.isEmpty()) {
                        domainName = domainNameList.get(0);
                    }
                    selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                    String login = "admin";
                    try {
                        Iterator it;
                        Column column = new Column("AaaLogin", "LOGIN_ID");
                        Criteria cri = new Criteria(column, (Object)1, 0);
                        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AaaLogin", cri);
                        if (!dataObj.isEmpty() && (it = dataObj.getRows("AaaLogin")).hasNext()) {
                            Row r = (Row)it.next();
                            login = (String)r.get("NAME");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    listener.searchACE(session.getId(), domainName, loginId, login, (String)bean.get("adsPath"), (String)bean.get("securityPrincipal"), bean.getAceList(), (ArrayList)bean.get("sidList"));
                    request.setAttribute("listener", (Object)listener);
                    break block24;
                }
                if (request.getParameter("clear") != null || request.getParameter("page") != null && listener.getSearchId() == null) {
                    listener.stopSearch();
                    request.setAttribute("result", new ArrayList());
                    Properties selectedDomain = null;
                    String domainName = "";
                    ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
                    String defaultDomain = DomainUtil.getDefaultDomain();
                    if (domainNameList.contains(defaultDomain)) {
                        domainName = defaultDomain;
                    } else if (!domainNameList.isEmpty()) {
                        domainName = domainNameList.get(0);
                    }
                    selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                    bean.set("adsPath", selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT"));
                    bean.set("adsPathText", MessageFormat.format(rb.getString("jsp.search_main_page.and_its_children"), selectedDomain.getProperty("DOMAIN_NAME")));
                    bean.set("securityPrincipal", "");
                    bean.set("securityPrincipalText", rb.getString("jsp.search_main_page.any_security_principal"));
                    bean.set("aceListText", rb.getString("jsp.search_main_page.any_permission"));
                    bean.setAceList(new ArrayList());
                    request.setAttribute("recordsCount", (Object)new Long(0L));
                } else {
                    Long searchId = listener.getSearchId();
                    if (searchId != null) {
                        Properties prop = SearchHandler.getSearchCriterias((Long)searchId);
                        String rangeStr = request.getParameter("RANGE");
                        String isNavigate = request.getParameter("isNavigate");
                        Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "ReportResult", loginId);
                        request.setAttribute("range", (Object)range);
                        long startIndex = 1L;
                        long endIndex = new Long(range.intValue());
                        if (request.getParameter("FROM_INDEX") != null) {
                            startIndex = new Long(request.getParameter("FROM_INDEX"));
                            endIndex = new Long(request.getParameter("TO_INDEX"));
                        }
                        request.setAttribute("FROM_INDEX", (Object)new Long(startIndex));
                        request.setAttribute("TO_INDEX", (Object)new Long(endIndex));
                        String columnName = "NAME";
                        if (request.getParameter("columnName") != null) {
                            columnName = request.getParameter("columnName");
                        }
                        request.setAttribute("columnName", (Object)columnName);
                        String ascending = "true";
                        if (request.getParameter("ascending") != null) {
                            ascending = request.getParameter("ascending");
                        }
                        request.setAttribute("ascending", (Object)ascending);
                        ArrayList list = SearchHandler.getSearchResult((Long)searchId, (String)columnName, (String)ascending, (int)new Long(startIndex).intValue(), (int)range);
                        if (ascending.equals("true")) {
                            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
                        } else {
                            request.setAttribute("sortImage", (Object)"images/sortup.gif");
                        }
                        long count = SearchHandler.getSearchCount((Long)searchId);
                        if (list != null) {
                            System.out.println("The Number of records Found is " + list.size());
                            request.setAttribute("recordsCount", (Object)new Long(count));
                            request.setAttribute("result", (Object)list);
                        }
                        request.setAttribute("searchId", (Object)searchId);
                        if (!listener.isCompleted()) {
                            request.setAttribute("listener", (Object)listener);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapping.findForward("success");
    }

    public ActionForward getADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setDirectoryObject(request);
        return mapping.findForward("ado");
    }

    public ActionForward getSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchBean bean = (SearchBean)form;
        this.getSIDs(request, bean);
        return mapping.findForward("sid");
    }

    public ActionForward getSearchPermissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            SearchBean temp = (SearchBean)form;
            temp.init(request);
            request.setAttribute("schemaIDGuid", temp.get("schemaIDGuid"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("searchPermissions");
    }

    public ActionForward expandNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            String nodeClicked = request.getParameter("nodeClicked");
            Properties selectedDomain = null;
            String domainName = "";
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
            String defaultDomain = DomainUtil.getDefaultDomain();
            if (domainNameList.contains(defaultDomain)) {
                domainName = defaultDomain;
            } else if (!domainNameList.isEmpty()) {
                domainName = domainNameList.get(0);
            }
            selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            DirectoryObject object = (DirectoryObject)ADHandler.getDomainObject((String)domainName, (Long)loginId, (String)nodeClicked);
            ByteArrayOutputStream outNode = this.getXMLElement(object, rootPath);
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteArrayOutputStream getXMLElement(DirectoryObject dirObject, String root) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DirectoryObject temp;
            int i;
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String NodeId = dirObject.getID();
            StringTokenizer tokenizer = new StringTokenizer(NodeId, ",");
            int cnt = tokenizer.countTokens();
            StringTokenizer rootToken = new StringTokenizer(root, ",");
            int rtcnt = rootToken.countTokens();
            Element count = document.createElement("count");
            count.setAttribute("value", new Integer(cnt - rtcnt).toString());
            data.appendChild(count);
            Element parent = document.createElement("parent");
            parent.setAttribute("NodeId", dirObject.getID());
            parent.setAttribute("displayName", dirObject.getName());
            parent.setAttribute("imageIcon", dirObject.getImageIcon());
            data.appendChild(parent);
            ArrayList childObjectList = dirObject.getChildObjectList();
            int childCount = childObjectList.size();
            boolean grandChild = false;
            for (i = 0; i < childCount; ++i) {
                temp = (DirectoryObject)childObjectList.get(i);
                if (temp.isLeaf()) continue;
                grandChild = true;
            }
            if (grandChild) {
                for (i = 0; i < childCount; ++i) {
                    temp = (DirectoryObject)childObjectList.get(i);
                    Element child = document.createElement("child");
                    child.setAttribute("NodeId", temp.getID());
                    child.setAttribute("displayName", temp.getName());
                    child.setAttribute("imageIcon", temp.getImageIcon());
                    data.appendChild(child);
                }
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    private void setDirectoryObject(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            Properties selectedDomain = null;
            String domainName = "";
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
            String defaultDomain = DomainUtil.getDefaultDomain();
            if (domainNameList.contains(defaultDomain)) {
                domainName = defaultDomain;
            } else if (!domainNameList.isEmpty()) {
                domainName = domainNameList.get(0);
            }
            selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList);
            DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
            request.setAttribute("rootPath", (Object)rootPath);
            request.setAttribute("DOMAIN_NAME", (Object)selectedDomain.getProperty("DOMAIN_NAME"));
            session.setAttribute("TreeModel", (Object)model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSIDs(HttpServletRequest request, SearchBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList sidList = (ArrayList)bean.get("sidList");
        Properties selectedDomain = null;
        String domainName = "";
        try {
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
            String defaultDomain = DomainUtil.getDefaultDomain();
            if (domainNameList.contains(defaultDomain)) {
                domainName = defaultDomain;
            } else if (!domainNameList.isEmpty()) {
                domainName = domainNameList.get(0);
            }
            selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            sidList = CommonUtil.searchSecurityPrincipals(null, (String)domainName, (int)-1, (int)-1, null, (ArrayList)ouList, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bean.set("sidList", sidList);
        request.setAttribute("sidList", (Object)sidList);
        request.setAttribute("domainName", (Object)domainName);
    }

    public ActionForward searchSID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Properties selectedDomain = null;
        String domainName = "";
        try {
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
            String defaultDomain = DomainUtil.getDefaultDomain();
            if (domainNameList.contains(defaultDomain)) {
                domainName = defaultDomain;
            } else if (!domainNameList.isEmpty()) {
                domainName = domainNameList.get(0);
            }
            selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SearchBean searchBean = (SearchBean)form;
        String searchSIDs = request.getParameter("searchSIDs");
        searchSIDs = searchSIDs.toLowerCase();
        searchBean.set("searchSIDs", searchSIDs);
        String searchPattern = "";
        boolean flag = false;
        for (int i = 0; i < searchSIDs.length(); ++i) {
            if (searchSIDs.charAt(i) != '*') continue;
            flag = true;
        }
        searchPattern = flag ? searchSIDs : "*" + searchSIDs + "*";
        ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
        ArrayList searchSidList = new ArrayList();
        searchSidList = CommonUtil.searchSecurityPrincipals((String)searchPattern, (String)domainName, (int)-1, (int)-1, null, (ArrayList)ouList, (Long)loginId);
        searchBean.set("searchSidList", searchSidList);
        if (!searchSidList.isEmpty()) {
            int length = searchSidList.size();
            request.setAttribute("searchSize", (Object)new Integer(length));
        } else {
            request.setAttribute("searchSize", (Object)"No");
        }
        request.setAttribute("searchSidList", (Object)searchSidList);
        return mapping.findForward("sid");
    }

    public ActionForward saveSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long SEARCH_ID = new Long(request.getParameter("Search_Id"));
        boolean status = SearchHandler.saveSearch((Long)SEARCH_ID, (String)"SEARCH_NAME");
        return null;
    }

    public ActionForward getACLs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String distinguishedName = request.getParameter("dn");
        Long SEARCH_RESULT_ID = new Long(request.getParameter("id"));
        String dispName = request.getParameter("displayName");
        String columnName = "ACE_TYPE";
        if (request.getParameter("columnName") != null) {
            columnName = request.getParameter("columnName");
        }
        request.setAttribute("columnName", (Object)columnName);
        String ascending = "true";
        if (request.getParameter("ascending") != null) {
            ascending = request.getParameter("ascending");
        }
        request.setAttribute("ascending", (Object)ascending);
        ArrayList list = SearchHandler.getSearchAcls((Long)SEARCH_RESULT_ID, (String)columnName, (String)ascending);
        if (list == null || list.size() <= 0) {
            String defaultDomain;
            Properties selectedDomain = null;
            String domainName = "";
            ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
            if (domainNameList.contains(defaultDomain = DomainUtil.getDefaultDomain())) {
                domainName = defaultDomain;
            } else if (!domainNameList.isEmpty()) {
                domainName = domainNameList.get(0);
            }
            selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            Properties prop = ADHandler.getACLsFromDN((String)domainName, (Long)loginId, (String)distinguishedName);
            ArrayList aclsList = new ArrayList();
            aclsList = (ArrayList)prop.get("acls");
            if (!aclsList.isEmpty()) {
                for (int i = 0; i < aclsList.size(); ++i) {
                    Properties aclsProps = (Properties)aclsList.get(i);
                    Properties searchAclsProps = new Properties();
                    searchAclsProps.put("SEARCH_RESULT_ID", SEARCH_RESULT_ID);
                    searchAclsProps.put("ACE_TYPE", rb.getString((String)aclsProps.get("aceType")));
                    searchAclsProps.put("SECURITY_PRINCIPAL", aclsProps.get("trustee"));
                    Object object = aclsProps.get("permission");
                    if (object instanceof List) {
                        ArrayList permList = (ArrayList)object;
                        StringBuffer permissionsBuffer = new StringBuffer();
                        for (int j = 0; j < permList.size(); ++j) {
                            String temp = (String)permList.get(j);
                            String objectTypeStr = (String)aclsProps.get("objectTypeStr");
                            if (objectTypeStr != null) {
                                if (temp.equalsIgnoreCase("")) {
                                    temp = objectTypeStr;
                                }
                                temp = MessageFormat.format(rb.getString(temp), objectTypeStr);
                            } else {
                                temp = rb.getString(temp);
                            }
                            if (j == 0) {
                                permissionsBuffer.append(temp);
                                continue;
                            }
                            permissionsBuffer.append(", ");
                            permissionsBuffer.append(temp);
                        }
                        searchAclsProps.put("PERMISSION", permissionsBuffer.toString());
                    } else if (object instanceof String) {
                        String permString = (String)object;
                        searchAclsProps.put("PERMISSION", rb.getString(permString));
                    } else {
                        System.out.println("Not matched with any java objects listed above");
                    }
                    if (aclsProps.get("appliesToObject") != null && ((String)aclsProps.get("appliesToObject")).equalsIgnoreCase("true")) {
                        searchAclsProps.put("APPLIES_TO", MessageFormat.format(rb.getString("admp.common.permissions.appliesTo_user_objects"), aclsProps.get("appliesTo")));
                    } else {
                        searchAclsProps.put("APPLIES_TO", rb.getString((String)aclsProps.get("appliesTo")));
                    }
                    SearchHandler.addSearchAcls((Properties)searchAclsProps);
                    list = SearchHandler.getSearchAcls((Long)SEARCH_RESULT_ID, (String)columnName, (String)ascending);
                }
            }
        }
        request.setAttribute("list", (Object)list);
        request.setAttribute("dispName", (Object)dispName);
        String[] sortColumns = new String[]{"ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO"};
        for (int i = 0; i < sortColumns.length; ++i) {
            if (!columnName.equals(sortColumns[i])) continue;
            request.setAttribute("sortColumnIndex", (Object)new Integer(i));
        }
        if (ascending.equals("true")) {
            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
        } else {
            request.setAttribute("sortImage", (Object)"images/sortup.gif");
        }
        return mapping.findForward("acls");
    }

    public ActionForward searchADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String commonName = request.getParameter("searchText");
            ArrayList domainList = new ArrayList();
            ArrayList searchedObjectsList = new ArrayList();
            ArrayList errorList = new ArrayList();
            SearchSIDsListener listener = new SearchSIDsListener();
            String action = request.getParameter("action");
            if (action != null && action.equals("search")) {
                String searchPattern = null;
                boolean flag = false;
                for (int i = 0; i < commonName.length(); ++i) {
                    if (commonName.charAt(i) != '*') continue;
                    flag = true;
                }
                searchPattern = !flag ? "*" + commonName + "*" : commonName;
                listener.addSearchParams("All", "contains", searchPattern);
                domainList = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, 1801L);
                for (int j = 0; j < domainList.size(); ++j) {
                    Hashtable<String, String> hash;
                    Properties selectedDomain = (Properties)domainList.get(j);
                    String domainName = selectedDomain.getProperty("DOMAIN_NAME");
                    String defaultNamingContext = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
                    listener.setDomainName(domainName);
                    ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
                    if (ouList == null || ouList.size() == 0) {
                        ouList.add(defaultNamingContext);
                    } else {
                        ouList = DirectoryObjectUtil.getParentOUs(ouList);
                    }
                    try {
                        for (int i = 0; i < ouList.size(); ++i) {
                            ADHandler.searchADObjects((String)domainName, (Long)loginId, (String)((String)ouList.get(i)), (String)searchPattern, (NativeListener)listener);
                        }
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        hash = new Hashtable<String, String>();
                        hash.put("domain", ((Properties)domainList.get(j)).getProperty("DOMAIN_DNS_NAME"));
                        hash.put("error", e.getMessage(rb));
                        errorList.add(hash);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        hash = new Hashtable();
                        hash.put("domain", ((Properties)domainList.get(j)).getProperty("DOMAIN_DNS_NAME"));
                        hash.put("error", e.getMessage());
                        errorList.add(hash);
                    }
                }
                listener.completedAction();
            } else {
                Long searchSidId = Long.valueOf(request.getParameter("searchId"));
                listener.setSearchSidId(searchSidId);
            }
            Integer count = listener.getSearchResultCount();
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "ReportResult", loginId);
            int fromIndex = 1;
            if (request.getParameter("FROM_INDEX") != null) {
                fromIndex = Integer.parseInt(request.getParameter("FROM_INDEX"));
            }
            request.setAttribute("range", (Object)range);
            searchedObjectsList.addAll(listener.getRows("COMMON_NAME", true, fromIndex, range));
            if (!searchedObjectsList.isEmpty()) {
                StringBuffer forwardURLBuffer = null;
                for (int i = 0; i < searchedObjectsList.size(); ++i) {
                    Hashtable properties = (Hashtable)searchedObjectsList.get(i);
                    forwardURLBuffer = null;
                    String objectClassString = (String)properties.get("OBJECT_CLASS");
                    String nameString = (String)properties.get("COMMON_NAME");
                    String objectGuid = (String)properties.get("OBJECT_GUID");
                    String dnString = (String)properties.get("FQDN");
                    String domainName = "";
                    int startIndex = dnString.indexOf(",DC=");
                    for (int j = 0; j < domainList.size(); ++j) {
                        Properties selectedDomain = (Properties)domainList.get(j);
                        String domainNameStr = selectedDomain.getProperty("DOMAIN_NAME");
                        String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainNameStr);
                        if (!defaultNamingContext.equals(dnString.substring(startIndex + 1))) continue;
                        domainName = domainNameStr;
                    }
                    if (objectClassString != null && objectClassString.equals("user")) {
                        forwardURLBuffer = new StringBuffer("selectedTab=home&guid=" + objectGuid + "&domainName=" + domainName + "&selectedObjectTab=properties&reportProperties=objectProperties&objectClass=" + objectClassString);
                        properties.put("queryString", forwardURLBuffer.toString());
                        properties.put("url", "ExecuteForm.do?methodToCall=init&operation=singleModify&templateCategoryId=6&");
                        continue;
                    }
                    forwardURLBuffer = new StringBuffer("bookmark=yes&selectedObjectTab=properties");
                    forwardURLBuffer.append("&objectClass=" + objectClassString + "&objectName=" + URLEncoder.encode(nameString) + "&guid=" + objectGuid + "&nodeClicked=" + URLEncoder.encode(dnString));
                    properties.put("queryString", forwardURLBuffer.toString());
                    properties.put("url", "SecurityExplorer.do?selectedTab=home&methodToCall=explorer");
                }
            }
            request.setAttribute("searchedObjectsList", searchedObjectsList);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("searchedString", (Object)commonName);
            request.setAttribute("errorList", errorList);
            request.setAttribute("searchSidId", (Object)listener.getSearchSidId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("searchados");
    }

    public ActionForward getSIDbyChar(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defaultDomain;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        SearchBean searchBean = (SearchBean)form;
        Properties selectedDomain = null;
        String domainName = "";
        ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1802L);
        if (domainNameList.contains(defaultDomain = DomainUtil.getDefaultDomain())) {
            domainName = defaultDomain;
        } else if (!domainNameList.isEmpty()) {
            domainName = domainNameList.get(0);
        }
        selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
        ArrayList sidListByChar = new ArrayList();
        String charString = request.getParameter("char");
        String searchPattern = charString + "*";
        sidListByChar = CommonUtil.searchSecurityPrincipals((String)searchPattern, (String)domainName, (int)-1, (int)-1, null, (ArrayList)ouList, (Long)loginId);
        searchBean.set("sidListByChar", sidListByChar);
        if (!sidListByChar.isEmpty()) {
            int length = sidListByChar.size();
            request.setAttribute("charSize", (Object)new Integer(length));
        } else {
            request.setAttribute("charSize", (Object)"No");
        }
        request.setAttribute("sidListByChar", (Object)sidListByChar);
        request.setAttribute("startChar", (Object)charString.toUpperCase());
        return mapping.findForward("sid");
    }
}

