/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient;

import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.sym.adsm.security.server.TemplateHandler;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.model.TemplateBean;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateAction
extends DispatchAction {
    private static Long DELEGATE_ROLE_ACTION_ID = 1805L;

    public ActionForward getTemplates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ADMPAuthObject authObject;
        Hashtable domainVsactions;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "template";
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Properties defaultDomainProp = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)(domainVsactions = (authObject = (ADMPAuthObject)request.getSession().getAttribute("ADMP_AUTH_OBJECT")).getDomainActionMap()), (Long)DELEGATE_ROLE_ACTION_ID);
        String domainName = defaultDomainProp.getProperty("DOMAIN_NAME");
        if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1806L).booleanValue()) {
            if (ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1804L).booleanValue()) {
                request.setAttribute("operation", (Object)"new");
                forwardPage = "description";
            } else {
                forwardPage = "applyRole";
            }
        } else {
            if (request.getAttribute("statusCode") != null) {
                Integer status = (Integer)request.getAttribute("statusCode");
                System.out.println("The Status String is " + status);
                int statusCode = status;
                String message = rb.getString(TemplateAction.getErrorCodeString(statusCode));
                request.setAttribute("message", (Object)message);
            }
            try {
                TemplateBean temp = (TemplateBean)form;
                if (temp.get("operation").equals("delete") && request.getParameterValues("template") != null) {
                    Hashtable tempList = TemplateHandler.getTemplateInfo();
                    String[] templates = request.getParameterValues("template");
                    block2: for (int i = 0; i < templates.length; ++i) {
                        for (String tempName : tempList.keySet()) {
                            if (!rb.getString(tempName).equals(templates[i]) && !tempName.equals(templates[i])) continue;
                            TemplateHandler.delete((String)tempName);
                            continue block2;
                        }
                    }
                }
                this.setTemplates(request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapping.findForward(forwardPage);
    }

    public static String getErrorCodeString(int statusCode) {
        String message = "";
        if (statusCode == 0) {
            message = "security.client.template_action.Successfullydelegatedtherole";
        } else if (statusCode == 1) {
            message = "security.client.template_action.SameACEalreadyExists";
        } else if (statusCode == 2) {
            message = "security.client.template_action.SomeUnKnownError";
        } else if (statusCode == 3) {
            message = "security.client.template_action.Someonehasalreadydeletedtherolemanually";
        } else if (statusCode == 4) {
            message = "security.client.template_action.SomeUnKnownACEs";
        }
        return message;
    }

    private void setTemplates(HttpServletRequest request) {
        ArrayList allRoles = SecurityClientUtil.getTemplateDetails(request);
        ArrayList<Hashtable> appliedRoles = new ArrayList<Hashtable>();
        ArrayList<Hashtable> unAppliedRoles = new ArrayList<Hashtable>();
        for (int i = 0; i < allRoles.size(); ++i) {
            Hashtable ht = (Hashtable)allRoles.get(i);
            String templateName = (String)ht.get("TEMPLATE_NAME");
            Long templateId = (Long)ht.get("TEMPLATE_ID");
            boolean objectsList = TemplateHandler.getObjectsAppliedByTemplate((long)templateId);
            if (!objectsList) {
                unAppliedRoles.add(ht);
            } else {
                appliedRoles.add(ht);
            }
            ht.put("APPLIED_ADOBJECTS", objectsList);
        }
        request.setAttribute("allRoles", (Object)allRoles);
        request.setAttribute("appliedRoles", appliedRoles);
        request.setAttribute("unAppliedRoles", unAppliedRoles);
    }

    public ActionForward getPermissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "permissions";
        try {
            TemplateBean temp = (TemplateBean)form;
            temp.getPermissions(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward searchPermissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "permissions";
        try {
            TemplateBean temp = (TemplateBean)form;
            request.getParameter("searchPermission");
            temp.set("searchPermission", request.getParameter("searchPermission"));
            temp.searchPermissions(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward allowDeny(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "ace";
        try {
            TemplateBean temp = (TemplateBean)form;
            temp.allowDeny(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        TemplateBean temp = (TemplateBean)form;
        Hashtable p = TemplateHandler.get((Long)((Long)temp.get("TEMPLATE_ID")), (Long)loginId);
        System.out.println("Final getList : " + p);
        request.setAttribute("aceList", p.get("aceList"));
        request.setAttribute("TEMPLATE_NAME", (Object)((String)p.get("TEMPLATE_NAME")));
        request.setAttribute("TEMPLATE_ID", p.get("TEMPLATE_ID"));
        request.setAttribute("DESCRIPTION", (Object)ClientUtil.htmlEscape((String)p.get("DESCRIPTION")));
        request.setAttribute("MODIFIED_BY", p.get("MODIFIED_BY"));
        Long l = (Long)p.get("MODIFIED_TIME");
        request.setAttribute("MODIFIED_TIME", (Object)DateTimeUtil.formatDate((Long)l, (Long)loginId));
        request.setAttribute("delegationList", p.get("delegationList"));
        request.setAttribute("APPLIED_ADOBJECTS", (Object)TemplateHandler.getObjectsAppliedByTemplate((long)((Long)p.get("TEMPLATE_ID"))));
        return mapping.findForward("view");
    }

    public ActionForward isExist(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        TemplateBean templateBean = (TemplateBean)form;
        templateBean.init(request);
        String message = null;
        String TEMPLATE_NAME = (String)templateBean.get("TEMPLATE_NAME");
        String DESCRIPTION = (String)templateBean.get("DESCRIPTION");
        boolean status = TemplateHandler.isExist((String)TEMPLATE_NAME);
        if (status) {
            message = rb.getString("security.client.template_action.Rolewithsamenamealreadyexists");
            request.setAttribute("message", (Object)message);
            request.setAttribute("operation", (Object)"new");
            return mapping.findForward("description");
        }
        templateBean.set("TEMPLATE_NAME", TEMPLATE_NAME);
        templateBean.set("DESCRIPTION", DESCRIPTION);
        request.setAttribute("operation", (Object)"new");
        request.setAttribute("cardName", (Object)"schemaobjects");
        request.setAttribute("schemaIDGuid", templateBean.get("schemaIDGuid"));
        return mapping.findForward("temp");
    }

    public ActionForward wizard(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        String forwardPage = null;
        String message = null;
        String successMessage = null;
        String cardName = null;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)request.getSession().getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            Properties defaultDomainProp = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
            String domainName = defaultDomainProp.getProperty("DOMAIN_NAME");
            TemplateBean temp = (TemplateBean)form;
            cardName = (String)temp.get("cardName");
            temp.init(request);
            request.setAttribute("operation", temp.get("operation"));
            request.setAttribute("schemaIDGuid", temp.get("schemaIDGuid"));
            if (cardName.equals("introduction")) {
                forwardPage = cardName;
                ArrayList langlabel = new ArrayList();
                ArrayList langValue = new ArrayList();
                Properties prop = ADSMPersUtil.getLanguageList((AdventNetResourceBundle)rb);
                temp.set("Countries", prop.get("label"));
                temp.set("CountriesValue", prop.get("value"));
                Properties language = ADSMPersUtil.getLanguageSettings();
                temp.set("COUNTRY", language.get("language"));
            } else if (cardName.equals("description")) {
                forwardPage = cardName;
                String operation = (String)temp.get("operation");
                if (request.getParameter("back") == null) {
                    ArrayList templates = SecurityClientUtil.getTemplates(loginId);
                    ArrayList nameList = new ArrayList();
                    for (int i = 0; i < templates.size(); ++i) {
                        nameList.add(((Hashtable)templates.get(i)).get("TEMPLATE_NAME"));
                    }
                    boolean isExists = false;
                    String name = null;
                    for (int i = 1; i < 1000; ++i) {
                        isExists = false;
                        name = rb.getString("admp.create_security_role.step_1.my_role").trim();
                        name = name + i;
                        for (int j = 0; j < nameList.size(); ++j) {
                            String tempName = (String)nameList.get(j);
                            if (!name.equalsIgnoreCase(tempName)) continue;
                            isExists = true;
                        }
                        if (!isExists) break;
                    }
                    temp.set("TEMPLATE_NAME", name);
                    temp.set("DESCRIPTION", "");
                }
            } else if (cardName.equals("schemaobjects")) {
                forwardPage = cardName;
                request.setAttribute("TEMPLATE_NAME", (Object)request.getParameter("TEMPLATE_NAME"));
                request.setAttribute("TEMPLATE_ID", (Object)request.getParameter("TEMPLATE_ID"));
            } else if (cardName.equals("summary")) {
                forwardPage = cardName;
                request.setAttribute("TEMPLATE_NAME", temp.get("TEMPLATE_NAME"));
                request.setAttribute("DESCRIPTION", temp.get("DESCRIPTION"));
                request.setAttribute("TEMPLATE_ID", temp.get("TEMPLATE_ID"));
            }
            if (request.getParameter("save") != null) {
                message = temp.saveTemplate(request);
                if (message.equals("NoName")) {
                    message = rb.getString("security.client.template_action.NoNamefortheTemplate");
                    forwardPage = "description";
                } else if (message.equals("Already Exists")) {
                    message = rb.getString("security.client.template_action.Rolewiththesamenamealreadyexists");
                    forwardPage = "description";
                } else {
                    successMessage = message;
                    this.setTemplates(request);
                    forwardPage = "template";
                }
                if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1805L).booleanValue() || !ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1806L).booleanValue()) {
                    if (successMessage != null) {
                        request.setAttribute("successMessage", (Object)successMessage);
                        message = null;
                    }
                    forwardPage = "description";
                }
            } else if (request.getParameter("saveAndDelegate") != null) {
                message = temp.saveTemplate(request);
                if (message.equals("NoName")) {
                    message = rb.getString("security.client.template_action.NoNamefortheTemplate");
                    forwardPage = "description";
                } else if (message.equals("Already Exists")) {
                    message = rb.getString("security.client.template_action.Rolewiththesamenamealreadyexists");
                    forwardPage = "description";
                } else {
                    forwardPage = "applyRole";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String mess = e.getMessage();
            if (mess != null) {
                request.setAttribute("errorMessage", (Object)mess);
            }
            forwardPage = cardName;
        }
        request.setAttribute("cardName", cardName);
        if (message != null) {
            request.setAttribute("message", message);
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward editCommonSchema(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemplateBean templateBean = (TemplateBean)form;
        templateBean.init(request);
        return mapping.findForward("common");
    }

    public ActionForward saveCommonSchema(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        try {
            System.out.println("Saving Common Schemas");
            TemplateBean templateBean = (TemplateBean)form;
            templateBean.init(request);
            ArrayList schemaIDGuidList = (ArrayList)templateBean.get("schemaIDGuidList");
            ArrayList schemaObjects = (ArrayList)templateBean.get("schemaObjects");
            String schemaString = request.getParameter("schemaString");
            System.out.println("schema String : " + schemaString);
            StringTokenizer schemaTokenizer = new StringTokenizer(schemaString, ",");
            ArrayList<Properties> schemaList = new ArrayList<Properties>();
            while (schemaTokenizer.hasMoreTokens()) {
                Properties properties = new Properties();
                String schemaId = schemaTokenizer.nextToken();
                String schemaName = (String)schemaObjects.get(schemaIDGuidList.indexOf(schemaId));
                properties.setProperty("SCHEMAID_GUID", schemaId);
                properties.setProperty("SCHEMA_OBJECT", schemaName);
                schemaList.add(properties);
            }
            System.out.println("SchemaList : " + schemaList);
            SecurityClientUtil.updateCommonSchema(schemaList);
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element saveElement = document.createElement("saved");
            if (saveFlag) {
                saveElement.setAttribute("status", "true");
            } else {
                saveElement.setAttribute("status", "false");
            }
            data.appendChild(saveElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateCommonSchema(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream outNode = null;
        ArrayList list = SecurityClientUtil.getCommonSchemas(request);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (int i = 0; i < list.size(); ++i) {
                Properties prop = (Properties)list.get(i);
                Element schema = document.createElement("schema");
                schema.setAttribute("id", prop.getProperty("SCHEMAID_GUID"));
                schema.setAttribute("name", prop.getProperty("SCHEMA_OBJECT"));
                data.appendChild(schema);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveLocaleSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resMsg = "";
        try {
            TemplateBean templateForm = (TemplateBean)form;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Properties language = ADSMPersUtil.getLanguageSettings();
            String oldLanguageSettings = (String)language.get("language");
            String newLanguageSettings = request.getParameter("newLocale");
            if (!newLanguageSettings.equalsIgnoreCase(oldLanguageSettings)) {
                ADSMPersUtil.changeLanguageSettings((String)newLanguageSettings);
                ArrayList schema = (ArrayList)templateForm.get("schemaObjects");
                templateForm.set("schemaObjects", null);
            }
            resMsg = rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_updated_your_language_settings");
        }
        catch (Exception e) {
            e.printStackTrace();
            resMsg = e.getMessage();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("statusMessage", (Object)resMsg);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }
}

