/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.jreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportBaseClass;
import com.adventnet.sym.adsm.security.webclient.jreport.TemplateDataProvider;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class DelegationDetailsDataProvider
extends ReportBaseClass {
    private Logger logger = Logger.getLogger(TemplateDataProvider.class.getName());
    private TableNavigatorModel tableModel = null;
    private int index = -1;
    public static AdventNetResourceBundle rb;

    public DelegationDetailsDataProvider(HttpServletRequest request) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    @Override
    public Map getReportParams() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("DELEGATION_ID", new Long(0L));
        hm.put("DElEGATION_PATH", "ado");
        hm.put("SECURITY_PRINCIPAL", "sid");
        hm.put("DOMAIN_NAME", "domain");
        hm.put("COL_DELEGATED_AD_OBJECTS", rb.getString("admp.ad_delegation.search_ace.export.col_delegated_AD_objects"));
        hm.put("COL_AD_OBJECT", rb.getString("jsp.view_template.applied_on"));
        hm.put("COL_SECURITY_PRINCIPAL", rb.getString("jsp.view_template.applied_to"));
        return hm;
    }

    public TableNavigatorModel getDefaultTableModel(HttpServletRequest request) throws Exception {
        String templateNameString = null;
        if (request.getAttribute("templateNameString") != null) {
            templateNameString = (String)request.getAttribute("templateNameString");
        } else if (request.getParameter("templateNameString") != null) {
            templateNameString = request.getParameter("templateNameString");
        }
        System.out.println("templateNameString : " + templateNameString);
        Table baseTable = new Table("ADSMTemplates");
        Table delegationJoinTable = new Table("ADSMDelegationDetails");
        SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
        Join delegationJoin = new Join(baseTable, delegationJoinTable, new String[]{"TEMPLATE_ID"}, new String[]{"TEMPLATE_ID"}, 1);
        selectQuery.addJoin(delegationJoin);
        ArrayList<Column> columnList = new ArrayList<Column>();
        Column templateID = new Column("ADSMTemplates", "TEMPLATE_ID");
        Column templateName = new Column("ADSMTemplates", "TEMPLATE_NAME");
        Column delegationID = new Column("ADSMDelegationDetails", "DELEGATION_ID");
        Column delegationPath = new Column("ADSMDelegationDetails", "DELEGATION_PATH");
        Column securityPrincipal = new Column("ADSMDelegationDetails", "SECURITY_PRINCIPAL");
        Column domainName = new Column("ADSMDelegationDetails", "DOMAIN_NAME");
        columnList.add(templateID);
        columnList.add(templateName);
        columnList.add(delegationID);
        columnList.add(delegationPath);
        columnList.add(securityPrincipal);
        columnList.add(domainName);
        selectQuery.addSelectColumns(columnList);
        Criteria criteria = new Criteria(templateName, (Object)templateNameString, 0);
        selectQuery.setCriteria(criteria);
        SortColumn sortColumn = new SortColumn("ADSMDelegationDetails", "DELEGATION_ID", true);
        selectQuery.addSortColumn(sortColumn);
        this.tableModel = SecurityClientUtil.getTableNavigatorModel((SelectQuery)selectQuery);
        this.tableModel.showRange(this.tableModel.getStartIndex(), this.tableModel.getTotalRecordsCount());
        if (this.tableModel.getTotalRecordsCount() > 0L) {
            this.data_available = true;
        } else {
            System.out.println("No Data available");
        }
        return this.tableModel;
    }

    @Override
    public JRDataSource getJRDataSource() {
        return this;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String fieldname = jRField.getName();
        Object value = this.getFieldValue(this.tableModel, fieldname, this.index);
        if (fieldname.equals("DELEGATION_PATH")) {
            String dPath = (String)value;
            if (dPath == null) {
                return " -- ";
            }
            return StrUtil.getNameFromDN((String)dPath);
        }
        if (fieldname.equals("SECURITY_PRINCIPAL")) {
            String sid = (String)value;
            if (sid == null) {
                return "--";
            }
            String domainName = (String)this.getFieldValue(this.tableModel, "DOMAIN_NAME", this.index);
            return CommonUtil.getDisplayName((String)domainName, (String)sid);
        }
        return value;
    }

    public Object getFieldValue(TableNavigatorModel tm, String fieldname, int idx) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            String colname = tm.getColumnName(i);
            if (!colname.equalsIgnoreCase(fieldname)) continue;
            return tm.getValueAt(idx, i);
        }
        return null;
    }

    public TableNavigatorModel getTableModel() {
        return this.tableModel;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.tableModel.getRowCount();
    }

    @Override
    public String getDesignFileName() {
        return "delegationDetailsReport";
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }
}

