/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.jreport;

import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.jreport.ReportDataProvider;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ExportAction;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportBaseClass;
import com.adventnet.sym.adsm.security.webclient.jreport.SearchResultDataProvider;
import com.adventnet.sym.adsm.security.webclient.jreport.TemplateDataProvider;
import com.adventnet.sym.adsm.security.webclient.jreport.TemplateListDataProvider;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.io.FileUtils;

public class ReportExporter {
    String className = ExportAction.class.getName();
    Logger out = Logger.getLogger(this.className);
    private String exportType;
    private String password;
    private String path;
    private String exportFile;
    private String encoding;
    private boolean isPasswordProtected;
    private JRExporter exporter;

    public ReportExporter(String exportType, String password) {
        this.exportType = exportType;
        this.password = password;
        if (this.password != null && !this.password.equals("")) {
            this.isPasswordProtected = true;
        }
    }

    public ReportExporter() {
    }

    public static ReportExporter getInstance() {
        return new ReportExporter();
    }

    public void generateReport(HttpServletRequest request, HttpServletResponse response, HttpSession session, String toolID, String reportType) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        String basepath = request.getSession().getServletContext().getRealPath("/");
        String baseurl = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        ReportDataProvider reportProvider = this.getReportDataProvider(toolID, request, showSerialNo);
        reportProvider.setURLBase(baseurl);
        JRDataSource jrds = reportProvider.getJRDataSource();
        HashMap reportParams = (HashMap)reportProvider.getReportParams();
        reportParams.put("loginId", loginId);
        reportParams.put("locale", request.getLocale());
        reportParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
        String designFileName = reportProvider.getDesignFileName();
        if (designFileName.equalsIgnoreCase("templateReport")) {
            showSerialNo = false;
        }
        try {
            int normalSize = 9;
            String designFilePath = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + designFileName + ".xml";
            JasperDesign jasperDesign = JRXmlLoader.load((String)designFilePath);
            if (reportType.toLowerCase().indexOf("csv") == -1) {
                JRFieldDesignUtil.addLogo(jasperDesign, reportType);
            }
            JRDesignBand columnHeaderBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRFont reportPDFFont = JRFieldDesignUtil.getReportFont(reportType, locale);
            JRDesignReportFont columnFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            if (showSerialNo) {
                String displayName = rb.getString("admp.reports.common.export.Serial_no");
                JRFieldDesignUtil.addFieldToJasper(jasperDesign, columnHeaderBand, detailBand, columnFont, normalFont, 20, 0, 50, 36, 20, displayName, "serialNo", rb, loginId, reportType, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)reportParams, (JRDataSource)jrds);
            if (reportType.toLowerCase().indexOf("pdf") != -1) {
                response.reset();
                this.exportAsPdf(print, toolID, response, locale);
                System.out.println("Export pdf completed successfully");
            } else if (reportType.toLowerCase().indexOf("jpg") != -1) {
                this.exportAsJpeg(print, toolID, response);
            } else if (reportType.toLowerCase().indexOf("html") != -1) {
                this.exportAsHtml(print, toolID, response, request.getSession());
                System.out.println("Export html completed successfully");
            } else if (reportType.toLowerCase().indexOf("xlsx") != -1) {
                this.exportAsXlsx(print, toolID, response);
            } else if (reportType.toLowerCase().indexOf("xls") != -1) {
                this.exportAsXls(print, toolID, response);
            } else if (reportType.toLowerCase().indexOf("csv") != -1) {
                this.exportAsCsv(print, toolID, response, loginId);
            } else {
                this.out.log(Level.INFO, "Unrecognized report format " + reportType);
            }
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                int reportId = 0;
                String actionText = "";
                if (toolID.equals("templateListReport")) {
                    reportId = 1806;
                    actionText = "admp.ad_delegation.view_security_role.export.title";
                } else if (toolID.equals("templateReport")) {
                    reportId = 1806;
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.view_security_role";
                } else if (toolID.equals("searchResultReport")) {
                    reportId = 1802;
                    actionText = "admp.deleg.hdt_deleg.cre_role.action_name.search_permissions";
                }
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.text.ad_management", (String)actionText, (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)(toolID + "." + reportType), (String)reportType.toLowerCase(), (String)"-", (Integer)reportProvider.getRowCount());
            }
        }
        catch (Exception ex) {
            this.out.log(Level.WARNING, "Exception occured while exporting" + ex);
            ex.printStackTrace();
        }
    }

    public int verifyReportStatus(String toolID, HttpServletRequest request) {
        ReportDataProvider reportProvider = this.getReportDataProvider(toolID, request, false);
        if (reportProvider == null) {
            this.out.log(Level.INFO, "Export / Print Feature not supported for toolID :" + toolID);
            return 1;
        }
        if (!reportProvider.isDataAvailable()) {
            this.out.log(Level.INFO, "No Data to Export / Print for toolID :" + toolID);
            return 2;
        }
        return 0;
    }

    private ReportDataProvider getReportDataProvider(String toolID, HttpServletRequest request, boolean showSerialNo) {
        ReportBaseClass reportProvider = null;
        if (toolID.equals("templateListReport")) {
            reportProvider = showSerialNo ? new TemplateListDataProvider(request, showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER) : new TemplateListDataProvider(request);
        } else if (toolID.equals("templateReport")) {
            reportProvider = new TemplateDataProvider(request);
        } else if (toolID.equals("searchResultReport")) {
            reportProvider = showSerialNo ? new SearchResultDataProvider(request, showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER) : new SearchResultDataProvider(request);
        }
        return reportProvider;
    }

    public void exportAsPdf(JasperPrint print, String toolID, Long schedule_id, String dir, Long loginId) throws Exception {
        System.out.println("exportAsPdf File storage Path is " + dir);
        this.exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        Locale locale = I18NUtil.getUserLocale((Long)loginId);
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + this.exportFile));
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        print.setDefaultFont((JRReportFont)font);
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)font.getPdfEncoding());
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        this.exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsPdf(ArrayList printList, String toolID, Long schedule_id, String dir, Long loginId, Locale locale) throws Exception {
        System.out.println("exportAsPdf File storage Path is " + dir);
        this.exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        File file = new File(dir + File.separator + this.exportFile);
        FileOutputStream output = new FileOutputStream(file);
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)font.getPdfEncoding());
        this.exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsInlineHTML(ArrayList printList, String toolID, Long schedule_id, String dir) throws Exception {
        this.exporter = new JRHtmlExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exportAsHTML(this.exporter, toolID, schedule_id, dir);
    }

    public void exportAsHTML(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        this.exporter = new JRHtmlExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportAsHTML(this.exporter, toolID, schedule_id, dir);
    }

    public void exportAsHTML(ArrayList printList, String toolID, Long schedule_id, String dir) throws Exception {
        this.exporter = new JRHtmlExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exportAsHTML(this.exporter, toolID, schedule_id, dir);
    }

    private void exportAsHTML(JRExporter exporter, String toolID, Long schedule_id, String dir) throws Exception {
        this.exportFile = toolID + ".html";
        File file = new File(dir + File.separator + this.exportFile);
        FileOutputStream output = new FileOutputStream(file);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        HashMap imagesMap = new HashMap();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsCSV(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportAsCSV((JRExporter)exporter, toolID, schedule_id, dir, (Long)1L);
    }

    public void exportAsCSV(ArrayList printList, String toolID, Long schedule_id, String dir, Long loginId) throws Exception {
        this.exporter = new JRCsvExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exportAsCSV(this.exporter, toolID, schedule_id, dir, loginId);
    }

    private void exportAsCSV(JRExporter exporter, String toolID, Long schedule_id, String dir, Long loginId) throws Exception {
        this.exportFile = toolID + ".csv";
        File file = new File(dir + File.separator + this.exportFile);
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)",");
        FileOutputStream output = new FileOutputStream(file);
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(200));
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(50));
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        if (I18NUtil.getDefaultCSVCharEncoding((Long)loginId).equalsIgnoreCase("UTF-8")) {
            this.encoding = "utf8";
            this.handleUtfForCSV(output);
        }
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsXLSX(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        this.exportAsXLSX(print, toolID, schedule_id, dir, null);
    }

    public void exportAsXLSX(JasperPrint print, String toolID, Long schedule_id, String dir, HashMap patternMap) throws Exception {
        this.exporter = new JRXlsxExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportAsXLSX(this.exporter, toolID, schedule_id, dir, patternMap);
    }

    public void exportAsXLSX(ArrayList printList, String toolID, Long schedule_id, String dir, HashMap patternMap) throws Exception {
        this.exporter = new JRXlsxExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exportAsXLSX(this.exporter, toolID, schedule_id, dir, patternMap);
    }

    private void exportAsXLSX(JRExporter exporter, String toolID, Long schedule_id, String dir, HashMap patternMap) throws Exception {
        this.exportFile = toolID + ".xlsx";
        File file = new File(dir + File.separator + this.exportFile);
        FileOutputStream output = new FileOutputStream(file);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        if (patternMap != null) {
            exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)patternMap);
        }
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsPdf(JasperPrint print, String toolID, HttpServletResponse response, Locale locale) throws Exception {
        this.exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        this.exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)font.getPdfEncoding());
        print.setDefaultFont((JRReportFont)font);
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        if (this.password.length() > 0) {
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
        }
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=" + this.exportFile);
        ServletOutputStream out = response.getOutputStream();
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
        this.exporter.exportReport();
        out.close();
    }

    public void exportAsPdf(ArrayList print, String toolID, HttpServletResponse response) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        if (this.password.length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.password);
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.password);
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
        }
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=" + this.exportFile);
        ServletOutputStream out = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
        exporter.exportReport();
        out.close();
    }

    public static void exportAsPdf(JasperPrint jrPrint, String fileName) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jrPrint);
        exporter.exportReport();
    }

    public void exportAsJpeg(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        this.exporter = new JRGraphics2DExporter();
        BufferedImage bufferedImage = new BufferedImage(500, 350, 1);
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
        this.exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)"ChassisImg.jpg");
        this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)bufferedImage.createGraphics());
    }

    public void exportAsHtml(JasperPrint print, String toolID, HttpServletResponse response, HttpSession session) throws Exception {
        this.exporter = new JRHtmlExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        this.exportFile = toolID + ".html";
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGES_MAP");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(false));
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(false));
        this.exportReportToWriter(response);
    }

    public void exportAsXlsx(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        this.exportAsXlsx(print, toolID, response, null);
    }

    public void exportAsXlsx(JasperPrint print, String toolID, HttpServletResponse response, HashMap patternMap) throws Exception {
        this.exporter = new JRXlsxExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportFile = toolID + ".xlsx";
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("content-disposition", "inline;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        if (patternMap != null) {
            this.exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)patternMap);
        }
        System.out.println("Export XLS Using JVM Encoding : " + System.getProperty("file.encoding"));
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.exportReport(response);
    }

    public void exportAsCsv(JasperPrint print, String designFileName, HttpServletResponse response, Long loginId) throws Exception {
        this.exporter = new JRCsvExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportFile = designFileName + ".csv";
        response.reset();
        response.setContentType("application/msexcel-comma");
        response.setHeader("content-disposition", "attachment;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)",");
        this.exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, (Object)"\n");
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsCsv: " + I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.exportReport(response);
    }

    private JasperPrint getReport(String bpath, String dFile, Map reportParams, JRDataSource jrds) throws Exception {
        String designFileName = dFile;
        String compileFileName = bpath + "jasper" + File.separator + designFileName + ".jasper";
        JasperPrint print = null;
        print = JasperFillManager.fillReport((String)compileFileName, (Map)reportParams, (JRDataSource)jrds);
        return print;
    }

    public void exportAsHtml(ArrayList print, String toolID, HttpServletResponse response, HttpSession session) throws Exception {
        response.setContentType("text/html");
        this.exporter = new JRHtmlExporter();
        this.exportFile = toolID + ".html";
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGES_MAP");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(false));
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(false));
        this.exportReportToWriter(response);
    }

    public void exportAsCsv(ArrayList print, String designFileName, HttpServletResponse response, Long loginId) throws Exception {
        this.exporter = new JRCsvExporter();
        this.exportFile = designFileName + ".csv";
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsCsv: " + I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        response.reset();
        response.setContentType("application/msexcel-comma");
        response.setHeader("content-disposition", "attachment;filename=" + this.exportFile);
        if (I18NUtil.getDefaultCSVCharEncoding((Long)loginId).equalsIgnoreCase("UTF-8")) {
            this.encoding = "utf8";
            this.exportReport(response);
            ServletOutputStream os = response.getOutputStream();
            ByteArrayOutputStream outputByteArray = new ByteArrayOutputStream();
            os.write(outputByteArray.toByteArray());
            os.flush();
            os.close();
        } else {
            this.exportReport(response);
        }
    }

    public void exportAsXlsx(ArrayList print, String toolID, HttpServletResponse response) throws Exception {
        this.exportAsXlsx(print, toolID, response, null);
    }

    public void exportAsXlsxSheets(ArrayList print, String toolID, HttpServletResponse response, String[] sheetNames) throws Exception {
        JRFieldDesignUtil.removeSplCharsFromSheetNames(sheetNames);
        this.exporter = new JRXlsxExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exportFile = toolID + ".xlsx";
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("content-disposition", "inline;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.SHEET_NAMES, (Object)sheetNames);
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsXlsxSheets: " + System.getProperty("file.encoding"));
        this.exportReport(response);
    }

    public void exportAsXlsx(ArrayList print, String toolID, HttpServletResponse response, HashMap patternMap) throws Exception {
        this.exporter = new JRXlsxExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exportFile = toolID + ".xlsx";
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("content-disposition", "inline;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        if (patternMap != null) {
            this.exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)patternMap);
        }
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsXlsx: " + System.getProperty("file.encoding"));
        this.exportReport(response);
    }

    public void exportAsJpeg(ArrayList print, String toolID, HttpServletResponse response) throws Exception {
        this.exporter = new JRGraphics2DExporter();
        BufferedImage bufferedImage = new BufferedImage(500, 350, 1);
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
        this.exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)"ChassisImg.jpg");
        this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)bufferedImage.createGraphics());
    }

    public void exportAsPdf(ArrayList print, String toolID, HttpServletResponse response, Locale locale) throws Exception {
        this.exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        for (int i = 0; i < print.size(); ++i) {
            JasperPrint printObj = (JasperPrint)print.get(i);
            printObj.setDefaultFont((JRReportFont)font);
        }
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)font.getPdfEncoding());
        this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_LINEBREAK_POLICY, (Object)Boolean.TRUE);
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsPdf: " + font.getPdfEncoding());
        if (this.password.length() > 0) {
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
        }
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=" + this.exportFile);
        ServletOutputStream out = response.getOutputStream();
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
        this.exporter.exportReport();
        out.close();
    }

    public void exportAsHtml(ArrayList printList, String fileName, HttpSession session) throws Exception {
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGES_MAP");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        this.exportAsHtml(printList, fileName, imagesMap);
    }

    public void exportAsHtml(ArrayList printList, String fileName, Map imagesMap) throws Exception {
        JRHtmlExporter exporter = new JRHtmlExporter();
        this.exportFile = fileName;
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        if (imagesMap != null) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, (Object)imagesMap);
        }
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(false));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(false));
        exporter.exportReport();
    }

    public void exportAsExcelForXlsx(ArrayList printList, String fileName, HashMap patternMap) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        this.exportFile = fileName;
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        if (patternMap != null) {
            exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)patternMap);
        }
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        exporter.exportReport();
    }

    public void exportAsCsv(ArrayList printList, String fileName, Long loginId) throws Exception {
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsCsv: " + I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        exporter.exportReport();
    }

    public void exportAsPdf(ArrayList printList, String toolID, Long schedule_id, String dir) throws Exception {
        this.exportFile = toolID + ".pdf";
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + this.exportFile));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_LINEBREAK_POLICY, (Object)Boolean.TRUE);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.exportReport();
        ((OutputStream)output).close();
    }

    public void exportAsHtmlWithHugeData(ArrayList print, String toolID, HttpServletResponse response, HttpSession session, boolean isDownload) throws Exception {
        this.exporter = new JRHtmlExporter();
        this.exportFile = toolID + ".html";
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        if (isDownload) {
            response.reset();
            response.setContentType("application/html");
            response.setHeader("content-disposition", "attachment;filename=" + this.exportFile);
        }
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"/jrimage?image=");
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGES_MAP");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(false));
        this.exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(false));
        if (!isDownload) {
            this.exportReportToWriter(response);
        } else {
            this.exportReport(response);
        }
    }

    public void exportAsCsvWithHugeData(ArrayList print, String designFileName, HttpServletResponse response, Long loginId) throws Exception {
        this.exporter = new JRCsvExporter();
        this.exportFile = designFileName + ".csv";
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        response.reset();
        response.setContentType("application/msexcel-comma");
        response.setHeader("content-disposition", "attachment;filename=" + this.exportFile);
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsCsvWithHugeData: " + I18NUtil.getDefaultCSVCharEncoding((Long)loginId));
        this.exportReport(response);
    }

    public void exportAsXlsWithHugeData(ArrayList print, String toolID, HttpServletResponse response, HashMap patternMap, String reportType) throws Exception {
        if (reportType.toLowerCase().indexOf("xlsx") != -1) {
            this.exportAsXlsx(print, toolID, response, patternMap);
        } else if (reportType.toLowerCase().indexOf("xls") != -1) {
            this.exportAsXls(print, toolID, response);
        }
    }

    public void exportAsPdfWithHugeData(ArrayList print, String toolID, HttpServletResponse response, Locale locale) throws Exception {
        this.exporter = new JRPdfExporter();
        this.exportFile = toolID + ".pdf";
        JRDesignReportFont font = (JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(locale);
        for (int i = 0; i < print.size(); ++i) {
            JasperPrint printObj = (JasperPrint)print.get(i);
            printObj.setDefaultFont((JRReportFont)font);
        }
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)font.getPdfEncoding());
        this.out.log(Level.FINE, "CHARACTER_ENCODING: :exportAsPdfWithHugeData:" + font.getPdfEncoding());
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=" + this.exportFile);
        if (this.password.length() > 0) {
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.password);
            this.exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
        }
        ServletOutputStream out = response.getOutputStream();
        this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
        this.exporter.exportReport();
        out.close();
    }

    public void exportAsXls(JasperPrint print, String toolID, Long schedule_id, String dir) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportAsXls((JRExporter)exporter, toolID, schedule_id, dir);
    }

    public void exportAsXls(ArrayList printList, String toolID, Long schedule_id, String dir) throws Exception {
        this.exporter = new JRXlsExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        this.exportAsXls(this.exporter, toolID, schedule_id, dir);
    }

    private void exportAsXls(JRExporter exporter, String toolID, Long schedule_id, String dir) throws Exception {
        this.exportFile = toolID + ".xls";
        File file = new File(dir + File.separator + this.exportFile);
        FileOutputStream output = new FileOutputStream(file);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsXls(JasperPrint print, String toolID, HttpServletResponse response) throws Exception {
        this.exporter = new JRXlsExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        this.exportFile = toolID + ".xls";
        response.reset();
        response.setContentType("application/xls");
        response.setHeader("content-disposition", "inline;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsXls: " + System.getProperty("file.encoding"));
        this.exportReport(response);
    }

    public void exportAsXls(ArrayList print, String toolID, HttpServletResponse response) throws Exception {
        this.exporter = new JRXlsExporter();
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        this.exportFile = toolID + ".xls";
        response.reset();
        response.setContentType("application/xls");
        response.setHeader("content-disposition", "inline;filename=" + this.exportFile);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        this.exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        this.exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsXls: " + System.getProperty("file.encoding"));
        this.exportReport(response);
    }

    public void exportAsExcel(ArrayList printList, String fileName) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)printList);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
        this.out.log(Level.FINE, "CHARACTER_ENCODING: exportAsExcel:" + System.getProperty("file.encoding"));
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        exporter.exportReport();
    }

    private void exportReport(OutputStream output) throws Exception {
        this.exportReport(null, output);
    }

    private void exportReport(HttpServletResponse response) throws Exception {
        ServletOutputStream output = response.getOutputStream();
        this.exportReport(response, (OutputStream)output);
    }

    private void exportReport(HttpServletResponse response, OutputStream output) throws Exception {
        if (this.isPasswordProtected) {
            this.path = System.getProperty("server.home") + File.separator + "temp" + File.separator + "export" + File.separator + String.valueOf(System.currentTimeMillis());
            File storageDir = new File(this.path);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            File file = new File(this.path + File.separator + this.exportFile);
            output = new FileOutputStream(file);
        }
        if (output != null) {
            this.handleUtfForCSV(output);
            this.exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        }
        this.exporter.exportReport();
        if (output != null) {
            output.flush();
            output.close();
        }
        if (this.isPasswordProtected) {
            this.protectFilesWithPassword(response);
        }
    }

    private void handleUtfForCSV(OutputStream output) throws Exception {
        if (this.exportType != null && this.exportType.toLowerCase().indexOf("csv") != -1 && this.encoding != null && this.encoding.equals("utf8")) {
            byte[] b = new byte[]{-17, -69, -65};
            output.write(b);
        }
    }

    private void exportReportToWriter(HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        if (this.isPasswordProtected) {
            this.path = System.getProperty("server.home") + File.separator + "temp" + File.separator + "export" + File.separator + String.valueOf(System.currentTimeMillis());
            File storageDir = new File(this.path);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            File file = new File(this.path + File.separator + this.exportFile);
            out = new PrintWriter(file);
        }
        this.exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)out);
        this.exporter.exportReport();
        if (out != null) {
            out.flush();
            out.close();
        }
        if (this.isPasswordProtected) {
            this.protectFilesWithPassword(response);
        }
    }

    private void protectFilesWithPassword(HttpServletResponse response) throws Exception {
        String zipPath = this.path + ".zip";
        this.makeZip();
        if (response != null) {
            response.reset();
            this.exportFile = "ADMPReports.zip";
            response.setContentType("application/zip");
            response.setHeader("content-disposition", "attachment;filename=" + this.exportFile);
            Files.copy(Paths.get(zipPath, new String[0]), (OutputStream)response.getOutputStream());
            try {
                FileUtils.forceDelete((File)new File(this.path));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void makeZip() throws Exception {
        ZipFile zipFile = new ZipFile(this.path + ".zip");
        ZipParameters zp = new ZipParameters();
        zp.setCompressionMethod(8);
        zp.setCompressionLevel(5);
        zp.setEncryptFiles(true);
        zp.setEncryptionMethod(99);
        zp.setAesKeyStrength(3);
        zp.setPassword(this.password);
        zipFile.addFile(new File(this.path + File.separator + this.exportFile), zp);
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public String getExportPath() {
        return this.path;
    }
}

