/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.jreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportBaseClass;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class SearchResultDataProvider
extends ReportBaseClass {
    private Logger logger = Logger.getLogger(SearchResultDataProvider.class.getName());
    private TableNavigatorModel tableModel = null;
    private int index = -1;
    public static AdventNetResourceBundle rb;
    private boolean showSerialNo = false;
    private int startingSerialNo = 0;

    public SearchResultDataProvider(HttpServletRequest request) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    public SearchResultDataProvider(HttpServletRequest request, boolean showSerialNo, int startingSerialNo) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            this.showSerialNo = showSerialNo;
            this.startingSerialNo = startingSerialNo;
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    @Override
    public Map getReportParams() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("NAME", "name");
        hm.put("OBJECT_CLASS", "class");
        hm.put("LOCATION", "location");
        hm.put("SEARCH_ID", new Long(0L));
        hm.put("SEARCH_RESULT_ID", new Long(0L));
        hm.put("title", rb.getString("jsp.search_main_page.search_result"));
        hm.put("colName", rb.getString("jsp.search_main_page.name"));
        hm.put("colObjectClass", rb.getString("jsp.search_main_page.object_class"));
        hm.put("colLocation", rb.getString("jsp.search_main_page.location"));
        return hm;
    }

    public TableNavigatorModel getDefaultTableModel(HttpServletRequest request) throws Exception {
        Table baseTable = new Table("ADSMSearchResult");
        SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
        Long searchID = null;
        if (request.getAttribute("searchID") != null) {
            searchID = (Long)request.getAttribute("searchID");
        } else if (request.getParameter("searchID") != null) {
            searchID = new Long(request.getParameter("searchID"));
        }
        String columnName = "NAME";
        String ascending = "true";
        boolean sortType = true;
        if (request.getParameter("columnName") != null) {
            columnName = request.getParameter("columnName");
        }
        if (request.getParameter("ascending") != null) {
            ascending = request.getParameter("ascending");
        }
        sortType = ascending.equals("true");
        SortColumn sortColumn = new SortColumn("ADSMSearchResult", columnName, sortType);
        selectQuery.addSortColumn(sortColumn);
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.add(new Column("ADSMSearchResult", "NAME"));
        columnList.add(new Column("ADSMSearchResult", "OBJECT_CLASS"));
        columnList.add(new Column("ADSMSearchResult", "LOCATION"));
        columnList.add(new Column("ADSMSearchResult", "SEARCH_ID"));
        columnList.add(new Column("ADSMSearchResult", "SEARCH_RESULT_ID"));
        selectQuery.addSelectColumns(columnList);
        Criteria criteria = new Criteria(new Column("ADSMSearchResult", "SEARCH_ID"), (Object)searchID, 0);
        selectQuery.setCriteria(criteria);
        this.tableModel = SecurityClientUtil.getTableNavigatorModel((SelectQuery)selectQuery);
        this.tableModel.showRange(this.tableModel.getStartIndex(), this.tableModel.getTotalRecordsCount());
        if (this.tableModel.getTotalRecordsCount() > 0L) {
            this.data_available = true;
        }
        return this.tableModel;
    }

    @Override
    public JRDataSource getJRDataSource() {
        return this;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String fieldname = jRField.getName();
        Object value = null;
        if (fieldname.equalsIgnoreCase("serialNo") && this.showSerialNo) {
            return this.startingSerialNo + "";
        }
        value = this.getFieldValue(this.tableModel, fieldname, this.index);
        return value;
    }

    public Object getFieldValue(TableNavigatorModel tm, String fieldname, int idx) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            String colname = tm.getColumnName(i);
            if (!colname.equalsIgnoreCase(fieldname)) continue;
            return tm.getValueAt(idx, i);
        }
        return null;
    }

    public TableNavigatorModel getTableModel() {
        return this.tableModel;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.index != 0) {
            ++this.startingSerialNo;
        }
        return this.index < this.tableModel.getRowCount();
    }

    @Override
    public String getDesignFileName() {
        return "searchResultReport";
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }
}

