/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.model;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.DynamicController;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.SearchHandler;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class SearchListener
implements NativeListener,
DynamicController {
    private Long searchId = null;
    private PrintWriter out = null;
    private long sleepMillis = 700L;
    private boolean isCompleted = true;
    private int count = 0;
    AdventNetResourceBundle rb = null;

    public SearchListener(AdventNetResourceBundle resourceBundle) {
        this.rb = resourceBundle;
    }

    public void setWriter(PrintWriter o) {
        this.out = o;
    }

    public Long getSearchId() {
        return this.searchId;
    }

    public void init(HttpServletRequest request) {
    }

    public void addRow(Properties prop) {
        ArrayList list = (ArrayList)prop.get("objectClass");
        String objectClass = (String)list.get(list.size() - 1);
        prop.setProperty("OBJECT_CLASS", objectClass);
        prop.setProperty("NAME", prop.getProperty("name"));
        prop.setProperty("LOCATION", prop.getProperty("FQDN"));
        prop.setProperty("DISTINGUISHED_NAME", prop.getProperty("distinguishedName"));
        SearchHandler.addSearchResult((Long)this.searchId, (Properties)prop);
        this.updateUI(prop);
    }

    public synchronized void searchACE(String sessionId, String domainName, Long loginId, String userName, String adsPath, String sid, ArrayList aceList, ArrayList sidList) {
        if (!this.isCompleted) {
            return;
        }
        this.isCompleted = false;
        try {
            this.count = 0;
            Hashtable<String, Object> prop = new Hashtable<String, Object>();
            prop.put("SESSION_ID", sessionId);
            prop.put("ADS_PATH", adsPath);
            prop.put("SECURITY_PRINCIPAL", sid);
            prop.put("USER_NAME", userName);
            prop.put("STATUS", new Integer(1));
            prop.put("aceList", aceList);
            SearchHandler.add(prop);
            this.searchId = (Long)prop.get("SEARCH_ID");
            Action action = new Action(domainName, loginId, adsPath, sid, aceList, sidList, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopSearch() {
        this.isCompleted = true;
    }

    private void updateUI(Properties prop) {
        ++this.count;
        if (this.out != null) {
            if (this.count <= 25) {
                this.out.write("<script> updateUI('" + ClientUtil.scriptEscape(ClientUtil.htmlEscape(prop.getProperty("NAME"))) + "','" + prop.getProperty("OBJECT_CLASS") + "','" + ClientUtil.scriptEscape(ClientUtil.htmlEscape(prop.getProperty("LOCATION"))) + "')</script>");
                this.out.flush();
            }
            this.out.write("<script> updateCount('" + this.count + "')</script>");
            this.out.flush();
        }
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    private void writeDivTags() {
        this.out.write("<div id=\"ADObjects\"  style=\"display:none\" height=\"700\" >\n");
        this.out.write("<iframe frameborder=\"1\" width=\"100%\" name=\"ADObjects\" src=\"Search.do?methodToCall=getADObjects\"> </iframe>\n");
        this.out.write("</div>\n");
        this.out.write("<div id=\"SIDs\"  style=\"display:none\" height=\"700\" >\n");
        this.out.write("<iframe frameborder=\"1\" width=\"100%\" name=\"SIDs\" src=\"Search.do?methodToCall=getSIDs\"> </iframe>\n");
        this.out.write("</div>\n");
        this.out.write("<div id=\"Permissions\"  style=\"display:none\" height=\"700\" >\n");
        this.out.write("<iframe frameborder=\"1\" width=\"100%\" name=\"Permissions\" src=\"Search.do?methodToCall=getPermissions\"> </iframe>\n");
        this.out.write("</div>\n");
    }

    private void setClientButtons(boolean start) {
        this.out.write("<script> setClientButtons('" + start + "'); </script>");
        this.out.flush();
    }

    @Override
    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        boolean actionSet = false;
        while (!this.isCompleted) {
            try {
                if (!actionSet) {
                    this.setClientButtons(true);
                    actionSet = true;
                }
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.mgmt.security_mgmt.statmsg.error_occurred_message"), e.getMessage()));
            }
        }
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.setClientButtons(false);
                this.out.write("<script>window.location.href='Search.do?methodToCall=search&selectedTab=admin'</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.out = null;
    }

    public void stop(HttpServletRequest request) {
    }

    public void start(Integer id, HttpServletRequest request) {
    }

    private class Action
    extends Thread {
        private String domainName = null;
        private Long loginId = null;
        private String adsPath = null;
        private String sid = null;
        private ArrayList aceList = null;
        private SearchListener listener = null;
        private Properties dnSIDMap = null;

        public Action(String domain, Long loginId, String ads, String s, ArrayList l, ArrayList sids, SearchListener li) {
            int i;
            this.domainName = domain;
            this.loginId = loginId;
            this.adsPath = ads;
            this.sid = s;
            this.aceList = new ArrayList();
            this.listener = li;
            this.dnSIDMap = new Properties();
            for (i = 0; i < sids.size(); ++i) {
                Properties p = (Properties)sids.get(i);
                this.dnSIDMap.setProperty(p.getProperty("DN_STRING"), p.getProperty("SID_STRING"));
            }
            for (i = 0; i < l.size(); ++i) {
                Hashtable h = (Hashtable)l.get(i);
                Properties p = new Properties();
                p.put("ACE_TYPE", h.get("ACE_TYPE"));
                p.put("ACCESS_MASK", h.get("ACCESS_MASK"));
                p.put("INHERIT_TYPE_FLAG", h.get("INHERIT_TYPE_FLAG"));
                if (h.get("PERMISSION_GUID") != null && !h.get("PERMISSION_GUID").equals("null")) {
                    p.put("PERMISSION_GUID", h.get("PERMISSION_GUID"));
                }
                if (h.get("APPLIES_GUID") != null && !h.get("APPLIES_GUID").equals("null")) {
                    p.put("APPLIES_GUID", h.get("APPLIES_GUID"));
                }
                this.aceList.add(p);
            }
        }

        public void test() {
            for (int i = 0; i < 3; ++i) {
                Properties p = new Properties();
                p.setProperty("name", "name" + i);
                ArrayList<String> list = new ArrayList<String>();
                list.add("objectClass" + i);
                p.put("objectClass", list);
                p.setProperty("FQDN", "FQDN" + i);
                SearchListener.this.addRow(p);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ADHandler.searchACE((String)this.domainName, (Long)this.loginId, (String)this.adsPath, (String)this.sid, (ArrayList)this.aceList, (Properties)this.dnSIDMap, (NativeListener)this.listener);
                SearchHandler.update((Long)SearchListener.this.searchId, (int)0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SearchListener.this.isCompleted = true;
            }
        }
    }
}

