/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.adviewer.webclient;

import com.adventnet.sym.adsm.adviewer.server.util.ADViewerUtil;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ADExplorerAction
extends DispatchAction {
    public ActionForward explorer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "explorer";
        Properties selectedDomain = new Properties();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String message = null;
        try {
            String domainName = "";
            String operation = request.getParameter("operation");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            if (operation != null) {
                domainName = request.getParameter("domainName");
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                request.setAttribute("selectedDomain", (Object)domainName);
                if (!operation.equals("change") && operation.equals("connect")) {
                    DomainUtil.setDefaultDomain((String)domainName, (boolean[])new boolean[0]);
                }
            } else {
                String defaultDomain;
                ArrayList<String> domainNameList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.AD_EXPLORER_ACTION_ID);
                if (domainNameList.contains(defaultDomain = DomainUtil.getDefaultDomain())) {
                    domainName = defaultDomain;
                } else if (!domainNameList.isEmpty()) {
                    domainName = domainNameList.get(0);
                }
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                request.setAttribute("selectedDomain", (Object)domainName);
            }
            try {
                this.setDirectoryObject(selectedDomain, request);
            }
            catch (LocalizedException ex) {
                message = ex.getMessage(rb);
                ex.printStackTrace();
            }
            String bookMarks = request.getParameter("bookmark");
            if (bookMarks != null && bookMarks.equals("yes")) {
                request.setAttribute("guid", (Object)request.getParameter("guid"));
                request.setAttribute("objectClass", (Object)request.getParameter("objectClass"));
                request.setAttribute("nodeClicked", (Object)request.getParameter("nodeClicked"));
                request.setAttribute("selectedObjectTab", (Object)request.getParameter("selectedObjectTab"));
                request.setAttribute("objectName", (Object)request.getParameter("objectName"));
                request.setAttribute("bookMarks", (Object)request.getParameter("bookmark"));
                request.setAttribute("bmNode", (Object)request.getParameter("nodeClicked"));
            }
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)6000L);
            request.setAttribute("domainList", (Object)domainList);
        }
        catch (LocalizedException e) {
            message = e.getMessage(rb);
            e.printStackTrace();
        }
        catch (Exception e) {
            message = rb.getString("admp.mgmt.ad_search.ad_objs.statmsg.unable_to_retrieve_objects");
            e.printStackTrace();
        }
        request.setAttribute("errorMessage", (Object)message);
        return mapping.findForward(forwardPage);
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request) throws Exception {
        String domainName = selectedDomain.getProperty("DOMAIN_NAME");
        String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
        request.setAttribute("DOMAIN_NAME", (Object)domainName);
        try {
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList);
            object.setObjectClass("domainDNS");
            if (object != null) {
                DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute("TreeModel", (Object)model);
                request.setAttribute("nodeClicked", (Object)rootPath);
                ArrayList list = object.getChildObjectList();
                if (list.size() > 0) {
                    DirectoryObject childObject = (DirectoryObject)list.get(0);
                    request.setAttribute("guid", (Object)childObject.getGuid());
                    request.setAttribute("objectClass", (Object)childObject.getObjectClass());
                    request.setAttribute("objectName", (Object)childObject.getName());
                }
            }
            session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ActionForward saveBookMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
            Properties bmProp = new Properties();
            String name = request.getParameter("bmname");
            bmProp.setProperty("BOOKMARK_NAME", name);
            String hrefLocation = request.getParameter("bmlink");
            bmProp.setProperty("BOOKMARK_LOCATION", hrefLocation);
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            bmProp.setProperty("BOOKMARK_DOMAIN", domainName);
            ADViewerUtil.saveBookMarks((Properties)bmProp);
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element saveElement = document.createElement("saved");
            if (saveFlag) {
                saveElement.setAttribute("status", "true");
            } else {
                saveElement.setAttribute("status", "false");
            }
            data.appendChild(saveElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

