/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.adviewer.webclient;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ADTreeAction
extends DispatchAction {
    public ActionForward treeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String nodeClicked = request.getParameter("nodeClicked");
        String bookMarks = request.getParameter("bookmark");
        String domainName = request.getParameter("domainName");
        Properties selectedDomain = new Properties();
        selectedDomain = domainName != null ? HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId) : HDTDomainHandler.getSelectedDomain((Long)loginId);
        if (bookMarks != null && bookMarks.equals("yes")) {
            this.setDirectoryObject(selectedDomain, request);
            String domainPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            StringTokenizer domainTokenizer = new StringTokenizer(domainPath, ",");
            int domainTokenCount = domainTokenizer.countTokens();
            StringTokenizer nodeTokenizer = new StringTokenizer(nodeClicked, ",");
            int nodeTokenCount = nodeTokenizer.countTokens();
            int parentsCount = 0;
            if (domainTokenCount != nodeTokenCount) {
                parentsCount = nodeTokenCount - domainTokenCount - 1;
            }
            if (parentsCount > 0) {
                int i;
                String[] parentArray = new String[parentsCount];
                for (i = 0; i < parentsCount; ++i) {
                    parentArray[i] = i == 0 ? nodeClicked.substring(nodeClicked.indexOf(",") + 1, nodeClicked.length()) : parentArray[i - 1].substring(parentArray[i - 1].indexOf(",") + 1, parentArray[i - 1].length());
                }
                for (i = parentsCount; i > 0; --i) {
                    this.setDirectoryObject(selectedDomain, parentArray[i - 1], request, null, false);
                    request.setAttribute("selectedObject", (Object)parentArray[i - 1]);
                }
            }
        }
        if (nodeClicked != null) {
            this.setDirectoryObject(selectedDomain, nodeClicked, request, null, false);
            request.setAttribute("selectedObject", (Object)nodeClicked);
        }
        request.setAttribute("DOMAIN_NAME", (Object)selectedDomain.getProperty("DOMAIN_NAME"));
        return mapping.findForward("tree");
    }

    public ActionForward expandNodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            boolean showContainerOnly = false;
            String domainName = request.getParameter("domainName");
            String modelName = request.getParameter("modelName");
            String showContainerOnlyStr = request.getParameter("showContainersOnly");
            String rootPath = null;
            Properties selectedDomain = null;
            if (domainName == null) {
                selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
                rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            } else {
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            }
            if (showContainerOnlyStr != null && showContainerOnlyStr.equals("true")) {
                showContainerOnly = true;
            }
            if (modelName == null) {
                modelName = "TreeModel";
            }
            String nodeClicked = request.getParameter("nodeClicked");
            ArrayList<String> filter = new ArrayList<String>();
            if (showContainerOnly) {
                filter.add("organizationalUnit");
                filter.add("container");
            }
            this.setDirectoryObject(selectedDomain, nodeClicked, request, filter, showContainerOnly);
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(nodeClicked, request, modelName);
            boolean isWorkflow = false;
            if (request.getParameter("workflow") != null) {
                isWorkflow = Boolean.parseBoolean(request.getParameter("workflow"));
            }
            ByteArrayOutputStream outNode = new ByteArrayOutputStream();
            outNode = isWorkflow ? DirectoryObjectUtil.getADOXMLElement(object, rootPath, showContainerOnly, domainName, loginId) : DirectoryObjectUtil.getADOXMLElement(object, rootPath, showContainerOnly);
            byte[] bs = outNode.toByteArray();
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, ArrayList filter, boolean skipLeafCheck) {
        this.setDirectoryObject(selectedDomain, nodeClicked, request, "TreeModel", filter, skipLeafCheck);
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, String modelName, ArrayList filter, boolean skipLeafCheck) {
        try {
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(modelName);
            DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
            int index = nodeClicked.indexOf(rootPath);
            if (index > 0) {
                DirectoryObjectUtil.getDirectoryObject(object, nodeClicked, selectedDomain, loginId, filter, skipLeafCheck);
                DirectoryObjectTreeModel newModel = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute(modelName, (Object)newModel);
                String bookMarks = request.getParameter("bookmark");
                if (bookMarks != null && bookMarks.equals("yes")) {
                    ArrayList pathToOpen = new ArrayList();
                    pathToOpen = (ArrayList)session.getAttribute("TreeModel_showLines_showRootNode_OPENED-NODES");
                    pathToOpen.add(nodeClicked);
                    session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", (Object)pathToOpen);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request) {
        String domainName = selectedDomain.getProperty("DOMAIN_NAME");
        String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        request.setAttribute("DOMAIN_NAME", (Object)domainName);
        try {
            DirectoryObject object = null;
            object = (DirectoryObject)ADHandler.getDomainObject((String)domainName, (Long)loginId, (String)rootPath);
            object.setObjectClass("domainDNS");
            if (object != null) {
                DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute("TreeModel", (Object)model);
                request.setAttribute("nodeClicked", (Object)rootPath);
                ArrayList list = object.getChildObjectList();
                if (list.size() > 0) {
                    DirectoryObject childObject = (DirectoryObject)list.get(0);
                    request.setAttribute("guid", (Object)childObject.getGuid());
                    request.setAttribute("objectClass", (Object)childObject.getObjectClass());
                    request.setAttribute("objectName", (Object)childObject.getName());
                }
            }
            session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

