/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.sym.adsm.clientapi.mgmt.RestAPIFSMHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.popup.AdvancedFilterObject;
import com.adventnet.sym.adsm.common.server.popup.PopupDataModel;
import com.adventnet.sym.adsm.common.server.popup.PopupManager;
import com.adventnet.sym.adsm.common.server.popup.PopupReqParams;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import com.adventnet.sym.adsm.common.server.popup.PopupSingleton;
import com.adventnet.sym.adsm.common.server.popup.PopupTabObject;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupTableDataModel;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileServerMgmtAPIcall {
    public static final Integer ALL_GROUPS = 1;
    public static final Integer GROUPS_WITH_SAME_PERMISSION = 2;

    public static JSONObject getFSMFolderList(HttpServletRequest request) throws Exception {
        int startIndex = 1;
        int range = 25;
        String domainName = "";
        String searchText = "";
        Integer popupId = 81;
        Integer objectTypeId = 81;
        Integer objViewModelId = 15;
        Integer popupDataModelId = 75;
        String folderPath = null;
        Boolean isRefresh = false;
        JSONObject resultJSON = new JSONObject();
        if (request.getParameter("startIndex") != null) {
            startIndex = Integer.parseInt(request.getParameter("startIndex"));
        }
        if (request.getParameter("range") != null) {
            range = Integer.parseInt(request.getParameter("range"));
        }
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
        }
        if (request.getParameter("searchText") != null) {
            searchText = request.getParameter("searchText");
        }
        if (request.getParameter("folderPath") != null) {
            folderPath = request.getParameter("folderPath");
        }
        if (request.getParameter("refresh") != null) {
            isRefresh = new Boolean(request.getParameter("refresh"));
        }
        ADMPAuthObject authObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        if (!RestAPIFSMHandler.isValidFileServer(folderPath, loginId).booleanValue()) {
            resultJSON.put("FOLDER_COUNT", 0);
            resultJSON.put("FOLDER_LIST", (Object)new JSONArray());
            resultJSON.put("STATUS_MESSAGE", (Object)rb.getString("admp.admin.tp_integ.perm_mgmt.not_have_access_to_the_computer"));
            return resultJSON;
        }
        PopupSelection popupSelection = PopupSingleton.getInstance().getPopupSelection(Long.valueOf(popupId.intValue()), loginId);
        for (PopupTabObject tab : popupSelection.getPopupTabs()) {
            for (AdvancedFilterObject afo : tab.getAfoList()) {
                if (afo.getObjectTypeId() != objectTypeId) continue;
                for (PopupDataModel pdm : afo.getPopupDataModelList()) {
                    if (pdm.getViewModelId() != objViewModelId) continue;
                    popupDataModelId = pdm.getPopupDataModelId().intValue();
                }
            }
        }
        try {
            JSONObject reqParams = new JSONObject();
            reqParams.put("popupId", (Object)popupId);
            reqParams.put("objectTypeId", (Object)objectTypeId);
            reqParams.put("viewModelId", (Object)objViewModelId);
            reqParams.put("popupDataModelId", (Object)popupDataModelId);
            reqParams.put("authObject", (Object)authObject);
            reqParams.put("domainName", (Object)domainName);
            reqParams.put("searchText", (Object)searchText);
            reqParams.put("start", startIndex);
            reqParams.put("end", startIndex + range - 1);
            reqParams.put("range", range);
            reqParams.put("refresh", (Object)isRefresh);
            reqParams.put("exchType", 2003);
            reqParams.put("inputParams", (Object)new JSONObject().put("isWorkFlowMode", true).put("isAPICall", true));
            if (folderPath != null && !folderPath.equals("")) {
                reqParams.put("folderPath", (Object)folderPath);
            }
            PopupReqParams popupReqParams = new PopupReqParams(reqParams);
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            popupReqParams.setRb(rb);
            PopupTableDataModel iDataModel = (PopupTableDataModel)PopupManager.getDataModel((PopupReqParams)popupReqParams);
            resultJSON.put("FOLDER_COUNT", iDataModel.getTotalResultCount());
            JSONArray folderArray = new JSONArray();
            if (iDataModel.getTotalResultCount() > 0) {
                for (int j = 0; j < iDataModel.getTableData().size(); ++j) {
                    JSONObject folderDetails = new JSONObject();
                    folderDetails.put("FOLDER_PATH", (Object)((String)iDataModel.getValueAt(j, 0)));
                    folderDetails.put("FOLDER_TYPE", (Object)((String)iDataModel.getValueAt(j, 2)));
                    folderDetails.put("FOLDER_NAME", (Object)((String)iDataModel.getValueAt(j, 3)));
                    folderArray.put((Object)folderDetails);
                }
            }
            resultJSON.put("FOLDER_LIST", (Object)folderArray);
            resultJSON.put("STATUS_MESSAGE", (Object)"SUCCESS");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return resultJSON;
    }

    public static JSONObject getGroupsWithSamePermission(HttpServletRequest request) throws Exception {
        JSONObject resultJSON = new JSONObject();
        String folderPath = request.getParameter("folderPath");
        String folderType = request.getParameter("folderType");
        Long appliesToVal = 3L;
        Long aceTypeVal = 0L;
        ArrayList<Long> permissionVals = new ArrayList<Long>();
        if (request.getParameter("permissions") != null) {
            JSONArray permissionValJSON = new JSONArray(request.getParameter("permissions"));
            for (int i = 0; i < permissionValJSON.length(); ++i) {
                permissionVals.add(new Long(permissionValJSON.getInt(i)));
            }
        }
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        ArrayList<String> sidList = new ArrayList<String>();
        ArrayList permProps = FileServerMgmtUtil.getFolderPermissions((ADMPAuthObject)authObject, (String)folderPath, (Long)loginId, (AdventNetResourceBundle)rb, (boolean)false, (String)folderType, (Boolean)false, (Boolean)false);
        for (Properties permProp : permProps) {
            String pObjectType = (String)permProp.get("objectType");
            Long pAppilesToVal = (Long)permProp.get("appliesToVal");
            Long pAceTypeVal = (Long)permProp.get("aceTypeVal");
            ArrayList pPermissionVals = (ArrayList)permProp.get("permissionVals");
            Boolean samePermission = pPermissionVals.size() == permissionVals.size();
            if (samePermission.booleanValue()) {
                for (Long permVal : pPermissionVals) {
                    if (permissionVals.contains(permVal)) continue;
                    samePermission = false;
                    break;
                }
            }
            if (pObjectType == null || !pObjectType.equalsIgnoreCase("group") || !pAppilesToVal.equals(appliesToVal) || !pAceTypeVal.equals(aceTypeVal) || !samePermission.booleanValue()) continue;
            String sid = (String)permProp.get("sid");
            sidList.add(sid);
        }
        Hashtable sidProps = UserMgmtUtil.getObjectPropsFromSIDList((ADMPAuthObject)authObject, sidList, (Hashtable)authObject.getDomainOUsMap());
        JSONObject groupList = new JSONObject();
        for (String sid : sidProps.keySet()) {
            groupList.put(sid, (Object)FcJSONUtility.propertiesToJSONObject((Properties)((Properties)sidProps.get(sid))));
        }
        resultJSON.put("GROUP_COUNT", sidProps.size());
        resultJSON.put("GROUP_LIST", (Object)groupList);
        return resultJSON;
    }

    public static JSONArray setFolderPermissions(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        RestAPIFSMHandler fsmHandler = new RestAPIFSMHandler(request);
        fsmHandler.setActionId(1909L);
        if (!fsmHandler.checkAuthorization()) {
            fsmHandler.fillResultFormat();
            jsonArray = fsmHandler.getFormattedResult();
            return jsonArray;
        }
        fsmHandler.commitAPIRequest();
        jsonArray = fsmHandler.getFormattedResult();
        return jsonArray;
    }

    public static JSONArray removeFolderPermissions(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        RestAPIFSMHandler fsmHandler = new RestAPIFSMHandler(request);
        fsmHandler.setActionId(1910L);
        if (!fsmHandler.checkAuthorization()) {
            fsmHandler.fillResultFormat();
            jsonArray = fsmHandler.getFormattedResult();
            return jsonArray;
        }
        fsmHandler.commitAPIRequest();
        jsonArray = fsmHandler.getFormattedResult();
        return jsonArray;
    }
}

