/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcBulkLayoutController;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBUCResultsDataSource;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class MCreateBulkUserCommitListener
extends MobileCommitListener {
    JSONObject currentCSVStatusObj = new JSONObject();
    ADMPAuthObject authObject = null;
    boolean invalidDomain = false;
    Long requestId = 0L;

    public MCreateBulkUserCommitListener(HttpServletRequest request) throws Exception {
        super(request);
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            this.authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Properties domainProp = DomainUtil.getDomainDetails((String)this.domainName);
            if (domainProp.isEmpty()) {
                this.invalidDomain = true;
                return false;
            }
            Hashtable domainVsIds = this.authObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)DelegationUtil.CREATE_USER_ACTION_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        Locale locale = this.request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String userDetailsStr = this.request.getParameter("inputFormat");
            JSONArray userDetails = new JSONArray(userDetailsStr);
            for (int userCounter = 0; userCounter < userDetails.length(); ++userCounter) {
                String reqId;
                JSONObject additionalDataJson;
                boolean checkAuthroziation;
                JSONObject errorDetailsObj;
                JSONObject groupAuthorizationDetails;
                boolean isAllGroupsAuthorized;
                String defaultDomainNamingContext;
                JSONObject OUNameAuthorizationDetails;
                boolean isAllOusAuthorized;
                ArrayList ouList;
                int OUNameHeaderIndex;
                if (this.isLicenseRestricted.booleanValue() && !APIRequestsCountHandler.getInstance().isAllowed(APIRequestsCountHandler.CREATE_USER_API_ID)) {
                    this.setErrorMsg(rb.getString("admp.api.mgmt.api_limit_exceeded"));
                    return;
                }
                Vector<String> headerVector = new Vector<String>();
                Vector<String> valuesVector = new Vector<String>();
                int headerSize = 0;
                ArrayList<Vector> list = new ArrayList<Vector>();
                JSONObject userDataJSON = userDetails.getJSONObject(userCounter);
                Iterator itr = userDataJSON.keys();
                while (itr.hasNext()) {
                    String header = (String)itr.next();
                    String value = (String)userDataJSON.get(header);
                    headerVector.add(header);
                    valuesVector.add(value);
                }
                headerSize = headerVector.size();
                list.add(valuesVector);
                FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
                fcBulkExecuteFormBean.initBean(this.request);
                this.currentCSVStatusObj = fcBulkExecuteFormBean.getCurrentCSVStatusObj();
                Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
                String domainName = fcBulkExecuteFormBean.getDomainName();
                Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
                Long selectedLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
                JSONObject statusObj = FcValidation.validateAPIAttrNames(headerVector, (AdventNetResourceBundle)rb);
                if (!statusObj.getBoolean("status")) {
                    this.setErrorMsg(statusObj.getString("errorMsg"));
                    continue;
                }
                int templateNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "templateName");
                boolean isTemplateNameHeaderAvailable = false;
                if (templateNameHeaderIndex != -1) {
                    String templateName;
                    isTemplateNameHeaderAvailable = true;
                    JSONObject layoutAuthorizationDetails = FcLayoutAuth.validateTemplateNames((int)templateNameHeaderIndex, list, (Long)templateCategoryId, (Long)this.loginId, (String)domainName, (AdventNetResourceBundle)rb);
                    if (layoutAuthorizationDetails.has("inValid") && layoutAuthorizationDetails.getBoolean("inValid")) {
                        templateName = layoutAuthorizationDetails.getString("templateName");
                        String error = MessageFormat.format(rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_valid"), templateName);
                        this.setErrorMsg(error);
                        continue;
                    }
                    if (layoutAuthorizationDetails.has("unAuthorized")) {
                        templateName = layoutAuthorizationDetails.getString("templateName");
                        String error = MessageFormat.format(rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_authorized"), templateName);
                        this.setErrorMsg(error);
                        continue;
                    }
                }
                if ((OUNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "OUName")) != -1 && (ouList = HelpdeskUtil.getOUList((String)domainName, (Long)this.loginId)) != null && ouList.size() != 0 && !(isAllOusAuthorized = (OUNameAuthorizationDetails = FcLayoutAuth.isAuthorizedOUNames((int)OUNameHeaderIndex, list, (ArrayList)ouList, (String)(defaultDomainNamingContext = DomainUtil.getDefaultNamingContext((String)domainName)))).getBoolean("isAllOusAuthorized"))) {
                    String ouName = OUNameAuthorizationDetails.getString("ouName");
                    String error = MessageFormat.format(rb.getString("admp.api.mgmt.fc_layout_error.ou_name_is_not_authorized"), ouName);
                    this.setErrorMsg(error);
                    continue;
                }
                JSONObject statusObject = FcLayoutAuth.convertNameToDN(list, headerVector, (String)domainName, (Long)this.loginId, (Boolean)true);
                if (statusObject == null || statusObject.length() == 0) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(MessageFormat.format(rb.getString("admp.mgmt.csv_import.common.statmsg.value_must_be_specified_in_dn_format_or_samaccountname"), new Object[0]));
                    this.setErrorMsg(msg.toString());
                } else if (statusObject.has("ERROR_KEY")) {
                    StringBuilder msg = new StringBuilder();
                    Object[] params = (Object[])statusObject.get("ERROR_KEY_PARAMS");
                    msg.append(MessageFormat.format(rb.getString(statusObject.getString("ERROR_KEY")), params));
                    this.setErrorMsg(msg.toString());
                }
                int memberOfHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf");
                if (memberOfHeaderIndex != -1 && !(isAllGroupsAuthorized = (groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)memberOfHeaderIndex, list, (Long)this.loginId, (String)domainName, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode())).getBoolean("isAllGroupsAuthorized"))) {
                    String groupName = groupAuthorizationDetails.getString("groupName");
                    String error = MessageFormat.format(rb.getString("admp.api.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName);
                    this.setErrorMsg(error);
                    continue;
                }
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, this.request, dataObj, errorDetailsObj = new JSONObject(), headerVector, list, templateCategoryId, this.loginId, rb, domainName, isTemplateNameHeaderAvailable, templateNameHeaderIndex, selectedLayoutId, checkAuthroziation = true, fcBulkExecuteFormBean.getDPValues());
                if (!status) {
                    StringBuffer finalStatus = new StringBuffer();
                    JSONArray errorDetailsArray = errorDetailsObj.getJSONArray("errorMsg");
                    if (errorDetailsArray != null && errorDetailsArray.length() > 0) {
                        for (int i = 0; i < errorDetailsArray.length(); ++i) {
                            JSONObject errorObject = errorDetailsArray.getJSONObject(i);
                            finalStatus.append((String)errorObject.get("errorMsg"));
                        }
                    }
                    this.setErrorMsg(finalStatus.toString());
                    continue;
                }
                if (FcLayoutViewHandler.isAnyObjectHasValidationError((Long)objectCreationId, (int)-1, (int)-1)) {
                    FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                    RVReqParams reqParams = new RVReqParams();
                    reqParams.setRange(list.size());
                    reqParams.setLoginId(this.loginId);
                    reqParams.setRvId(203);
                    reqParams.setGenerationId(objectCreationId.longValue());
                    bucResultObj.initDataSource(rb, reqParams, null, false, false);
                    ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                    ArrayList columnList = bucResultObj.getColumnList();
                    for (int counter = 0; counter < resultList.size(); ++counter) {
                        HashMap hash = (HashMap)resultList.get(counter);
                        JSONObject resultJson = new JSONObject();
                        for (int index = 0; index < columnList.size(); ++index) {
                            HashMap details = (HashMap)columnList.get(index);
                            Integer visibleId = (Integer)details.get("VISIBLE");
                            if (visibleId != 2) continue;
                            String colName = (String)details.get("DISPLAY_NAME");
                            Integer colId = (Integer)details.get("COLUMN_ID");
                            resultJson.put(colName, (Object)((String)hash.get(colId)));
                        }
                        String msg = (String)hash.get(609);
                        msg = CommonUtil.htmlEscape((String)msg);
                        msg = CommonUtil.htmlEscapeForAuditReport((String)msg);
                        msg = CommonUtil.htmlDeEscape((String)msg);
                        resultJson.put("statusMessage", (Object)msg);
                        String creationStatus = "SEVERE";
                        resultJson.put("status", (Object)creationStatus);
                        this.outputFormat.put((Object)resultJson);
                    }
                    continue;
                }
                fcBulkExecuteFormBean.setStartIndex(1);
                IMgmtListener listener = fcBulkExecuteFormBean.getIMgmtListener();
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)201, 0);
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                FcBulkLayoutController.getInstance().addStatusUpdator(fcBulkExecuteFormBean.getObjectCreationId(), statusUpdater);
                FcIamApps fcIamApps = fcBulkExecuteFormBean.getIamApps();
                String moduleUsed = this.getModule();
                listener.setModuleUsed(moduleUsed);
                String additionalData = this.request.getParameter("additionalData");
                if (additionalData != null && !additionalData.equals("") && (additionalDataJson = new JSONObject(additionalData)).has("reqId") && !(reqId = String.valueOf(additionalDataJson.get("reqId"))).equals("-") && !reqId.equals("")) {
                    this.requestId = Long.valueOf(reqId);
                }
                listener.setRequestId(this.requestId);
                listener.doBulkAction(this.request, (Object)fcBulkExecuteFormBean, (Object)fcIamApps, this.loginId, Boolean.valueOf(true));
                while (!listener.getIsCompleted()) {
                    Thread.sleep(100L);
                }
                FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                RVReqParams reqParams = new RVReqParams();
                reqParams.setRange(list.size());
                reqParams.setLoginId(this.loginId);
                reqParams.setRvId(203);
                reqParams.setGenerationId(objectCreationId.longValue());
                bucResultObj.initDataSource(rb, reqParams, null, false, false);
                ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                ArrayList columnList = bucResultObj.getColumnList();
                for (int counter = 0; counter < resultList.size(); ++counter) {
                    HashMap hash = (HashMap)resultList.get(counter);
                    JSONObject resultJson = new JSONObject();
                    for (int index = 0; index < columnList.size(); ++index) {
                        HashMap details = (HashMap)columnList.get(index);
                        Integer visibleId = (Integer)details.get("VISIBLE");
                        if (visibleId != 2) continue;
                        String colName = (String)details.get("DISPLAY_NAME");
                        Integer colId = (Integer)details.get("COLUMN_ID");
                        resultJson.put(colName, (Object)((String)hash.get(colId)));
                    }
                    String msg = (String)hash.get(604);
                    if (msg.contains(rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                        msg = msg.replace(rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), rb.getString("admp.mgmt.o365.exchange_online_later"));
                    }
                    if (msg.contains(rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"))) {
                        msg = msg.replace(rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"), "");
                    }
                    msg = CommonUtil.htmlEscape((String)msg);
                    msg = CommonUtil.htmlEscapeForAuditReport((String)msg);
                    msg = CommonUtil.htmlDeEscape((String)msg);
                    resultJson.put("statusMessage", (Object)msg);
                    String creationStatus = bucResultObj.getCreationStatus(objectCreationId);
                    if (creationStatus == null) {
                        creationStatus = "SEVERE";
                    } else if (creationStatus.equalsIgnoreCase("NO_AD")) {
                        creationStatus = "SUCCESS";
                    }
                    resultJson.put("status", (Object)creationStatus);
                    this.outputFormat.put((Object)resultJson);
                    if (!this.isLicenseRestricted.booleanValue() || !creationStatus.equalsIgnoreCase("SUCCESS")) continue;
                    APIRequestsCountHandler.getInstance().updateCount(APIRequestsCountHandler.CREATE_USER_API_ID, 1);
                    ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.create_bulk_user_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
                }
            }
        }
        catch (Exception ee) {
            this.setErrorMsg(rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
            ee.printStackTrace();
        }
    }

    public void setErrorMsg(String errorMsg) {
        JSONObject currentCSVStatusObj = new JSONObject();
        try {
            errorMsg = CommonUtil.htmlEscape((String)errorMsg);
            errorMsg = CommonUtil.htmlEscapeForAuditReport((String)errorMsg);
            errorMsg = CommonUtil.htmlDeEscape((String)errorMsg);
            currentCSVStatusObj.put("statusMessage", (Object)errorMsg);
            currentCSVStatusObj.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)currentCSVStatusObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillResultFormat() {
        JSONObject errorJson = new JSONObject();
        try {
            if (this.invalidDomain) {
                errorJson.put("statusMessage", (Object)MessageFormat.format(this.rb.getString("admp.api.domain_settings.domain_not_configured"), this.domainName));
            } else {
                errorJson.put("statusMessage", (Object)"Access Denied");
            }
            errorJson.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)errorJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

