/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class MDeleteCommitListener
extends MobileCommitListener {
    public MDeleteCommitListener(HttpServletRequest request) throws Exception {
        super(request);
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            isAuthorized = this.isComputerObject() ? ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)MgmtActionIdConstants.DELETE_COMPUTERS_ACTIONID) : ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)MgmtActionIdConstants.DELETE_USERS_ACTIONID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        this.reportId = this.isComputerObject() ? Integer.valueOf(ReportsUtil.DELETE_COMPUTER_MGMT_REPORT_ID) : Integer.valueOf(ReportsUtil.DELETE_USER_MGMT_REPORT_ID);
        try {
            ArrayList<Long> auditIdList = new ArrayList<Long>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            int size = this.inputFormat.length();
            String batchName = "ADMP_EXPORT_" + System.currentTimeMillis();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                if (!this.isComputerObject()) {
                    jsonObj.put("batchName", (Object)batchName);
                }
                JSONObject singleResultFormat = this.commit(jsonObj, auditIdList, auditObjectIdList, objectOUList);
                this.outputFormat.put((Object)singleResultFormat);
            }
            if (!auditObjectIdList.isEmpty()) {
                Integer userObjectId = 1;
                Long viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                if (this.isComputerObject()) {
                    userObjectId = 3;
                    viewId = FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID;
                }
                this.triggerNotification(auditIdList, auditObjectIdList, userObjectId, null, this.reportId, viewId, objectOUList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject commit(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singelResultJsonFormat = new JSONObject();
        singelResultJsonFormat = this.isComputerObject() ? this.deleteComputer(jsonObj, auditIdList, auditObjectIdList, objectOUList) : this.deleteUser(jsonObj, auditIdList, auditObjectIdList, objectOUList);
        return singelResultJsonFormat;
    }

    public JSONObject deleteUser(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        String sAMAccountName = "";
        StringBuffer message = new StringBuffer();
        boolean errorOccurred = false;
        JSONObject singleResultJsonFormat = new JSONObject();
        DataObject auditDataObj = null;
        Hashtable<String, Comparable<Long>> audit_info = new Hashtable<String, Comparable<Long>>();
        try {
            String dn;
            String guid;
            String sid;
            String userPrincipalName;
            sAMAccountName = jsonObj.getString("sAMAccountName");
            if (jsonObj.has("userPrincipalName") && jsonObj.has("objectSID") && jsonObj.has("objectGUID") && jsonObj.has("distinguishedName")) {
                userPrincipalName = jsonObj.getString("userPrincipalName");
                sid = jsonObj.getString("objectSID");
                guid = jsonObj.getString("objectGUID");
                dn = jsonObj.getString("distinguishedName");
            } else {
                Properties userProperties = this.getUserDetails(sAMAccountName);
                if (userProperties.size() > 0) {
                    userPrincipalName = (String)userProperties.get("LOGON_NAME");
                    sid = (String)userProperties.get("SID_STRING");
                    guid = (String)userProperties.get("OBJECT_GUID");
                    dn = (String)userProperties.get("DISTINGUISHED_NAME");
                } else {
                    singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.user_mgmt.native.failure.no_such_user_matched"));
                    System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                    return singleResultJsonFormat;
                }
            }
            singleResultJsonFormat.put("objectGUID", (Object)guid);
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            singleResultJsonFormat.put("distinguishedName", (Object)dn);
            if (this.isLicenseRestricted.booleanValue() && !APIRequestsCountHandler.getInstance().isAllowed(APIRequestsCountHandler.DELETE_USER_API_ID)) {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.api_limit_exceeded"));
                System.out.println(" Finished exectuing enableDisable in MDeleteCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                return singleResultJsonFormat;
            }
            Hashtable<String, String> result = new Hashtable<String, String>();
            result.put("OBJECT_GUID", guid);
            result.put("batchName", jsonObj.getString("batchName"));
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)ReportsUtil.DELETE_USER_MGMT_REPORT_ID, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)sAMAccountName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            message = DeleteUtil.deleteUser(this.domainName, this.loginId, dn, guid, result, this.rb);
            guid = "{" + guid + "}";
            singleResultJsonFormat.put("status", (Object)"1");
            singleResultJsonFormat.put("statusMessage", (Object)message);
            auditObjectIdList.add(object_id);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
        }
        catch (LocalizedException le) {
            errorOccurred = true;
            le.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(this.rb));
        }
        catch (Exception e) {
            errorOccurred = true;
            e.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        if (errorOccurred) {
            try {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)message);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try {
            TechAuditAPI.getInstance().auditDeleteUser(this.loginId, this.rb.getString("admp.mgmt.user_mgmt.del_users.mgmtname.delete_users"), sAMAccountName, this.domainName, message.toString(), this.rb);
            audit_info.put("error_msg", message);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.isLicenseRestricted.booleanValue() && singleResultJsonFormat.get("status") == "1") {
                APIRequestsCountHandler.getInstance().updateCount(APIRequestsCountHandler.DELETE_USER_API_ID, 1);
                ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.delete_users_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" Finished exectuing delete in MDeleteCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
        return singleResultJsonFormat;
    }

    public JSONObject deleteComputer(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        String userPrincipalName;
        String sAMAccountName = "";
        StringBuffer message = new StringBuffer();
        boolean errorOccurred = false;
        JSONObject singleResultJsonFormat = new JSONObject();
        DataObject auditDataObj = null;
        Hashtable<String, Comparable<Long>> audit_info = new Hashtable<String, Comparable<Long>>();
        try {
            userPrincipalName = jsonObj.getString("userPrincipalName");
            String sid = jsonObj.getString("objectSID");
            sAMAccountName = jsonObj.getString("sAMAccountName");
            String guid = jsonObj.getString("objectGUID");
            String dn = jsonObj.getString("distinguishedName");
            singleResultJsonFormat.put("objectGUID", (Object)guid);
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            singleResultJsonFormat.put("distinguishedName", (Object)dn);
            Hashtable<String, String> result = new Hashtable<String, String>();
            result.put("OBJECT_GUID", guid);
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)ReportsUtil.DELETE_COMPUTER_MGMT_REPORT_ID, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)userPrincipalName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            DeleteUtil.deleteUser(this.domainName, this.loginId, dn, guid, result, this.rb);
            message = new StringBuffer(this.rb.getString("client.computermanagement.DeleteComputers.successfully_deleted_the_computer"));
            guid = "{" + guid + "}";
            singleResultJsonFormat.put("status", (Object)"1");
            singleResultJsonFormat.put("statusMessage", (Object)message);
            auditObjectIdList.add(object_id);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
        }
        catch (LocalizedException le) {
            errorOccurred = true;
            le.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(this.rb));
        }
        catch (Exception e) {
            errorOccurred = true;
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        if (errorOccurred) {
            try {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)message);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try {
            userPrincipalName = jsonObj.getString("userPrincipalName");
            TechAuditAPI.getInstance().auditDeleteComputer(this.loginId, this.rb.getString("admp.mgmt.comp_mgmt.common.mgmtname.delete_computers"), userPrincipalName, this.domainName, message.toString(), this.rb);
            audit_info.put("error_msg", message);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return singleResultJsonFormat;
    }

    public void fillResultFormat() {
        JSONObject singleResultJsonFormat = null;
        try {
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                singleResultJsonFormat = new JSONObject();
                if (jsonObj.has("sAMAccountName")) {
                    singleResultJsonFormat.put("sAMAccountName", (Object)jsonObj.getString("sAMAccountName"));
                }
                if (jsonObj.has("userPrincipalName")) {
                    singleResultJsonFormat.put("userPrincipalName", (Object)jsonObj.getString("userPrincipalName"));
                }
                if (jsonObj.has("distinguishedName")) {
                    singleResultJsonFormat.put("distinguishedName", (Object)jsonObj.getString("distinguishedName"));
                }
                if (jsonObj.has("objectGUID")) {
                    singleResultJsonFormat.put("objectGUID", (Object)jsonObj.getString("objectGUID"));
                }
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user"));
                this.outputFormat.put((Object)singleResultJsonFormat);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

