/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.ComputerHandler;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.InputHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.reports.UserAccountControl;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportController;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.serverapi.ADObject;
import com.adventnet.sym.adsm.serverapi.AdUser;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MReportAPIcall {
    public static ADObject getUserList(HttpServletRequest request) throws Exception {
        String[] resultColumns = new String[]{"OBJECT_GUID", "SAM_ACCOUNT_NAME", "OU_NAME", "DISPLAY_NAME", "DISTINGUISHED_NAME", "SID_STRING", "LOGON_NAME"};
        String[] searchColumns = new String[]{"DISPLAY_NAME", "FULL_NAME", "SAM_ACCOUNT_NAME"};
        return MReportAPIcall.getUserList(request, resultColumns, searchColumns);
    }

    public static JSONObject searchUsers(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        JSONObject jsonObject = new JSONObject();
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        ArrayList authorizedDomainListDetails = admpAuthObject.getDomainList();
        String[] resultColumns = new String[]{"OBJECT_GUID", "FIRST_NAME", "LAST_NAME", "INITIAL", "DISPLAY_NAME", "STREET_ADDRESS", "CITY", "COUNTRY", "MOBILE", "EMAIL_ADDRESS", "LOGON_NAME", "SAM_ACCOUNT_NAME"};
        String[] searchColumns = new String[]{"DISPLAY_NAME", "FULL_NAME", "SAM_ACCOUNT_NAME"};
        String domainName = request.getParameter("domainName");
        if (!authorizedDomainList.contains(domainName)) {
            boolean notAuthorized = true;
            for (int i = 0; i < authorizedDomainListDetails.size(); ++i) {
                Properties prop = (Properties)authorizedDomainListDetails.get(i);
                String domainFlatName = prop.getProperty("DOMAIN_FLAT_NAME");
                if (!domainFlatName.equalsIgnoreCase(domainName)) continue;
                request.setAttribute("domainName", (Object)prop.getProperty("DOMAIN_NAME"));
                notAuthorized = false;
                break;
            }
            if (notAuthorized) {
                jsonObject.put("status", (Object)"SEVERE");
                jsonObject.put("statusMessage", (Object)MessageFormat.format(rb.getString("admp.api.mgmt.fc_layout_error.domain_is_not_authorized"), domainName));
                jsonObject.put("count", (Object)"0");
                jsonObject.put("UsersList", (Object)new JSONArray());
                return jsonObject;
            }
        }
        ADObject adObject = MReportAPIcall.getUserList(request, resultColumns, searchColumns);
        Integer count = adObject.getCount();
        ArrayList userList = adObject.getUserList();
        try {
            JSONArray userListArray = new JSONArray();
            if (count != 0 && userList != null) {
                for (Properties prop : userList) {
                    JSONObject userTR = new JSONObject();
                    Enumeration<Object> allKeys = prop.keys();
                    while (allKeys.hasMoreElements()) {
                        String columnName = (String)allKeys.nextElement();
                        String columnValue = prop.getProperty(columnName) != null ? prop.getProperty(columnName) : "-";
                        userTR.put(columnName, (Object)prop.getProperty(columnName));
                    }
                    userListArray.put((Object)userTR);
                }
            }
            jsonObject.put("count", (Object)count);
            jsonObject.put("UsersList", (Object)userListArray);
            jsonObject.put("status", (Object)"SUCCESS");
            jsonObject.put("statusMessage", (Object)"");
            ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.search_user_api", METrackerConstantsUtil.OBJECTS_COUNT, new Long(userListArray.length()), loginId, false, false);
        }
        catch (JSONException e) {
            e.printStackTrace();
            jsonObject.put("status", (Object)"SEVERE");
            jsonObject.put("statusMessage", (Object)rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
            jsonObject.put("count", (Object)"0");
            jsonObject.put("UsersList", (Object)new JSONArray());
        }
        return jsonObject;
    }

    private static ADObject getUserList(HttpServletRequest request, String[] resultColumns, String[] searchColumns) throws Exception {
        String sortOrder;
        String startIndexStr;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADObject adObject = new ADObject();
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = DelegationUtil.MODIFY_SINGLE_USER_ACTION_ID;
        adObject.setAuthobject(admpAuthObject);
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(admpAuthObject, actionId);
        adObject.setDomainList(domainList);
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        String domainName = "";
        domainName = request.getAttribute("domainName") != null ? (String)request.getAttribute("domainName") : request.getParameter("domainName");
        if (domainName != null) {
            if (!authorizedDomainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
        } else if (!domainList.isEmpty()) {
            domainName = domainList.get(0);
        }
        adObject.setDomainName(domainName);
        int range = 1000;
        int startIndex = 1;
        String rangeStr = request.getParameter("RANGE");
        if (rangeStr == null) {
            rangeStr = request.getParameter("range");
        }
        if ((startIndexStr = request.getParameter("FROM_INDEX")) == null) {
            startIndexStr = request.getParameter("startIndex");
        }
        range = rangeStr != null ? Integer.parseInt(rangeStr) : 1000;
        adObject.setRange(range);
        startIndex = startIndexStr != null ? Integer.parseInt(startIndexStr) : 1;
        adObject.setStartIndex(startIndex);
        String searchPattern = "";
        if (request.getParameter("char") != null) {
            String s = request.getParameter("char");
            searchPattern = s + "*";
            request.setAttribute("char", (Object)s);
        } else if (request.getParameter("searchText") != null) {
            String searchText = request.getParameter("searchText");
            searchPattern = !searchText.equals("") ? "*" + searchText + "*" : "*";
        }
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        adObject.setAuthorizedOuList(ouList);
        ArrayList userList = new ArrayList();
        try {
            String refresh;
            if (request.getParameter("refresh") != null && (refresh = request.getParameter("refresh")) != null && refresh.equals("true")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"User"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sortColumn = request.getParameter("SORT_COLUMN");
        if (sortColumn == null) {
            sortColumn = request.getParameter("sortColumn");
        }
        if ((sortOrder = request.getParameter("ASCENDING")) == null) {
            sortOrder = request.getParameter("ascending");
        }
        Integer count = 0;
        userList = UserHandler.getUserList((String)domainName, (String)searchPattern, (int)startIndex, (int)range, (ArrayList)ouList, (String[])resultColumns, (String)sortColumn, (String)sortOrder, (String[])searchColumns);
        count = UserHandler.getUserCount((String)domainName, (String)searchPattern, (ArrayList)ouList, null, (String[])searchColumns);
        adObject.setUserList(userList);
        adObject.setCount(count);
        return adObject;
    }

    public static AdUser getUserDetails(HttpServletRequest request) {
        AdUser adUser = new AdUser();
        Logger reportLogger = Logger.getLogger("ReportLogger");
        try {
            String hexValOfImage = "";
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String objectGUID = request.getParameter("objectGUID");
            Boolean imageOnlyNeeded = new Boolean(request.getParameter("imageOnlyNeeded"));
            adUser.setObjectGUID(objectGUID);
            String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, "thumbnailPhoto");
            hexValOfImage = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, "{" + objectGUID + "}");
            if (hexValOfImage == null) {
                String samAccountName = request.getParameter("SamAccountName");
                ModifyPhotoListener.getPhotoFromAD(request, domainName, loginId, "thumbnailPhoto", samAccountName);
                hexValOfImage = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, "{" + objectGUID + "}");
            }
            adUser.setImage(hexValOfImage);
            if (imageOnlyNeeded.booleanValue()) {
                return adUser;
            }
            boolean locked = false;
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("objectGUID");
            attribList.add("distinguishedName");
            attribList.add("member");
            attribList.add("memberOf");
            attribList.add("primaryGroupID");
            attribList.add("managedBy");
            attribList.add("cn");
            attribList.add("name");
            attribList.add("sAMAccountName");
            attribList.add("userPrincipalName");
            attribList.add("lockoutTime");
            attribList.add("userAccountControl");
            attribList.add("pwdLastSet");
            attribList.add("objectSID");
            attribList.add("displayName");
            attribList.add("department");
            attribList.add("employeeID");
            attribList.add("telephoneNumber");
            attribList.add("mail");
            attribList.add("msDS-ResultantPSO");
            Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)objectGUID, attribList);
            ArrayList list = (ArrayList)prop.get("primaryGroupID");
            if (list != null) {
                String pyGrpDN = UserMgmtUtil.getGroupDNfromRID((String)domainName, (String)list.get(0).toString());
                String pyGrp = InputHandler.getCommonName((String)domainName, (String)pyGrpDN);
                if (pyGrp != null) {
                    adUser.setPrimaryGroup(pyGrp);
                } else {
                    adUser.setPrimaryGroup(list.get(0).toString());
                }
            }
            if ((list = (ArrayList)prop.get("sAMAccountName")) != null) {
                String samAccountName = list.get(0).toString();
                adUser.setSamAccountName(samAccountName);
            }
            if ((list = (ArrayList)prop.get("userPrincipalName")) != null) {
                String userPrincipalName = list.get(0).toString();
                adUser.setUserPrincipalName(userPrincipalName);
            }
            if ((list = (ArrayList)prop.get("name")) != null) {
                String name = list.get(0).toString();
                adUser.setFullName(name);
            }
            if ((list = (ArrayList)prop.get("objectSID")) != null) {
                String objectSID = list.get(0).toString();
                adUser.setObjectSID(objectSID);
            }
            if ((list = (ArrayList)prop.get("displayName")) != null) {
                String displayName = list.get(0).toString();
                adUser.setDisplayName(displayName);
            }
            if ((list = (ArrayList)prop.get("department")) != null) {
                String department = list.get(0).toString();
                adUser.setDepartment(department);
            }
            if ((list = (ArrayList)prop.get("memberOf")) != null) {
                adUser.setMemberOf(list);
            }
            if ((list = (ArrayList)prop.get("employeeID")) != null) {
                String employeeID = list.get(0).toString();
                adUser.setEmpId(employeeID);
            }
            if ((list = (ArrayList)prop.get("mail")) != null) {
                String mail = list.get(0).toString();
                adUser.setEmailId(mail);
            }
            if ((list = (ArrayList)prop.get("telephoneNumber")) != null) {
                String telephoneNumber = list.get(0).toString();
                adUser.setTelephoneNo(telephoneNumber);
            }
            locked = UserHandler.getLockoutStatus((String)domainName, (Long)loginId, (Properties)prop);
            adUser.setLockedStatus(Boolean.toString(locked));
            ArrayList uacValues = (ArrayList)prop.get("userAccountControl");
            Integer obj = new Integer((String)uacValues.get(0));
            int val = obj;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String accountStatus = rb.getString(UserAccountControl.getAccountStatus((int)val));
            adUser.setAccountStatus(accountStatus);
            adUser.setAccountStatusKey(UserAccountControl.getAccountStatus((int)val));
            Properties props = PolicyHandler.getPolicies((String)domainName, (Long)1L);
            String maxPwdAge = props.getProperty("maxPwdAge");
            ArrayList pwdValueList = (ArrayList)prop.get("pwdLastSet");
            Long longObj = new Long((String)pwdValueList.get(0));
            String str = "report.user.password_status.active";
            if (longObj != 0L) {
                ArrayList controlValues;
                String days = maxPwdAge;
                long maxPwdAgeTime = 0L;
                if (prop.get("msDS-ResultantPSO") != null) {
                    ArrayList psoList = (ArrayList)prop.get("msDS-ResultantPSO");
                    String resultantPSO = (String)psoList.get(0);
                    String psoProp = PolicyHandler.getPSOProp((String)domainName, (String)resultantPSO, (String)"MAX_PWD_AGE");
                    if (psoProp != null) {
                        long maxPwdAgeDays;
                        maxPwdAgeTime = Long.parseLong(psoProp);
                        if ((maxPwdAgeTime = -1L * maxPwdAgeTime) == Long.MIN_VALUE) {
                            maxPwdAgeDays = 0L;
                            maxPwdAgeTime = 0L;
                        } else {
                            maxPwdAgeDays = (long)((double)maxPwdAgeTime * 1.0E-7 / 86400.0);
                        }
                        days = String.valueOf(maxPwdAgeDays);
                    } else {
                        str = "-";
                    }
                }
                if (((val = (obj = new Integer((String)(controlValues = (ArrayList)prop.get("userAccountControl")).get(0))).intValue()) & 0x10000) == 65536) {
                    str = "report.user.password_status.never_expires";
                } else if (!str.equals("-")) {
                    if (days != null && !days.equals("0") || maxPwdAgeTime != 0L) {
                        long nDays = DateTimeUtil.getNoOfDays((Long)longObj);
                        long daysToExpire = Long.parseLong(days) - nDays;
                        if (daysToExpire < 0L) {
                            str = "report.user.password_status.expired";
                        }
                    } else {
                        str = "report.user.password_status.never_expires";
                    }
                }
            } else {
                str = "admp.reports.common.reportresulttxt.must_change_at_next_logon";
            }
            adUser.setPwdStatusKey(str);
            if (str.equals("-")) {
                adUser.setPwdStatus(str);
            } else {
                adUser.setPwdStatus(rb.getString(str));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return adUser;
    }

    public static ADObject getComputerList(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADObject adObject = new ADObject();
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = DelegationUtil.MODIFY_BULK_COMPUTER_ACTION_ID;
        adObject.setAuthobject(admpAuthObject);
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(admpAuthObject, actionId);
        adObject.setDomainList(domainList);
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        String domainName = "";
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            if (!authorizedDomainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
        } else if (!domainList.isEmpty()) {
            domainName = domainList.get(0);
        }
        adObject.setDomainName(domainName);
        int range = 1000;
        int startIndex = 1;
        String rangeStr = request.getParameter("RANGE");
        String startIndexStr = request.getParameter("FROM_INDEX");
        range = rangeStr != null ? Integer.parseInt(rangeStr) : 1000;
        adObject.setRange(range);
        startIndex = startIndexStr != null ? Integer.parseInt(startIndexStr) : 1;
        adObject.setStartIndex(startIndex);
        String searchPattern = "";
        if (request.getParameter("char") != null) {
            String s = request.getParameter("char");
            searchPattern = s + "*";
            request.setAttribute("char", (Object)s);
        } else if (request.getParameter("searchText") != null) {
            String searchText = request.getParameter("searchText");
            searchPattern = !searchText.equals("") ? "*" + searchText + "*" : "*";
        }
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        adObject.setAuthorizedOuList(ouList);
        ArrayList computerList = new ArrayList();
        try {
            String refresh;
            if (request.getParameter("refresh") != null && (refresh = request.getParameter("refresh")) != null && refresh.equals("true")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"Computer"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sortColumn = request.getParameter("SORT_COLUMN");
        String sortOrder = request.getParameter("ASCENDING");
        Integer count = 0;
        String[] resultColumns = new String[]{"OBJECT_GUID", "SAM_ACCOUNT_NAME", "COMPUTER_NAME", "OU_NAME", "DISTINGUISHED_NAME", "SID_STRING"};
        String[] searchColumns = new String[]{"COMPUTER_NAME"};
        computerList = ComputerHandler.getComputerList((String)domainName, (String)searchPattern, (int)startIndex, (int)range, (ArrayList)ouList, (String[])resultColumns, (String)sortColumn, (String)sortOrder, (String[])searchColumns);
        count = ComputerHandler.getComputerCount((String)domainName, (String)searchPattern, (ArrayList)ouList, null, (String[])searchColumns);
        adObject.setUserList(computerList);
        adObject.setCount(count);
        return adObject;
    }

    public static JSONObject getComputerDetails(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        try {
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String objectGUID = request.getParameter("objectGUID");
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("objectGUID");
            attribList.add("distinguishedName");
            attribList.add("member");
            attribList.add("memberOf");
            attribList.add("primaryGroupID");
            attribList.add("managedBy");
            attribList.add("cn");
            attribList.add("name");
            attribList.add("sAMAccountName");
            attribList.add("userPrincipalName");
            attribList.add("lockoutTime");
            attribList.add("userAccountControl");
            attribList.add("pwdLastSet");
            attribList.add("objectSID");
            attribList.add("displayName");
            attribList.add("dNSHostName");
            attribList.add("operatingSystem");
            attribList.add("operatingSystemVersion");
            attribList.add("location");
            Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)objectGUID, attribList);
            ArrayList list = (ArrayList)prop.get("primaryGroupID");
            if (list != null) {
                String pyGrpDN = UserMgmtUtil.getGroupDNfromRID((String)domainName, (String)list.get(0).toString());
                String pyGrp = InputHandler.getCommonName((String)domainName, (String)pyGrpDN);
                if (pyGrp != null) {
                    jsonObject.put("primaryGroup", (Object)pyGrp);
                } else {
                    jsonObject.put("primaryGroup", (Object)list.get(0).toString());
                }
            }
            if ((list = (ArrayList)prop.get("sAMAccountName")) != null) {
                String samAccountName = list.get(0).toString();
                jsonObject.put("sAMAccountName", (Object)samAccountName);
            }
            if ((list = (ArrayList)prop.get("userPrincipalName")) != null) {
                String userPrincipalName = list.get(0).toString();
                jsonObject.put("userPrincipalName", (Object)userPrincipalName);
            }
            if ((list = (ArrayList)prop.get("name")) != null) {
                String name = list.get(0).toString();
                jsonObject.put("fullName", (Object)name);
            }
            if ((list = (ArrayList)prop.get("displayName")) != null) {
                String displayName = list.get(0).toString();
                jsonObject.put("displayName", (Object)displayName);
            }
            if ((list = (ArrayList)prop.get("dNSHostName")) != null) {
                String dNSHostName = list.get(0).toString();
                jsonObject.put("dNSHostName", (Object)dNSHostName);
            }
            if ((list = (ArrayList)prop.get("memberOf")) != null) {
                JSONArray memberOf = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    memberOf.put(list.get(i));
                }
                jsonObject.put("memberOf", (Object)memberOf);
            }
            if ((list = (ArrayList)prop.get("operatingSystem")) != null) {
                String operatingSystem = list.get(0).toString();
                jsonObject.put("operatingSystem", (Object)operatingSystem);
            }
            if ((list = (ArrayList)prop.get("operatingSystemVersion")) != null) {
                String operatingSystemVersion = list.get(0).toString();
                jsonObject.put("operatingSystemVersion", (Object)operatingSystemVersion);
            }
            if ((list = (ArrayList)prop.get("location")) != null) {
                String location = list.get(0).toString();
                jsonObject.put("location", (Object)location);
            }
            ArrayList uacValues = (ArrayList)prop.get("userAccountControl");
            Integer obj = new Integer((String)uacValues.get(0));
            int val = obj;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String accountStatus = rb.getString(UserAccountControl.getAccountStatus((int)val));
            jsonObject.put("accountStatus", (Object)accountStatus);
            jsonObject.put("accountStatusKey", (Object)UserAccountControl.getAccountStatus((int)val));
            Properties props = PolicyHandler.getPolicies((String)domainName, (Long)1L);
            String maxPwdAge = props.getProperty("maxPwdAge");
            ArrayList pwdValueList = (ArrayList)prop.get("pwdLastSet");
            Long longObj = new Long((String)pwdValueList.get(0));
            String str = "report.user.password_status.active";
            if (longObj != 0L) {
                ArrayList controlValues;
                String days = maxPwdAge;
                long maxPwdAgeTime = 0L;
                if (prop.get("msDS-ResultantPSO") != null) {
                    long maxPwdAgeDays;
                    ArrayList psoList = (ArrayList)prop.get("msDS-ResultantPSO");
                    String resultantPSO = (String)psoList.get(0);
                    maxPwdAgeTime = Long.parseLong(PolicyHandler.getPSOProp((String)domainName, (String)resultantPSO, (String)"MAX_PWD_AGE"));
                    if ((maxPwdAgeTime = -1L * maxPwdAgeTime) == Long.MIN_VALUE) {
                        maxPwdAgeDays = 0L;
                        maxPwdAgeTime = 0L;
                    } else {
                        maxPwdAgeDays = (long)((double)maxPwdAgeTime * 1.0E-7 / 86400.0);
                    }
                    days = String.valueOf(maxPwdAgeDays);
                }
                if (((val = (obj = new Integer((String)(controlValues = (ArrayList)prop.get("userAccountControl")).get(0))).intValue()) & 0x10000) == 65536) {
                    str = "report.user.password_status.never_expires";
                } else if (days != null && !days.equals("0") || maxPwdAgeTime != 0L) {
                    long nDays = DateTimeUtil.getNoOfDays((Long)longObj);
                    long daysToExpire = Long.parseLong(days) - nDays;
                    if (daysToExpire < 0L) {
                        str = "report.user.password_status.expired";
                    }
                } else {
                    str = "report.user.password_status.never_expires";
                }
            } else {
                str = "admp.reports.common.reportresulttxt.must_change_at_next_logon";
            }
            jsonObject.put("pwdStatusKey", (Object)str);
            str = rb.getString(str);
            jsonObject.put("pwdStatus", (Object)str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public static ADObject getGroupList(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADObject adObject = new ADObject();
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        String domainName = "";
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            domainName = DomainUtil.getDefaultNamingContext((String)domainName);
        }
        int range = 1000;
        int startIndex = 1;
        String rangeStr = request.getParameter("RANGE");
        String startIndexStr = request.getParameter("FROM_INDEX");
        range = rangeStr != null ? Integer.parseInt(rangeStr) : 1000;
        adObject.setRange(range);
        startIndex = startIndexStr != null ? Integer.parseInt(startIndexStr) : 1;
        adObject.setStartIndex(startIndex);
        String searchPattern = "";
        if (request.getParameter("char") != null) {
            String s = request.getParameter("char");
            searchPattern = s + "*";
            request.setAttribute("char", (Object)s);
        } else if (request.getParameter("searchText") != null) {
            String searchText = request.getParameter("searchText");
            searchPattern = !searchText.equals("") ? "*" + searchText + "*" : "*";
        }
        ArrayList forestList = HDTDomainHandler.getForestDomains((String)domainName, (Long)loginId);
        adObject.setForestDomains(forestList);
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        ArrayList groupList = new ArrayList();
        Integer count = 0;
        String refresh = "false";
        String isPrimaryGroup = "false";
        String groupType = null;
        String groupScope = null;
        String[] resultColumns = new String[]{"OBJECT_GUID", "GROUP_NAME", "OU_NAME", "SID_STRING", "DISTINGUISHED_NAME", "GROUP_TYPE", "GROUP_SCOPE", "OU_NAME"};
        if (request.getParameter("refresh") != null) {
            refresh = request.getParameter("refresh");
        }
        if (request.getParameter("isPrimaryGroup") != null && (isPrimaryGroup = request.getParameter("isPrimaryGroup")).equals("true")) {
            groupType = "Security";
            groupScope = "Global";
        }
        Criteria ouCrit = null;
        if (ouList != null) {
            for (int i = 0; i < ouList.size(); ++i) {
                String key = (String)ouList.get(i);
                Criteria crite = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)key, 11);
                ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
            }
        }
        ouCrit = ouCrit == null ? new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"IS_DELETED"), (Object)new Integer(1), 0) : ouCrit.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"IS_DELETED"), (Object)new Integer(1), 0));
        count = GroupHandler.getGroupsCount((String)domainName, (String)searchPattern, (String)groupType, (String)groupScope, (Long)loginId, (ArrayList)ouList, (String)refresh, null, (Criteria)ouCrit);
        DataObject dataObj = GroupHandler.getGroups((String)domainName, (String)searchPattern, (String)groupType, (String)groupScope, (int)startIndex, (int)range, (Criteria)ouCrit, (Long)loginId, (ArrayList)ouList);
        if (!dataObj.isEmpty()) {
            groupList = CommonUtil.getList((DataObject)dataObj, (String[])resultColumns, (String)"ADSMGroupGeneralDetails");
        }
        adObject.setCount(count);
        adObject.setGroupList(groupList);
        return adObject;
    }

    public static Long generateReport(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = DelegationUtil.REPORT_TAB_ACTION_ID;
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(admpAuthObject, actionId);
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        String domainName = "";
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            if (!authorizedDomainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
        } else if (!domainList.isEmpty()) {
            domainName = domainList.get(0);
        }
        String dncDomainName = DomainUtil.getDomainDetails((String)domainName).getProperty("DEFAULT_NAMING_CONTEXT");
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
        Row r = obj.getFirstRow("ADSMReports");
        String className = (String)r.get("CLASS_NAME");
        Class<?> classToInvoke = Class.forName(className.trim());
        AbstractListener listener = (AbstractListener)classToInvoke.newInstance();
        listener.init(request.getLocale(), r, loginId);
        Hashtable<String, String> requestParams = new Hashtable<String, String>();
        if (reportId == 1 || reportId == 201 || reportId == 213) {
            Integer noOfDays = Integer.parseInt(request.getParameter("noOfDays"));
            Date currentTime = new Date();
            SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy");
            Calendar c = Calendar.getInstance();
            c.setTime(currentTime);
            c.add(5, noOfDays * -1);
            String startDate = format.format(c.getTime());
            String endDate = format.format(currentTime);
            requestParams.put("START_DATE", startDate);
            requestParams.put("END_DATE", endDate);
            requestParams.put("DATA_LABEL_TEXT", "admp.common.matching_criteria.last_N_days");
        }
        String dynamicHandlerClassName = "com.adventnet.sym.adsm.common.webclient.statusupdater.ReportStatusUpdater";
        StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
        listener.setStatusController(statusUpdater);
        Long generationId = ReportController.getInstance().generateReportForAPI(loginId, admpAuthObject, reportId, dncDomainName, listener, statusUpdater, requestParams);
        return generationId;
    }

    public static JSONObject getReportStatus(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        Long generationId = Long.parseLong(request.getParameter("generationId"));
        JSONObject jsonObject = null;
        JSONObject reqJSONObject = reportId == 201 || reportId == 210 || reportId == 213 || reportId == 203 ? new JSONObject("{\"reportId\":" + reportId + ",\"generationId\":" + generationId + ",\"viewType\":1,\"attributeList\":[3017, 3001, 3015, 3001]}") : new JSONObject("{\"reportId\":" + reportId + ",\"generationId\":" + generationId + ",\"viewType\":1,\"attributeList\":[1145, 1006, 1142, 1009]}");
        StatusUpdater dynamicUpdator = ReportController.getInstance().getStatusUpdater(generationId);
        if (dynamicUpdator == null) {
            jsonObject = new JSONObject();
            jsonObject.put("isCompleted", true);
        } else {
            jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
        }
        return jsonObject;
    }

    public static ADObject getReportObjectList(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADObject adObject = new ADObject();
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = DelegationUtil.REPORT_TAB_ACTION_ID;
        adObject.setAuthobject(admpAuthObject);
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(admpAuthObject, actionId);
        adObject.setDomainList(domainList);
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        String domainName = "";
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            if (!authorizedDomainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
        } else if (!domainList.isEmpty()) {
            domainName = domainList.get(0);
        }
        adObject.setDomainName(domainName);
        int range = 1000;
        int startIndex = 1;
        String rangeStr = request.getParameter("RANGE");
        String startIndexStr = request.getParameter("FROM_INDEX");
        range = rangeStr != null ? Integer.parseInt(rangeStr) : 1000;
        adObject.setRange(range);
        startIndex = startIndexStr != null ? Integer.parseInt(startIndexStr) : 1;
        adObject.setStartIndex(startIndex);
        String searchPattern = "";
        if (request.getParameter("char") != null) {
            String s = request.getParameter("char");
            searchPattern = s + "*";
            request.setAttribute("char", (Object)s);
        } else if (request.getParameter("searchText") != null) {
            String searchText = request.getParameter("searchText");
            searchPattern = !searchText.equals("") ? "*" + searchText + "*" : "*";
        }
        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        adObject.setAuthorizedOuList(ouList);
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        Long generationId = Long.parseLong(request.getParameter("generationId"));
        Integer count = 0;
        ReportController.getInstance().removeGenId(generationId);
        ArrayList mandatoryAttrList = ReportsUtil.getMandatoryAttrList((Integer)reportId);
        ArrayList attrlist = ReportAttributeHandler.getInstance().getViewAttributesList(reportId, loginId);
        for (int i = 0; i < mandatoryAttrList.size(); ++i) {
            if (attrlist.contains(mandatoryAttrList.get(i))) continue;
            attrlist.add(mandatoryAttrList.get(i));
        }
        ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributeProps(attrlist);
        Row r = ReportHandler.getReportDetailsRow((Integer)reportId);
        String resultTableName = (String)r.get("RESULT_TABLE_NAME");
        String reportBaseTableName = (String)r.get("BASE_TABLE_NAME");
        String tableKey = "OBJECT_GUID";
        ArrayList reportObjectList = ReportResultUtil.getRowsForAPI(generationId, resultTableName, reportBaseTableName, attributeList, startIndex, range, searchPattern, tableKey);
        count = ReportResultUtil.getRecordsCountForAPI(generationId, resultTableName, reportBaseTableName, searchPattern, attributeList, tableKey);
        adObject.setUserList(reportObjectList);
        adObject.setCount(count);
        return adObject;
    }
}

