/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class MResetPwdCommitListener
extends MobileCommitListener {
    protected String password = "";
    protected String mustChangePassword = "";

    public MResetPwdCommitListener(HttpServletRequest request) throws Exception {
        super(request);
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            Long actionId = MgmtActionIdConstants.USERS_RESET_PWD_ACTIONID;
            if (this.isComputerObject()) {
                actionId = MgmtActionIdConstants.COMPUTERS_RESET_ACTIONID;
            }
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        if (this.isUserObject()) {
            this.reportId = (int)ReportsUtil.RESET_PASSWORD_USER_MGMT_REPORT_ID;
            this.password = this.request.getParameter("pwd");
            this.mustChangePassword = this.request.getParameter("mustChangePassword");
        } else if (this.isComputerObject()) {
            this.reportId = 2013;
        }
        try {
            ArrayList<Long> auditIdList = new ArrayList<Long>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                JSONObject singleResultFormat = this.commit(jsonObj, auditIdList, auditObjectIdList, objectOUList);
                this.outputFormat.put((Object)singleResultFormat);
            }
            if (!auditObjectIdList.isEmpty()) {
                Integer userObjectId = 1;
                Long viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                if (this.isComputerObject()) {
                    userObjectId = 3;
                    viewId = FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID;
                }
                this.triggerNotification(auditIdList, auditObjectIdList, userObjectId, null, this.reportId, viewId, objectOUList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject commit(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singelResultJsonFormat = new JSONObject();
        singelResultJsonFormat = this.isComputerObject() ? this.resetComputer(jsonObj, auditIdList, auditObjectIdList, objectOUList) : this.resetPwdUser(jsonObj, auditIdList, auditObjectIdList, objectOUList);
        return singelResultJsonFormat;
    }

    public JSONObject resetPwdUser(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        HashMap<String, String> props = new HashMap<String, String>();
        String sAMAccountName = "";
        StringBuffer message = new StringBuffer();
        boolean errorOccurred = false;
        JSONObject singleResultJsonFormat = new JSONObject();
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        DataObject auditDataObj = null;
        boolean resetStatus = false;
        try {
            String hostId;
            String dn;
            String guid;
            String sid;
            String userPrincipalName;
            sAMAccountName = jsonObj.getString("sAMAccountName");
            if (jsonObj.has("userPrincipalName") && jsonObj.has("objectSID") && jsonObj.has("objectGUID") && jsonObj.has("distinguishedName")) {
                userPrincipalName = jsonObj.getString("userPrincipalName");
                sid = jsonObj.getString("objectSID");
                guid = jsonObj.getString("objectGUID");
                dn = jsonObj.getString("distinguishedName");
            } else {
                Properties userProperties = this.getUserDetails(sAMAccountName);
                if (userProperties.size() > 0) {
                    userPrincipalName = (String)userProperties.get("LOGON_NAME");
                    sid = (String)userProperties.get("SID_STRING");
                    guid = (String)userProperties.get("OBJECT_GUID");
                    dn = (String)userProperties.get("DISTINGUISHED_NAME");
                } else {
                    singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.user_mgmt.native.failure.no_such_user_matched"));
                    System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                    return singleResultJsonFormat;
                }
            }
            singleResultJsonFormat.put("objectGUID", (Object)guid);
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            singleResultJsonFormat.put("distinguishedName", (Object)dn);
            if (this.isLicenseRestricted.booleanValue() && !APIRequestsCountHandler.getInstance().isAllowed(APIRequestsCountHandler.RESET_USER_PASSWORD_API_ID)) {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.api_limit_exceeded"));
                System.out.println(" Finished exectuing enableDisable in MResetpwdCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                return singleResultJsonFormat;
            }
            if (jsonObj.has("mustChangePassword") && jsonObj.has("cantChangePassword") && jsonObj.has("passwordNeverExpires")) {
                props.put("mustChangePassword", jsonObj.getString("mustChangePassword"));
                props.put("cantChangePassword", jsonObj.getString("cantChangePassword"));
                props.put("passwordNeverExpires", jsonObj.getString("passwordNeverExpires"));
            }
            hostId = (hostId = this.request.getRemoteHost()) == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)ReportsUtil.RESET_PASSWORD_USER_MGMT_REPORT_ID, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)sAMAccountName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            if (!this.password.equals("")) {
                MgmtUtil.resetPassword(this.domainName, sid, dn, sAMAccountName, this.password, this.request, audit_info, auditDataObj);
            }
            resetStatus = true;
            if (props.size() > 0) {
                MgmtUtil.modifyPasswordAttributes(this.domainName, sid, dn, sAMAccountName, props, this.request, audit_info, auditDataObj);
            } else if (this.mustChangePassword != null) {
                props.put("mustChangePassword", "No");
                if (this.mustChangePassword.equalsIgnoreCase("\"true\"") || this.mustChangePassword.equalsIgnoreCase("true")) {
                    props.put("mustChangePassword", "Yes");
                }
                props.put("cantChangePassword", "--");
                props.put("passwordNeverExpires", "--");
                MgmtUtil.modifyPasswordAttributes(this.domainName, sid, dn, sAMAccountName, props, this.request, audit_info, auditDataObj);
            }
            singleResultJsonFormat.put("status", (Object)"1");
            singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            auditObjectIdList.add(object_id);
            message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            System.out.println(" Pwd reset guid " + guid + " dn " + dn + " domainName " + this.domainName);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
        }
        catch (LocalizedException le) {
            errorOccurred = true;
            le.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(this.rb));
        }
        catch (Exception e) {
            errorOccurred = true;
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        try {
            if (errorOccurred) {
                singleResultJsonFormat.put("status", (Object)"0");
                if (!resetStatus) {
                    singleResultJsonFormat.put("statusMessage", (Object)message);
                } else {
                    message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.success_resetpwd") + "\n" + message);
                    singleResultJsonFormat.put("statusMessage", (Object)message);
                }
            }
            singleResultJsonFormat.put("reset", (Object)"yes");
            audit_info.put("error_msg", message.toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.isLicenseRestricted.booleanValue() && singleResultJsonFormat.get("status") == "1") {
                APIRequestsCountHandler.getInstance().updateCount(APIRequestsCountHandler.RESET_USER_PASSWORD_API_ID, 1);
                ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.reset_user_password_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return singleResultJsonFormat;
    }

    public JSONObject resetComputer(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        HashMap props = new HashMap();
        String sAMAccountName = "";
        StringBuffer message = new StringBuffer();
        boolean errorOccurred = false;
        JSONObject singleResultJsonFormat = new JSONObject();
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        DataObject auditDataObj = null;
        boolean resetStatus = false;
        try {
            String computerName = jsonObj.getString("userPrincipalName");
            String sid = jsonObj.getString("objectSID");
            sAMAccountName = jsonObj.getString("sAMAccountName");
            String guid = jsonObj.getString("objectGUID");
            String dn = jsonObj.getString("distinguishedName");
            singleResultJsonFormat.put("objectGUID", (Object)guid);
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)computerName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            singleResultJsonFormat.put("distinguishedName", (Object)dn);
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)computerName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            this.password = computerName + "$";
            MgmtUtil.resetComputer(this.domainName, sid, dn, computerName, this.password, this.request, audit_info, auditDataObj);
            resetStatus = true;
            singleResultJsonFormat.put("status", (Object)"1");
            singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            auditObjectIdList.add(object_id);
            message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            System.out.println(" Pwd reset guid " + guid + " dn " + dn + " domainName " + this.domainName);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
        }
        catch (LocalizedException le) {
            errorOccurred = true;
            le.printStackTrace();
            message = new StringBuffer(le.getMessage(this.rb));
        }
        catch (Exception e) {
            errorOccurred = true;
            message = new StringBuffer(e.getMessage());
        }
        try {
            if (errorOccurred) {
                singleResultJsonFormat.put("status", (Object)"0");
                if (!resetStatus) {
                    singleResultJsonFormat.put("statusMessage", (Object)message);
                } else {
                    message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.success_resetpwd") + "\n" + message);
                    singleResultJsonFormat.put("statusMessage", (Object)message);
                }
            }
            singleResultJsonFormat.put("reset", (Object)"yes");
            audit_info.put("error_msg", message.toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return singleResultJsonFormat;
    }

    public void fillResultFormat() {
        JSONObject singleResultJsonFormat = null;
        try {
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                singleResultJsonFormat = new JSONObject();
                if (jsonObj.has("sAMAccountName")) {
                    singleResultJsonFormat.put("sAMAccountName", (Object)jsonObj.getString("sAMAccountName"));
                }
                if (jsonObj.has("userPrincipalName")) {
                    singleResultJsonFormat.put("userPrincipalName", (Object)jsonObj.getString("userPrincipalName"));
                }
                if (jsonObj.has("distinguishedName")) {
                    singleResultJsonFormat.put("distinguishedName", (Object)jsonObj.getString("distinguishedName"));
                }
                if (jsonObj.has("objectGUID")) {
                    singleResultJsonFormat.put("objectGUID", (Object)jsonObj.getString("objectGUID"));
                }
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
                this.outputFormat.put((Object)singleResultJsonFormat);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

