/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class MUnlockCommitListener
extends MobileCommitListener {
    public MUnlockCommitListener(HttpServletRequest request) throws Exception {
        super(request);
        this.reportId = (int)ReportsUtil.UNLOCK_USER_USER_MGMT_REPORT_ID;
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, 1015L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        try {
            ArrayList<Long> auditIdList = new ArrayList<Long>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                JSONObject singleResultFormat = this.commit(jsonObj, auditIdList, auditObjectIdList, objectOUList);
                this.outputFormat.put((Object)singleResultFormat);
            }
            if (!auditObjectIdList.isEmpty()) {
                Integer userObjectId = 1;
                Long viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                this.triggerNotification(auditIdList, auditObjectIdList, userObjectId, null, this.reportId, viewId, objectOUList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject commit(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singelResultJsonFormat = new JSONObject();
        singelResultJsonFormat = this.unlockUser(jsonObj, auditIdList, auditObjectIdList, objectOUList);
        return singelResultJsonFormat;
    }

    public JSONObject unlockUser(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        String sAMAccountName = "";
        StringBuffer message = new StringBuffer();
        boolean errorOccurred = false;
        JSONObject singleResultJsonFormat = new JSONObject();
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        DataObject auditDataObj = null;
        try {
            String dn;
            String guid;
            String sid;
            String userPrincipalName;
            sAMAccountName = jsonObj.getString("sAMAccountName");
            if (jsonObj.has("userPrincipalName") && jsonObj.has("objectSID") && jsonObj.has("objectGUID") && jsonObj.has("distinguishedName")) {
                userPrincipalName = jsonObj.getString("userPrincipalName");
                sid = jsonObj.getString("objectSID");
                guid = jsonObj.getString("objectGUID");
                dn = jsonObj.getString("distinguishedName");
            } else {
                Properties userProperties = this.getUserDetails(sAMAccountName);
                if (userProperties.size() > 0) {
                    userPrincipalName = (String)userProperties.get("LOGON_NAME");
                    sid = (String)userProperties.get("SID_STRING");
                    guid = (String)userProperties.get("OBJECT_GUID");
                    dn = (String)userProperties.get("DISTINGUISHED_NAME");
                } else {
                    singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.user_mgmt.native.failure.no_such_user_matched"));
                    System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                    return singleResultJsonFormat;
                }
            }
            singleResultJsonFormat.put("objectGUID", (Object)guid);
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            singleResultJsonFormat.put("distinguishedName", (Object)dn);
            if (this.isLicenseRestricted.booleanValue() && !APIRequestsCountHandler.getInstance().isAllowed(APIRequestsCountHandler.UNLOCK_USER_API_ID)) {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.api_limit_exceeded"));
                System.out.println(" Finished exectuing enableDisable in MUnlockCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                return singleResultJsonFormat;
            }
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)ReportsUtil.UNLOCK_USER_USER_MGMT_REPORT_ID, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)sAMAccountName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            MgmtUtil.unlock(this.domainName, sid, dn, sAMAccountName, "", this.request, audit_info, auditDataObj);
            singleResultJsonFormat.put("status", (Object)"1");
            singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            auditObjectIdList.add(object_id);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
        }
        catch (LocalizedException le) {
            errorOccurred = true;
            le.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(this.rb));
        }
        catch (Exception e) {
            errorOccurred = true;
            e.printStackTrace();
            message = new StringBuffer(this.rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        try {
            if (errorOccurred) {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)message);
            }
            audit_info.put("error_msg", message.toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.isLicenseRestricted.booleanValue() && singleResultJsonFormat.get("status") == "1") {
                APIRequestsCountHandler.getInstance().updateCount(APIRequestsCountHandler.UNLOCK_USER_API_ID, 1);
                ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.unlock_users_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        System.out.println(" Finished exectuing unlock in MUnlockCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
        return singleResultJsonFormat;
    }

    public void fillResultFormat() {
        Object singleResultJsonFormat = null;
        try {
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                if (jsonObj.has("sAMAccountName")) {
                    singleResultJsonFormat.put("sAMAccountName", (Object)jsonObj.getString("sAMAccountName"));
                }
                if (jsonObj.has("userPrincipalName")) {
                    singleResultJsonFormat.put("userPrincipalName", (Object)jsonObj.getString("userPrincipalName"));
                }
                if (jsonObj.has("distinguishedName")) {
                    singleResultJsonFormat.put("distinguishedName", (Object)jsonObj.getString("distinguishedName"));
                }
                if (jsonObj.has("objectGUID")) {
                    singleResultJsonFormat.put("objectGUID", (Object)jsonObj.getString("objectGUID"));
                }
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_unlock_user"));
                this.outputFormat.put(singleResultJsonFormat);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

