/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.sym.adsm.clientapi.mgmt.MCreateBulkUserCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MCreateSingleUserCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MDeleteCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MEnableDisableCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MGetNamingFormatCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MModifyBulkUserCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MResetPwdCommitListener;
import com.adventnet.sym.adsm.clientapi.mgmt.MUnlockCommitListener;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.layout.component.FcOrgAttribute;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.popup.PopupManager;
import com.adventnet.sym.adsm.common.server.popup.PopupReqParams;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupAddRemoveDataModel;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupTableDataModel;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormAction;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MUserMgmtAPIcall {
    public static String resetPwd(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        MResetPwdCommitListener pesetPwdUserListener = new MResetPwdCommitListener(request);
        pesetPwdUserListener.setObjectType("user");
        pesetPwdUserListener.getInputRecords();
        if (!pesetPwdUserListener.checkAuthorization()) {
            pesetPwdUserListener.fillResultFormat();
            jsonArray = pesetPwdUserListener.getFormattedResult();
            return jsonArray.toString();
        }
        pesetPwdUserListener.commitMobileRequest();
        jsonArray = pesetPwdUserListener.getFormattedResult();
        return jsonArray.toString();
    }

    public static String unlockUser(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        MUnlockCommitListener unlockUserListener = new MUnlockCommitListener(request);
        unlockUserListener.setObjectType("user");
        unlockUserListener.getInputRecords();
        if (!unlockUserListener.checkAuthorization()) {
            unlockUserListener.fillResultFormat();
            jsonArray = unlockUserListener.getFormattedResult();
            return jsonArray.toString();
        }
        unlockUserListener.commitMobileRequest();
        jsonArray = unlockUserListener.getFormattedResult();
        return jsonArray.toString();
    }

    public static String deleteUser(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        MDeleteCommitListener deleteUserListener = new MDeleteCommitListener(request);
        deleteUserListener.setObjectType("user");
        deleteUserListener.getInputRecords();
        if (!deleteUserListener.checkAuthorization()) {
            deleteUserListener.fillResultFormat();
            jsonArray = deleteUserListener.getFormattedResult();
            return jsonArray.toString();
        }
        deleteUserListener.commitMobileRequest();
        jsonArray = deleteUserListener.getFormattedResult();
        return jsonArray.toString();
    }

    public static String enableUser(HttpServletRequest request) throws Exception {
        String isEnable = request.getParameter("isEnable");
        if (isEnable == null || "true".equalsIgnoreCase(isEnable)) {
            request.setAttribute("isEnable", (Object)"true");
        } else {
            request.setAttribute("isEnable", (Object)"false");
        }
        return MUserMgmtAPIcall.enableDisableUser(request);
    }

    public static String disableUser(HttpServletRequest request) throws Exception {
        request.setAttribute("isEnable", (Object)"false");
        return MUserMgmtAPIcall.enableDisableUser(request);
    }

    private static String enableDisableUser(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        MEnableDisableCommitListener enableDisable = new MEnableDisableCommitListener(request);
        enableDisable.setObjectType("user");
        enableDisable.getInputRecords();
        if (!enableDisable.checkAuthorization()) {
            enableDisable.fillResultFormat();
            jsonArray = enableDisable.getFormattedResult();
            return jsonArray.toString();
        }
        enableDisable.commitMobileRequest();
        jsonArray = enableDisable.getFormattedResult();
        return jsonArray.toString();
    }

    public static String getLayoutUserTemplates(HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long actionId = DelegationUtil.CREATE_USER_ACTION_ID;
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(admpAuthObject, actionId);
        ArrayList authorizedDomainList = admpAuthObject.getDomainNameList();
        String domainName = "";
        if (request.getParameter("domainName") != null) {
            domainName = request.getParameter("domainName");
            if (!authorizedDomainList.contains(domainName)) {
                domainName = domainList.get(0);
            }
        } else if (!domainList.isEmpty()) {
            domainName = domainList.get(0);
        }
        ArrayList templateList = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId, (String)domainName, (int)-1, (String)"");
        JSONObject jsonTemplateNames = new JSONObject();
        try {
            JSONArray jsonTemplatearr = new JSONArray();
            int size = templateList.size();
            for (int i = 0; i < size; ++i) {
                Properties prop = (Properties)templateList.get(i);
                JSONObject jsontemplate = new JSONObject();
                String layoutName = prop.getProperty("LAYOUT_NAME");
                jsontemplate.put("TEMPLATE_NAME", (Object)layoutName);
                jsontemplate.put("TEMPLATE_DISPLAY_NAME", (Object)rb.getString(layoutName));
                jsontemplate.put("TEMPLATE_ID", prop.get("LAYOUT_ID"));
                jsonTemplatearr.put((Object)jsontemplate);
            }
            jsonTemplateNames.put("TemplateList", (Object)jsonTemplatearr);
            jsonTemplateNames.put("domainName", (Object)domainName);
            jsonTemplateNames.put("admpAuthobject", (Object)admpAuthObject.toJSONStringForMobile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonTemplateNames.toString();
    }

    public static String getTemplateLayout(HttpServletRequest request) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long layoutId = Long.parseLong(request.getParameter("templateId"));
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
        session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
        fcExecuteFormBean.initForExecution(request, layoutId, request.getParameter("domainName"), false);
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        session.setAttribute("ADMP_SESSION_LOGIN_ID", request.getAttribute("ADMP_SESSION_LOGIN_ID"));
        fcExecuteFormBean.getExecuteFormLayout().setSelectedIamApps(fcExecuteFormBean.getIamApps(), null);
        FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
        fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
        iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
        Properties prop = new Properties();
        prop.put("domainName", fcExecuteFormBean.getDomainName());
        prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
        Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
        FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, fcExecuteFormBean.getUserData());
        fcExecuteFormBean.setToClientData(fcFormDataContainer);
        FcLayout fc = fcExecuteFormBean.getExecuteFormLayout();
        JSONArray mailBoxServerDetails = FcLayoutViewHandler.getMailBoxServerDetailsList((String)fcExecuteFormBean.getDomainName());
        JSONObject result = new JSONObject();
        result.put("layoutData", (Object)fc.serializeToJsonString());
        result.put("mailBoxServerDetails", (Object)mailBoxServerDetails);
        return result.toString();
    }

    public static String getNamingFormatValues(HttpServletRequest request) {
        String formattedNameJSONString = "";
        try {
            formattedNameJSONString = FcExecuteFormAction.getFormattedNameJSONString(request);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formattedNameJSONString;
    }

    public static String getOuList(HttpServletRequest request) {
        String output = null;
        AdventNetResourceBundle rb = null;
        try {
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            HttpSession session = request.getSession();
            session.setAttribute("ADMP_SESSION_LOGIN_ID", request.getAttribute("ADMP_SESSION_LOGIN_ID"));
            session.setAttribute("ADMP_AUTH_OBJECT", request.getAttribute("ADMP_AUTH_OBJECT"));
            String nodeClicked = request.getParameter("container");
            rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            String domainName = request.getParameter("domainName");
            Properties selectedDomain = null;
            if (domainName == null) {
                selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            } else {
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            ArrayList ouList = null;
            ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
            if (nodeClicked != null && !ouList.isEmpty()) {
                ouList.add(nodeClicked);
            }
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(selectedDomain.getProperty("DOMAIN_NAME"), loginId, selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT"), ouList);
            DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
            DirectoryObjectTreeNode root = model.rootNode;
            TreeObject treeObj = (TreeObject)root.getUserObject();
            JSONObject obbj = MUserMgmtAPIcall.config(treeObj, false);
            output = obbj.toString();
            request.setAttribute("rootPath", (Object)selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT"));
            session.setAttribute("TreeModel", (Object)model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String expandContainer(HttpServletRequest request) {
        String output = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            int index;
            boolean showContainerOnly = true;
            String domainName = request.getParameter("domainName");
            String nodeClicked = request.getParameter("nodeClicked");
            String modelName = "TreeModel";
            Properties selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(modelName);
            DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
            ArrayList<String> filter = new ArrayList<String>();
            if (showContainerOnly) {
                filter.add("organizationalUnit");
                filter.add("container");
            }
            if ((index = nodeClicked.indexOf(rootPath)) > 0) {
                DirectoryObjectUtil.getDirectoryObject(object, nodeClicked, selectedDomain, loginId, filter, showContainerOnly);
                DirectoryObjectTreeModel newModel = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute(modelName, (Object)newModel);
            }
            object = DirectoryObjectUtil.getDirectoryObject(nodeClicked, request, modelName);
            model = new DirectoryObjectTreeModel((TreeObject)object);
            DirectoryObjectTreeNode root = model.rootNode;
            TreeObject treeObj = (TreeObject)root.getUserObject();
            JSONObject obbj = MUserMgmtAPIcall.config(treeObj, true);
            output = obbj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static JSONObject config(TreeObject treeObj, boolean expandOU) throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("DISPLAY_NAME", (Object)treeObj.getName());
        obj.put("ID", (Object)treeObj.getID());
        JSONArray arrr = new JSONArray();
        for (int g = 0; g < treeObj.getChildObjectList().size(); ++g) {
            String imageIcon = ((TreeObject)treeObj.getChildObjectList().get(g)).getImageIcon();
            if ((imageIcon.equals("images/user_ad.gif") || imageIcon.equals("images/group_ad.gif") || imageIcon.equals("images/computer_ad.gif") || imageIcon.equals("images/contact_ad.gif") || imageIcon.equals("images/publicfolder_ad.gif") || imageIcon.equals("images/sharedfolder.gif")) && !expandOU) continue;
            arrr.put((Object)MUserMgmtAPIcall.config((TreeObject)treeObj.getChildObjectList().get(g), true));
        }
        obj.put("CHILD", (Object)arrr);
        obj.put("IS_LEAF", treeObj.isLeaf());
        return obj;
    }

    public static String getManagerValues(HttpServletRequest request) {
        int start = Integer.parseInt(request.getParameter("FROM_INDEX"));
        int range = Integer.parseInt(request.getParameter("RANGE"));
        String domainName = request.getParameter("domainName") == null ? "" : request.getParameter("domainName");
        String searchText = request.getParameter("searchText") == null ? "" : request.getParameter("searchText");
        StringBuilder paramString = new StringBuilder();
        paramString.append("{\"popupId\":6,\"objectTypeId\":8,\"viewModelId\":11,\"domainName\":\"");
        paramString.append(domainName);
        paramString.append("\",\"popupDataModelId\":11,\"searchText\":\"");
        paramString.append(searchText);
        paramString.append("\",\"start\":");
        paramString.append(start);
        paramString.append(",\"end\":");
        paramString.append(start + range - 1);
        paramString.append(",\"range\":");
        paramString.append(range);
        paramString.append(",\"refresh\":false,\"exchType\":\"undefined\"}");
        Integer objViewModelId = null;
        String output = null;
        try {
            JSONObject json = new JSONObject(paramString.toString());
            PopupReqParams popupReqParams = new PopupReqParams(json);
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            popupReqParams.setRb(ResourceBundleMgr.getInstance().getBundle(request));
            objViewModelId = popupReqParams.getViewModelId();
            PopupTableDataModel iDataModel = (PopupTableDataModel)PopupManager.getDataModel((PopupReqParams)popupReqParams);
            JSONObject result = new JSONObject();
            result.put("MANAGER_COUNT", iDataModel.getTotalResultCount());
            JSONArray arr = new JSONArray();
            for (int j = 0; j < iDataModel.getTableData().size(); ++j) {
                JSONObject obj = new JSONObject();
                obj.put("DISTINGUISHED_NAME", (Object)((String)iDataModel.getValueAt(j, 0)));
                obj.put("DISPLAY_NAME", (Object)((String)iDataModel.getValueAt(j, 2)));
                obj.put("LOCATION", (Object)((String)iDataModel.getValueAt(j, 3)));
                obj.put("OBJECT_CLASS", (Object)((String)iDataModel.getValueAt(j, 4)));
                arr.put((Object)obj);
            }
            result.put("MANAGER_LIST", (Object)arr);
            output = result.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String getGroupValues(HttpServletRequest request) {
        String domainName = request.getParameter("domainName") == null ? "" : request.getParameter("domainName");
        StringBuilder paramString = new StringBuilder();
        paramString.append("{\"popupId\":51,\"objectTypeId\":7,\"viewModelId\":12,\"domainName\":\"");
        paramString.append(domainName);
        paramString.append("\",\"popupDataModelId\":34,\"exchType\":\"undefined\",\"inputParams\":{\"showPrimaryGroup\":\"true\",\"defaultGroupRID\":\"513\"}}");
        Integer objViewModelId = null;
        String output = null;
        try {
            JSONObject json = new JSONObject(paramString.toString());
            PopupReqParams popupReqParams = new PopupReqParams(json);
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            popupReqParams.setLoginId(loginId);
            popupReqParams.setSessionId(session.getId());
            objViewModelId = popupReqParams.getViewModelId();
            PopupAddRemoveDataModel iDataModel = (PopupAddRemoveDataModel)PopupManager.getDataModel((PopupReqParams)popupReqParams);
            JSONArray arr = new JSONArray();
            ArrayList availableList = iDataModel.getAvailableColumnList();
            for (int index = 0; index < availableList.size(); ++index) {
                JSONObject obj = new JSONObject();
                HashMap map = (HashMap)availableList.get(index);
                obj.put("VALUE", (Object)map.get("VALUE").toString());
                obj.put("groupType", map.get("groupType"));
                obj.put("LABEL", map.get("LABEL"));
                arr.put((Object)obj);
            }
            output = arr.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String createUser(HttpServletRequest request) throws Exception {
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        JSONArray jsonArray = new JSONArray();
        MCreateSingleUserCommitListener createUser = new MCreateSingleUserCommitListener(request);
        HttpSession session = request.getSession();
        ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
        session.setAttribute("ADMP_AUTH_OBJECT", (Object)admpAuthObject);
        if (!createUser.checkAuthorization()) {
            createUser.fillResultFormat();
            jsonArray = createUser.getFormattedResult();
            return jsonArray.toString();
        }
        createUser.commitMobileRequest();
        jsonArray = createUser.getFormattedResult();
        return jsonArray.toString();
    }

    public static String createBulkUser(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        MCreateBulkUserCommitListener createUser = new MCreateBulkUserCommitListener(request);
        if (!createUser.checkAuthorization()) {
            createUser.fillResultFormat();
            jsonArray = createUser.getFormattedResult();
            return jsonArray.toString();
        }
        createUser.commitMobileRequest();
        jsonArray = createUser.getFormattedResult();
        return jsonArray.toString();
    }

    public static String modifyBulkUser(HttpServletRequest request) throws Exception {
        JSONArray jsonArray = new JSONArray();
        try {
            MModifyBulkUserCommitListener modifyUser = new MModifyBulkUserCommitListener(request);
            if (!modifyUser.checkAuthorization()) {
                modifyUser.fillResultFormat();
                jsonArray = modifyUser.getFormattedResult();
                return jsonArray.toString();
            }
            modifyUser.commitMobileRequest();
            jsonArray = modifyUser.getFormattedResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray.toString();
    }

    public static String getNamingFormat(HttpServletRequest request) throws Exception {
        MGetNamingFormatCommitListener nfListener = new MGetNamingFormatCommitListener(request);
        String resultStr = nfListener.commitMobileRequest(request);
        return resultStr;
    }

    public static JSONObject getDepartmentList() {
        JSONObject deptList = new JSONObject();
        JSONArray deptArr = new JSONArray();
        FcOrgAttribute fcOrgAttribute = new FcOrgAttribute();
        try {
            Locale locale = I18NUtil.getDefultLocale();
            AdventNetResourceBundle rb = new AdventNetResourceBundle(locale);
            ArrayList fcOptionList = fcOrgAttribute.getOrgAttributes("DEPT", rb, null);
            for (FcOption fcOption : fcOptionList) {
                JSONObject fcOptJson = fcOption.serializeToJSONObject();
                deptArr.put((Object)fcOptJson);
            }
            deptList.put("departments", (Object)deptArr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deptList;
    }
}

