/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.RestAPIAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcBulkLayoutController;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.layout.FcBUCResultsDataSource;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestAPICreateUserHandler {
    JSONObject currentCSVStatusObj = new JSONObject();
    ADMPAuthObject authObject = null;
    boolean invalidDomain = false;
    boolean isLicenseRestricted = true;
    JSONArray currentStatus = new JSONArray();
    JSONArray outputFormat = null;
    AdventNetResourceBundle rb = null;
    String domainName = "";
    Long loginId = null;

    public RestAPICreateUserHandler(String domainName, Long loginId, AdventNetResourceBundle rb) throws Exception {
        this.domainName = domainName;
        this.loginId = loginId;
        this.rb = rb;
        this.authObject = new RestAPIAuthObject(loginId);
        this.outputFormat = new JSONArray();
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            Properties domainProp = DomainUtil.getDomainDetails((String)this.domainName);
            if (domainProp.isEmpty()) {
                this.invalidDomain = true;
                return false;
            }
            Hashtable domainVsIds = this.authObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)DelegationUtil.CREATE_USER_ACTION_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAPIRequest(JSONArray userDetails) {
        try {
            for (int userCounter = 0; userCounter < userDetails.length(); ++userCounter) {
                JSONObject userDataJSON = userDetails.getJSONObject(userCounter);
                JSONObject resultJson = this.processSingleUser(userDataJSON);
                if (resultJson == null) {
                    resultJson = new JSONObject();
                    resultJson.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
                    resultJson.put("status", (Object)"SEVERE");
                }
                this.outputFormat.put((Object)resultJson);
                if (userCounter >= 26) continue;
                RestAPICreateUserHandler restAPICreateUserHandler = this;
                synchronized (restAPICreateUserHandler) {
                    this.currentStatus.put((Object)resultJson);
                    continue;
                }
            }
        }
        catch (Exception ee) {
            this.setErrorMsg(this.rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
            ee.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAPIRequest(GenericData userData) {
        try {
            ArrayList<GenericData.GenericDataRecord> records = userData.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                GenericData.GenericDataRecord record = records.get(i);
                JSONObject userDataJSON = record.toJSONObject();
                userDataJSON.put("templateName", (Object)userData.getTemplateName());
                JSONObject resultJson = this.processSingleUser(userDataJSON);
                if (resultJson == null) {
                    resultJson = new JSONObject();
                    resultJson.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
                    resultJson.put("status", (Object)"SEVERE");
                }
                this.outputFormat.put((Object)resultJson);
                if (i < 26) {
                    RestAPICreateUserHandler restAPICreateUserHandler = this;
                    synchronized (restAPICreateUserHandler) {
                        this.currentStatus.put((Object)resultJson);
                    }
                }
                record.setStatus((String)resultJson.get("statusMessage"));
                if (((String)resultJson.get("status")).equalsIgnoreCase("SEVERE")) {
                    record.setIsExecutionSuccess(false);
                    continue;
                }
                record.setIsExecutionSuccess(true);
            }
        }
        catch (Exception ee) {
            this.setErrorMsg(this.rb.getString("admp.api.mgmt.fc_layout_error.some_internal_error_occured"));
            ee.printStackTrace();
        }
    }

    private JSONObject processSingleUser(JSONObject userDataJSON) {
        try {
            boolean checkAuthroziation;
            JSONObject errorDetailsObj;
            JSONObject groupAuthorizationDetails;
            boolean isAllGroupsAuthorized;
            String defaultDomainNamingContext;
            JSONObject OUNameAuthorizationDetails;
            boolean isAllOusAuthorized;
            ArrayList ouList;
            int OUNameHeaderIndex;
            Vector<String> headerVector = new Vector<String>();
            Vector<String> valuesVector = new Vector<String>();
            int headerSize = 0;
            ArrayList<Vector> list = new ArrayList<Vector>();
            Iterator itr = userDataJSON.keys();
            while (itr.hasNext()) {
                String header = (String)itr.next();
                String value = (String)userDataJSON.get(header);
                headerVector.add(header);
                valuesVector.add(value);
            }
            headerSize = headerVector.size();
            list.add(valuesVector);
            FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
            fcBulkExecuteFormBean.initBean(this.loginId, this.domainName, this.authObject, this.rb);
            this.currentCSVStatusObj = fcBulkExecuteFormBean.getCurrentCSVStatusObj();
            Long templateCategoryId = fcBulkExecuteFormBean.getTemplateCategoryId();
            this.domainName = fcBulkExecuteFormBean.getDomainName();
            Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
            Long selectedLayoutId = fcBulkExecuteFormBean.getDefaultLayoutId();
            JSONObject statusObj = FcValidation.validateAPIAttrNames(headerVector, (AdventNetResourceBundle)this.rb);
            if (!statusObj.getBoolean("status")) {
                JSONObject resultJson = new JSONObject();
                resultJson.put("statusMessage", (Object)statusObj.getString("errorMsg"));
                resultJson.put("status", (Object)"SEVERE");
                return resultJson;
            }
            int templateNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "templateName");
            boolean isTemplateNameHeaderAvailable = false;
            if (templateNameHeaderIndex != -1) {
                isTemplateNameHeaderAvailable = true;
                JSONObject layoutAuthorizationDetails = FcLayoutAuth.validateTemplateNames((int)templateNameHeaderIndex, list, (Long)templateCategoryId, (Long)this.loginId, (String)this.domainName, (AdventNetResourceBundle)this.rb);
                if (layoutAuthorizationDetails.has("inValid") && layoutAuthorizationDetails.getBoolean("inValid")) {
                    String templateName = layoutAuthorizationDetails.getString("templateName");
                    String error = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_valid"), templateName);
                    JSONObject resultJson = new JSONObject();
                    resultJson.put("statusMessage", (Object)error);
                    resultJson.put("status", (Object)"SEVERE");
                    return resultJson;
                }
                if (layoutAuthorizationDetails.has("unAuthorized")) {
                    String templateName = layoutAuthorizationDetails.getString("templateName");
                    String error = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_authorized"), templateName);
                    JSONObject resultJson = new JSONObject();
                    resultJson.put("statusMessage", (Object)error);
                    resultJson.put("status", (Object)"SEVERE");
                    return resultJson;
                }
            }
            if ((OUNameHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "OUName")) != -1 && (ouList = HelpdeskUtil.getOUList((String)this.domainName, (Long)this.loginId)) != null && ouList.size() != 0 && !(isAllOusAuthorized = (OUNameAuthorizationDetails = FcLayoutAuth.isAuthorizedOUNames((int)OUNameHeaderIndex, list, (ArrayList)ouList, (String)(defaultDomainNamingContext = DomainUtil.getDefaultNamingContext((String)this.domainName)))).getBoolean("isAllOusAuthorized"))) {
                String ouName = OUNameAuthorizationDetails.getString("ouName");
                String error = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.ou_name_is_not_authorized"), ouName);
                JSONObject resultJson = new JSONObject();
                resultJson.put("statusMessage", (Object)error);
                resultJson.put("status", (Object)"SEVERE");
                return resultJson;
            }
            int memberOfHeaderIndex = FcExecuteFormFlow.getLdapNameIndex(headerVector, "memberOf");
            if (memberOfHeaderIndex != -1 && !(isAllGroupsAuthorized = (groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)memberOfHeaderIndex, list, (Long)this.loginId, (String)this.domainName, (boolean)fcBulkExecuteFormBean.getIsWorkFlowMode())).getBoolean("isAllGroupsAuthorized"))) {
                String groupName = groupAuthorizationDetails.getString("groupName");
                String error = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName);
                JSONObject resultJson = new JSONObject();
                resultJson.put("statusMessage", (Object)error);
                resultJson.put("status", (Object)"SEVERE");
                return resultJson;
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, null, dataObj, errorDetailsObj = new JSONObject(), headerVector, list, templateCategoryId, this.loginId, this.rb, this.domainName, isTemplateNameHeaderAvailable, templateNameHeaderIndex, selectedLayoutId, checkAuthroziation = false, fcBulkExecuteFormBean.getDPValues());
            if (!status) {
                StringBuffer finalStatus = new StringBuffer();
                JSONArray errorDetailsArray = errorDetailsObj.getJSONArray("errorMsg");
                if (errorDetailsArray != null && errorDetailsArray.length() > 0) {
                    for (int i = 0; i < errorDetailsArray.length(); ++i) {
                        JSONObject errorObject = errorDetailsArray.getJSONObject(i);
                        finalStatus.append((String)errorObject.get("error"));
                    }
                }
                JSONObject resultJson = new JSONObject();
                resultJson.put("statusMessage", (Object)finalStatus.toString());
                resultJson.put("status", (Object)"SEVERE");
                return resultJson;
            }
            if (FcLayoutViewHandler.isAnyObjectHasValidationError((Long)objectCreationId, (int)-1, (int)-1)) {
                FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                RVReqParams reqParams = new RVReqParams();
                reqParams.setRange(list.size());
                reqParams.setLoginId(this.loginId);
                reqParams.setRvId(203);
                reqParams.setGenerationId(objectCreationId.longValue());
                bucResultObj.initDataSource(this.rb, reqParams, null, false, false);
                ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                ArrayList columnList = bucResultObj.getColumnList();
                int counter = 0;
                if (counter < resultList.size()) {
                    HashMap hash = (HashMap)resultList.get(counter);
                    JSONObject resultJson = new JSONObject();
                    for (int index = 0; index < columnList.size(); ++index) {
                        HashMap details = (HashMap)columnList.get(index);
                        Integer visibleId = (Integer)details.get("VISIBLE");
                        if (visibleId != 2) continue;
                        String colName = (String)details.get("DISPLAY_NAME");
                        Integer colId = (Integer)details.get("COLUMN_ID");
                        resultJson.put(colName, (Object)((String)hash.get(colId)));
                    }
                    resultJson.put("statusMessage", (Object)((String)hash.get(609)));
                    String creationStatus = "SEVERE";
                    resultJson.put("status", (Object)creationStatus);
                    return resultJson;
                }
            } else {
                fcBulkExecuteFormBean.setStartIndex(1);
                IMgmtListener listener = fcBulkExecuteFormBean.getIMgmtListener();
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)201, 0);
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                FcBulkLayoutController.getInstance().addStatusUpdator(fcBulkExecuteFormBean.getObjectCreationId(), statusUpdater);
                FcIamApps fcIamApps = fcBulkExecuteFormBean.getIamApps();
                listener.doBulkActionForWorkFlow(this.rb, fcBulkExecuteFormBean.getCommonContainerName(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getDomainName(), fcIamApps, this.loginId);
                while (!listener.getIsCompleted()) {
                    Thread.sleep(100L);
                }
                FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                RVReqParams reqParams = new RVReqParams();
                reqParams.setRange(list.size());
                reqParams.setLoginId(this.loginId);
                reqParams.setRvId(203);
                reqParams.setGenerationId(objectCreationId.longValue());
                bucResultObj.initDataSource(this.rb, reqParams, null, false, false);
                ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                ArrayList columnList = bucResultObj.getColumnList();
                int counter = 0;
                if (counter < resultList.size()) {
                    HashMap hash = (HashMap)resultList.get(counter);
                    JSONObject resultJson = new JSONObject();
                    for (int index = 0; index < columnList.size(); ++index) {
                        HashMap details = (HashMap)columnList.get(index);
                        Integer visibleId = (Integer)details.get("VISIBLE");
                        if (visibleId != 2) continue;
                        String colName = (String)details.get("DISPLAY_NAME");
                        Integer colId = (Integer)details.get("COLUMN_ID");
                        resultJson.put(colName, (Object)((String)hash.get(colId)));
                    }
                    resultJson.put("statusMessage", (Object)((String)hash.get(604)));
                    String creationStatus = bucResultObj.getCreationStatus(objectCreationId);
                    if (creationStatus == null) {
                        creationStatus = "SEVERE";
                    }
                    resultJson.put("status", (Object)creationStatus);
                    if (this.isLicenseRestricted && creationStatus.equalsIgnoreCase("SUCCESS")) {
                        ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.create_bulk_user_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
                    }
                    return resultJson;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setErrorMsg(String errorMsg) {
        JSONObject currentCSVStatusObj = new JSONObject();
        try {
            currentCSVStatusObj.put("statusMessage", (Object)errorMsg);
            currentCSVStatusObj.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)currentCSVStatusObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillResultFormat() {
        JSONObject errorJson = new JSONObject();
        try {
            if (this.invalidDomain) {
                errorJson.put("statusMessage", (Object)MessageFormat.format(this.rb.getString("admp.api.domain_settings.domain_not_configured"), this.domainName));
            } else {
                errorJson.put("statusMessage", (Object)"Access Denied");
            }
            errorJson.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)errorJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getClonedStatus() throws Exception {
        RestAPICreateUserHandler restAPICreateUserHandler = this;
        synchronized (restAPICreateUserHandler) {
            String txt = this.currentStatus.toString();
            JSONArray newStatusObj = new JSONArray(txt);
            return newStatusObj;
        }
    }

    public JSONArray getFormattedResult() {
        return this.outputFormat;
    }
}

