/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplate;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTrigger;
import com.adventnet.sym.adsm.common.server.automation.AutomationNotificationMacro;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.pushnotification.PushNotificationTrigger;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflow;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflowRule;
import com.adventnet.sym.adsm.common.server.workflow.WFAssignToRule;
import com.adventnet.sym.adsm.common.server.workflow.WFAttributeHandler;
import com.adventnet.sym.adsm.common.server.workflow.WFNotificationMacro;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleConstants;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WFTask;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskSet;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlow;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class WFMgmtAPIcall {
    public static String getWFRequestList(HttpServletRequest httpRequest) throws Exception {
        JSONObject wfRequestList = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(httpRequest);
            Long loginId = (Long)httpRequest.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer startIndex = Integer.parseInt(httpRequest.getParameter("FROM_INDEX"));
            Integer toIndex = Integer.parseInt(httpRequest.getParameter("END_INDEX"));
            Integer attributeId = Integer.parseInt(httpRequest.getParameter("ATTRIBUTE_ID"));
            String searchFilter = httpRequest.getParameter("SEARCH_FILTER");
            boolean ascending = new Boolean(httpRequest.getParameter("ASCENDING"));
            boolean isNavigation = new Boolean(httpRequest.getParameter("IS_NAVIGATION"));
            String requestId = httpRequest.getParameter("REQUEST_ID");
            ArrayList columnList = WFAttributeHandler.getInstance().listRequestsAllColumns();
            Integer count = -1;
            if (!isNavigation) {
                count = WorkFlow.getListReqResultCount((String)searchFilter.toString(), (Long)loginId, (Object)requestId);
                wfRequestList.put("REQUEST_COUNT", (Object)count);
                if (loginId == 1L) {
                    wfRequestList.put("ISADMIN", true);
                } else {
                    wfRequestList.put("ISADMIN", false);
                }
            }
            JSONArray requestList = new JSONArray();
            if (count != null && count != 0) {
                List result = new ArrayList();
                result = WorkFlow.listRequests((int)startIndex, (int)toIndex, (String)searchFilter.toString(), (ArrayList)columnList, (Integer)attributeId, (Boolean)ascending, (Long)loginId, (Object)requestId, (AdventNetResourceBundle)rb);
                for (int i = 0; i < result.size(); ++i) {
                    Hashtable requestDetail = (Hashtable)result.get(i);
                    JSONObject newRequestDetail = new JSONObject();
                    for (int j = 0; j < columnList.size(); ++j) {
                        HashMap attributeProp = (HashMap)columnList.get(j);
                        String attribName = (String)attributeProp.get("ATTRIB_COLUMN_NAME");
                        Integer attribId = (Integer)attributeProp.get("WF_ATTRIB_ID");
                        if (attribId == 11003) {
                            String createdTime = DateTimeUtil.formatDate((Long)Long.parseLong((String)requestDetail.get(attribId)), (Long)loginId);
                            newRequestDetail.put(attribName, (Object)createdTime);
                            continue;
                        }
                        newRequestDetail.put(attribName, requestDetail.get(attribId));
                    }
                    requestList.put((Object)newRequestDetail);
                }
            }
            wfRequestList.put("REQUEST_LIST", (Object)requestList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wfRequestList.toString();
    }

    public static String getWFRequestDetail(HttpServletRequest request) throws Exception {
        JSONObject resultantJson = new JSONObject();
        try {
            HashMap updateInputDetails;
            JSONObject taskDetails;
            Boolean isAuthorizedToManage;
            BusinessWorkflowRule businesWorkflowRule;
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID").toString());
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
            Long ruleId = (Long)requestDetails.get("ruleId");
            Long wfCount = (Long)requestDetails.get("WFCount");
            int currentWorkFlow = 0;
            Integer wFstatusId = (Integer)requestDetails.get("WFStatus");
            if (wFstatusId == null) {
                resultantJson.put("STATUS", (Object)"deleted");
                return resultantJson.toString();
            }
            boolean commitRequest = false;
            if (wFstatusId != WFRuleConstants.WORKFLOW_STATUS_COMMITED && wFstatusId != WFRuleConstants.WORKFLOW_STATUS_REJECTED && ((currentWorkFlow = (businesWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)ruleId)).getNextElement(wFstatusId, wfCount).intValue()) == 0 || currentWorkFlow == WFRuleConstants.WORKFLOW_STATUS_COMMITED)) {
                currentWorkFlow = WFRuleConstants.WORKFLOW_STATUS_COMMITED;
                commitRequest = true;
            }
            if ((isAuthorizedToManage = WorkFlowUserHandler.isAssignedWorkflowTechnician((Long)requestId, (Integer)wFstatusId, (Long)new Long("" + currentWorkFlow), (Long)loginId)).booleanValue() && !loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
                BusinessWorkflow businessWF = new BusinessWorkflow(requestId, loginId);
                isAuthorizedToManage = businessWF.isAllowToModifyWorkflowStatus();
            }
            if (isAuthorizedToManage.booleanValue() && wFstatusId == WFRuleConstants.WORKFLOW_STATUS_SCHEDULED) {
                isAuthorizedToManage = false;
            }
            Boolean isAuthorizedToView = WorkFlowUserHandler.isAuthorizedToView((Long)requestId, (Integer)wFstatusId, (Long)new Long("" + wFstatusId), (Long)loginId);
            String status = (String)requestDetails.get("status");
            Long requestor_id = (Long)requestDetails.get("requestor_id");
            if (!(requestor_id == null || requestor_id.equals(loginId) || isAuthorizedToManage.booleanValue() || isAuthorizedToView.booleanValue())) {
                resultantJson.put("STATUS", (Object)"fail");
                return resultantJson.toString();
            }
            resultantJson.put("STATUS", (Object)"success");
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            ArrayList wfTaskSetList = wfViewRequest.getInstantTaskSetList();
            JSONObject jsonRequestDetails = new JSONObject((Map)requestDetails);
            jsonRequestDetails.put("IS_AUTHORIZED_TO_MANAGE", (Object)isAuthorizedToManage);
            jsonRequestDetails.put("IS_AUTHORIZED_TO_VIEW", (Object)isAuthorizedToView);
            jsonRequestDetails.put("COMMIT_REQUEST", commitRequest);
            jsonRequestDetails.put("CURRENT_WORKFLOW", currentWorkFlow);
            wfViewRequest.updateWFTaskDetails();
            JSONArray requestHistoryArray = wfViewRequest.getRequestHistoryJSONArray(Long.valueOf(1L), rb);
            for (int i = 0; i < requestHistoryArray.length(); ++i) {
                String requestDetail = requestHistoryArray.getJSONArray(i).getJSONObject(0).getString("value");
                if (requestHistoryArray.getJSONArray(i).length() > 1) {
                    requestHistoryArray.put(i, (Object)(requestDetail + ",  Comments : " + requestHistoryArray.getJSONArray(i).getJSONObject(1).getString("value")));
                    continue;
                }
                requestHistoryArray.put(i, (Object)requestDetail);
            }
            jsonRequestDetails.put("HISTORY_DETAILS", (Object)requestHistoryArray.toString());
            JSONArray taskDetailsList = new JSONArray();
            for (WFTaskSet wfTaskSet : wfTaskSetList) {
                for (WFTask wfTask : wfTaskSet.getAdmpTaskList()) {
                    taskDetails = new JSONObject();
                    updateInputDetails = wfTask.setActionInputValue(rb);
                    taskDetails.put("requestActionId", (Object)wfTask.getRequestActionId());
                    taskDetails.put("taskDetailsId", (Object)wfTask.getReqMonitorTaskId());
                    taskDetails.put("requestObjectCount", (Object)wfTask.getReqActionResultCount());
                    taskDetails.put("taskName", (Object)wfTask.getReqActionName());
                    taskDetails.put("inputDetails", (Object)wfTask.getReqActionInputValue());
                    taskDetailsList.put((Object)taskDetails);
                }
            }
            jsonRequestDetails.put("TASK_DETAILS", (Object)taskDetailsList);
            taskDetailsList = new JSONArray();
            wfTaskSetList = wfViewRequest.getSuccessiveTaskSetList();
            for (WFTaskSet wfTaskSet : wfTaskSetList) {
                for (WFTask wfTask : wfTaskSet.getAdmpTaskList()) {
                    taskDetails = new JSONObject();
                    updateInputDetails = wfTask.setActionInputValue(rb);
                    taskDetails.put("requestActionId", (Object)wfTask.getRequestActionId());
                    taskDetails.put("taskDetailsId", (Object)wfTask.getReqMonitorTaskId());
                    taskDetails.put("requestObjectCount", (Object)wfTask.getReqActionResultCount());
                    taskDetails.put("taskName", (Object)wfTask.getReqActionName());
                    taskDetails.put("inputDetails", (Object)wfTask.getReqActionInputValue());
                    taskDetails.put("timeDetails", (Object)wfTask.getTimeSummary());
                    taskDetailsList.put((Object)taskDetails);
                }
            }
            jsonRequestDetails.put("SUCCESSIVE_TASK_DETAILS", (Object)taskDetailsList);
            String wfStatusKeyValue = rb.getString((String)jsonRequestDetails.get("workflowStatus"));
            jsonRequestDetails.put("workflowStatus", (Object)wfStatusKeyValue);
            resultantJson.put("REQUEST_DETAILS", (Object)jsonRequestDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultantJson.toString();
    }

    public static String getWFRequestObjectList(HttpServletRequest request) throws Exception {
        JSONObject requestObjectList = new JSONObject();
        try {
            Long requestActionId = Long.parseLong(request.getParameter("REQUEST_ACTION_ID"));
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long taskDetailsId = Long.parseLong(request.getParameter("TASK_DETAILS_ID"));
            String fromIndesStr = request.getParameter("FROM_INDEX");
            String rangeStr = request.getParameter("RANGE");
            String sortColumnNameStr = request.getParameter("ATTRIBUTE_ID");
            String sortingOrder = request.getParameter("ASCENDING");
            boolean isNavigation = new Boolean(request.getParameter("IS_NAVIGATION"));
            if (requestActionId.compareTo(WorkFlowUtil.CREATE_GROUP_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0) {
                Locale locale = request.getLocale();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
                Integer fromIndex = 1;
                if (fromIndesStr != null) {
                    fromIndex = Integer.parseInt(fromIndesStr);
                }
                WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
                wfViewRequest.updateWFTaskDetails();
                WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
                HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
                Integer workflowStatus = (Integer)requestDetails.get("WFStatus");
                request.setAttribute("WORKFLOW_STATUS", (Object)workflowStatus);
                request.setAttribute("requestDetails", (Object)requestDetails);
                ArrayList taskInputDetails = wfTask.getUserDetailsInputs(rb);
                request.setAttribute("taskInputDetails", (Object)taskInputDetails);
                request.setAttribute("requestActionId", (Object)wfTask.getRequestActionId());
                request.setAttribute("requestId", (Object)requestId);
                HttpSession session = request.getSession();
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
                JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails((Long)null, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), fcBulkExecuteFormBean.getDomainName(), loginId, rb, (int)fromIndex, Integer.parseInt(rangeStr), null, request, fcBulkExecuteFormBean.getActionId(), false, fcBulkExecuteFormBean.getDPValues());
                JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
                FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
                ArrayList sortedColumnsList = FcBulkExecuteFormFlow.sortColumnsList(columnsList);
                JSONArray jsonArray = FcExecuteFormFlow.getValuesList(objectDetailsArray);
                FcBulkExecuteFormFlow.removeNonValueColumnNames(fcBulkExecuteFormBean, sortedColumnsList, jsonArray);
                fcBulkExecuteFormBean.setSortedColumnsList(sortedColumnsList);
                if (!isNavigation) {
                    requestObjectList.put("OBJECT_COUNT", (Object)wfTask.getReqActionResultCount());
                }
                JSONArray objectList = new JSONArray();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject objectDetails = new JSONObject();
                    JSONObject singleObjRowDetails = jsonArray.getJSONObject(i).getJSONObject("objectRowDetails");
                    objectDetails.put("OBJECT_UNIQUE_ID", jsonArray.getJSONObject(i).getLong("objectIndexId"));
                    objectDetails.put("message", (Object)jsonArray.getJSONObject(i).getString("validationStatusMsg"));
                    if (singleObjRowDetails.has("OUName")) {
                        objectDetails.put("OUName", singleObjRowDetails.getJSONObject("OUName").get("value")).toString();
                    } else {
                        objectDetails.put("OUName", (Object)"-");
                    }
                    for (int j = 0; j < sortedColumnsList.size(); ++j) {
                        FcAttributes fcAttr = (FcAttributes)sortedColumnsList.get(j);
                        String ldapName = fcAttr.getAttribLdapName();
                        if (!singleObjRowDetails.has(ldapName)) continue;
                        JSONObject valueDetails = singleObjRowDetails.getJSONObject(ldapName);
                        String attribValue = valueDetails.get("value").toString();
                        if (ldapName.equalsIgnoreCase("password") && !PasswordUtil.getShowPasswordValue()) {
                            attribValue = "******";
                        }
                        objectDetails.put(ldapName, (Object)attribValue);
                    }
                    objectList.put((Object)objectDetails);
                }
                requestObjectList.put("OBJECT_LIST", (Object)objectList);
            } else if (requestActionId == WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) {
                Locale locale = request.getLocale();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
                WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
                wfViewRequest.updateWFTaskDetails();
                WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
                String domainName = wfViewRequest.getDomainName();
                Long userCreationID = wfTask.getUserCreationId();
                ArrayList attributeList = wfTask.getUserDetailsAttribList();
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
                ArrayList customAttributeList = new ArrayList();
                if (!customAttributes.isEmpty()) {
                    Enumeration enumeration = customAttributes.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        Hashtable nameVsValues = (Hashtable)customAttributes.get(key);
                        if (nameVsValues.isEmpty()) continue;
                        Enumeration enumeration2 = nameVsValues.keys();
                        while (enumeration2.hasMoreElements()) {
                            Object object = enumeration2.nextElement();
                            if (customAttributeList.contains(object)) continue;
                            customAttributeList.add(object);
                        }
                    }
                }
                JSONArray objectList = new JSONArray();
                for (int i = 0; i < userDetailsList.size(); ++i) {
                    JSONObject objectDetails = new JSONObject();
                    Hashtable userAttributeDetails = (Hashtable)userDetailsList.get(i);
                    Long userIndex = (Long)userAttributeDetails.get("USER_INDEX");
                    objectDetails.put("OBJECT_UNIQUE_ID", (Object)userIndex);
                    objectDetails.put("admp.common.attrib_disp_name.domain_name", (Object)domainName);
                    ArrayList tempList = (ArrayList)userAttributeDetails.get("USER_VALUES");
                    for (Hashtable hashtable : tempList) {
                        Object value = hashtable.get("ATTRIB_VALUE");
                        if (value == null) {
                            value = "";
                        }
                        String displayObject = ClientUtil.htmlEscape(value.toString());
                        String columnName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                        if (columnName.equalsIgnoreCase("password") && !PasswordUtil.getShowPasswordValue()) {
                            displayObject = "******";
                        }
                        objectDetails.put(columnName, (Object)displayObject);
                    }
                    Hashtable customNameVsValues = (Hashtable)customAttributes.get(userIndex);
                    for (int j = 0; j < customAttributeList.size(); ++j) {
                        ArrayList values;
                        String attName = (String)customAttributeList.get(j);
                        String val = "";
                        if (customNameVsValues != null && (values = (ArrayList)customNameVsValues.get(attName)) != null && values.size() > 0) {
                            val = values.size() == 1 ? (String)values.get(0) : values.toString();
                        }
                        String displayObject = ClientUtil.htmlEscape(val);
                        objectDetails.put(attName, (Object)displayObject);
                    }
                    objectList.put((Object)objectDetails);
                }
                requestObjectList.put("OBJECT_COUNT", userDetailsList.size());
                requestObjectList.put("OBJECT_LIST", (Object)objectList);
            } else {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
                wfViewRequest.updateWFTaskDetails();
                WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
                wfTask.setReportId();
                Long fromIndex = 1L;
                if (fromIndesStr != null) {
                    fromIndex = new Long(fromIndesStr);
                }
                Integer attributeId = 0;
                attributeId = sortColumnNameStr != null ? new Integer(sortColumnNameStr) : wfTask.getSortColumnId();
                Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
                requestProperties.put("RANGE", Integer.parseInt(rangeStr));
                requestProperties.put("FROM_INDEX", fromIndex);
                requestProperties.put("ascending", sortingOrder);
                requestProperties.put("attributeId", attributeId);
                ArrayList columnList = wfTask.getColumnList();
                Hashtable multipleValuesSids = new Hashtable();
                ArrayList resultList = wfTask.getRequestResultRows(requestProperties, columnList, multipleValuesSids);
                WFAttributeHandler.getInstance();
                WFAttributeHandler.getMultipleValues((ArrayList)columnList, multipleValuesSids, (String)ReportsUtil.TABLE_KEY, null);
                ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                JSONArray requestArray = new JSONArray();
                for (int i = 0; i < resultList.size(); ++i) {
                    JSONObject requestDetails = new JSONObject();
                    HashMap result = (HashMap)resultList.get(i);
                    String guidValue = (String)result.get("OBJECT_GUID");
                    requestDetails.put("OBJECT_UNIQUE_ID", result.get("OBJECT_GUID"));
                    for (int j = 0; j < columnList.size(); ++j) {
                        Long fileTime;
                        String val;
                        HashMap attributeProp = (HashMap)columnList.get(j);
                        String ldapName = (String)attributeProp.get("ATTRIB_DISP_NAME");
                        Integer attribId = (Integer)attributeProp.get("ATTRIB_ID");
                        String column = (String)attributeProp.get("ATTRIB_COLUMN_NAME");
                        if (column.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                            val = (String)result.get(attribId);
                            if (val == null) {
                                val = "-";
                            }
                            if (!val.equals("0") && !val.equals("-")) {
                                fileTime = Long.parseLong(val);
                                val = DateTimeUtil.getAccountExpiresDateFromFileTime((Long)fileTime, (AdventNetResourceBundle)rb, (Long)loginId);
                            } else if (val.equals("0")) {
                                val = "admp.reports.user.account_exp_date.never_expires";
                            }
                            requestDetails.put(ldapName, (Object)val);
                            continue;
                        }
                        if (column.equalsIgnoreCase("WHEN_CREATED") || column.equalsIgnoreCase("WHEN_CHANGED") || column.equalsIgnoreCase("LAST_LOGON_TIME") || column.equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || column.equalsIgnoreCase("LAST_LOGOFF_TIME") || column.equalsIgnoreCase("BAD_PASSWORD_TIME") || column.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || column.equalsIgnoreCase("PASSWORD_LAST_SET") || column.equalsIgnoreCase("CREATION_TIME") || column.equalsIgnoreCase("LAST_ACCESS_TIME") || column.equalsIgnoreCase("LAST_WRITE_TIME") || column.equalsIgnoreCase("MODIFIED_TIME") || column.equalsIgnoreCase("CREATED_ON") || column.equalsIgnoreCase("CHANGED_ON") || column.equalsIgnoreCase("LOCK_OUT_TIME")) {
                            val = (String)result.get(attribId);
                            if (val == null) {
                                val = "-";
                            }
                            if (!val.equals("0") && !val.equals("-")) {
                                fileTime = Long.parseLong(val);
                                val = DateTimeUtil.getDateFromFileTime((Long)fileTime, (Long)loginId);
                            } else if (column.equalsIgnoreCase("PASSWORD_LAST_SET") && (wfTask.getReportId() <= 200 || wfTask.getReportId() >= 300)) {
                                val = "admp.reports.common.reportresulttxt.must_change_at_next_logon";
                            }
                            requestDetails.put(ldapName, (Object)val);
                            continue;
                        }
                        if (column.equalsIgnoreCase("WHEN_CREATED") || column.equalsIgnoreCase("WHEN_CHANGED") || column.equalsIgnoreCase("LAST_LOGON_TIME") || column.equalsIgnoreCase("LAST_LOGOFF_TIME") || column.equalsIgnoreCase("BAD_PASSWORD_TIME") || column.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || column.equalsIgnoreCase("CREATION_TIME") || column.equalsIgnoreCase("MODIFIED_TIME")) {
                            val = (String)result.get(attribId);
                            if (val == null) {
                                val = "-";
                            }
                            if (!val.equals("0") && !val.equals("-")) {
                                fileTime = Long.parseLong(val);
                                val = DateTimeUtil.getDateFromFileTime((Long)fileTime, (Long)loginId);
                            }
                            requestDetails.put(ldapName, (Object)val);
                            continue;
                        }
                        if (column.equalsIgnoreCase("MEMBER_OF") || column.equalsIgnoreCase("MEMBERS") || column.equalsIgnoreCase("protocol_settings") || column.equalsIgnoreCase("reject_messages_from") || column.equalsIgnoreCase("accept_messages_from") || column.equalsIgnoreCase("send_on_behalf")) {
                            val = "";
                            Hashtable multipleValues = (Hashtable)multipleValuesSids.get(guidValue);
                            ArrayList values = (ArrayList)multipleValues.get(attribId);
                            if (values == null || values.size() == 0 || values.contains("-")) {
                                val = "-";
                            } else {
                                int l = values.size();
                                for (int k = 0; values != null && k < l; ++k) {
                                    val = val + values.get(k);
                                    val = k != l - 1 ? val + "; " : val + ".";
                                }
                            }
                            requestDetails.put(ldapName, (Object)val);
                            continue;
                        }
                        if (column.equalsIgnoreCase("Password")) {
                            String pwdValue = (String)result.get(attribId);
                            String hidePwdValue = "******";
                            if (pwdValue != null && !pwdValue.equals("")) {
                                hidePwdValue = pwdValue.replaceAll(".", "*");
                            }
                            requestDetails.put(ldapName, (Object)hidePwdValue);
                            continue;
                        }
                        requestDetails.put(ldapName, result.get(attribId));
                    }
                    requestArray.put((Object)requestDetails);
                }
                if (!isNavigation) {
                    requestObjectList.put("OBJECT_COUNT", (Object)wfTask.getReqActionResultCount());
                }
                requestObjectList.put("OBJECT_LIST", (Object)requestArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestObjectList.toString();
    }

    public static boolean reviewWFRequest(HttpServletRequest request) {
        boolean status = false;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            String comment = request.getParameter("COMMENTS");
            Integer wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_REVIEWED;
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (WorkFlowClientUtil.isAllowToModifyWFStatus(wfviRequest, wFStatusId)) {
                Hashtable hash = WorkFlow.modifyRequestWorkflowWithCount((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null);
                if (hash.get("isModified") != null && ((Boolean)hash.get("isModified")).booleanValue()) {
                    WFTask wfTask;
                    boolean isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable();
                    if (isTemplateBasedActionAvailable && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                        HashMap resultMap = wfTask.getRequestUserCreationDetails();
                        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                        auditActivities.setCurrentWFStatus(wFStatusId);
                        AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                        auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                    }
                    status = true;
                } else {
                    status = false;
                }
                if (hash.get("isWFStatusChanged") != null && ((Boolean)hash.get("isWFStatusChanged")).booleanValue()) {
                    WFRuleExecutor ruleExecutor = new WFRuleExecutor(wFStatusId, requestId, rb, loginId, (Long)hash.get("ruleId"));
                    ruleExecutor.start();
                    while (ruleExecutor.isAlive()) {
                        Thread.sleep(100L);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean approveWFRequest(HttpServletRequest request) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Integer wFStatusId = null;
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            String comment = request.getParameter("COMMENTS");
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (WorkFlowClientUtil.isAllowToModifyWFStatus(wfviRequest, WorkFlowUtil.WORKFLOW_STATUS_APPROVED)) {
                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_APPROVED;
                Hashtable hash = WorkFlow.modifyRequestWorkflowWithCount((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null);
                if (hash.get("isModified") != null && ((Boolean)hash.get("isModified")).booleanValue()) {
                    WFTask wfTask;
                    boolean isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable();
                    if (isTemplateBasedActionAvailable && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                        HashMap resultMap = wfTask.getRequestUserCreationDetails();
                        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                        auditActivities.setCurrentWFStatus(wFStatusId);
                        AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                        auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                    }
                    Boolean isNotificationNeeded = true;
                    if (BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId()).getNextElement(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_APPROVED)) == 0) {
                        JSONObject status;
                        boolean canCommit = true;
                        if (WorkFlowUtil.anySSPApprovalTask((WFViewRequest)wfviRequest) && (status = JumpToHandler.getProductStatus((String)"ManageEngine ADSelfService Plus")) != null && !"00000000".equalsIgnoreCase(status.getString("ERROR_CODE"))) {
                            canCommit = false;
                        }
                        if (canCommit) {
                            if (wfviRequest.getRequestMode() == 1L) {
                                Long automationId = AutomationUtil.getAutomationIdFromRaisedId((Long)wfviRequest.getRaisedRequestId());
                                AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                                Hashtable<String, Object> ids = new Hashtable<String, Object>();
                                ids.put("automationId", automationId);
                                ids.put("autoRaisedId", wfviRequest.getRaisedRequestId());
                                ids.put("requestId", requestId);
                                ids.put("errorMessage", rb.getString("admp.automation.notification.success_message"));
                                notificationMacro.init(ids);
                                NotificationTemplateHandler.macroMap.put(requestId, notificationMacro);
                                if (AutomationUtil.isNotifyEnabledAutomation((Long)automationId)) {
                                    isNotificationNeeded = false;
                                }
                            }
                            wfviRequest.commitRequestedTask(loginId, comment, rb);
                        }
                    }
                    WFRuleExecutor ruleExecutor = new WFRuleExecutor(wFStatusId, requestId, rb, loginId, isNotificationNeeded);
                    ruleExecutor.start();
                    while (ruleExecutor.isAlive()) {
                        Thread.sleep(100L);
                    }
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean executeWFRequest(HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
        String comment = request.getParameter("COMMENTS");
        String message = "";
        boolean canCommit = true;
        if (WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
            try {
                JSONObject status;
                WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
                if (WorkFlowUtil.anySSPApprovalTask((WFViewRequest)wfviRequest) && (status = JumpToHandler.getProductStatus((String)"ManageEngine ADSelfService Plus")) != null && !"00000000".equalsIgnoreCase(status.getString("ERROR_CODE"))) {
                    message = "admp.workflow.viewrequest.statmsg.execute_failed_ssp_down";
                    canCommit = false;
                }
                if (canCommit) {
                    WFTask wfTask;
                    Integer wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_COMMITED;
                    Boolean isNotificationNeeded = true;
                    if (wfviRequest.getRequestMode() == 1L) {
                        Long automationId = AutomationUtil.getAutomationIdFromRaisedId((Long)wfviRequest.getRaisedRequestId());
                        AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                        Hashtable<String, Object> ids = new Hashtable<String, Object>();
                        ids.put("automationId", automationId);
                        ids.put("autoRaisedId", wfviRequest.getRaisedRequestId());
                        ids.put("requestId", requestId);
                        ids.put("errorMessage", rb.getString("admp.automation.notification.success_message"));
                        notificationMacro.init(ids);
                        NotificationTemplateHandler.macroMap.put(requestId, notificationMacro);
                        if (AutomationUtil.isNotifyEnabledAutomation((Long)automationId)) {
                            isNotificationNeeded = false;
                        }
                    }
                    message = wfviRequest.commitRequestedTask(loginId, comment, rb);
                    boolean isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable();
                    if (isTemplateBasedActionAvailable && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                        HashMap resultMap = wfTask.getRequestUserCreationDetails();
                        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                        auditActivities.setCurrentWFStatus(wFStatusId);
                        AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                        auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                    }
                    if (isNotificationNeeded.booleanValue()) {
                        Integer statusId = wfviRequest.getWorkflowStatus();
                        BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId());
                        int currentWorkFlow = businessWorkflowRule.getNextElement(statusId, wfviRequest.getwFProcessedCount());
                        WFAssignToRule ruledetails = new WFAssignToRule(wfviRequest.getWfRuleId(), rb);
                        ruledetails.initRuleResultData(true);
                        Long[] notificationTemplateIds = ruledetails.getNotificationTemplateIdList(Long.valueOf(currentWorkFlow));
                        ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                        if (notificationTemplateIds != null) {
                            for (Long notificationTemplateId : notificationTemplateIds) {
                                JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)rb);
                                NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                                associatedTemplates.add(notificationTemplate);
                            }
                        }
                        WFNotificationMacro macro = new WFNotificationMacro();
                        Hashtable<String, Long> macroDetailsMap = new Hashtable<String, Long>();
                        macroDetailsMap.put("requestId", requestId);
                        macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                        macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WorkFlowUtil.WORKFLOW_STATUS_COMMITED));
                        macro.init(macroDetailsMap);
                        NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                        trigger.setNotificationTemplates(associatedTemplates);
                        trigger.start();
                    }
                    new PushNotificationTrigger(loginId, Long.valueOf(wFStatusId.longValue()), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                    return true;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static boolean rejectWFRequest(HttpServletRequest request) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Integer wFStatusId = null;
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            String comment = request.getParameter("COMMENTS");
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
                Integer statusId = wfviRequest.getWorkflowStatus();
                BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId());
                int currentWorkFlow = businessWorkflowRule.getNextElement(statusId, wfviRequest.getwFProcessedCount());
                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_REJECTED;
                wfviRequest.updateRejectRequestTaskStatus();
                if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, (Integer)3)) {
                    WFAssignToRule ruledetails = new WFAssignToRule(wfviRequest.getWfRuleId(), rb);
                    ruledetails.initRuleResultData(true);
                    Long[] rejectedNotificationTemplateIds = ruledetails.getRejectedNotificationTemplateIdList(Long.valueOf(currentWorkFlow));
                    ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                    if (rejectedNotificationTemplateIds != null) {
                        for (Long notificationTemplateId : rejectedNotificationTemplateIds) {
                            JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)rb);
                            NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                            associatedTemplates.add(notificationTemplate);
                        }
                    }
                    WFNotificationMacro macro = new WFNotificationMacro();
                    Hashtable<String, Long> macroDetailsMap = new Hashtable<String, Long>();
                    macroDetailsMap.put("requestId", requestId);
                    macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                    macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WFRuleConstants.WORKFLOW_REQUEST_STAUS_CLOSED));
                    macro.init(macroDetailsMap);
                    NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                    trigger.setNotificationTemplates(associatedTemplates);
                    trigger.start();
                    new PushNotificationTrigger(loginId, Long.valueOf(currentWorkFlow), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean closeWFRequest(HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Integer wFStatusId = null;
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
        String comment = request.getParameter("COMMENTS");
        String[] requestIdStr = new String[]{Long.toString(requestId)};
        try {
            wFStatusId = 6;
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, (Integer)2)) {
                WorkFlowUtil.deleteWFRequestSchedule((String[])requestIdStr, (String)"close");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean cancelWFRequest(HttpServletRequest request) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Integer wFStatusId = null;
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            String comment = request.getParameter("COMMENTS");
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
                Integer statusId = wfviRequest.getWorkflowStatus();
                BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId());
                int currentWorkFlow = businessWorkflowRule.getNextElement(statusId, wfviRequest.getwFProcessedCount());
                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_CANCELED;
                wfviRequest.updateRejectRequestTaskStatus();
                if (WorkFlow.modifyRequestWorkflow((Long)requestId, (Long)loginId, (String)comment, (Integer)wFStatusId, (Integer)4)) {
                    WFAssignToRule ruledetails = new WFAssignToRule(wfviRequest.getWfRuleId(), rb);
                    ruledetails.initRuleResultData(true);
                    Long[] rejectedNotificationTemplateIds = ruledetails.getRejectedNotificationTemplateIdList(Long.valueOf(currentWorkFlow));
                    ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                    if (rejectedNotificationTemplateIds != null) {
                        for (Long notificationTemplateId : rejectedNotificationTemplateIds) {
                            JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)rb);
                            NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                            associatedTemplates.add(notificationTemplate);
                        }
                    }
                    WFNotificationMacro macro = new WFNotificationMacro();
                    Hashtable<String, Long> macroDetailsMap = new Hashtable<String, Long>();
                    macroDetailsMap.put("requestId", requestId);
                    macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                    macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WFRuleConstants.WORKFLOW_REQUEST_STAUS_CLOSED));
                    macro.init(macroDetailsMap);
                    NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                    trigger.setNotificationTemplates(associatedTemplates);
                    trigger.start();
                    new PushNotificationTrigger(loginId, Long.valueOf(currentWorkFlow), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean deleteWFRequestObject(HttpServletRequest request) {
        boolean status = false;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONArray selectedGuidList = new JSONArray(request.getParameter("OBJECT_UNIQUE_ID"));
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long taskDetailsId = Long.parseLong(request.getParameter("TASK_DETAILS_ID"));
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            Long requestActionId = Long.parseLong(request.getParameter("REQUEST_ACTION_ID"));
            String comments = request.getParameter("COMMENTS");
            WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
            if (requestActionId.compareTo(WorkFlowUtil.CREATE_GROUP_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0) {
                HttpSession session = request.getSession();
                FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
                auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                auditActivities.setAuditActivitySubType(WFRequestUtil.TASK_OBJECT_REMOVED);
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setComments(comments);
                Long objectUniqueId = Long.parseLong(selectedGuidList.getString(0));
                JSONArray objectDetailsArray = FcBulkExecuteFormFlow.getObjectDetails(null, null, fcBulkExecuteFormBean.getObjectCreationId(), fcBulkExecuteFormBean.getTemplateCategoryId(), objectUniqueId, fcBulkExecuteFormBean.getDomainName(), loginId, rb, -1, -1, null, ClientUtil.getAuthObject(request), fcBulkExecuteFormBean.getActionId(), false, fcBulkExecuteFormBean.getDPValues());
                JSONObject columnsList = fcBulkExecuteFormBean.getColumnsList();
                FcExecuteFormFlow.updateAvailableColumnsList(objectDetailsArray, columnsList);
                JSONArray objectsList = FcExecuteFormFlow.getValuesList(objectDetailsArray);
                auditActivities.updateAuditActivities(new JSONObject(), objectUniqueId, objectsList, new JSONArray());
                status = FcExecuteFormFlow.deleteSingleObject(fcBulkExecuteFormBean.getObjectCreationId(), objectUniqueId, fcBulkExecuteFormBean.getTemplateCategoryId());
            } else if (requestActionId == WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) {
                Long objectUniqueId = Long.parseLong(selectedGuidList.getString(0));
                WorkFlowUtil.deleteUserCreationRequest((Long)objectUniqueId);
                status = true;
            } else {
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setComments(comments);
                status = auditActivities.updateAuditActivities(new JSONObject(), Long.valueOf(-1L), new JSONArray(), selectedGuidList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    public static FcBulkExecuteFormBean getBulkExecuteFormBean(HttpServletRequest request) {
        FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
        try {
            Long requestId = Long.parseLong(request.getParameter("REQUEST_ID"));
            Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long taskDetailsId = Long.parseLong(request.getParameter("TASK_DETAILS_ID"));
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
            Integer workflowStatus = (Integer)requestDetails.get("WFStatus");
            request.setAttribute("WORKFLOW_STATUS", (Object)workflowStatus);
            request.setAttribute("requestDetails", (Object)requestDetails);
            HashMap resultMap = wfTask.getRequestUserCreationDetails();
            ArrayList taskInputDetails = wfTask.getUserDetailsInputs(rb);
            request.setAttribute("taskInputDetails", (Object)taskInputDetails);
            request.setAttribute("requestActionId", (Object)wfTask.getRequestActionId());
            request.setAttribute("requestId", (Object)requestId);
            Long userCreationID = wfTask.getUserCreationId();
            Long templateCategoryId = null;
            for (AdmpInput admpInput : wfTask.getInputList()) {
                if (!admpInput.getName().equalsIgnoreCase("templateCategoryId")) continue;
                templateCategoryId = new Long(admpInput.getValue());
            }
            String domainName = (String)resultMap.get("DOMAIN_NAME");
            String templateName = (String)resultMap.get("TEMPLATE_NAME");
            Long layoutId = (Long)resultMap.get("LAYOUT_ID");
            if (templateName != null && templateName.equals("") && layoutId == -1L) {
                layoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false);
                templateName = FcLayoutViewHandler.getLayoutName((Long)layoutId, null);
            }
            fcBulkExecuteFormBean.initBean(request, templateCategoryId.toString(), userCreationID, layoutId, domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fcBulkExecuteFormBean;
    }
}

