/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ADSMServletAPIController {
    private static volatile ADSMServletAPIController instance = null;
    private static final Logger logger = Logger.getLogger(ADSMServletAPIController.class.getName());
    private Hashtable<String, Hashtable<String, Object>> apiMapping = new Hashtable();
    private static final String CLASS_INSTANCE = "CLASS_INSTANCE";
    private static final String METHOD_INSTANCE = "METHOD_INSTANCE";
    private static final String GET_INSTANCE_METHOD = "getInstance";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ADSMServletAPIController getInstance() {
        if (instance != null) return instance;
        Class<ADSMServletAPIController> clazz = ADSMServletAPIController.class;
        synchronized (ADSMServletAPIController.class) {
            if (instance != null) return instance;
            instance = new ADSMServletAPIController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ADSMServletAPIController() {
        try {
            this.initializeAPIMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeAPIMap() {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMServletAPIMapping", (Row)null);
            Iterator iterator = dataObject.getRows("ADSMServletAPIMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String urlPath = (String)row.get("URL_PATH");
                String className = (String)row.get("CLASS_NAME");
                String methodName = (String)row.get("METHOD_NAME");
                Class<?> caller = Class.forName(className);
                Class[] argTypes = new Class[]{};
                Method getInstanceMethod = caller.getMethod(GET_INSTANCE_METHOD, argTypes);
                Object obj = getInstanceMethod.invoke(caller, new Object[0]);
                argTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
                Method executionMethod = caller.getMethod(methodName, argTypes);
                Hashtable<String, Object> mappingInfo = new Hashtable<String, Object>();
                mappingInfo.put(CLASS_INSTANCE, obj);
                mappingInfo.put(METHOD_INSTANCE, executionMethod);
                this.apiMapping.put(urlPath, mappingInfo);
            }
            logger.log(Level.INFO, " ServletAPI map initialized in ADSMServletAPIController");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int execute(HttpServletRequest request, HttpServletResponse response) {
        int errCode = 200;
        String urlPath = request.getRequestURI().replaceFirst("/api/(json|xml)/", "");
        try {
            Hashtable<String, Object> mappingInfo = this.apiMapping.get(urlPath);
            if (mappingInfo != null) {
                Object obj = mappingInfo.get(CLASS_INSTANCE);
                Method executionMethod = (Method)mappingInfo.get(METHOD_INSTANCE);
                logger.log(Level.FINE, "Accessing URL: {0}, Class: {1}, Method : {2}", new String[]{urlPath, obj.getClass().getName(), executionMethod.getName()});
                executionMethod.invoke(obj, request, response);
            } else {
                logger.log(Level.INFO, "ServletAPI unavailable for " + urlPath);
                errCode = 404;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return errCode;
    }
}

