/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPAuthUtil;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTApi;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONException;
import org.json.JSONObject;

public class DomainAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(DomainAction.class.getName());

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject status;
        String domainName;
        String operation;
        String message;
        DynaActionForm domainDetails;
        Long loginId;
        block27: {
            String params;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            domainDetails = (DynaActionForm)form;
            message = null;
            if (DomainHandler.startDomainDiscovery()) {
                message = rb.getString("admp.domain_settings.add-edit_domain.info.domain_discovery_progress_wait");
            }
            this.checkBoxValues(domainDetails, request);
            operation = (String)domainDetails.get("operation");
            domainName = (String)domainDetails.get("DOMAIN_NAME");
            status = new JSONObject();
            if (request.getParameter("save") != null) {
                params = "add";
                message = this.save(domainDetails, request, params);
            } else if (request.getParameter("update") != null) {
                params = "update";
                message = this.save(domainDetails, request, params);
            } else if (operation.equals("delete")) {
                try {
                    if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)7000L).booleanValue()) {
                        throw new Exception(rb.getString("admp.common.authorization_message.access_denied"));
                    }
                    if (DomainHandler.deleteDomain((String)domainName)) {
                        message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.successfully_deleted");
                        break block27;
                    }
                    message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.problem_in_deleting_the_domain");
                    request.setAttribute("errHandler", (Object)"1");
                    status.put("errHandler", (Object)"1");
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
                catch (Exception e) {
                    message = e.getMessage();
                    request.setAttribute("errHandler", (Object)"1");
                    status.put("errHandler", (Object)"1");
                }
            } else if (operation.equals("connect")) {
                try {
                    if (!ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)7000L).booleanValue()) {
                        throw new Exception(rb.getString("admp.common.authorization_message.access_denied"));
                    }
                    this.connect(domainName);
                    HDTApi.getInstance().updateAuthObject();
                }
                catch (Exception e) {
                    message = e.getMessage();
                    request.setAttribute("errHandler", (Object)"1");
                }
            } else if (operation.equals("updateDomainData")) {
                String[] selectedUpdates = request.getParameterValues("updates");
                message = rb.getString("admp.domain_settings.add-edit_domain.info.refresh_request_processed_data_will_be_updated");
                try {
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                }
                catch (Exception e) {
                    message = e.getMessage();
                }
            }
        }
        ArrayList list = HDTDomainHandler.getConfiguredList((Long)loginId);
        request.setAttribute("list", (Object)list);
        if (operation.equals("modify")) {
            this.modifyDetails(domainDetails, request, mapping);
        }
        if (operation.equals("")) {
            operation = "init";
            domainDetails.set("operation", (Object)operation);
        }
        if (message != null) {
            request.setAttribute("message", (Object)message);
        }
        domainDetails.set("operation", (Object)operation);
        request.setAttribute("operation", (Object)operation);
        ArrayList dcList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        int width = 20;
        if (dcList != null) {
            String dcs = "";
            for (int i = 0; i < dcList.size(); ++i) {
                String dcL = (String)dcList.get(i);
                dcs = dcs + dcL;
                if (i != dcList.size() - 1) {
                    dcs = dcs + ",";
                }
                if (width >= dcL.length()) continue;
                width = dcL.length();
            }
            request.setAttribute("DOMAIN_CONTROLLER", (Object)dcs);
            request.setAttribute("elementWidth", (Object)(width * 7));
            request.setAttribute("selectSize", (Object)(dcList.size() * 1));
        }
        request.setAttribute("DOMAIN_NAME", (Object)domainName);
        if (operation.equalsIgnoreCase("delete")) {
            domainDetails.initialize(mapping);
            status.put("message", (Object)message);
            AjaxUtil.writeJsonResponse(response, status.toString());
            return null;
        }
        return mapping.findForward("list");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward deleteDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        JSONObject jsonObject = new JSONObject();
        String status = "Success";
        String domainName = request.getParameter("DOMAIN_NAME");
        Boolean o365LinkPresent = Boolean.parseBoolean(request.getParameter("O365_LINK_PRESENT"));
        Boolean oneO365Link = Boolean.parseBoolean(request.getParameter("ONE_O365_LINK"));
        String message = new String();
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.DOMAIN_SETTING_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.common.authorization_message.access_denied"));
            }
            if (o365LinkPresent.booleanValue() && oneO365Link.booleanValue()) {
                Properties o365Props = DomainInfoCache.getInstance().getO356AccountProperties(domainName);
                if (!O365MgmtHandler.removeCredentialsFromDB((Long)((Long)o365Props.get("WAAD_DOMAIN_ID")), (String)domainName)) throw new Exception(rb.getString("admp.admin.custom_settgs.del_policy.delete_o365_account_failure"));
                message = rb.getString("admp.admin.custom_settgs.del_policy.delete_o365_account_success");
            } else if (o365LinkPresent.booleanValue()) {
                DomainInfoCache.getInstance().reInitializeO356Cache();
            }
            if (DomainHandler.deleteDomain((String)domainName)) {
                message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.successfully_deleted");
                DashboardUtil.checkWidget(request, domainName);
            } else {
                message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.problem_in_deleting_the_domain");
                status = "Failure";
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            message = e.getMessage();
            status = "Failure";
        }
        jsonObject.put("message", (Object)message);
        jsonObject.put("status", (Object)status);
        jsonObject.put("defaultDomain", (Object)DomainUtil.getDefaultDomain());
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObject.toString());
        return null;
    }

    public ActionForward getDCDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        System.out.println("in the method getDCDetails");
        DynaActionForm domainDetails = (DynaActionForm)form;
        String authen = request.getParameter("authen");
        ArrayList l = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        ArrayList<String> dcList = new ArrayList<String>();
        String dcName = request.getParameter("DOMAIN_CONTROLLER_NAME");
        StringTokenizer st = new StringTokenizer(dcName, ",");
        while (st.hasMoreTokens()) {
            String dcL = st.nextToken().toLowerCase();
            if (dcList.contains(dcL)) continue;
            dcList.add(dcL);
        }
        String substring = request.getParameter("substring");
        st = new StringTokenizer(substring, ",");
        String operation = (String)domainDetails.get("operation");
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        int width = 20;
        while (st.hasMoreTokens()) {
            String dcL = st.nextToken().toLowerCase();
            if (!dcList.contains(dcL)) {
                dcList.add(dcL);
            }
            if (width >= dcL.length()) continue;
            width = dcL.length();
        }
        for (int i = 0; i < l.size(); ++i) {
            String str = (String)l.get(i);
            if (width >= str.length()) continue;
            width = str.length();
        }
        if (width < domainName.length()) {
            width = domainName.length();
        }
        if (operation.equals("modify")) {
            Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            this.setValues(domainDetails, p);
        }
        ArrayList list = HDTDomainHandler.getConfiguredList((Long)loginId);
        request.setAttribute("list", (Object)list);
        domainDetails.set("DOMAIN_CONTROLLER_LIST", dcList);
        domainDetails.set("IS_AUTHENTICATION_REQUIRED", (Object)authen);
        request.setAttribute("elementWidth", (Object)(width * 7));
        request.setAttribute("selectSize", (Object)(dcList.size() * 1));
        request.setAttribute("showDetailsPage", (Object)"true");
        request.setAttribute("operation", (Object)operation);
        request.setAttribute("DOMAIN_CONTROLLER", (Object)substring);
        domainDetails.set("PASSWORD", (Object)"");
        return mapping.findForward("list");
    }

    public ActionForward checkLinkedO365(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = new JSONObject();
        String oneO365Link = "true";
        String o365LinkPresent = "true";
        String domainName = request.getParameter("DOMAIN_NAME");
        String tenantId = DomainInfoCache.getInstance().getO365Account(domainName);
        if (tenantId == null || tenantId.length() == 0) {
            oneO365Link = "false";
            o365LinkPresent = "false";
        } else {
            ArrayList linkedADDomains = DomainInfoCache.getInstance().getLinkedADDomains(tenantId);
            if (linkedADDomains == null || linkedADDomains.size() == 0) {
                oneO365Link = "false";
                o365LinkPresent = "false";
            } else if (linkedADDomains.size() > 1) {
                oneO365Link = "false";
            }
        }
        jsonObject.put("o365LinkPresent", (Object)o365LinkPresent);
        jsonObject.put("oneO365Link", (Object)oneO365Link);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObject.toString());
        return null;
    }

    private void modifyDetails(DynaActionForm domainDetails, HttpServletRequest request, ActionMapping mapping) {
        try {
            String display = request.getParameter("display");
            if (display == null || display.equals("")) {
                System.out.println("do nothing");
            } else {
                domainDetails.initialize(mapping);
                String domainName = request.getParameter("DOMAIN_NAME");
                Properties p = DomainHandler.getConfiguredValuesForModify((String)domainName);
                this.setValues(domainDetails, p);
                domainDetails.set("DOMAIN_NAME", (Object)domainName);
                domainDetails.set("PASSWORD", (Object)"");
                request.setAttribute("showDetailsPage", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void connect(String domainName) {
        try {
            DomainUtil.setDefaultDomain((String)domainName, (boolean[])new boolean[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String save(DynaActionForm domainDetails, HttpServletRequest request, String params) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String errHandler = "0";
        String showDetailsPage = "false";
        String userName = "";
        String userPwd = "";
        if (request.getParameter("USER_DISTINGUISHED_NAME") != null) {
            userName = request.getParameter("USER_DISTINGUISHED_NAME");
        }
        if (request.getParameter("PASSWORD") != null) {
            userPwd = request.getParameter("PASSWORD");
        }
        ArrayList dcDetails = new ArrayList();
        String message = null;
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        Properties prop = new Properties();
        prop.put("DOMAIN_NAME", domainDetails.get("DOMAIN_NAME"));
        prop.put("USER_DISTINGUISHED_NAME", userName);
        prop.put("PASSWORD", userPwd);
        prop.put("IS_AUTHENTICATION_REQUIRED", domainDetails.get("IS_AUTHENTICATION_REQUIRED"));
        ArrayList<String> dcList = new ArrayList<String>();
        String dcName = request.getParameter("DOMAIN_CONTROLLER_NAME");
        StringTokenizer st = new StringTokenizer(dcName, ",");
        while (st.hasMoreTokens()) {
            String dcL = st.nextToken();
            dcList.add(dcL);
        }
        prop.put("DOMAIN_CONTROLLER_LIST", dcList);
        domainDetails.set("DOMAIN_CONTROLLER_LIST", dcList);
        if (!dcList.isEmpty()) {
            logger.log(Level.INFO, "DomainSetting update, Operation : " + params + " UserName : " + userName + " Highest priority DC : " + dcList.get(0));
        }
        try {
            if (loginId != 1L && !ClientAuthorizationUtil.isAuthorized(request, 7000L).booleanValue()) {
                throw new Exception(rb.getString("admp.common.authorization_message.access_denied"));
            }
            if (params == "add") {
                if (DomainHandler.addDomainDetails((Properties)prop, (AdventNetResourceBundle)rb, (boolean[])new boolean[0])) {
                    message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.domain_added_successfully");
                    if (!loginId.equals(ADMPAuthUtil.ADMIN_LOGIN_ID)) {
                        String userCredential = "true";
                        Properties hdtConfigProps = HelpdeskUtil.getUserConfigProps((Long)loginId);
                        String appendGroups = (String)hdtConfigProps.get("APPEND_GROUPS");
                        Hashtable domainVsCredential = (Hashtable)hdtConfigProps.get("CREDENTIALS");
                        Set keys = domainVsCredential.keySet();
                        for (String key : keys) {
                            if (!domainVsCredential.get(key).toString().equalsIgnoreCase("false")) continue;
                            userCredential = "false";
                        }
                        ADMPUserHandler.setRoleForUserWithResultData((Long)loginId, (Long)ADMPAuthUtil.ADMIN_ROLE_ID, (String)userCredential, (String)appendGroups, (String)domainName);
                        HDTApi.getInstance().updateAuthObject();
                        DashboardUtil.addChartPointsForDomain(loginId, domainName);
                    }
                    DashboardUtil.addChartPointsForDomain(ADMPAuthUtil.ADMIN_LOGIN_ID, domainName);
                } else {
                    message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.problem_in_adding_domain_details");
                    showDetailsPage = "true";
                }
            } else {
                Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                prop.put("IS_DEFAULT_DOMAIN", (String)p.get("IS_DEFAULT_DOMAIN"));
                if (DomainHandler.updateDomainDetails((Properties)prop, (AdventNetResourceBundle)rb, (boolean[])new boolean[0])) {
                    String[] selectedUpdates = new String[]{"Exchange", "Policy"};
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates, (boolean)false);
                    message = rb.getString("admp.domain_settings.update_domain_details.statmsg.successfully_updated");
                } else {
                    message = rb.getString("admp.domain_settings.update_domain_details.statmsg.problem_in_updating_domain_details");
                    showDetailsPage = "true";
                }
            }
            domainDetails.set("PASSWORD", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
            showDetailsPage = "true";
            errHandler = "1";
        }
        if (message == null && params == "add") {
            message = rb.getString("admp.domain_settings.add-edit_domain.statmsg.problem_in_adding_domain_details");
        } else if (message == null && params == "update") {
            message = rb.getString("admp.domain_settings.update_domain_details.statmsg.problem_in_updating_domain_details");
        }
        request.setAttribute("showDetailsPage", (Object)showDetailsPage);
        request.setAttribute("errHandler", (Object)errHandler);
        return message;
    }

    private void setValues(DynaActionForm form, Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            try {
                if (form.get(key) == null) continue;
                form.set(key, p.get(key));
            }
            catch (Exception ex) {}
        }
    }

    private void checkBoxValues(DynaActionForm domainDetails, HttpServletRequest request) {
        String[] arr = new String[]{"IS_AUTHENTICATION_REQUIRED"};
        if (request.getParameter(arr[0]) == null) {
            domainDetails.set(arr[0], (Object)"false");
        } else {
            domainDetails.set(arr[0], (Object)"true");
        }
    }
}

