/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.sym.adsm.common.server.UrlClicksHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.JsMessage;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class UtilsAction
extends DispatchAction {
    private static volatile UtilsAction instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UtilsAction getInstance() {
        if (instance != null) return instance;
        Class<UtilsAction> clazz = UtilsAction.class;
        synchronized (UtilsAction.class) {
            if (instance != null) return instance;
            instance = new UtilsAction();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ActionForward resetUrls(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println(" UTILS ACTION ...");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "no-store");
        UrlClicksHandler.getInstance().reset();
        return null;
    }

    public void jsMessage(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject localeObj = new JSONObject();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            localeObj.put("keys", (Object)rb.getJsonObject());
            JsMessage jsMessage = new JsMessage(locale);
            localeObj.put("jsKeys", (Object)jsMessage.getJsonObject());
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(localeObj.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getOUDetails(HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject jsonObject = new JSONObject();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String distinguishedName = request.getParameter("distinguishedName");
            String domainName = request.getParameter("domainName");
            JSONObject selectedOUs = new JSONObject(request.getParameter("selectedOus"));
            JSONObject excludedOus = new JSONObject(request.getParameter("excludedOus"));
            Boolean isExcludeChildOU = new Boolean(request.getParameter("isExcludeChildOU"));
            JSONArray list = new JSONArray();
            Iterator itr = selectedOUs.keys();
            while (itr.hasNext()) {
                String selectedOUDN = (String)itr.next();
                JSONObject ouProp = new JSONObject();
                if (selectedOUDN.equalsIgnoreCase(distinguishedName)) {
                    Properties domainProp = DomainUtil.getDomainDetails((String)domainName);
                    String rootName = domainProp.getProperty("DOMAIN_FLAT_NAME") + " [" + domainProp.getProperty("DOMAIN_DNS_NAME") + "]";
                    ouProp.put("ouPath", (Object)rootName);
                    ouProp.put("ouName", (Object)domainProp.getProperty("DOMAIN_DNS_NAME"));
                } else {
                    Properties prop = OUUtil.getOULocationProp((String)domainName, (String)selectedOUDN, (String)distinguishedName);
                    ouProp.put("ouPath", (Object)prop.getProperty("OU_PATH"));
                    ouProp.put("ouName", (Object)prop.getProperty("OU_NAME"));
                }
                ouProp.put("ouDN", (Object)selectedOUDN);
                list.put((Object)ouProp);
            }
            if (list.length() == 0) {
                isExcludeChildOU = Boolean.FALSE;
            }
            JSONArray excludeOUList = new JSONArray();
            itr = excludedOus.keys();
            while (itr.hasNext()) {
                String excludedOUDN = (String)itr.next();
                boolean isParentSelected = false;
                for (int i = 0; i < list.length(); ++i) {
                    JSONObject selectedOUProp = (JSONObject)list.get(i);
                    String ouDN = selectedOUProp.getString("ouDN");
                    if (!excludedOUDN.endsWith(ouDN)) continue;
                    isParentSelected = true;
                    break;
                }
                if (!isParentSelected) continue;
                Properties prop = OUUtil.getOULocationProp((String)domainName, (String)excludedOUDN, (String)distinguishedName);
                JSONObject excludedOuProp = new JSONObject();
                excludedOuProp.put("ouPath", (Object)prop.getProperty("OU_PATH"));
                excludedOuProp.put("ouName", (Object)prop.getProperty("OU_NAME"));
                excludedOuProp.put("ouDN", (Object)excludedOUDN);
                excludeOUList.put((Object)excludedOuProp);
            }
            jsonObject.put("selectedOUList", (Object)list);
            jsonObject.put("excludedOUList", (Object)excludeOUList);
            jsonObject.put("isExcludeChildOU", (Object)isExcludeChildOU);
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            out.println(jsonObject.toString());
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

