/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.sym.adsm.common.server.delegation.workflow.RequesterPolicyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ValidateHttpsAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList domainList = null;
        try {
            ServletContext context = request.getSession().getServletContext();
            String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
            request.setAttribute("isPasswordChanged", (Object)isPasswordChanged);
            request.setAttribute("isServicePackApplied", (Object)CommonUtil.isServicePackApplied());
            String selectedTheme = ADSMPersUtil.getSyMParameter((String)"THEME");
            context.setAttribute("selectedTheme", (Object)selectedTheme);
            String noOfUsers = LicenseMgr.getInstance().getLicenseProperty("HelpDeskUsers", "NumberOfUsers");
            String noOfRequesters = LicenseMgr.getInstance().getLicenseProperty("Workflow", "NumberOfRequesters");
            if (noOfUsers == null) {
                noOfUsers = "0";
            }
            if (noOfRequesters == null || noOfRequesters.equalsIgnoreCase("false")) {
                noOfRequesters = "0";
            }
            domainList = DomainUtil.getConfiguredDomainsList();
            Boolean duplicateDomain = ValidateHttpsAction.checkForDuplicateDomain(domainList);
            ArrayList requesterPolicyCount = RequesterPolicyHandler.getAvailableActivePolicyList();
            String aType = null;
            String selfService = ADSMPersUtil.getSyMParameter((String)"SelfService");
            aType = LicenseMgr.getInstance().isFreeEdition() || noOfUsers.equals("0") && noOfRequesters.equals("0") && LicenseMgr.getInstance().isStandardLicense() ? "AAA" : (HelpdeskUtil.getADMPUsersCount() > 1 || HelpdeskUtil.getADMPGroupsCount() > 0 || HelpdeskUtil.getADMPRequestersCount() > 0 || requesterPolicyCount.size() > 0 || selfService.equalsIgnoreCase("true") && domainList.size() > 0 ? "AD" : "AAA");
            String authType = ADSMPersUtil.getSyMParameter((String)"AuthType");
            if (!authType.equalsIgnoreCase(aType)) {
                ADSMPersUtil.updateSyMParameter((String)"AuthType", (String)aType);
            }
            if (!(LicenseMgr.getInstance().isFreeEdition() || noOfUsers.equals("0") && noOfRequesters.equals("0") && LicenseMgr.getInstance().isStandardLicense())) {
                Properties prop = new Properties();
                prop.put("DOMAIN_NAME", rb.getString("admp.login.domain_name_admp_authentication"));
                prop.put("DOMAIN_FLAT_NAME", rb.getString("admp.login.domain_name_admp_authentication"));
                domainList.add(prop);
                request.setAttribute("domainList", (Object)domainList);
                request.setAttribute("duplicateDomainName", (Object)duplicateDomain);
            }
            context.setAttribute("authType", (Object)aType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CommonUtil.isDemo()) {
            return mapping.findForward("demoLogin");
        }
        return mapping.findForward("loginPage");
    }

    public static Boolean checkForDuplicateDomain(ArrayList<Properties> domList) {
        ArrayList<String> domainFlatNames = new ArrayList<String>();
        for (int i = 0; i < domList.size(); ++i) {
            if (domainFlatNames.contains(domList.get(i).get("DOMAIN_FLAT_NAME"))) {
                return true;
            }
            domainFlatNames.add((String)domList.get(i).get("DOMAIN_FLAT_NAME"));
        }
        return false;
    }
}

