/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.admin.SearchListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ADSearch
extends DispatchAction {
    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            SearchListener listener = (SearchListener)session.getAttribute("SearchListener");
            if (listener == null) {
                listener = new SearchListener();
                listener.init(request);
                session.setAttribute("SearchListener", (Object)listener);
            }
            if (request.getParameter("reportType") != null) {
                DynaActionForm bean = (DynaActionForm)form;
                this.exportReport(bean, request, response);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("searchPage");
    }

    void exportReport(DynaActionForm bean, HttpServletRequest request, HttpServletResponse response) {
        try {
            Hashtable columnWidths;
            Integer widthValue;
            SearchListener listener = (SearchListener)request.getSession().getAttribute("SearchListener");
            ArrayList attributelist = listener.getAttributeList(listener.classes[(Integer)bean.get("inputFilter")]);
            String resultTableName = listener.getResultTableName(listener.classes[(Integer)bean.get("inputFilter")]);
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            String ascending = (String)bean.get("ascending");
            String action = (String)bean.get("action");
            String reportFileName = request.getSession().getServletContext().getRealPath("/") + "jasperreports" + File.separator + "jrxml" + File.separator + "showAllUsersReport.xml";
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportFileName = "ADMPReport";
            request.setAttribute("reportFileName", (Object)reportFileName);
            int sortIndex = 0;
            String sortIndexStr = request.getParameter("sortIndex");
            try {
                if (sortIndexStr != null) {
                    sortIndex = Integer.parseInt(sortIndexStr);
                }
            }
            catch (Exception e) {
                sortIndex = 0;
                e.printStackTrace();
            }
            ArrayList<String> tableNames = new ArrayList<String>();
            Criteria columnSearchCriteria = listener.getColumnSearchCriteria(request, attributelist, tableNames);
            Criteria reportGenCrit = null;
            ArrayList list = null;
            if (action.equalsIgnoreCase("showAll")) {
                list = listener.getAllRows(attributelist, listener.classes[(Integer)bean.get("inputFilter")], sortIndex, Boolean.parseBoolean(ascending), new Long(-1L), -1, tableNames, columnSearchCriteria);
            } else {
                reportGenCrit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)listener.getGenerationId(), 0);
                Criteria criteria = columnSearchCriteria == null ? reportGenCrit : reportGenCrit.and(columnSearchCriteria);
                list = listener.getRows(attributelist, listener.classes[(Integer)bean.get("inputFilter")], sortIndex, Boolean.parseBoolean(ascending), new Long(-1L), -1, tableNames, resultTableName, criteria);
            }
            listener.setExportRowCount(list.size());
            ReportJRDataSource dataSource = new ReportJRDataSource(list, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            boolean flexWidth = true;
            String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
            if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                flexWidth = false;
                pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
            }
            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, new Hashtable(), reportType, request, new Hashtable(), pageColumnWidth, flexWidth, true, rb)).remove("maxColumnWidth")) != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, listener.getLoginId(), showSerialNo, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            inputParams.put("title", rb.getString("admp.emp_search.export_text.employee_search"));
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            if (action.equalsIgnoreCase("showAll")) {
                inputParams.put("date", DateTimeUtil.getDateFormat((Long)listener.getLoginId()).format(new Date(listener.showAllTime)));
            } else {
                Row row = ReportHandler.getGeneratedReportDetails((Long)listener.getGenerationId(), (Long)listener.getLoginId());
                inputParams.put("date", DateTimeUtil.getDateFormat((Long)listener.getLoginId()).format(new Date((Long)row.get("CREATION_TIME"))));
            }
            Hashtable domainVsOus = SearchProfileHandler.getInstance().getSearchDomainsAndOus(Long.valueOf(1L));
            String domainsStr = "";
            int z = 0;
            Enumeration e = domainVsOus.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                domainsStr = z == 0 ? domainName : domainsStr + ", " + domainName;
                ++z;
            }
            inputParams.put("desc", rb.getString("client.reports.AbstractListener.report_generated_for_the_domains") + " " + domainsStr);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, listener.getLoginId(), listener);
            DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)listener.getLoginId(), (String)HelpdeskUtil.getLoginUserName((Long)listener.getLoginId()), (String)request.getRemoteAddr(), (String)"jspf.create_admp_role.search", (String)listener.getTitle(), (Integer)listener.getReportId(), (String)"-", (Boolean)Boolean.FALSE, (String)listener.getExportFileName(), (String)reportType.toLowerCase(), (String)"-", (Integer)listener.getExportRowCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward setDefaultDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uname = request.getParameter("username");
        String adminUsers = "false";
        if (uname != null && (uname.equals("admin") || uname.equals("helpdesk") || uname.equals("hrassociate"))) {
            adminUsers = "true";
        }
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(adminUsers);
        return null;
    }
}

