/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.admin.RetreiveFeedHandler;
import com.adventnet.sym.adsm.common.webclient.admin.RssConnector;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.MSSQLDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.OracleDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayUtil;
import com.adventnet.sym.adsm.common.webclient.integration.ZPeopleUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class AddOnIntegration
extends DispatchAction {
    Logger logg = Logger.getLogger(AddOnIntegration.class.getName());
    private static final String SERVICE_DESK_PLUS = "ManageEngine ServiceDesk Plus";
    private static final String SERVICENOW = "ServiceNow";
    private static final String SELF_SERVICE_PLUS = "ManageEngine ADSelfService Plus";
    public static AdventNetResourceBundle rb = null;

    public ActionForward showProducts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.INTEGRATIONS_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("mainPage");
    }

    public ActionForward sDPSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SERVICEDESK_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        try {
            Properties p;
            DynaActionForm addOns = (DynaActionForm)form;
            addOns.set("productName", (Object)SERVICE_DESK_PLUS);
            String operation = request.getParameter("operation");
            String message = "";
            if (request.getParameter("add") != null) {
                message = AddOnIntegration.save(addOns, request);
            }
            if ((p = AdminHandler.getAddOnRow((String)SERVICE_DESK_PLUS)) != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    try {
                        addOns.set(key, p.get(key));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                addOns.getMap().clear();
                addOns.set("PROTOCOL", (Object)"http");
                addOns.set("isTrustedProduct", (Object)"false");
            }
            request.setAttribute("errMsg", (Object)message);
            request.setAttribute("heading", (Object)rb.getString("client.admin.AdminController.settings"));
            request.setAttribute("description", (Object)rb.getString("client.admin.AdminController.configure_settings_for_serviceDesk_plus"));
            return mapping.findForward("serviceDeskPlusPage");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("mainPage");
        }
    }

    public ActionForward serviceNowSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties p;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SERVICENOW_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        DynaActionForm addOns = (DynaActionForm)form;
        addOns.set("productName", (Object)SERVICENOW);
        String operation = request.getParameter("operation");
        String message = "";
        if (operation != null && operation.equals("save")) {
            addOns.set("PORT", (Object)443);
            addOns.set("PROTOCOL", (Object)"https");
            addOns.set("isTrustedProduct", (Object)"false");
            message = AddOnIntegration.save(addOns, request);
        }
        if ((p = AdminHandler.getAddOnRow((String)SERVICENOW)) != null) {
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    addOns.set(key, p.get(key));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            addOns.getMap().clear();
        }
        request.setAttribute("errMsg", (Object)message);
        request.setAttribute("heading", (Object)rb.getString("client.admin.AdminController.settings"));
        request.setAttribute("description", (Object)rb.getString("client.admin.AdminController.configure_settings_for_serviceDesk_plus"));
        return mapping.findForward("serviceNowPage");
    }

    public ActionForward sSPSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SELFSERVICE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        try {
            Properties p;
            DynaActionForm addOns = (DynaActionForm)form;
            addOns.set("productName", (Object)SELF_SERVICE_PLUS);
            addOns.set("isTrustedProduct", (Object)"false");
            String message = "";
            if (request.getParameter("add") != null) {
                String sslProtocol = (String)addOns.get("PROTOCOL");
                String caFilePath = request.getParameter("fileName");
                JSONObject importStatus = new JSONObject();
                importStatus.put("status", true);
                if (sslProtocol.equals("https")) {
                    importStatus = CommonUtil.importCACert((String)caFilePath, (String)"adssp_", (Boolean)true, (AdventNetResourceBundle)rb);
                }
                if (importStatus.getBoolean("status")) {
                    message = AddOnIntegration.save(addOns, request);
                } else {
                    String string = message = importStatus.getString("statusMessage") != null ? importStatus.getString("statusMessage") : rb.getString("admp.admin.gen_settgs.error_import_cert");
                }
            }
            if ((p = AdminHandler.getAddOnRow((String)SELF_SERVICE_PLUS)) != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    try {
                        addOns.set(key, p.get(key));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                addOns.getMap().clear();
                addOns.set("PROTOCOL", (Object)"http");
            }
            request.setAttribute("errMsg", (Object)message);
            return mapping.findForward("selfServicePlusPage");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("mainPage");
        }
    }

    public ActionForward restApiServices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.INTEGRATIONS_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("restAPIPage");
    }

    public static String save(DynaActionForm addOns, HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = "";
        String pdtName = (String)addOns.get("productName");
        String hostName = (String)addOns.get("HOST");
        hostName = hostName.replaceAll("(^(http://www\\.|https://www\\.|http://|https://|www\\.))|(/+$)", "");
        Integer portNo = (Integer)addOns.get("PORT");
        Properties p = new Properties();
        p.put("PRODUCT_NAME", pdtName);
        p.put("HOST", hostName);
        p.put("PORT", portNo);
        p.put("PROTOCOL", addOns.get("PROTOCOL"));
        p.put("isTrustedProduct", addOns.get("isTrustedProduct"));
        String sslProtocol = (String)addOns.get("PROTOCOL");
        if (sslProtocol.equals("https") && pdtName.equalsIgnoreCase(SERVICE_DESK_PLUS)) {
            String trustStoreFileName = request.getParameter("fileName");
            System.setProperty("javax.net.ssl.trustStore", trustStoreFileName);
        }
        try {
            if (AdminHandler.addProductDetails((String)pdtName, (Properties)p)) {
                message = rb.getString("admp.admin.gen_settgs.sd_plus.statmsg.successfully_connected_and_updated");
                String serverhost = request.getServerName();
                if (serverhost.equals("localhost")) {
                    serverhost = InetAddress.getLocalHost().getHostName();
                }
                int serverport = request.getServerPort();
                String serverProtocol = "";
                boolean isADMPProtocolSecured = request.isSecure();
                serverProtocol = isADMPProtocolSecured ? "https" : "http";
                RetreiveFeedHandler RFH = new RetreiveFeedHandler();
                RssConnector rssConnector = RssConnector.getInstance();
                rssConnector.fetchRss(RFH, "?host=" + serverhost + "&port=" + serverport + "&protocol=" + serverProtocol + "&product=ADMANAGER");
                System.out.println("Local Host : " + serverhost + " : Local Port : " + serverport + " : Local protocol : " + serverProtocol);
            } else {
                message = "errorOccured";
            }
        }
        catch (Exception e) {
            message = "errorOccured";
            e.printStackTrace();
        }
        return message;
    }

    public ActionForward workdaySettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.WORKDAY_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        String opeartion = "view";
        String operation = request.getParameter("operation");
        if (operation != null && operation.equalsIgnoreCase("addCredentials")) {
            WorkdayUtil.addCredentials(request, response);
            return null;
        }
        if (operation != null && operation.equalsIgnoreCase("createNewConfig")) {
            operation = "createNewConfig";
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SERVICEDESK_ACTION_ID);
        request.setAttribute("credsAvailable", (Object)false);
        request.setAttribute("domainList", domainList);
        request.setAttribute("opearation", (Object)operation);
        return mapping.findForward("workdaySettingsPage");
    }

    public ActionForward syslogSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SYSLOG_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        String operation = request.getParameter("operation");
        if (operation != null && operation.equals("save")) {
            String jsonString = request.getParameter("syslogProfile");
            try {
                response.setContentType("application/json");
                CommonUtil.addSyslogProfile((JSONObject)new JSONObject(jsonString));
                request.setAttribute("syslogJSON", (Object)CommonUtil.getSyslogSettings());
                request.setAttribute("settings_available", (Object)true);
                String message = "admp.admin.syslog.syslog_successful";
                PrintWriter writer = response.getWriter();
                writer.print(rb.getString(message));
                return null;
            }
            catch (Exception e) {
                this.logg.log(Level.INFO, "Exception while forwarding Syslog:" + e);
                String message = "admp.admin.syslog.syslog_unsuccessful";
                PrintWriter writer = response.getWriter();
                writer.print(rb.getString(message));
                return null;
            }
        }
        JSONObject syslogJSON = CommonUtil.getSyslogSettings();
        if (syslogJSON != null) {
            request.setAttribute("syslogJSON", (Object)syslogJSON);
            request.setAttribute("settings_available", (Object)true);
        } else {
            request.setAttribute("settings_available", (Object)false);
        }
        request.setAttribute("heading", (Object)rb.getString("client.admin.AdminController.settings"));
        request.setAttribute("description", (Object)rb.getString("client.admin.AdminController.configure_settings_for_syslog"));
        return mapping.findForward("syslogPage");
    }

    public ActionForward splunkSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SPLUNK_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        String operation = request.getParameter("operation");
        if (operation != null && operation.equals("save")) {
            String jsonString = request.getParameter("splunkProfile");
            try {
                String message = rb.getString("admp.admin.splunk.splunk_unsuccessful");
                String status = "";
                JSONObject profileJSON = new JSONObject(jsonString);
                String hostName = profileJSON.getString("HOST");
                hostName = hostName.replaceAll("(^(http://www\\.|https://www\\.|http://|https://|www\\.))|(/+$)", "");
                profileJSON.put("HOST", (Object)hostName);
                JSONObject result = CommonUtil.addSplunkProfile((JSONObject)profileJSON, (AdventNetResourceBundle)rb);
                if (result.has("status") && result.getBoolean("status")) {
                    request.setAttribute("splunkJSON", (Object)CommonUtil.getSplunkSettings());
                    request.setAttribute("settings_available", (Object)true);
                    message = rb.getString("admp.admin.splunk.splunk_successful");
                }
                if (result.has("statusMessage")) {
                    message = message + result.getString("statusMessage");
                }
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(message);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logg.log(Level.INFO, "Exception while forwarding Splunk:" + e);
                String message = rb.getString("admp.admin.splunk.splunk_unsuccessful");
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(message);
                return null;
            }
        }
        JSONObject splunkJSON = CommonUtil.getSplunkSettings();
        if (splunkJSON != null) {
            request.setAttribute("splunkJSON", (Object)splunkJSON);
            request.setAttribute("settings_available", (Object)true);
        } else {
            request.setAttribute("settings_available", (Object)false);
        }
        request.setAttribute("heading", (Object)rb.getString("client.admin.AdminController.settings"));
        request.setAttribute("description", (Object)rb.getString("client.admin.AdminController.configure_settings_for_splunk"));
        return mapping.findForward("splunkPage");
    }

    public ActionForward sqlServerSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SQL_SERVER_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("sqlSettingsPage");
    }

    public ActionForward oracleServerSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ORACLE_DB_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("oracleSettingsPage");
    }

    public ActionForward zendeskSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ZENDESK_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("zendeskConfigPage");
    }

    public ActionForward saveSqlConnection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "sqlSettingsPage";
        try {
            DynaActionForm addOns = (DynaActionForm)form;
            String message = "";
            String operation = request.getParameter("operation");
            if (operation.equalsIgnoreCase("saveConnection")) {
                message = AddOnIntegration.saveSQLDetails(addOns, request);
                String dbType = request.getParameter("configDBType");
                if (dbType.equalsIgnoreCase("mssql") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SQL_SERVER_ACTION_ID).booleanValue() || dbType.equalsIgnoreCase("oracle") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ORACLE_DB_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                if (dbType.equalsIgnoreCase("oracle")) {
                    forwardPage = "oracleSettingsPage";
                }
            } else {
                String dbDetails = request.getParameter("dbDetails");
                JSONObject obj = new JSONObject(dbDetails);
                String dbType = (String)obj.get("dbType");
                if (dbType.equalsIgnoreCase("mssql") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SQL_SERVER_ACTION_ID).booleanValue() || dbType.equalsIgnoreCase("oracle") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ORACLE_DB_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                String databaseName = (String)obj.get("databaseName");
                String tableName = (String)obj.get("tableName");
                ArrayList columnList = DBDataSourceUtil.getColumnList(dbType, databaseName, tableName);
                JSONArray jsonarr = new JSONArray();
                for (int i = 0; i < columnList.size(); ++i) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("columnName", columnList.get(i));
                    jsonarr.put((Object)jsonObj);
                }
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(jsonarr.toString());
                return null;
            }
            if (message != null && !message.equals("")) {
                request.setAttribute("errMsg", (Object)message);
            } else {
                request.setAttribute("executionStatus", (Object)rb.getString("admp.admin.db_integration.validated_saved_successfully"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public static String saveSQLDetails(DynaActionForm addOns, HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = "";
        try {
            boolean connectionStatus;
            String dbInstanceName;
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String serverName = request.getParameter("serverName");
            String portNumber = request.getParameter("portNumber");
            String databaseName = request.getParameter("databaseName");
            String instanceName = request.getParameter("instanceName");
            String dbType = request.getParameter("configDBType");
            String isWindowsAuthentication = request.getParameter("isWindowsAuthentication");
            String domainName = request.getParameter("domainName");
            String authenticationType = "";
            if (dbType.equals("mssql")) {
                dbInstanceName = instanceName;
                authenticationType = "true".equals(isWindowsAuthentication) || "on".equals(isWindowsAuthentication) ? "windows" : "sql";
                connectionStatus = MSSQLDataSourceUtil.checkDBConnection(serverName, portNumber, domainName, username, password, instanceName, authenticationType);
            } else {
                connectionStatus = OracleDataSourceUtil.checkDBConnection(serverName, portNumber, username, password, databaseName);
                dbInstanceName = databaseName;
            }
            if (connectionStatus) {
                Row r;
                Table table = new Table("ThirdPartyDBDetails");
                SelectQueryImpl query = new SelectQueryImpl(table);
                Criteria criteria = new Criteria(new Column("ThirdPartyDBDetails", "DB_TYPE"), (Object)dbType, 0);
                query.setCriteria(criteria);
                query.addSelectColumn(new Column(null, "*"));
                Row existingRow = null;
                String existingDBName = null;
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (dataObject != null && !dataObject.isEmpty()) {
                    existingRow = dataObject.getFirstRow("ThirdPartyDBDetails");
                    existingDBName = (String)existingRow.get("INSTANCE_NAME");
                }
                if (!dataObject.isEmpty()) {
                    r = dataObject.getFirstRow("ThirdPartyDBDetails");
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("USER_NAME", (Object)username);
                    r.set("PASSWORD", (Object)password);
                    r.set("AUTHENTICATION_TYPE", (Object)authenticationType);
                    r.set("INSTANCE_NAME", (Object)dbInstanceName);
                    r.set("SERVER_NAME", (Object)serverName);
                    r.set("PORT_NUMBER", (Object)portNumber);
                    dataObject.updateRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                } else {
                    r = new Row("ThirdPartyDBDetails");
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("DB_TYPE", (Object)dbType);
                    r.set("USER_NAME", (Object)username);
                    r.set("PASSWORD", (Object)password);
                    r.set("AUTHENTICATION_TYPE", (Object)authenticationType);
                    r.set("INSTANCE_NAME", (Object)dbInstanceName);
                    r.set("SERVER_NAME", (Object)serverName);
                    r.set("PORT_NUMBER", (Object)portNumber);
                    dataObject.addRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
                }
                if (existingDBName != null && !existingDBName.equals(dbInstanceName)) {
                    String configTableName = "";
                    String columnName = "";
                    if (dbType.equals("mssql")) {
                        configTableName = "MsSqlInputConfig";
                        columnName = "INSTANCE_NAME";
                    } else {
                        configTableName = "OracleInputConfig";
                        columnName = "SID";
                    }
                    table = new Table(configTableName);
                    query = new SelectQueryImpl(table);
                    criteria = new Criteria(new Column(configTableName, columnName), (Object)existingDBName, 0);
                    query.setCriteria(criteria);
                    query.addSelectColumn(new Column(null, "*"));
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                    Iterator it = dataObject.getRows(configTableName);
                    while (it.hasNext()) {
                        existingRow = (Row)it.next();
                        existingRow.set("IS_VALID", (Object)"false");
                        dataObject.updateRow(existingRow);
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                    query = new SelectQueryImpl(table);
                    criteria = new Criteria(new Column(configTableName, columnName), (Object)dbInstanceName, 0);
                    query.setCriteria(criteria);
                    query.addSelectColumn(new Column(null, "*"));
                    dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                    it = dataObject.getRows(configTableName);
                    while (it.hasNext()) {
                        existingRow = (Row)it.next();
                        existingRow.set("IS_VALID", (Object)"true");
                        dataObject.updateRow(existingRow);
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                }
            } else {
                message = rb.getString("admp.admin.db_integration.cant_establish_connection");
            }
        }
        catch (Exception e) {
            message = "errorOccured";
            e.printStackTrace();
        }
        return message;
    }

    public static String saveSQLConfig(DynaActionForm addOns, HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = "";
        try {
            String dbTableName = request.getParameter("dbTableName");
        }
        catch (Exception e) {
            message = "errorOccured";
            e.printStackTrace();
        }
        return message;
    }

    public ActionForward updateDBConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "newSqlConfig";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String operation = request.getParameter("operation");
            String action = request.getParameter("action");
            String init = request.getParameter("init");
            String dbType = request.getParameter("dbConfigType");
            if (dbType.equalsIgnoreCase("mssql") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SQL_SERVER_ACTION_ID).booleanValue() || dbType.equalsIgnoreCase("oracle") && !ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ORACLE_DB_ACTION_ID).booleanValue()) {
                return new ActionForward("/403Error.do");
            }
            if (action.equalsIgnoreCase("create") || action.equalsIgnoreCase("edit")) {
                if (operation == null) {
                    operation = "newSqlConfig";
                }
                if (operation.equalsIgnoreCase("saveSqlConfig")) {
                    Integer configId;
                    String configName = request.getParameter("configName");
                    String configDesc = request.getParameter("description");
                    request.setAttribute("dbUsername", (Object)request.getParameter("dbUsername"));
                    request.setAttribute("dbServerName", (Object)request.getParameter("dbServerName"));
                    request.setAttribute("dbPortNumber", (Object)request.getParameter("dbPortNumber"));
                    request.setAttribute("dbDatabaseName", (Object)request.getParameter("dbDatabaseName"));
                    request.setAttribute("dbTableName", (Object)request.getParameter("dbTableName"));
                    request.setAttribute("dbSid", (Object)request.getParameter("dbSid"));
                    request.setAttribute("configId", (Object)request.getParameter("configId"));
                    request.setAttribute("configName", (Object)request.getParameter("configName"));
                    request.setAttribute("description", (Object)request.getParameter("description"));
                    request.setAttribute("attrMappingListInputs", (Object)request.getParameter("attrMappingListInputs"));
                    String val = request.getParameter("configId");
                    if (action.equalsIgnoreCase("create") || action.equalsIgnoreCase("edit")) {
                        configId = 0;
                        if (val != null && !val.equals("")) {
                            configId = Integer.parseInt(val);
                        }
                        if (DBDataSourceUtil.duplicateConfigName(configName, dbType, configId, action)) {
                            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.duplicate_configuration_name"));
                            forwardPage = dbType.equals("mssql") ? "newSqlConfig" : "newOracleConfig";
                            return mapping.findForward(forwardPage);
                        }
                    }
                    Hashtable<String, String> details = new Hashtable<String, String>();
                    if (dbType != null && dbType.equalsIgnoreCase("mssql")) {
                        details.put("dbName", request.getParameter("dbDatabaseName"));
                        details.put("tableName", request.getParameter("dbTableName"));
                    } else {
                        details.put("sid", request.getParameter("dbSid"));
                        details.put("tableName", request.getParameter("dbTableName"));
                    }
                    details.put("attrMapping", request.getParameter("attrMappingListInputs"));
                    String validationStatus = DBDataSourceUtil.validateConnection(details, dbType);
                    if (validationStatus.equalsIgnoreCase("success")) {
                        JSONArray jsonArr = new JSONArray(request.getParameter("attrMappingListInputs"));
                        if (jsonArr == null || jsonArr.length() == 0) {
                            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.attr_mapping_mandatory"));
                            forwardPage = dbType.equals("mssql") ? "newSqlConfig" : "newOracleConfig";
                            return mapping.findForward(forwardPage);
                        }
                        ArrayList<String> tempArray = new ArrayList<String>();
                        for (int ii = 0; ii < jsonArr.length(); ++ii) {
                            JSONObject jsonObj = (JSONObject)jsonArr.get(ii);
                            String ldapVal = (String)jsonObj.get("ldapName");
                            if (tempArray.contains(ldapVal)) {
                                request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.duplicate_ldap_entries"));
                                forwardPage = dbType.equals("mssql") ? "newSqlConfig" : "newOracleConfig";
                                return mapping.findForward(forwardPage);
                            }
                            tempArray.add(ldapVal);
                        }
                        if (val != null && !val.equals("")) {
                            configId = Integer.parseInt(val);
                            DBDataSourceUtil.updateDBConfigData(configId, dbType, details, configName, configDesc);
                        } else {
                            configId = DBDataSourceUtil.addDBConfigData(details, dbType, configName, configDesc);
                        }
                        DBDataSourceUtil.updateDBAttrMapping(configId, jsonArr);
                        forwardPage = dbType.equals("mssql") ? "sqlSettingsPage" : "oracleSettingsPage";
                        request.setAttribute("executionStatus", (Object)rb.getString("admp.admin.db_integration.configuration_save_success"));
                    } else {
                        if (validationStatus.equals("table_does_not_exists")) {
                            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.table_doesnt_exists"));
                            request.setAttribute("attrMappingListInputs", null);
                        } else if (validationStatus.equals("empty_primary_keys_list")) {
                            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.empty_attr_list_select_column_to_uniquely_identify_user"));
                            request.setAttribute("isEmptyPKList", (Object)"true");
                        } else {
                            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.empty_attr_list_select_column_to_uniquely_identify_user"));
                            request.setAttribute("attrMappingListInputs", null);
                        }
                        forwardPage = dbType.equals("mssql") ? "newSqlConfig" : "newOracleConfig";
                    }
                } else {
                    String tempVal = request.getParameter("configId");
                    if (tempVal != null && !tempVal.equals("")) {
                        Integer configId = Integer.parseInt(request.getParameter("configId"));
                        Hashtable details = DBDataSourceUtil.getConfigDetails(configId);
                        JSONArray attrMapping = DBDataSourceUtil.getDBAttrMapping(configId);
                        request.setAttribute("dbUsername", details.get("USER_NAME"));
                        request.setAttribute("dbServerName", details.get("SERVER_NAME"));
                        request.setAttribute("dbPortNumber", details.get("PORT_NUMBER"));
                        request.setAttribute("dbSid", details.get("SID"));
                        request.setAttribute("dbDatabaseName", details.get("DATABASE_NAME"));
                        request.setAttribute("dbTableName", details.get("TABLE_NAME"));
                        request.setAttribute("configId", (Object)tempVal);
                        request.setAttribute("configName", details.get("CONFIG_NAME"));
                        request.setAttribute("description", details.get("CONFIG_DESCRIPTION"));
                        request.setAttribute("isValid", details.get("IS_VALID"));
                        request.setAttribute("attrMappingListInputs", (Object)attrMapping.toString());
                        boolean pkFlag = false;
                        for (int i = 0; i < attrMapping.length(); ++i) {
                            JSONObject jsonObj = (JSONObject)attrMapping.get(i);
                            boolean isPrimary = (Boolean)jsonObj.get("isPrimary");
                            if (!isPrimary) continue;
                            pkFlag = true;
                            break;
                        }
                        if (pkFlag) {
                            request.setAttribute("isEmptyPKList", (Object)"true");
                        } else {
                            request.setAttribute("isEmptyPKList", (Object)"false");
                        }
                        forwardPage = ((String)details.get("DB_TYPE")).equals("mssql") ? "newSqlConfig" : "newOracleConfig";
                    } else {
                        Hashtable serverDetails;
                        forwardPage = dbType != null && dbType.equalsIgnoreCase("mssql") ? ((serverDetails = DBDataSourceUtil.getDBServerDetails("mssql")).get("serverName") == null ? "sqlSettingsPage" : "newSqlConfig") : ((serverDetails = DBDataSourceUtil.getDBServerDetails("oracle")).get("serverName") == null ? "oracleSettingsPage" : "newOracleConfig");
                    }
                }
            } else if (action.equalsIgnoreCase("delete")) {
                forwardPage = dbType != null && dbType.equalsIgnoreCase("mssql") ? "sqlSettingsPage" : "oracleSettingsPage";
                String tempVal = request.getParameter("configId");
                Integer confId = Integer.parseInt(tempVal);
                JSONObject resultObj = DBDataSourceUtil.deleteConfig(confId, "DB");
                if (resultObj.get("message").toString().equalsIgnoreCase("success")) {
                    request.setAttribute("executionStatus", (Object)rb.getString("admp.admin.db_integration.configuration_delete_success"));
                } else {
                    JSONArray usedInArray = (JSONArray)resultObj.get("configUsedInArray");
                    String statMessage = rb.getString("admp.admin.integration.congig.cant_delete_message");
                    statMessage = statMessage + usedInArray.getString(0);
                    for (int i = 1; i < usedInArray.length(); ++i) {
                        statMessage = statMessage + ", " + usedInArray.getString(i);
                    }
                    request.setAttribute("errMsg", (Object)statMessage);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            request.setAttribute("errorMsg", (Object)rb.getString("admp.admin.db_integration.internal_error"));
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getWorkdayConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.WORKDAY_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = null;
        JSONObject obj = new JSONObject();
        JSONArray attribMapping = new JSONArray();
        int configId = Integer.parseInt(request.getParameter("configId"));
        Criteria crit = new Criteria(Column.getColumn((String)"WorkdayInputConfig", (String)"CONFIG_ID"), (Object)configId, 0);
        Row row = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayInputConfig", crit).getFirstRow("WorkdayInputConfig");
        if (row != null) {
            obj.put("configId", configId);
            obj.put("configName", (Object)((String)row.get("CONFIG_NAME")));
            obj.put("configDesc", (Object)((String)row.get("CONFIG_DESCRIPTION")));
            crit = new Criteria(Column.getColumn((String)"WorkdayIntegAttrMapping", (String)"CONFIG_ID"), (Object)configId, 0);
            Iterator it = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayIntegAttrMapping", crit).getRows("WorkdayIntegAttrMapping");
            while (it.hasNext()) {
                row = (Row)it.next();
                JSONObject mapObj = new JSONObject();
                mapObj.put("wdColumn", row.get("WD_COLUMN"));
                mapObj.put("ldapColumn", row.get("GENERIC_COLUMN"));
                mapObj.put("isPrimary", row.get("IS_PRIMARY"));
                attribMapping.put((Object)mapObj);
            }
            obj.put("configAttribMapping", (Object)attribMapping);
            obj.put("message", (Object)"success");
            writer = response.getWriter();
            writer.print(obj.toString());
        }
        return null;
    }

    public ActionForward deleteWorkdayConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.WORKDAY_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = response.getWriter();
        int configId = Integer.parseInt(request.getParameter("configId"));
        writer.print(DBDataSourceUtil.deleteConfig(configId, "Workday").toString());
        return null;
    }

    public ActionForward saveWorkdayConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.WORKDAY_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = null;
        JSONObject obj = new JSONObject();
        try {
            JSONObject configDetails = new JSONObject(request.getParameter("configDetails"));
            String configDesc = "";
            String configName = configDetails.getString("configName");
            int configId = -1;
            if (configDetails.getString("configId") != null && !configDetails.getString("configId").isEmpty()) {
                configId = Integer.parseInt(configDetails.getString("configId"));
            }
            if (configDetails.getString("configDesc") != null) {
                configDesc = configDetails.getString("configDesc");
            }
            Row row = new Row("WorkdayInputConfig");
            row.set("CONFIG_NAME", (Object)configName);
            row.set("CONFIG_DESCRIPTION", (Object)configDesc);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            if (configId > 0) {
                row.set("CONFIG_ID", (Object)configId);
                dataObject.updateRow(row);
                Criteria c = new Criteria(Column.getColumn((String)"WorkdayIntegAttrMapping", (String)"CONFIG_ID"), (Object)configId, 0);
                DataAccess.delete((Criteria)c);
                obj.put("action", (Object)"update");
            } else {
                dataObject.addRow(row);
                DataAccess.fillGeneratedValues((DataObject)dataObject);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
                row = dataObject.getRow("WorkdayInputConfig");
                configId = (Integer)row.get("CONFIG_ID");
                obj.put("action", (Object)"save");
            }
            JSONArray configList = (JSONArray)configDetails.get("configList");
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < configList.length(); ++i) {
                JSONObject configObj = configList.getJSONObject(i);
                row = new Row("WorkdayIntegAttrMapping");
                row.set("CONFIG_ID", (Object)configId);
                row.set("WD_COLUMN", (Object)configObj.getString("wdColumnName"));
                row.set("GENERIC_COLUMN", (Object)configObj.getString("ldapName"));
                row.set("IS_PRIMARY", (Object)configObj.getBoolean("isPrimary"));
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            obj.put("configId", configId);
            obj.put("configName", (Object)configName);
            obj.put("configDesc", (Object)configDesc);
            obj.put("message", (Object)"success");
            try {
                writer = response.getWriter();
                writer.print(obj.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                obj = new JSONObject();
                writer = response.getWriter();
                writer.print(obj.toString());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    public ActionForward zPeopleSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ZPEOPLE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        String operation = request.getParameter("operation");
        if (operation != null && operation.equalsIgnoreCase("addCredentials")) {
            ZPeopleUtil.addCredentials(request, response);
            return null;
        }
        if (operation != null && operation.equalsIgnoreCase("createNewConfig")) {
            operation = "createNewConfig";
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SERVICEDESK_ACTION_ID);
        request.setAttribute("credsAvailable", (Object)false);
        request.setAttribute("domainList", domainList);
        request.setAttribute("opearation", (Object)operation);
        return mapping.findForward("zPeopleSettingsPage");
    }

    public ActionForward getZPeopleConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ZPEOPLE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = null;
        JSONObject obj = new JSONObject();
        JSONArray attribMapping = new JSONArray();
        int configId = Integer.parseInt(request.getParameter("configId"));
        Criteria crit = new Criteria(Column.getColumn((String)"ZPeopleInputConfig", (String)"CONFIG_ID"), (Object)configId, 0);
        Row row = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ZPeopleInputConfig", crit).getFirstRow("ZPeopleInputConfig");
        if (row != null) {
            obj.put("configId", configId);
            obj.put("configName", (Object)((String)row.get("CONFIG_NAME")));
            obj.put("configDesc", (Object)((String)row.get("CONFIG_DESCRIPTION")));
            crit = new Criteria(Column.getColumn((String)"ZohoIntegAttrMapping", (String)"CONFIG_ID"), (Object)configId, 0);
            Iterator it = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ZohoIntegAttrMapping", crit).getRows("ZohoIntegAttrMapping");
            while (it.hasNext()) {
                row = (Row)it.next();
                JSONObject mapObj = new JSONObject();
                mapObj.put("zpColumn", row.get("ZP_COLUMN"));
                mapObj.put("ldapColumn", row.get("GENERIC_COLUMN"));
                mapObj.put("isPrimary", row.get("IS_PRIMARY"));
                attribMapping.put((Object)mapObj);
            }
            obj.put("configAttribMapping", (Object)attribMapping);
            obj.put("message", (Object)"success");
            writer = response.getWriter();
            writer.print(obj.toString());
        }
        return null;
    }

    public ActionForward saveZPeopleConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ZPEOPLE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = null;
        JSONObject obj = new JSONObject();
        try {
            JSONObject configDetails = new JSONObject(request.getParameter("configDetails"));
            String configDesc = "";
            String configName = configDetails.getString("configName");
            configName.replace("_", " ");
            int configId = -1;
            if (configDetails.getString("configId") != null && !configDetails.getString("configId").isEmpty()) {
                configId = Integer.parseInt(configDetails.getString("configId"));
            }
            if (configDetails.getString("configDesc") != null) {
                configDesc = configDetails.getString("configDesc");
            }
            Row row = new Row("ZPeopleInputConfig");
            row.set("CONFIG_NAME", (Object)configName);
            row.set("CONFIG_DESCRIPTION", (Object)configDesc);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            if (configId > 0) {
                row.set("CONFIG_ID", (Object)configId);
                dataObject.updateRow(row);
                Criteria c = new Criteria(Column.getColumn((String)"ZohoIntegAttrMapping", (String)"CONFIG_ID"), (Object)configId, 0);
                DataAccess.delete((Criteria)c);
                obj.put("action", (Object)"update");
            } else {
                dataObject.addRow(row);
                DataAccess.fillGeneratedValues((DataObject)dataObject);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
                row = dataObject.getRow("ZPeopleInputConfig");
                configId = (Integer)row.get("CONFIG_ID");
                obj.put("action", (Object)"save");
            }
            JSONArray configList = (JSONArray)configDetails.get("configList");
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < configList.length(); ++i) {
                JSONObject configObj = configList.getJSONObject(i);
                row = new Row("ZohoIntegAttrMapping");
                row.set("CONFIG_ID", (Object)configId);
                row.set("ZP_COLUMN", (Object)configObj.getString("zpColumnName"));
                row.set("GENERIC_COLUMN", (Object)configObj.getString("ldapName"));
                row.set("IS_PRIMARY", (Object)configObj.getBoolean("isPrimary"));
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            obj.put("configId", configId);
            obj.put("configName", (Object)configName);
            obj.put("configDesc", (Object)configDesc);
            obj.put("message", (Object)"success");
            try {
                writer = response.getWriter();
                writer.print(obj.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                obj = new JSONObject();
                writer = response.getWriter();
                writer.print(obj.toString());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    public ActionForward deleteZPeopleConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.ZPEOPLE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        PrintWriter writer = response.getWriter();
        int configId = Integer.parseInt(request.getParameter("configId"));
        writer.print(DBDataSourceUtil.deleteConfig(configId, "zPeople").toString());
        return null;
    }
}

