/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.GoogleAppMgmtHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.iam.FcIamAppsConfiguration;
import com.adventnet.sym.adsm.common.server.iam.GAppsAdminConfiguration;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class GoogleAppActionClass
extends DispatchAction {
    Logger logg = Logger.getLogger("FcLogger");

    public ActionForward showGAppCreds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, 5274L).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)5274L);
        ArrayList credsList = GoogleAppMgmtHandler.getAllCredentials();
        request.setAttribute("credsList", (Object)credsList);
        request.setAttribute("domainList", domainList);
        return mapping.findForward("appSettings");
    }

    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = null;
        DynaActionForm dynForm = (DynaActionForm)form;
        FormFile formFile = (FormFile)dynForm.get("p12FileUpload");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        fileName = formFile.getFileName();
        if (fileName != null) {
            try {
                this.storeFile(fileName, formFile);
            }
            catch (Exception ex) {
                this.logg.log(Level.WARNING, "Exception while storing the Google Apps P12 file ", ex);
            }
        } else {
            this.logg.log(Level.WARNING, "The Google Apps P12 file is not found");
        }
        return mapping.findForward("null");
    }

    private void storeFile(String fileName, FormFile formFile) throws Exception {
        FileOutputStream fout = null;
        File saveFile = null;
        try {
            InputStream fileInput = formFile.getInputStream();
            byte[] file = new byte[fileInput.available()];
            fileInput.read(file);
            String currentPath = System.getProperty("user.dir");
            String directory = currentPath + File.separator + "Google Apps";
            File saveDir = new File(directory);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(directory + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write(file);
            fout.close();
            this.logg.log(Level.INFO, "The googleApps p12 File " + fileName + " is stored successfully");
        }
        catch (FileNotFoundException ex) {
            this.logg.log(Level.WARNING, "Exception while storing the p12 file under Google Apps directory ", ex);
            throw ex;
        }
        catch (IOException ex) {
            this.logg.log(Level.WARNING, "Exception while storing the p12 file under Google Apps directory ", ex);
            throw ex;
        }
    }

    public ActionForward deleteCredential(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String credIdToDelete = request.getParameter("credId");
            String linkedDomains = request.getParameter("domainList");
            if (credIdToDelete != null && credIdToDelete.length() > 0) {
                Long waadDomainId = Long.parseLong(credIdToDelete);
                this.logg.log(Level.INFO, "Deleting the credential with Id: " + waadDomainId);
                boolean isDeleted = GoogleAppMgmtHandler.removeCredentialsFromDB((Long)waadDomainId, (String)linkedDomains);
                if (isDeleted) {
                    String[] tableNames;
                    this.logg.log(Level.INFO, "Successfully deleted Google Apps credentials. Going to delete associated general details");
                    for (String tableName : tableNames = new String[]{"GAppsUserGeneralDetails", "GAppsGroupGeneralDetails", "GAppsOrgUnitGeneralDetails"}) {
                        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"WAAD_DOMAIN_ID"), (Object)waadDomainId, 0);
                        CommonUtil.getPersistenceNT().delete(criteria);
                    }
                } else {
                    this.logg.log(Level.INFO, "Some error occurred while deleting Google Apps account - isDeleted: " + isDeleted);
                }
            }
            FcIamAppsConfiguration.getInstance().reload();
            authObj.resetIamAccountVsDetails();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward addOrUpdateCredentials(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String credDetailsJsonTxt = request.getParameter("credDetails");
            JSONObject credDetailsJson = new JSONObject(credDetailsJsonTxt);
            this.logg.log(Level.INFO, "credDetailsJson.length : " + credDetailsJson.length());
            boolean isUpdating = false;
            if (credDetailsJson.has("waadDomainId")) {
                isUpdating = true;
            }
            credDetailsJson.put("techLoginId", (Object)loginId);
            String message = GoogleAppMgmtHandler.addOrUpdateCredentialsInDB((JSONObject)credDetailsJson, (boolean)isUpdating);
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString(message));
            FcIamAppsConfiguration.getInstance().reload();
            authObj.resetIamAccountVsDetails();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward updateGSuiteAccount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String domainIdString = request.getParameter("domainId");
            Long domainId = Long.parseLong(domainIdString);
            Properties gAppsConfigProps = GAppsAdminConfiguration.getGAppsConfigData((Long)domainId, (Long)loginId);
            String message = GoogleAppMgmtHandler.updateGSuiteDomains((Properties)gAppsConfigProps);
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString(message));
            FcIamAppsConfiguration.getInstance().reload();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

