/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationConstants;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationProfileHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleGroup;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationProfileAction
extends DispatchAction {
    ArrayList viewColumnList = null;
    private static Logger logger = Logger.getLogger(NotificationProfileAction.class.getName());

    public ActionForward showProfilePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.NOTIFICATION_PROFILE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        return mapping.findForward("notificationProfilePage");
    }

    public ActionForward listProfiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.NOTIFICATION_PROFILE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        Long cvId = ColumnConfiguration.getDefaultCvId((String)"NotificationProfile");
        this.viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
        request.setAttribute("columnList", (Object)this.viewColumnList);
        request.setAttribute("NotificationProfile", (Object)"true");
        return mapping.findForward("notificationProfiles");
    }

    public ActionForward listProfileRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotificationProfileHandler.getProfileList((HttpServletRequest)request, (ArrayList)this.viewColumnList, (AdventNetResourceBundle)ResourceBundleMgr.getInstance().getBundle(request));
        return mapping.findForward("profileList");
    }

    public ActionForward deleteProfile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.log(Level.INFO, "Going to delete profile");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String statusMessage = null;
        Integer statusCode = 0;
        try {
            String profileId = request.getParameter("profileId");
            if (profileId != null) {
                statusCode = NotificationProfileHandler.deleteProfile((Long)new Long(profileId), (AdventNetResourceBundle)rb);
            }
            if (statusCode.equals(0)) {
                statusMessage = rb.getString("admp.admin.notification_profile.delete_profile.success");
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("statusCode", (Object)statusCode);
            jsonObj.put("statusMessage", (Object)statusMessage);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward enableDisableProfile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.log(Level.INFO, "Enable/disable profile");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String statusMessage = null;
        Integer statusCode = 0;
        try {
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            statusCode = NotificationProfileHandler.enableDisableProfile((Long)json.getLong("profileId"), (Boolean)json.getBoolean("isEnabled"));
            if (statusCode.equals(NotificationConstants.ENABLE_PROFILE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notification_profile.enable_profile.success");
            } else if (statusCode.equals(NotificationConstants.DISABLE_PROFILE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notification_profile.disable_profile.success");
            } else if (statusCode.equals(NotificationConstants.ENABLE_PROFILE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notification_profile.enable_profile.failure");
            } else if (statusCode.equals(NotificationConstants.DISABLE_PROFILE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notification_profile.disable_profile.failure");
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("statusCode", (Object)statusCode);
            jsonObj.put("statusMessage", (Object)statusMessage);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward editProfile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        JSONObject profileDetails = null;
        String profileId = request.getParameter("profileId");
        if (profileId != null && !profileId.equals("")) {
            logger.log(Level.INFO, "Editing profile Started ");
            profileDetails = NotificationProfileHandler.getProfileDetails((Long)Long.valueOf(profileId), (AdventNetResourceBundle)rb);
            logger.log(Level.INFO, "profile details : " + profileDetails.toString());
        } else {
            profileDetails = new JSONObject();
            MgmtRuleGroup mgmtRuleGroup = new MgmtRuleGroup();
            profileDetails.put("associatedRules", (Object)mgmtRuleGroup.serializeToJsonObject());
        }
        request.setAttribute("profileDetails", (Object)profileDetails);
        JSONObject supportedMatchCriteriaArray = MgmtRuleHandler.getSupportedMatchCriteria((String)"NotifyConditionFieldVsCrit");
        request.setAttribute("supportedMatchCriteriaArray", (Object)supportedMatchCriteriaArray);
        JSONObject matchCriteriaIdVsName = MgmtRuleHandler.getMatchCriteriaName((String)"ADMPMgmtRulesMatchCriterias", (AdventNetResourceBundle)rb);
        request.setAttribute("matchCriteriaIdVsName", (Object)matchCriteriaIdVsName);
        JSONArray fieldsArray = MgmtRuleHandler.getReportConditionFields((String)"NotificationConditionFields", (AdventNetResourceBundle)rb);
        request.setAttribute("fieldsArray", (Object)fieldsArray);
        ArrayList delegatedDomains = HDTDomainHandler.getDomainNamesList((Long)loginId);
        request.setAttribute("delegatedDomains", (Object)FcJSONUtility.getJSONArray((ArrayList)delegatedDomains));
        JSONArray delegatedTechnicians = HelpdeskUtil.getPermittedTechnicians((Long)loginId, (AdventNetResourceBundle)rb, null);
        request.setAttribute("delegatedTechnicians", (Object)delegatedTechnicians);
        return mapping.findForward("createEditprofile");
    }

    public ActionForward searchTechnician(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            String searchTxt = request.getParameter("params");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONArray techList = HelpdeskUtil.getPermittedTechnicians((Long)loginId, (AdventNetResourceBundle)rb, (String)searchTxt);
            JSONObject json = new JSONObject();
            json.put("technicianList", (Object)techList);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveProfile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String params = request.getParameter("params");
        logger.log(Level.INFO, "Profile creation params: " + params);
        Long sessionLoginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Integer statusCode = 0;
        String statusMessage = "";
        logger.log(Level.INFO, " check profile Name Called");
        JSONObject json = new JSONObject(params);
        String profileName = (String)json.get("profileName");
        Long currentProfileId = Long.valueOf((String)json.get("profileId"));
        Long profileId = NotificationProfileHandler.getProfileId((String)profileName);
        if (profileId.equals(0L) || profileId.equals(currentProfileId)) {
            statusCode = NotificationProfileHandler.addProfileDetails((JSONObject)json, (Long)sessionLoginId, (AdventNetResourceBundle)rb);
            if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notification_profile.editprofile_failure");
            } else if (statusCode.equals(NotificationConstants.CREATE_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notification_profile.createprofile_failure");
            } else if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_PARTIAL_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notification_profile.editprofile_partially_updated");
            } else if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notification_profile.editprofile_success");
            } else if (statusCode.equals(NotificationConstants.CREATE_TEMPLATE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notification_profile.createprofile_success");
            }
            logger.log(Level.INFO, "Profile creation : " + statusMessage);
        } else {
            statusCode = NotificationConstants.DUPLICATE_TEMPLATE_NAME;
            statusMessage = rb.getString("admp.admin.notification_profile.duplicate_profile_name");
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("statusCode", (Object)statusCode);
        jsonObj.put("statusMessage", (Object)statusMessage);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }
}

