/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.iam.FcIamAppsConfiguration;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class O365ActionClass
extends DispatchAction {
    Logger logg = Logger.getLogger("FcLogger");

    public ActionForward showWAADCreds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long actionId = 5273L;
        if (!ClientAuthorizationUtil.isAuthorized(request, actionId).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, actionId);
        ArrayList credsList = O365MgmtHandler.getAllCredentials();
        request.setAttribute("credsList", (Object)credsList);
        request.setAttribute("domainList", domainList);
        request.setAttribute("o365UserADAttributeLinks", (Object)O365MgmtHandler.getOtherAppADAttrLinkDetails((String)"o365user", (String)"AD", (Integer)3));
        return mapping.findForward("appSettings");
    }

    public ActionForward addOrUpdateCredentials(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String credDetailsJsonTxt = request.getParameter("credDetails");
            JSONObject credDetailsJson = new JSONObject(credDetailsJsonTxt);
            this.logg.log(Level.INFO, "credDetailsJson.length : " + credDetailsJson.length());
            boolean isUpdating = false;
            boolean userInSameTenant = false;
            if (credDetailsJson.has("waadDomainId")) {
                isUpdating = true;
                Long waadDomainId = credDetailsJson.getLong("waadDomainId");
                String previousDomainsStr = credDetailsJson.getString("previousADDomainList");
                ArrayList<String> previousDomains = new ArrayList<String>(Arrays.asList(previousDomainsStr.replaceAll("\\s+", "").split(",")));
                Properties domainProperties = O365InfoCache.getInstance().getO365DefaultDomain(previousDomains.get(0));
                ArrayList waadDomainNameList = (ArrayList)domainProperties.get("waadDomains");
                String tenantId = credDetailsJson.getString("tenantId");
                try {
                    for (String waadDomainName : waadDomainNameList) {
                        if (!tenantId.toLowerCase().contains(waadDomainName.toLowerCase())) continue;
                        userInSameTenant = true;
                    }
                }
                catch (NullPointerException ex) {
                    this.logg.log(Level.FINE, "Domain list is empty! Incorrect password or expired account");
                    credDetailsJson.put("checkSameTenant", true);
                    userInSameTenant = true;
                }
            }
            credDetailsJson.put("techLoginId", (Object)loginId);
            PrintWriter writer = response.getWriter();
            if (!userInSameTenant && isUpdating) {
                String msg = ClientUtil.htmlEscape(rb.getString("admp.admin.custom_app_settings.text_user_not_part_of_same_tenant"));
                writer.print(msg);
                return null;
            }
            String message = O365MgmtHandler.addOrUpdateCredentialsInDB((JSONObject)credDetailsJson, (boolean)isUpdating);
            if (message.indexOf("admp.mgmt.o365.error.unauth_cred") != -1) {
                message = ClientUtil.htmlEscape(rb.getString(message)) + "<br><a class=\"greenlinktxt\" href=\"/help/admin-settings/office365-active-directory-management-tool.html#Troubleshooting\" target=\"_help\">" + rb.getString("admp.common.info.click_here_to_troubleShoot") + "</a></br>";
            } else if (!(message = rb.getString(message)).contains("href")) {
                message = ClientUtil.htmlEscape(message);
            }
            writer.print(message);
            FcIamAppsConfiguration.getInstance().reload();
            authObj.resetIamAccountVsDetails();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteCredential(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            String credIdToDelete = request.getParameter("credId");
            String linkedDomains = request.getParameter("domainList");
            if (credIdToDelete != null && credIdToDelete.length() > 0) {
                this.logg.log(Level.INFO, "Deleting the credential with Id: " + credIdToDelete);
                boolean isDeleted = O365MgmtHandler.removeO365ScheduledReports((Long)Long.parseLong(credIdToDelete));
                this.logg.log(Level.INFO, "O365 Delete Schedule Report Status: " + isDeleted);
                isDeleted = O365MgmtHandler.removeOpenO365WFRequests((Long)Long.parseLong(credIdToDelete), (String)linkedDomains);
                this.logg.log(Level.INFO, "O365 Delete Open WF Request Status: " + isDeleted);
                isDeleted = O365MgmtHandler.removeNonPolicyO365Automation((Long)Long.parseLong(credIdToDelete), (String)linkedDomains);
                this.logg.log(Level.INFO, "O365 Delete Non Policy Automation Status: " + isDeleted);
                isDeleted = O365MgmtHandler.removeCredentialsFromDB((Long)Long.parseLong(credIdToDelete), (String)linkedDomains);
                this.logg.log(Level.INFO, "isDeleted: " + isDeleted);
                FcIamAppsConfiguration.getInstance().reload();
                authObj.resetIamAccountVsDetails();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward testConnection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            response.setContentType("application/json");
            String userName = request.getParameter("userName");
            String password = request.getParameter("password");
            String message = "admp.mgmt.waad.test_connection_unsuccessful";
            if (userName != null && password != null) {
                message = O365MgmtHandler.testWAADConnection((String)userName, (String)password);
            }
            message = message.indexOf("admp.mgmt.o365.error.unauth_cred") != -1 ? ClientUtil.htmlEscape(rb.getString(message)) + "<br><a class=\"greenlinktxt\" href=\"/help/admin-settings/office365-active-directory-management-tool.html#Troubleshooting\" target=\"_help\">" + rb.getString("admp.common.info.click_here_to_troubleShoot") + "</a></br>" : ClientUtil.htmlEscape(rb.getString(message));
            PrintWriter writer = response.getWriter();
            writer.print(message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward installMSOnlineModule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            response.setContentType("application/json");
            JSONObject jsonObj = O365MgmtHandler.installMSOnlineModule((AdventNetResourceBundle)rb);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward updateO365Data(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        try {
            Long waadDomainId = Long.parseLong(request.getParameter("waadDomainId"));
            message = O365MgmtHandler.updateDomainData((Long)waadDomainId);
        }
        catch (Exception ex) {
            message = "admp.mgmt.waad.some_error_occurred";
            ex.printStackTrace();
        }
        if (message.length() == 0) {
            message = "admp.mgmt.waad.updated_successfully";
        }
        this.logg.log(Level.INFO, "UpdateO365DomainData--message: " + message);
        response.setContentType("application/json");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("message", (Object)rb.getString(message));
        ArrayList<String> table = new ArrayList<String>();
        table.add("ADSMWAADDomainConfiguration");
        DataObject data = CommonUtil.getPersistence((boolean[])new boolean[0]).get(table, new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_DOMAIN_ID"), (Object)Long.parseLong(request.getParameter("waadDomainId")), 0));
        jsonObj.put("dirSyncEnabled", (Object)data.getFirstRow("ADSMWAADDomainConfiguration").get("IS_DIR_SYNC_ENABLED").toString());
        jsonObj.put("waadDomainId", (Object)data.getFirstRow("ADSMWAADDomainConfiguration").get("WAAD_DOMAIN_ID").toString());
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        FcIamAppsConfiguration.getInstance().reload();
        return null;
    }
}

