/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.metrack.METrackerUtil;
import com.adventnet.sym.adsm.common.server.o365.OMPIntegrationHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import com.manageengine.o365.server.admin.PersonalizeHandler;
import com.me.tools.zcutil.METrack;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class PrivacySettingsAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(PrivacySettingsAction.class.getName());

    public ActionForward showPrivacySettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean showDefault = false;
        JSONObject settingsJson = PrivacyHandler.getInstance().getPrivacyConfig();
        String usageStatistics = ADSMPersUtil.getSyMParameter((String)"USAGE_STATISTICS");
        if (usageStatistics == null) {
            usageStatistics = "true";
        }
        settingsJson.put("USAGE_STATISTICS", (Object)Boolean.valueOf(usageStatistics));
        request.setAttribute("settingsJson", (Object)settingsJson);
        return mapping.findForward("mainPage");
    }

    public ActionForward savePrivacySettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String jsonString = request.getParameter("settingsJson");
            JSONObject settingsJson = new JSONObject(jsonString);
            String exportPassword = settingsJson.getString("EXPORT_FILE_PASSWORD");
            String zipPassword = settingsJson.getString("BACKUP_ZIP_PASSWORD");
            if (settingsJson.getBoolean("PROTECT_EXPORTED_BACKUPS") && zipPassword.equals("")) {
                settingsJson.put("BACKUP_ZIP_PASSWORD", (Object)PrivacyHandler.getInstance().getBackupPassword());
            } else if (!settingsJson.getBoolean("PROTECT_EXPORTED_BACKUPS")) {
                settingsJson.put("BACKUP_ZIP_PASSWORD", (Object)"");
            }
            if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
                if (settingsJson.getBoolean("PROTECT_EXPORTED_FILES") && exportPassword.equals("")) {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)PrivacyHandler.getInstance().getExportFilePassword());
                } else if (!settingsJson.getBoolean("PROTECT_EXPORTED_FILES")) {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)"");
                }
                PrivacyHandler.getInstance().updatePrivacyDetails(settingsJson);
            } else if (settingsJson.getBoolean("PROTECT_EXPORTED_FILES")) {
                String adminPwd = PrivacyHandler.getInstance().getExportFilePassword();
                if (adminPwd == null || adminPwd.equals("")) {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)exportPassword);
                } else {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)adminPwd);
                }
                PrivacyHandler.getInstance().updatePrivacyDetails(settingsJson);
                if (exportPassword.equals("")) {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)ADMPUserHandler.getUserPersonalDetails((Long)loginId, (String)"EXPORT_PASSWORD"));
                } else {
                    settingsJson.put("EXPORT_FILE_PASSWORD", (Object)exportPassword);
                }
            } else {
                settingsJson.put("EXPORT_FILE_PASSWORD", (Object)"");
                PrivacyHandler.getInstance().updatePrivacyDetails(settingsJson);
            }
            Boolean usageStatistics = settingsJson.getBoolean("USAGE_STATISTICS");
            String currentUsageStatStr = ADSMPersUtil.getSyMParameter((String)"USAGE_STATISTICS");
            boolean currUsageStatistics = Boolean.valueOf(currentUsageStatStr);
            logger.log(Level.INFO, "The usageStatistics " + usageStatistics + " and currUsageStatistics is " + currUsageStatistics);
            if (currUsageStatistics != usageStatistics || currentUsageStatStr == null) {
                ADSMPersUtil.updateSyMParameter((String)"USAGE_STATISTICS", (String)usageStatistics.toString());
                if (usageStatistics.booleanValue()) {
                    METrackerUtil.startMETracker();
                    OMPIntegrationHandler.enableScheduler((String)"IntegrationMETrack");
                    METrack.enable(null);
                } else {
                    logger.log(Level.INFO, "Disabling ME tracker");
                    METrack.disable(null);
                    OMPIntegrationHandler.disableScheduler((String)"IntegrationMETrack");
                }
            }
            ADMPUserHandler.setUserPersonalDetails((Long)loginId, (String)"EXPORT_PASSWORD", (String)settingsJson.getString("EXPORT_FILE_PASSWORD"));
            Long userId = CommonUtil.getUserId((Long)loginId);
            JSONObject json = new JSONObject();
            json.put("EXPORT_PASSWORD", (Object)settingsJson.getString("EXPORT_FILE_PASSWORD"));
            PersonalizeHandler.updateSettings((Long)userId, (JSONObject)json);
            PrintWriter writer = response.getWriter();
            writer.print(rb.getString("client.admin.ConfigureSearchAction.successfully_updated_the_settings"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

