/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.SearchQueue;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.DynaActionForm;

public class SearchListener
extends AbstractListener {
    private SearchQueue queue = null;
    private String searchType = null;
    private String searchString = null;
    private ArrayList objectClasses = null;
    private ArrayList searchBy = new ArrayList();
    private String searchByStr = null;
    private Hashtable searchProfile = new Hashtable();
    public long showAllTime;
    public final String[] classes = new String[]{"user", "contact"};

    @Override
    public void shutDownQueue() {
        this.queue.shutDown();
    }

    public SearchListener() {
        this.reportId = new Integer(10001);
    }

    public void init(HttpServletRequest request) {
        HttpSession session = request.getSession();
        this.queue = (SearchQueue)session.getAttribute("searchQueue");
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (this.queue == null) {
            this.queue = new SearchQueue();
            session.setAttribute("searchQueue", (Object)this.queue);
        }
        Long profileId = 1L;
        this.searchProfile = SearchProfileHandler.getInstance().getSearchProfileDetails(profileId);
        this.objectClasses = SearchProfileHandler.getInstance().getObjectClassValues(profileId);
    }

    public void start(HttpServletRequest request) {
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            HttpSession session = request.getSession();
            this.loginId = session.getAttribute("ADMP_SESSION_LOGIN_ID") != null ? (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID") : new Long(1L);
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)"", (Long)this.loginId);
            String searchAttribs = request.getParameter("searchBy");
            if (searchAttribs == null) {
                searchAttribs = "ALL_FIELDS";
            }
            this.searchByStr = searchAttribs;
            this.searchBy = new ArrayList<String>(Arrays.asList(searchAttribs.split(";;;")));
            this.searchType = request.getParameter("searchType");
            this.searchString = request.getParameter("searchString");
            Action action = new Action(this.loginId, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getLoginId() {
        return this.loginId;
    }

    public String getResultTableName(String objClass) {
        String resultTable = null;
        for (int j = 0; j < this.objectClasses.size(); ++j) {
            Row row = (Row)this.objectClasses.get(j);
            String objectClass = (String)row.get("OBJECT_CLASS");
            if (!objectClass.equalsIgnoreCase(objClass)) continue;
            resultTable = (String)row.get("RESULT_MODULE");
        }
        return resultTable;
    }

    public void setReportRows(HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Integer count = null;
        DynaActionForm bean = (DynaActionForm)request.getSession().getAttribute("ADSearchBean");
        String action = (String)bean.get("action");
        if (action.equalsIgnoreCase("Stop")) {
            action = "showList";
            bean.set("action", (Object)"showList");
        }
        String objClass = this.classes[(Integer)bean.get("inputFilter")];
        String resultTable = this.getResultTableName(objClass);
        ArrayList<String> tableNames = new ArrayList<String>();
        ArrayList attributelist = this.getAttributeList(objClass);
        if (request.getParameter("changeInput") != null) {
            bean.set("FROM_INDEX", (Object)1L);
            bean.set("PAGE_NUMBER", (Object)"1");
        }
        Criteria criteria = null;
        Criteria columnSearchCriteria = this.getColumnSearchCriteria(request, attributelist, tableNames);
        if (action.equalsIgnoreCase("showAll")) {
            count = this.getAllObjectCount(attributelist, objClass, tableNames, columnSearchCriteria);
            this.showAllTime = System.currentTimeMillis();
        } else {
            Criteria reportGenCrit = new Criteria(Column.getColumn((String)resultTable, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0);
            criteria = columnSearchCriteria == null ? reportGenCrit : reportGenCrit.and(columnSearchCriteria);
            SelectQuery cSq = ReportResultUtil.getCountSQ(columnSearchCriteria, this.generationId, resultTable, tableNames, "OBJECT_GUID");
            count = DBUtil.getCount((SelectQuery)cSq);
        }
        if (this.errorMessage != null) {
            request.setAttribute("errorMsg", (Object)this.errorMessage);
        }
        this.errorMessage = null;
        if (count != null && count == 0) {
            request.setAttribute("result", new ArrayList());
            return;
        }
        if (count != null && count != 0) {
            Integer range = 25;
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            String ascending = (String)bean.get("ascending");
            int sortIndex = 0;
            String sortIndexStr = request.getParameter("sortIndex");
            try {
                if (sortIndexStr != null) {
                    sortIndex = Integer.parseInt(sortIndexStr);
                }
                range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "EmployeeSearch", this.loginId);
            }
            catch (Exception e) {
                sortIndex = 0;
                e.printStackTrace();
            }
            ArrayList list = null;
            list = action.equalsIgnoreCase("showAll") ? this.getAllRows(attributelist, objClass, sortIndex, new Boolean(ascending), startIndex, range, tableNames, columnSearchCriteria) : this.getRows(attributelist, objClass, sortIndex, new Boolean(ascending), startIndex, range, tableNames, resultTable, criteria);
            request.setAttribute("result", (Object)list);
            request.setAttribute("sortIndex", (Object)sortIndex);
            request.setAttribute("RANGE", (Object)range);
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            request.setAttribute("recordsCount", (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getAllRows(ArrayList attributeList, String objClass, int sortIndex, boolean ascending, Long startIndex, int range, ArrayList<String> tableNames, Criteria columnSearchCriteria) {
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String sortTableName = null;
        String sortColumn = null;
        ArrayList<SelectQueryImpl> queryList = new ArrayList<SelectQueryImpl>();
        try {
            ObjectClass objectClass = SearchProfileHandler.getInstance().getObjectClass(objClass);
            String baseTableName = objectClass.getBaseTable();
            Integer noOfColumns = attributeList.size();
            Hashtable domainVsOus = SearchProfileHandler.getInstance().getSearchDomainsAndOus(Long.valueOf(1L));
            Enumeration e = domainVsOus.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                Hashtable ous = (Hashtable)domainVsOus.get(domainName);
                Enumeration e1 = ous.keys();
                String defaultNamingContext = (String)e1.nextElement();
                ArrayList oulist = (ArrayList)ous.get(defaultNamingContext);
                ArrayList ouList = DirectoryObjectUtil.getParentOUs(oulist);
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)baseTableName));
                for (int j = 0; j < noOfColumns; ++j) {
                    Properties attributeProp = (Properties)attributeList.get(j);
                    String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                    String tableName = attributeProp.getProperty("TABLE_NAME");
                    Column selectColumn = null;
                    if (j == sortIndex) {
                        sortColumn = columnName;
                        sortTableName = tableName;
                        selectColumn = Column.getColumn((String)tableName, (String)columnName, (String)"NAME");
                    } else {
                        selectColumn = Column.getColumn((String)tableName, (String)columnName);
                    }
                    selectQuery.addSelectColumn(selectColumn);
                }
                if (objClass.equalsIgnoreCase("user")) {
                    String sidTableName = CommonUtil.getSIDTableName((String)domainName);
                    selectQuery.addJoin(new Join(baseTableName, sidTableName, new String[]{"SID_STRING"}, new String[]{"SID_STRING"}, 2));
                }
                for (int k = 0; k < tableNames.size(); ++k) {
                    if (tableNames.get(k).equalsIgnoreCase(baseTableName)) continue;
                    selectQuery.addJoin(new Join(baseTableName, tableNames.get(k), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)baseTableName, (String)"IS_DELETED"), (Object)new Integer(1), 0));
                if (ouList != null && !ouList.isEmpty()) {
                    Criteria oUCriteria = null;
                    for (int j = 0; j < ouList.size(); ++j) {
                        String ouDN = (String)ouList.get(j);
                        ouDN = EscapeUtil.getEscapedOuDN((String)ouDN);
                        oUCriteria = oUCriteria == null ? new Criteria(Column.getColumn((String)baseTableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12) : oUCriteria.or(new Criteria(Column.getColumn((String)baseTableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12));
                    }
                    criteria = criteria.and(oUCriteria);
                }
                if (columnSearchCriteria != null) {
                    criteria = criteria.and(columnSearchCriteria);
                }
                selectQuery.setCriteria(criteria);
                queryList.add(selectQuery);
            }
            String queryString = "";
            if (queryList.size() == 1) {
                SelectQuery query = (SelectQuery)queryList.get(0);
                if (range > 0) {
                    query.setRange(new Range((int)startIndex.longValue(), range));
                }
                SortColumn querySortColumn = new SortColumn(Column.getColumn(sortTableName, sortColumn), ascending);
                query.addSortColumn(querySortColumn);
                queryString = RelationalAPI.getInstance().getSelectSQL((Query)query);
            } else {
                QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
                ArrayList<String> unionQueryList = new ArrayList<String>();
                for (int q = 0; q < queryList.size(); ++q) {
                    unionQueryList.add(RelationalAPI.getInstance().getSelectSQL((Query)queryList.get(q)));
                }
                queryString = queryGen.getUnionQuery(Integer.parseInt(startIndex.toString()), range, "NAME", ascending, unionQueryList);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            stmt = connection.createStatement();
            rs = stmt.executeQuery(queryString);
            while (rs.next()) {
                Hashtable<Integer, String> resultHash = new Hashtable<Integer, String>();
                for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
                    try {
                        Properties attributeProperties = (Properties)attributeList.get(i);
                        String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        if (columnName.equalsIgnoreCase(sortColumn)) {
                            columnName = "NAME";
                        }
                        if (rs.getObject(columnName) == null) continue;
                        Object obj = rs.getObject(columnName);
                        resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                        continue;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                resultList.add(resultHash);
            }
            DBUtil.closeStmtAndConnection((Statement)stmt, (Connection)connection);
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return resultList;
        }
        try {
            if (rs == null) return resultList;
            rs.close();
            return resultList;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return resultList;
        }
        finally {
            DBUtil.closeStmtAndConnection(stmt, connection);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        }
    }

    private Integer getAllObjectCount(ArrayList attributeList, String objClass, ArrayList<String> tableNames, Criteria columnSearchCriteria) {
        Integer count = null;
        int noOfColumns = attributeList.size();
        ArrayList<SelectQueryImpl> queryList = new ArrayList<SelectQueryImpl>();
        try {
            ObjectClass objectClass = SearchProfileHandler.getInstance().getObjectClass(objClass);
            String baseTableName = objectClass.getBaseTable();
            Hashtable domainVsOus = SearchProfileHandler.getInstance().getSearchDomainsAndOus(Long.valueOf(1L));
            Enumeration e = domainVsOus.keys();
            while (e.hasMoreElements()) {
                String domainName = (String)e.nextElement();
                Hashtable ous = (Hashtable)domainVsOus.get(domainName);
                Enumeration e1 = ous.keys();
                String defaultNamingContext = (String)e1.nextElement();
                ArrayList oulist = (ArrayList)ous.get(defaultNamingContext);
                ArrayList ouList = DirectoryObjectUtil.getParentOUs(oulist);
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)baseTableName));
                selectQuery.addSelectColumn(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID").count());
                if (objClass.equalsIgnoreCase("user")) {
                    String sidTableName = CommonUtil.getSIDTableName((String)domainName);
                    selectQuery.addJoin(new Join(baseTableName, sidTableName, new String[]{"SID_STRING"}, new String[]{"SID_STRING"}, 2));
                }
                for (int k = 0; k < tableNames.size(); ++k) {
                    if (tableNames.get(k).equalsIgnoreCase(baseTableName)) continue;
                    selectQuery.addJoin(new Join(baseTableName, tableNames.get(k), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)baseTableName, (String)"IS_DELETED"), (Object)new Integer(1), 0));
                if (ouList != null && !ouList.isEmpty()) {
                    Criteria oUCriteria = null;
                    for (int j = 0; j < ouList.size(); ++j) {
                        String ouDN = (String)ouList.get(j);
                        ouDN = EscapeUtil.getEscapedOuDN((String)ouDN);
                        oUCriteria = oUCriteria == null ? new Criteria(Column.getColumn((String)baseTableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12) : oUCriteria.or(new Criteria(Column.getColumn((String)baseTableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12));
                    }
                    criteria = criteria.and(oUCriteria);
                }
                if (columnSearchCriteria != null) {
                    criteria = criteria.and(columnSearchCriteria);
                }
                selectQuery.setCriteria(criteria);
                queryList.add(selectQuery);
            }
            Integer resultCount = 0;
            for (int i = 0; i < queryList.size(); ++i) {
                resultCount = resultCount + DBUtil.getCount((SelectQuery)((SelectQuery)queryList.get(i)));
            }
            count = resultCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public Criteria getColumnSearchCriteria(HttpServletRequest request, ArrayList attributeList, ArrayList<String> tableNames) {
        Criteria crit = null;
        try {
            DynaActionForm bean = (DynaActionForm)request.getSession().getAttribute("ADSearchBean");
            String colSearchString = (String)bean.get("colSearchString");
            boolean search = false;
            if (request.getParameter("search") != null) {
                colSearchString = "";
                search = true;
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties p = (Properties)attributeList.get(i);
                Integer id = (Integer)p.get("ATTRIB_ID");
                String tableName = p.getProperty("TABLE_NAME");
                String columnName = p.getProperty("ATTRIB_COLUMN_NAME");
                String val = null;
                if (search) {
                    if (request.getParameter("search" + id.toString()) != null) {
                        val = request.getParameter("search" + id);
                        if (!colSearchString.equalsIgnoreCase("")) {
                            colSearchString = colSearchString + "&";
                        }
                        colSearchString = colSearchString + "search" + id + "=" + val;
                    }
                } else {
                    val = ReportResultUtil.getSearchString(colSearchString, id);
                }
                if (val != null && !val.equalsIgnoreCase("")) {
                    boolean hasWildCard = false;
                    val = val.replace("\\", "\\\\");
                    int index = val.indexOf("*");
                    while (index != -1) {
                        if (index == 0 || val.charAt(index - 1) != '\\') {
                            hasWildCard = true;
                            break;
                        }
                        index = val.indexOf("*", index + 1);
                    }
                    if (!hasWildCard) {
                        val = "*" + val + "*";
                    }
                    crit = crit == null ? new Criteria(new Column(tableName, columnName), (Object)val, 2) : crit.and(new Criteria(new Column(tableName, columnName), (Object)val, 2));
                }
                if (tableNames.contains(tableName)) continue;
                tableNames.add(tableName);
            }
            if (search) {
                bean.set("colSearchString", (Object)colSearchString);
                bean.set("FROM_INDEX", (Object)1L);
                bean.set("PAGE_NUMBER", (Object)"1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    @Override
    public synchronized void addRow(Properties prop) {
        try {
            ArrayList objectClass = (ArrayList)prop.get("objectClass");
            if (objectClass == null) {
                objectClass = (ArrayList)prop.get("ObjectClass");
            }
            if (objectClass == null) {
                System.out.println("No Object Class " + prop);
                return;
            }
            String objClass = ((String)objectClass.get(objectClass.size() - 1)).toLowerCase();
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return;
            }
            ++this.totalCount;
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Hashtable uiValues = new Hashtable();
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues, objClass);
            this.queue.addToQueue(objClass, guid, tableRowMap, relationalTableRowMap);
            if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
            }
            StringBuffer b = new StringBuffer();
            b.append("[");
            Properties objDet = (Properties)this.searchProfile.get(objClass);
            ArrayList viewAttributeList = (ArrayList)objDet.get("SEL_DIS_IDS");
            for (int i = 0; i < viewAttributeList.size(); ++i) {
                Integer attributeId = (Integer)viewAttributeList.get(i);
                b.append("'");
                String s = (String)uiValues.get(attributeId);
                if (s == null || s.trim().equalsIgnoreCase("")) {
                    b.append("-");
                } else {
                    s = ListenerUtil.getDynamicUpdateValues(attributeId, s);
                    b.append(s);
                }
                b.append("'");
                if (i == viewAttributeList.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
            this.updateUI(null, null, null, b.toString());
            this.queue.checkForNextUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        this.out = o;
        boolean actionSet = false;
        while (!this.isCompleted && this.continueAction) {
            try {
                if (this.continueAction && !actionSet) {
                    this.setClientButtons(true);
                    actionSet = true;
                }
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write("<b> " + this.rb.getString("admp.home.employee_search.message_error_occured") + " : " + e.getMessage() + " </b>");
            }
        }
        if (this.out != null && !this.out.checkError() && this.isCompleted) {
            this.setClientButtons(false);
            this.updateOutList();
            this.out.flush();
        }
        this.out = null;
    }

    public ArrayList getAttributeList(String objClassName) {
        Properties objDet = (Properties)this.searchProfile.get(objClassName);
        ArrayList selDisCols = (ArrayList)objDet.get("SEL_DIS_IDS");
        ArrayList allCols = (ArrayList)((Hashtable)this.searchProfile.get("ALL_OBJECT_ATTRIBUTES")).get(objClassName);
        ArrayList<Properties> displayColumns = new ArrayList<Properties>();
        try {
            block2: for (int j = 0; j < selDisCols.size(); ++j) {
                Integer attId = (Integer)selDisCols.get(j);
                for (int z = 0; z < allCols.size(); ++z) {
                    Properties prop = (Properties)allCols.get(z);
                    Integer attrId = (Integer)prop.get("ATTRIB_ID");
                    if (!attrId.equals(attId)) continue;
                    displayColumns.add(prop);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return displayColumns;
    }

    @Override
    public void updateQueue() {
        if (this.updateDetails) {
            while (!this.queue.isCompleted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void completedAction() {
        if (this.updateDetails) {
            reportLogger.log(Level.INFO, "Receiving Completed Action");
            this.updateQueue();
            reportLogger.log(Level.INFO, "Updating Completed Action");
            ReportHandler.updateReportGenerationDetails((Long)this.generationId, (int)1, (String)this.desc, (Long)this.loginId);
        }
        this.isCompleted = true;
    }

    public ArrayList getSearchAttributes(ArrayList displayCols) {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        for (int j = 0; j < displayCols.size(); ++j) {
            Properties p = (Properties)displayCols.get(j);
            if (attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
            attributeList.add(p.get("ATTRIB_LDAP_NAME"));
        }
        if (!attributeList.contains("objectGUID")) {
            attributeList.add("objectGUID");
        }
        if (!attributeList.contains("distinguishedName")) {
            attributeList.add("distinguishedName");
        }
        if (!attributeList.contains("objectSID")) {
            attributeList.add("objectSID");
        }
        if (!attributeList.contains("objectClass")) {
            attributeList.add("objectClass");
        }
        attributeList.remove("sAMAccountName");
        attributeList.add(0, "sAMAccountName");
        return attributeList;
    }

    private void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Hashtable uiValues, String objectClass) {
        try {
            ArrayList values = null;
            ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(this.reportId, objectClass);
            ObjectClass objClass = SearchProfileHandler.getInstance().getObjectClass(objectClass);
            String baseTableName = objClass.getBaseTable();
            int baseTableIndex = tableNames.indexOf(baseTableName);
            if (baseTableIndex > 0) {
                tableNames.remove(baseTableIndex);
                tableNames.add(0, baseTableName);
            }
            Properties objDet = (Properties)this.searchProfile.get(objectClass);
            ArrayList viewAttributeList = (ArrayList)objDet.get("SEL_DIS_IDS");
            String sid = null;
            ArrayList sidList = (ArrayList)prop.get("objectSID");
            if (sidList != null && sidList.size() != 0) {
                sid = (String)sidList.get(0);
            }
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, this.reportId, objectClass);
                ArrayList<Object> rowList = new ArrayList<Object>();
                Row r = null;
                Integer relationalType = null;
                ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
                for (int j = 0; j < attributeList.size(); ++j) {
                    Properties p = (Properties)attributeList.get(j);
                    String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                    String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)p.get("ATTRIB_ID");
                    relationalType = (Integer)p.get("RELATIONAL_TYPE");
                    if (!viewAttributeList.contains(attributeId)) continue;
                    values = (ArrayList)prop.get(ldapName);
                    values = this.getDBCustomizedValues(columnName, ldapName, prop);
                    StringBuffer buf = new StringBuffer();
                    if (relationalType.equals(new Integer(1))) {
                        buf.append("-");
                        if (values != null && !values.isEmpty()) {
                            for (int k = 0; k < values.size(); ++k) {
                                String value = (String)values.get(k);
                                Row r1 = null;
                                if (multipleTableRowList.size() > k) {
                                    r1 = (Row)multipleTableRowList.get(k);
                                } else {
                                    r1 = new Row(tableName);
                                    multipleTableRowList.add(k, r1);
                                }
                                r1.set(columnName, (Object)value);
                                r1.set(this.tableKey, (Object)guid);
                                buf.append(value);
                                if (k == values.size() - 1) continue;
                                buf.append(",");
                            }
                        } else {
                            if (r == null) {
                                r = new Row(tableName);
                            }
                            r.set(columnName, (Object)"-");
                        }
                    } else if (values != null && !values.isEmpty()) {
                        if (r == null) {
                            r = new Row(tableName);
                        }
                        r.set(columnName, values.get(0));
                        buf.append(values.get(0));
                    } else {
                        if (r == null) {
                            r = new Row(tableName);
                        }
                        r.set(columnName, (Object)"-");
                        buf.append("-");
                    }
                    uiValues.put(attributeId, buf.toString());
                }
                if (baseTableName.equals(tableName) && sid != null) {
                    r.set("SID_STRING", (Object)sid);
                }
                if (r != null) {
                    r.set(this.tableKey, (Object)guid);
                    rowList.add(r);
                }
                if (multipleTableRowList.size() > 0) {
                    rowList.addAll(multipleTableRowList);
                }
                if (relationalType.equals(new Integer(0))) {
                    tableRowMap.put(tableName, rowList);
                    continue;
                }
                relationalTableRowMap.put(tableName, rowList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSearchCriteria(ArrayList searchCris, String obj, String objLDAPCri) {
        StringBuffer buf = new StringBuffer();
        buf.append("(&" + objLDAPCri + "(|");
        Boolean sByAllFields = this.searchBy.contains("ALL_FIELDS");
        for (int i = 0; i < searchCris.size(); ++i) {
            Properties p = (Properties)searchCris.get(i);
            int attId = (Integer)p.get("ATTRIB_ID");
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String ldapCriteria = (String)p.get("LDAP_CRITERIA");
            if (!sByAllFields.booleanValue() && !this.searchBy.contains(obj + "_" + attId)) continue;
            buf.append(ldapCriteria);
            if (!sByAllFields.booleanValue()) break;
        }
        buf.append("))");
        String s = buf.toString();
        String searchQuery = this.searchString;
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < searchQuery.length(); ++i) {
            char curChar = searchQuery.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        searchQuery = sb.toString();
        if (this.searchType == null || this.searchType.equals("contains")) {
            searchQuery = "*" + searchQuery + "*";
        } else if (this.searchType.equals("startsWith")) {
            searchQuery = searchQuery + "*";
        } else if (this.searchType.equals("endsWith")) {
            searchQuery = "*" + searchQuery;
        }
        while (s.contains("%searchString%")) {
            s = s.replace("%searchString%", searchQuery);
        }
        reportLogger.log(Level.INFO, "searchQuery :: " + s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRows(ArrayList attributeList, String className, int sortIndex, boolean ascending, Long startIndex, int numOfObjects, ArrayList<String> tableNames, String resultTable, Criteria criteria) {
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            int i;
            int noOfColumns = attributeList.size();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)resultTable));
            for (i = 0; i < noOfColumns; ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                String tableName = attributeProp.getProperty("TABLE_NAME");
                Column selectColumn = Column.getColumn((String)tableName, (String)columnName);
                selectQuery.addSelectColumn(selectColumn);
                if (i != sortIndex) continue;
                SortColumn sortcolumn = new SortColumn(Column.getColumn((String)tableName, (String)columnName), ascending);
                selectQuery.addSortColumn(sortcolumn);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                selectQuery.addJoin(new Join(resultTable, tableNames.get(i), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
            }
            selectQuery.setCriteria(criteria);
            if (startIndex != -1L) {
                selectQuery.setRange(new Range((int)startIndex.longValue(), numOfObjects));
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                Hashtable resultRow = new Hashtable();
                ReportResultUtil.fillResult(dataSet, resultRow, attributeList);
                resultList.add(resultRow);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return resultList;
    }

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    public class Action
    extends Thread {
        private NativeListener listener = null;
        private Long loginId = null;

        public Action(Long loginId, NativeListener li) {
            this.loginId = loginId;
            this.listener = li;
        }

        @Override
        public void run() {
            SearchListener.this.errorMessage = null;
            SearchListener.this.guidList = new ArrayList();
            Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
            tableProps.put("generationId", SearchListener.this.generationId);
            Hashtable domainVsOus = SearchProfileHandler.getInstance().getSearchDomainsAndOus(new Long(1L));
            for (int j = 0; j < SearchListener.this.objectClasses.size(); ++j) {
                String obj = (String)((Row)SearchListener.this.objectClasses.get(j)).get("OBJECT_CLASS");
                Properties objDet = (Properties)SearchListener.this.searchProfile.get(obj);
                String isObjEn = (String)objDet.get("IS_OBJECT_ENABLED");
                if (!SearchListener.this.searchByStr.contains("ALL_FIELDS") && !SearchListener.this.searchByStr.contains(obj + "_") || !isObjEn.equals("1")) continue;
                ArrayList searchCris = (ArrayList)objDet.get("SEL_SEA_CRIS_DET");
                ArrayList displayCols = (ArrayList)objDet.get("SEL_DIS_COLS_DET");
                ArrayList attributeList = SearchListener.this.getSearchAttributes(displayCols);
                String searchQuery = SearchListener.this.getSearchCriteria(searchCris, obj, (String)objDet.get("OBJECT_LDAP_CRITERIA"));
                Enumeration e = domainVsOus.keys();
                while (e.hasMoreElements()) {
                    SearchListener.this.domainName = (String)e.nextElement();
                    Hashtable ous = (Hashtable)domainVsOus.get(SearchListener.this.domainName);
                    Enumeration e1 = ous.keys();
                    String defaultNamingContext = (String)e1.nextElement();
                    ArrayList oulist = (ArrayList)ous.get(defaultNamingContext);
                    ArrayList ouList = DirectoryObjectUtil.getParentOUs(oulist);
                    tableProps.put("domainName", SearchListener.this.domainName);
                    SearchListener.this.queue.setTableProps(tableProps);
                    if (ouList == null || ouList.size() == 0) {
                        reportLogger.log(Level.INFO, "Getting the Domain Data's from the domain " + SearchListener.this.domainName);
                        try {
                            ADHandler.getObjects((String)SearchListener.this.domainName, (Long)this.loginId, (String)defaultNamingContext, (ArrayList)attributeList, (String)searchQuery, (NativeListener)this.listener);
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            ((SearchListener)this.listener).setErrorMessage(le.getMessage(SearchListener.this.rb));
                            System.out.println("LocalizedException: - " + ((SearchListener)this.listener).errorMessage);
                        }
                        catch (Exception ex) {
                            SearchListener.this.errorMessage = ex.getMessage();
                            ex.printStackTrace();
                        }
                    } else {
                        for (int i = 0; i < ouList.size(); ++i) {
                            try {
                                String dn = (String)ouList.get(i);
                                reportLogger.log(Level.INFO, "Getting the Domain Data's from the domain " + SearchListener.this.domainName);
                                ADHandler.getObjects((String)SearchListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)attributeList, (String)searchQuery, (NativeListener)this.listener);
                                continue;
                            }
                            catch (LocalizedException le) {
                                le.printStackTrace();
                                ((SearchListener)this.listener).setErrorMessage(le.getMessage(SearchListener.this.rb));
                                System.out.println("LocalizedException: - " + ((SearchListener)this.listener).errorMessage);
                                continue;
                            }
                            catch (Exception ex) {
                                SearchListener.this.errorMessage = ex.getMessage();
                                ex.printStackTrace();
                            }
                        }
                    }
                    SearchListener.this.updateQueue();
                }
            }
            reportLogger.log(Level.INFO, "Completed the Reports Count : " + SearchListener.this.totalCount);
            SearchListener.this.updatedCount = 0;
            SearchListener.this.totalCount = 0;
            SearchListener.this.completedAction();
        }
    }
}

