/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.authentication;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ADAuthAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(ADAuthAction.class.getName());

    public ActionForward changeAuthType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String newAuthType = request.getParameter("AuthType");
        String currentAuthType = ADSMPersUtil.getSyMParameter((String)"AuthType");
        if (!currentAuthType.equalsIgnoreCase(newAuthType)) {
            ADSMPersUtil.updateSyMParameter((String)"AuthType", (String)newAuthType);
        }
        return mapping.findForward("adAuth");
    }

    public ActionForward resetBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        DynaValidatorForm bean = (DynaValidatorForm)form;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            request.setAttribute("usersList", (Object)ADMPUserHandler.getADMPUsers((AdventNetResourceBundle)rb, (String)"HelpDeskUser", null, null));
            request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID"))));
            request.setAttribute("rolesList", (Object)ADMPRoleHandler.getADMPRoles((AdventNetResourceBundle)rb));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bean.set("operation", (Object)"add");
        bean.set("roleIds", (Object)"");
        return mapping.findForward("viewADMPUsers");
    }

    private void reInit(DynaValidatorForm bean) {
        String[] ar;
        for (String string : ar = new String[]{"operation", "userDN", "userNameString", "userName"}) {
            bean.set(string, (Object)"");
        }
        bean.set("domainOUList", new Hashtable());
        bean.set("domainTemplateList", new Hashtable());
        bean.set("templateList", new ArrayList());
        bean.set("configuredDomains", (Object)new String[0]);
        bean.set("adminCredential", (Object)"true");
        bean.set("includeGroupsMap", new HashMap());
        bean.set("excludeGroupsMap", new HashMap());
        bean.set("defaultTemplate", (Object)new Long(0L));
    }

    public ActionForward searchUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String searchString = request.getParameter("searchString");
            String searchDomain = request.getParameter("searchDomain");
            String searchPattern = null;
            if (searchString != null && !searchString.equalsIgnoreCase("")) {
                searchPattern = searchString.indexOf("*") == -1 ? "*" + searchString + "*" : searchString;
            }
            String sidTableName = CommonUtil.getSIDTableName((String)searchDomain);
            Criteria criteria = new Criteria(new Column(sidTableName, "DISPLAY_NAME"), (Object)searchPattern, 2);
            criteria = criteria.and(new Column(sidTableName, "SID_IDENTIFIER"), (Object)1, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(sidTableName, criteria);
            ArrayList<Properties> searchResultList = new ArrayList<Properties>();
            Iterator iterator = dataObject.getRows(sidTableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Properties properties = new Properties();
                properties.setProperty("DN_STRING", row.get("DN_STRING").toString());
                properties.setProperty("DISPLAY_NAME", row.get("DISPLAY_NAME").toString());
                searchResultList.add(properties);
            }
            ByteArrayOutputStream outNode = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (Properties properties : searchResultList) {
                Element userElement = document.createElement("user");
                userElement.setAttribute("userDN", properties.getProperty("DN_STRING"));
                userElement.setAttribute("userName", properties.getProperty("DISPLAY_NAME"));
                data.appendChild(userElement);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward selfServiceAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forward = "SelfServiceAccounts";
        try {
            String SelfService;
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)form;
            String operation = request.getParameter("operation");
            if (operation != null && operation.equalsIgnoreCase("delete")) {
                Long loginId = Long.parseLong(request.getParameter("loginId"));
                if (HelpdeskUtil.deleteADMPUser((Long)loginId)) {
                    request.setAttribute("statusMessage", (Object)rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.success_deleted_user"));
                } else {
                    request.setAttribute("statusMessage", (Object)rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.error_deleting_user"));
                }
            }
            if (request.getParameter("Save") != null) {
                SelfService = request.getParameter("enableSelfService");
                if (SelfService == null) {
                    SelfService = "false";
                }
                ADSMPersUtil.updateSyMParameter((String)"SelfService", (String)SelfService);
                return null;
            }
            SelfService = ADSMPersUtil.getSyMParameter((String)"SelfService");
            bean.set("enableSelfServiceportal", (Object)SelfService);
            String domainFlatName = null;
            if (request.getParameter("domainFlatName") != null && !request.getParameter("domainFlatName").equals("ALL")) {
                domainFlatName = request.getParameter("domainFlatName");
            }
            ArrayList domainList = HDTDomainHandler.getConfiguredList((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            Properties p = new Properties();
            p.put("DOMAIN_FLAT_NAME", "ALL");
            domainList.add(p);
            request.setAttribute("domainList", (Object)domainList);
            String searchName = null;
            if (request.getParameter("searchName") != null && !request.getParameter("searchName").equals("")) {
                searchName = request.getParameter("searchName");
            }
            Long recordsCount = null;
            String range = "25";
            if (request.getParameter("RANGE") != null) {
                range = request.getParameter("RANGE");
            }
            request.setAttribute("range", (Object)range);
            long startIndex = 1L;
            long endIndex = new Long(range);
            if (request.getParameter("FROM_INDEX") != null) {
                startIndex = new Long(request.getParameter("FROM_INDEX"));
                endIndex = new Long(request.getParameter("TO_INDEX"));
            }
            request.setAttribute("FROM_INDEX", (Object)new Long(startIndex));
            request.setAttribute("TO_INDEX", (Object)new Long(endIndex));
            ArrayList selfServiceList = ADMPUserHandler.getADMPUsers((AdventNetResourceBundle)rb, (String)"SelfServiceUser", (String)domainFlatName, (String)searchName);
            recordsCount = new Long(selfServiceList.size());
            if (domainFlatName == null) {
                domainFlatName = "ALL";
            }
            request.setAttribute("ListingDomain", (Object)domainFlatName);
            request.setAttribute("selfServiceList", (Object)selfServiceList);
            request.setAttribute("TOTAL_RECORDS", (Object)recordsCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("statusMessage", (Object)rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg.error_updating_settings"));
        }
        return mapping.findForward(forward);
    }

    public static Boolean getRoleCheckStatus(ArrayList roleslist, Long roleId) {
        boolean str = false;
        ArrayList<Long> roleidlist = new ArrayList<Long>();
        for (int j = 0; j < roleslist.size(); ++j) {
            Properties p = (Properties)roleslist.get(j);
            Long roleIDs = (Long)p.get("ROLE_ID");
            roleidlist.add(roleIDs);
        }
        if (roleidlist.contains(roleId)) {
            str = true;
        }
        return str;
    }
}

