/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.authentication;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;

public class ADMPRoleAction
extends DispatchAction {
    public ActionForward viewADMPRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            ArrayList arrayList = ADMPRoleHandler.getADMPRoles((AdventNetResourceBundle)rb);
            request.setAttribute("AdmpRoleList", (Object)arrayList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward createADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            bean.set("userActionValues", (Object)"false");
            bean.set("roleID", (Object)new Long(0L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("createADMPRole");
    }

    public ActionForward modifyADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Long roleID = (Long)bean.get("roleID");
            String[] userActions = ADMPRoleHandler.initCreateUserActionIds((Long)roleID);
            if (userActions != null) {
                bean.set("userActions", (Object)userActions);
            }
            Hashtable hashtable = ADMPRoleHandler.getRoleDetails((Long)roleID);
            request.setAttribute("ROLE_DETAILS", (Object)hashtable);
            bean.set("userActionValues", (Object)"false");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("createADMPRole");
    }

    public ActionForward saveADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message;
        block10: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            message = null;
            DynaValidatorForm bean = (DynaValidatorForm)form;
            try {
                if (!ClientAuthorizationUtil.isAuthorized(request, 2000L).booleanValue()) {
                    throw new Exception("Access is Denied");
                }
                String[] userPropIds = new String[]{"1001"};
                String admpRoleName = request.getParameter("ADMP_ROLE_NAME");
                String admpRoleDescription = request.getParameter("ADMP_ROLE_DESCRIPTION");
                Long roleID = (Long)bean.get("roleID");
                String[] actions = request.getParameterValues("actions");
                String[] userActions = null;
                boolean bool = false;
                block2: for (int i = 0; i < userPropIds.length; ++i) {
                    for (int j = 0; actions != null && j < actions.length; ++j) {
                        if (!userPropIds[i].equals(actions[j])) continue;
                        bool = true;
                        continue block2;
                    }
                }
                if (bool) {
                    userActions = (String[])bean.get("userActions");
                }
                if (roleID != null && roleID != 0L) {
                    ADMPRoleHandler.updateADMPRole((Long)roleID, (String)admpRoleName, (String)admpRoleDescription, (String[])actions, (String[])userActions);
                    message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.success_updated_helpDesk_role");
                } else if (!ADMPRoleHandler.isRoleExists((String)admpRoleName)) {
                    ADMPRoleHandler.saveADMPRole((String)admpRoleName, (String)admpRoleDescription, (String[])actions, (String[])userActions);
                    message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.success_created_helpDesk_role");
                } else {
                    message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.role_name_already_exists");
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("ADMP_ROLE_NAME", admpRoleName);
                    hashtable.put("ADMP_ROLE_DESCRIPTION", admpRoleDescription);
                    request.setAttribute("message", (Object)message);
                    request.setAttribute("ROLE_DETAILS", hashtable);
                }
                ArrayList rolesList = ADMPRoleHandler.getADMPRoles((AdventNetResourceBundle)rb);
                request.setAttribute("AdmpRoleList", (Object)rolesList);
            }
            catch (Exception e) {
                message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_saving_helpDesk_role");
                e.printStackTrace();
                if (e.getMessage() == null) break block10;
                message = message + ":" + e.getMessage();
            }
        }
        request.setAttribute("statusMessage", (Object)message);
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward deleteADMPRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb;
        block3: {
            Locale locale = request.getLocale();
            rb = ResourceBundleMgr.getInstance().getBundle(locale);
            try {
                if (!ClientAuthorizationUtil.isAuthorized(request, 2000L).booleanValue()) {
                    throw new Exception("Access is Denied");
                }
                String roleIDString = request.getParameter("roleID");
                Long roleID = Long.parseLong(roleIDString);
                ADMPRoleHandler.deleteADMPRole((Long)roleID);
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) break block3;
                message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_deleting_helpDesk_roles"), message);
                request.setAttribute("statusMessage", (Object)message);
            }
        }
        ArrayList rolesList = ADMPRoleHandler.getADMPRoles((AdventNetResourceBundle)rb);
        request.setAttribute("AdmpRoleList", (Object)rolesList);
        return mapping.findForward("viewADMPRoles");
    }

    public ActionForward getParentChildIDS(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Long selectedId = Long.parseLong(request.getParameter("selectedId"));
            String check = request.getParameter("check");
            String tableName = "ADMPActionDetails";
            ArrayList parentId = new ArrayList();
            ArrayList childId = new ArrayList();
            childId = ADMPRoleAction.getParentChildIds(new String("PARENT_ID"), selectedId, new String("ACTION_ID"), childId, false);
            if (check.equals("true")) {
                parentId = ADMPRoleAction.getParentChildIds(new String("ACTION_ID"), selectedId, new String("PARENT_ID"), parentId, true);
            }
            ClientUtil.getXMLElement(response, parentId, childId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList getParentChildIds(String columnName, Long Value, String resultColumnName, ArrayList result, Boolean change) {
        try {
            int i = 1;
            String tableName = "ADMPActionDetails";
            Criteria crit = new Criteria(new Column(tableName, columnName), (Object)Value, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!dob.isEmpty()) {
                Iterator iterator = dob.getRows(tableName);
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    Long newValue = (Long)r.get(resultColumnName);
                    result.add((Long)r.get(resultColumnName));
                    if (i == 1 && change.booleanValue()) {
                        String a = resultColumnName;
                        resultColumnName = columnName;
                        columnName = a;
                        ++i;
                    }
                    if (change.booleanValue()) {
                        ADMPRoleAction.getParentChildIds(resultColumnName, newValue, columnName, result, true);
                        continue;
                    }
                    ADMPRoleAction.getParentChildIds(columnName, newValue, resultColumnName, result, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

