/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticatorForMobile;
import com.adventnet.sym.adsm.common.server.delegation.workflow.RequesterHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.refresh.RefreshListener;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.JSONUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ADMPAPIUtil {
    private static Logger out = Logger.getLogger("APILogger");
    public static final String ADSMTRUSTEDPRODUCTS = "ADSMTrustedProducts";

    public static String getJSONString(ArrayList arr) {
        return JSONUtil.getJSONString((ArrayList)arr);
    }

    public static String getJSONString(Properties props) {
        return JSONUtil.getJSONString((Properties)props);
    }

    public static String getXMLString(ArrayList arr) {
        String xmlString = "";
        return xmlString;
    }

    public static Long getLoginId(String loginName, String domainFlatName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainFlatName, 0));
            DataObject obj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence((boolean[])new boolean[0]).get("AaaLogin", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("AaaLogin");
                return (Long)r.get("LOGIN_ID");
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, "User Account is not found! Error occured while checking user account status");
            e.printStackTrace();
        }
        return null;
    }

    public static Boolean isAuthorizedSuperAdmin(HttpServletRequest request) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            String userName = request.getParameter("userName");
            String password = request.getParameter("password");
            String serviceName = "System";
            password = AuthUtil.decryptString((String)password);
            ADMPADAuthenticatorForMobile authenticator = new ADMPADAuthenticatorForMobile();
            authenticator.init(request, userName, domainName, password, serviceName);
            authenticator.authenticateUser();
            if (authenticator.getAuthenticationSuccess()) {
                Long loginId = authenticator.getLoginId();
                if (loginId != 1L) {
                    throw new Exception("00000013");
                }
                request.setAttribute("ADMP_SESSION_LOGIN_ID", (Object)loginId);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return false;
    }

    public static Long getLoginId(HttpServletRequest request) {
        try {
            String userName = request.getParameter("userName");
            String domainName = request.getParameter("domainName");
            String isProductUser = request.getParameter("isProductUser");
            if (isProductUser != null && isProductUser.equalsIgnoreCase("true")) {
                domainName = CommonUtil.getApplicationDomainName();
            } else {
                JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
                if (domainDetails != null && domainDetails.length() > 0) {
                    domainName = domainDetails.getString("DOMAIN_FLAT_NAME");
                }
            }
            return ADMPAPIUtil.getLoginId(userName, domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getGUID(HttpServletRequest request) {
        String objectGUID = null;
        String userName = request.getParameter("userName");
        String domainName = request.getParameter("domainName");
        try {
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
            if (domainDetails != null && domainDetails.length() > 0) {
                domainName = domainDetails.getString("DOMAIN_NAME");
            }
            String tableName = "ADSMUserGeneralDetails";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)userName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)"1", 0));
            DataObject obj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                objectGUID = (String)r.get("OBJECT_GUID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objectGUID == null) {
            try {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                Long loginId = ADMPAPIUtil.getLoginId(request);
                RefreshListener li = null;
                li = new RefreshListener(com.adventnet.sym.adsm.common.server.util.CommonUtil.ADMIN_LOGIN_ID, domainName, "user", rb);
                li.refresh(userName, "samAccountName");
                objectGUID = com.adventnet.sym.adsm.common.server.util.CommonUtil.getObjectGUId((String)domainName, (String)"SAM_ACCOUNT_NAME", (String)userName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objectGUID;
    }

    public static boolean isWFRequesterAccountActive(Long loginId) {
        return HelpdeskUtil.isRequester((Long)loginId) ? RequesterHandler.isEnabledRequester((Long)loginId) : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserAccountActive(Long loginId) {
        boolean isActive = false;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"AaaAccount", (String)"LOGIN_ID"), (Object)loginId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaAccountStatus"));
            sq.addJoin(new Join(Table.getTable((String)"AaaAccountStatus"), Table.getTable((String)"AaaAccount"), new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
            sq.addSelectColumn(Column.getColumn((String)"AaaAccountStatus", (String)"STATUS"));
            sq.setCriteria(c);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String accountStatus = (String)dataSet.getValue("STATUS");
                if (!"ACTIVE".equalsIgnoreCase(accountStatus) && !"NEW".equalsIgnoreCase(accountStatus)) continue;
                isActive = true;
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            out.log(Level.INFO, "User Account is not active! Error occured while checking user account status");
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return isActive;
    }

    public static String getFeedURL(String productName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"FEED_URL", (String)"FEED_NAME"), (Object)productName, 0);
            DataObject obj = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence((boolean[])new boolean[0]).get("FEED_URL", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("FEED_URL");
                return (String)r.get("FEED_URL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpURLConnection openConnection(String urlStr) throws Exception {
        URL urlObj = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    public static void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
            connection = null;
        }
    }
}

